#========================================================================#
#
# .fvwm95rc example configuration file for fvwm95-2.0.43
#
# Modifi,traduit et comment par E. Rouat pour GUILDE
# bas sur le fichier fvwm95rc de Daniel Veillard (entres autres)
# Le fichier d'origine contient d'autres exemples intressants.
# Il convient de lire la page 'man' de fvwm95 (ou a dfaut de fvwm2)
# Note: ce WM peut tre configur de multiples faons,  vous d'essayer 
# diffrentes possibilits et de choisir celle qui vous convient le mieux.
#
# ATTENTION: Ne fonctionne pas correctement avec la version de fvwm95 
# livre en standard avec la distribution RedHat, qui est la 2.0.42a
#========================================================================#

#------------------------------------------------------------------------------
# Fonts - une pour les fentres, une pour les icones, et une pour les menus
#------------------------------------------------------------------------------

WindowFont	-adobe-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*
IconFont	fixed
MenuFont   	-adobe-helvetica-medium-r-*-*-*-140-*-*-*-*-*-*


#------------------------------------------------------------------------------
# Couleurs par dfaut des fentres - Syntaxe:
#
#  DefaultColors winforecolor winbackcolor titleforecolor titlebackcolor
#  avec:
#  winbackcolor    est la couleur de fond de toutes les fentres
#                  y compris les fentres de menus
#  winforecolor    est utilise pour le texte des menus
#  titlebackcolor  est la couleur de fond des barres de titres de 
#                  fentres non acives
#  titleforecolor  est la couleur du titre d'une fentre non active
#------------------------------------------------------------------------------

DefaultColors   Black #c3c3c3 #c3c3c3 grey51

#------------------------------------------------------------------------------
# Couleurs de texte et de fond de la barre de titre d'une fentre active
#------------------------------------------------------------------------------

HilightColors   White NavyBlue


#------------------------------------------------------------------------------
# Couleurs de texte et de fond de la barre de titre d'une fentre colle
#------------------------------------------------------------------------------

StickyColors    grey51 #60c080


#========================================================================#
#
# Caractristiques principales du gestionnaire de fentres
#
#========================================================================#


#------------------------------------------------------------------------------
# L'instruction 'Style' permet de passer a des fentres des paramtres
# les caractrisants - on 'stylise' la fentre, quoi..... 
# ex: Style "*" Borderwidth 5 dfinit pour toutes les fentres une largeur
# de contour par dfaut gale  5.
# Style "xv" TitleIcon mini-xv.xpm va associer aux fentres intitules 'xv'
# une icones de titre (en haut  gauche) bien particulire
#------------------------------------------------------------------------------
 

#------------------------------------------------------------------------------
# On supprime les icones vu qu'on utilise la TaskBar
#------------------------------------------------------------------------------

Style "*" NoIcon

#------------------------------------------------------------------------------
# Activation d'une fentre - je prfre SloppyFocus
# Autres possibilits: ClickToFocus et MouseFocus
#------------------------------------------------------------------------------

Style "*" SloppyFocus


#------------------------------------------------------------------------------
# Ici quelques dfinitions un peu exotiques visant a assurer une certaine
# compatibilit entre diffrents systmes (Motif et OpenLook)
#------------------------------------------------------------------------------

Style "*" MWMFunctions
#Style "*" HintOverride
Style "*" MWMDecor
Style "*" OLDecor


#------------------------------------------------------------------------------
# La ligne suivante dtermine la faon dont fvwm95 dplace les fentres
# Ici, une fentre dont la surface n'excde pas 10% de la taille de l'cran 
# sera dplace de faon opaque et les autres de faon transparente.
# Notez: dplacer une fentre de faon tranparente est plus rapide!
#------------------------------------------------------------------------------

OpaqueMoveSize 10

#------------------------------------------------------------------------------
# EdgeScroll dtermine le pourcentage dont on va drouler une page quand la
# souris arrive au bord de l'cran - une valeur de 100 et 100 va faire en sorte
# que l'on va carrment changer d'cran virtuel!
#------------------------------------------------------------------------------

EdgeScroll 100 100

#------------------------------------------------------------------------------
# La ligne suivante dtermine la 'rsistance' oppos par FVWM95 au passage
# d'un cran virtuel  un autre avec la souris , et au passage d'une fentre 
# d'un cran  un autre.
# Le premier paramtre en en milli-secondes, le second en nombre de pixels qui 
# ont dj franchis le bord de l'cran. (0=on peut pas)
# - moi j'utilise 10000 0 -
#------------------------------------------------------------------------------

EdgeResistance 400 25


#------------------------------------------------------------------------------
# Options de placement des fentres  leur dmarrage - ici, le placement
# des fentres sera automatique et 'intelligent' 
#------------------------------------------------------------------------------

Style "*" RandomPlacement, SmartPlacement


#========================================================================#
#
# Dfinition du nombre d'crans virtuels (4 ici) par Desktop 
#
#========================================================================#

DeskTopSize 2x2


#========================================================================#
# Chemins pour les modules et les icones.
# Il est possible que dans vos menus, des icones ne soient pas trouves - ca 
# peut tre d  un chemin mal ou pas dfini.
#========================================================================#


ModulePath /usr/local/lib/X11/fvwm95/
PixmapPath /usr/local/lib/X11/icons/
IconPath   /usr/local/lib/X11/mini-icons/

#========================================================================#
# Maintenant on va dcorer les fentres. 
# L'ordre est important!!
# Si des definitions de styles compatibles sont fixes pour une fentre au
# cours de plusieurs commandes 'Style', alors on fait un 'OU' de ces definitions.
# Si ces dfinitions sont incompatibles, la dernire spcifie est conserve.
#========================================================================#



#------------------------------------------------------------------------------
# Largeur des bords et des poignes par dfaut
#------------------------------------------------------------------------------

Style "*" BorderWidth 5, HandleWidth 5


#------------------------------------------------------------------------------
# Caractristiques des modules de FVWM
#------------------------------------------------------------------------------


Style "Fvwm*"        NoTitle, Sticky, WindowListSkip
Style "FvwmPager"    Title, Sticky, WindowListHit
Style "Fvwm Pager"   Title, Sticky, WindowListHit
Style "FvwmTalk"     Title, WindowListHit
Style "FvwmConsole"  Title, WindowListHit
Style "Fvwm Pager"   StaysOnTop, NoHandles
Style "FvwmBanner"   StaysOnTop



#------------------------------------------------------------------------------
# Caractristiques de quelques applications
#------------------------------------------------------------------------------


Style "*lock"        NoTitle, NoHandles, Sticky, WindowListSkip
Style "xbiff"        NoTitle,            Sticky, WindowListSkip
Style "xsysinfo"     NoTitle,            Sticky, WindowListSkip
Style "xpostit"                                  WindowListSkip
Style "PostitNote"                               WindowListSkip
Style "Postit"       NoHandles,                  WindowListSkip,BorderWidth 5
  



#------------------------------------------------------------------------------
# On associe quelques icones  des titres de fentre
# (TitleIcon=icone en haut  gauche de la fentre)
#------------------------------------------------------------------------------

Style "*"         	TitleIcon mini-x2.xpm
Style "*xterm*"   	TitleIcon mini-term.xpm
Style "rxvt"      	TitleIcon mini-term.xpm
Style "xcalc"     	TitleIcon mini-calc.xpm
Style "xsession"  	TitleIcon mini-bx2.xpm
Style "xv"        	TitleIcon mini-xv.xpm
Style "Netscape"  	TitleIcon mini-nscape.xpm
Style "xmag"      	TitleIcon mini-zoom.xpm
Style "textedit"  	TitleIcon mini-edit.xpm
Style "*emacs*"	  	TitleIcon mini-edit.xpm
Style "tkps"      	TitleIcon mini-run.xpm
Style "Ghostview" 	TitleIcon mini-gv.xpm
Style "Xcolorsel" 	TitleIcon mini-colors.xpm
Style "IDL*"      	TitleIcon mini-zoom.xpm
Style "xeyes"     	TitleIcon mini-eyes.xpm
Style "*fm*"      	TitleIcon mini-filemgr.xpm
Style "FileRunner"	TitleIcon mini-ofolder.xpm
Style "The Gimp"  	TitleIcon mini-paint.xpm
Style "Scilab"    	TitleIcon mini-fractal.xpm
Style "thot"      	TitleIcon mini-pencil.xpm
Style "LyX"      	TitleIcon mini-pencil.xpm
# xman resource names
Style "topBox"    	TitleIcon mini-book1.xpm
Style "help"      	TitleIcon mini-book2.xpm
Style "manualBrowser" 	TitleIcon mini-book2.xpm
# xpaint resource names
Style "xpaint"   	TitleIcon mini-paint.xpm
Style "Canvas"   	TitleIcon mini-paint.xpm
Style "fatbits" 	TitleIcon mini-paint.xpm
Style "filebrowser"	TitleIcon mini-ofolder.xpm
# others...
Style "Explorer"     	TitleIcon mini-ofolder.xpm
Style "FvwmPager"    	TitleIcon mini-pager.xpm
Style "XDbx"         	TitleIcon mini-bug2.xpm
Style "Workman"      	TitleIcon mini-cd.xpm
Style "*playcd*"      	TitleIcon mini-cd.xpm
Style "*cdplay*"      	TitleIcon mini-cd.xpm
Style "Mail"         	TitleIcon mini-mail.xpm
Style "AcroRead"     	TitleIcon mini-pdf.xpm
Style "NcFtp"        	TitleIcon mini-ftp.xpm
Style "XbmBrowser"   	TitleIcon mini-paint.xpm
Style "Bitmap"       	TitleIcon mini-paint.xpm
Style "Pixmap"       	TitleIcon mini-paint.xpm
Style "XClipboard"   	TitleIcon mini-clipboard.xpm
Style "control-panel"  	TitleIcon mini-redhat.xpm
Style "*console*"  	TitleIcon mini-display.xpm



#========================================================================#
# Modules lancs au dmarrage et au redmarrage (aprs un Restart)
#========================================================================#


AddToFunc "InitFunction"    "I" Exec xsetroot -solid cyan4 &
+                           "I" Module FvwmButtons
+                           "I" Module FvwmTaskBar
+                           "I" Module FvwmAudio
# dcommentez la ligne suivante pour avoir l'"autoraise" des fentres
#+			    "I" Module FvwmAuto 500

AddToFunc "RestartFunction" "I" Module FvwmButtons
+                           "I" Module FvwmTaskBar
+                           "I" Module FvwmAudio



#========================================================================#
# Dfinitions de fonctions plus complexes, utilises plus loin
#========================================================================#


#------------------------------------------------------------------------------
# Celle-ci bouge puis remonte la fentre si on bouge la souris,
# remonte uniquement la fentre si on clique, ou agrandit au maximum
# la fentre si on double-clique.
# Si on avait voulu agrandir au maximum uniquement dans le sens vertical,
# on aurait mis Maximize 100 0 
#------------------------------------------------------------------------------

AddToFunc "Move-or-Raise" "M" Move
+                         "M" Raise
+                         "C" Raise
+                         "D" Maximize 100 100



#------------------------------------------------------------------------------
# Celle-ci bouge ou (des)iconifie une fentre:
#------------------------------------------------------------------------------

AddToFunc "Move-or-Iconify" "M" Move
+                           "D" Iconify


#------------------------------------------------------------------------------
# Celle-ci redimensionne puis remonte la fentre si on bouge la souris,
# remonte la fentre si on clique, et alterne remonte/redescente de la
# fentre si on double-clique.
#------------------------------------------------------------------------------

AddToFunc "Resize-or-Raise" "M" Resize
+                           "M" Raise
+                           "C" Raise
+                           "D" RaiseLower


#------------------------------------------------------------------------------
# Celle-ci selectionne la prochaine fentre iconifie, la dsiconifie
# et focalise le WM dessus (mais ca marche pas comme je voudrais...)
#------------------------------------------------------------------------------

AddToFunc "Raise-Iconic"  "I"	Focus
+			  "I"	Iconify -1


#========================================================================#
# Maintenant les menus - on attends encore un peu avant de faire les liens
# Il y a un paquet de fichiers et executables que vous n'aurez pas -  vous
# d'adapter ces exemples pour ce dont vous avez besoin.
#========================================================================#


#------------------------------------------------------------------------------
# Voici pour le menu Start de la  FvwmTaskBar
#------------------------------------------------------------------------------

DestroyMenu "StartMenu"
AddToMenu "StartMenu@linux-menu.xpm@^#808080^" \
  "&Programs%programs.xpm%"	Popup Programs
+ "&Documents%documents.xpm%"	Popup Documents
+ "&Settings%settings.xpm%"	Popup Settings
+ ""				Nop 
+ "RedHat %mini-redhat.xpm%"	popup redhat
+ ""				Nop
+ "&Find%find1.xpm%"		Popup Find
+ "&Help%help.xpm%"		Exec  xman
+ "&Run...%run.xpm%"		Exec  run 
+ ""				Nop 
+ "Sh&ut Down%shutdown.xpm%"	Popup Shutdown


#------------------------------------------------------------------------------
# Le menu suivant n'est evidemment valable que si on a install
# une distribution RedHat sur sa machine
#------------------------------------------------------------------------------

AddToMenu "RedHat" "RedHat Tools" Title
+ "Glint%mini-hammer.xpm%"		Exec glint 
+ "Control Panel%mini-filemgr.xpm%"	Exec control-panel 


#------------------------------------------------------------------------------
#--------- Le menu principal 
#------------------------------------------------------------------------------

DestroyMenu "Programs"
AddToMenu "Programs" \
  "Accessories%mini-hammer.xpm%"	Popup Accessories
+ "File managers%mini-filemgr.xpm" 	Popup FileManagers
+ "Graphic processing%mini-paint.xpm%"	Popup Graphics
+ "Word processing%mini-pencil.xpm%"	Popup WordPro
+ "Internet%mini-connect.xpm%"		Popup Internet
+ "Multimedia%mini-cd.xpm%"		Popup Multimedia
+ "Scientific applications%mini-question.xpm" Popup SciApps
+ "Viewers%mini-eye.xpm%"		Popup Viewers
+ "Games%mini-happy.xpm%"		Popup Games
+ ""					Nop
+ "Modules%mini-modules.xpm%"		Popup Module-Popup


#------------------------------------------------------------------------------
#--------- Accessoires divers et varis 
#------------------------------------------------------------------------------

DestroyMenu "Accessories"
AddToMenu "Accessories" \
  "View processes%mini-run.xpm%" Exec xterm -font 7x14 \
                                              -bg \#c0c0c0 -fg black \
                                              -T Top -n Top -e top  
+ "System load%mini-perf.xpm%"		Exec xload 
#+ "Memory usage%mini-perf.xpm%"	Exec xmem 
+ "Calculator%mini-calc.xpm%"		Exec xcalc 
+ "Magnifying glass%mini-zoom.xpm%" 	Exec xmag 
+ "Daliclock%mini-clock.xpm%" 		Exec xdaliclock 
+ "Xclock%mini-clock.xpm%" 		Exec xclock
#+ "Xgrab%mini-camera.xpm%"		Exec xgrab 
+ "Xxgdb%mini-bug2.xpm%"		Exec xxgdb 
+ "Xclipboard%mini-clipboard.xpm%"	Exec xclipboard
+ "View colormap%mini-colors.xpm%"	Exec xcolormap 
+ "Color viewer%mini-colors.xpm%"	Exec xcolorsel 
+ "Font viewer%mini-font.xpm%"		Exec xfontsel 

#------------------------------------------------------------------------------
#--------- Games and amusements - comme indiqu 
#------------------------------------------------------------------------------

DestroyMenu "Games"
AddToMenu "Games" \
  "Maze%mini-maze.xpm%"			Exec maze 
+ "Spider%mini-espada.xpm%"		Exec exec spider 
+ "Chess%mini-slon.xpm%"		Exec xboard 
+ "Xlander%mini-xlander.xpm%"		Exec exec xlander 
+ "Xmahjongg%mini-xmahjongg.xpm%" 	Exec exec xmahjongg 
+ "Tetris%mini-tetris.xpm%"		Exec tetris 
+ "Hextris%mini-hextris.xpm%"		Exec exec xhextris 
+ "" Nop
+ "Amusements"				Popup Amusements

DestroyMenu "Amusements"
AddToMenu "Amusements" \
  "Eyes%mini-eyes.xpm%"		Exec xeyes 
+ "X logo%mini-bx2.xpm%"	Exec xlogo 
+ "Xroach%mini-roach.xpm%"	Exec exec xroach 
+ "Fractint%mini-fractal.xpm%"	Exec xterm -font 7x14 -e xfractint map=chroma  
+ "Xsnow%mini-xsnow.xpm%"	Exec xsnow 
+ "Desktop cat%mini-cat.xpm%"	Exec xcat 


#------------------------------------------------------------------------------
#--------- Multimedia
#------------------------------------------------------------------------------
DestroyMenu "Multimedia"
AddToMenu "Multimedia" \
  "CD player%mini-cdlabel.xpm%"	Exec xplaycd 
+ "Xltwav%mini-sound.xpm%"	Exec xltwavplay 
+ "Xmixer%mini-audiovol.xpm%"	Exec xmixer 

#------------------------------------------------------------------------------
#--------- Outils de visualisation (postcript,pdf,fontes...)
#------------------------------------------------------------------------------

DestroyMenu "Viewers"
AddToMenu "Viewers" \
  "Ghostview (Postcript)%mini-gv.xpm%"	Exec ghostview 
+ "GV (Postcript)%mini-gv.xpm%"		Exec gv 
+ "Xview (images)%mini-xv.xpm%"		Exec xv 
+ "Font viewer%mini-font.xpm%"		Exec xfontsel 
+ "Pixmap browser%mini-paint.xpm%"	Exec xbmbrowser 

#------------------------------------------------------------------------------
#--------- Surfons....
#------------------------------------------------------------------------------
DestroyMenu "Internet"
AddToMenu "Internet" \
  "Netscape%mini-nscape.xpm%"	Exec netscape -geometry 790x543+0+0 
+ "Amaya%mini-nscape.xpm%"	Exec amaya -geometry 790x543+0+0 
+ "Mail (Pine)%mini-mail.xpm%"	Exec color-xterm -name Mail -T Mail -ls -fn 8x13 -e pine -i 
+ "NcFTP%mini-ftp.xpm%"		Exec color-xterm -name NcFtp -T FTP -ls -fn 8x13 -e ncftp 



#------------------------------------------------------------------------------
#--------- Outils graphiques
#------------------------------------------------------------------------------

DestroyMenu "Graphics"
AddToMenu "Graphics" \
  "The Gimp%mini-paint.xpm%" 		Exec gimp 
+ "Pixmap editor%mini-paint.xpm%" 	Exec pixmap 
+ "Xview%mini-xv.xpm%"		  	Exec xv 
+ "Xfig%mini-xfig.xpm%"		  	Exec xfig 
+ "Paint%mini-palette.xpm%"	  	Exec xpaint 

#------------------------------------------------------------------------------
#--------- Traitement de texte
#------------------------------------------------------------------------------

DestroyMenu "WordPro"
AddToMenu "WordPro" \
  "Lyx%mini-edit.xpm%"		Exec lyx 
+ "Thot%mini-edit.xpm%"	Exec thot


#------------------------------------------------------------------------------
#--------- Diverses applications scientifiques
#------------------------------------------------------------------------------

DestroyMenu "SciApps"
AddToMenu "SciApps" \
  "GNU plot%mini-graph.xpm%"	Exec xterm -T "GNU plot" -name GNUplot \
                                           -font "-*-lucidatypewriter-medium-r-*-*-14-*" \
                                           -e gnuplot 
+ "SCILAB%mini-zoom.xpm%"	Exec scilab 
+ "Spice3f5%mini-zoom.xpm%"	Exec xterm -T "Spice" -name Spice \
                                           -font "-*-lucidatypewriter-medium-r-*-*-14-*" \
					   -e spice3


#------------------------------------------------------------------------------
#--------- File managers
#------------------------------------------------------------------------------
DestroyMenu "FileManagers"
AddToMenu "FileManagers" \
  "Explorer%mini-ofolder.xpm%"		Exec explorer . 
+ "Tk desk%mini-desktop.xpm%"		Exec tkdesk 
+ "File manager%mini-filemgr.xpm%" 	Exec xfm


#------------------------------------------------------------------------------
#--------- Modules
#------------------------------------------------------------------------------

DestroyMenu "Module-Popup"
AddToMenu "Module-Popup" \
  "Audio%mini-sound.xpm%"               Module FvwmAudio
+ "Autoraise%mini-raise.xpm%"           Module FvwmAuto 500
+ "Banner%mini-ray.xpm%"                Module FvwmBanner
+ "Button bar%mini-ball.xpm%"           Module FvwmButtons
+ "Mini button bar%mini-ball.xpm%"      Module FvwmButtons MiniButtons
#+ "Configure%mini-hammer.xpm%"         Module FvwmConfig
+ "Console%mini-term.xpm%"              Module FvwmConsole -sb 
+ "Debug%mini-bug2.xpm%"                Module FvwmDebug
+ "IconBox%mini-maxwide.xpm%"           Module FvwmIconBox
+ "IconMan%mini-ball.xpm%"              Module FvwmIconMan
+ "Identify%mini-question.xpm%"         Module FvwmIdent
+ "Pager%mini-pager.xpm%"               Module FvwmPager 0 3
+ "Save Desktop%mini-desktop.xpm%"      Module FvwmSaveDesk
+ "Talk%mini-term.xpm%"                 Module FvwmTalk
+ "TaskBar%mini-exp.xpm"                Module FvwmTaskBar
+ "Window List%mini-windows.xpm%"       Module FvwmWinList



#------------------------------------------------------------------------------
#--------- Documentation
#------------------------------------------------------------------------------


DestroyMenu "Documents"
AddToMenu "Documents" \
  "FVWM95%mini.win95.xpm%"		Exec netscape \
					/usr/doc/fvwm95-test/docs/index.html
+ "LDP%mini-penguin.xpm%"		Popup LDP



#------------------------------------------------------------------------------
#--------- Linux Documentation Project
#------------------------------------------------------------------------------

DestroyMenu "LDP"
AddToMenu "LDP" \
  "FAQs%mini-nscape.xpm%"		Exec netscape \
					/usr/doc/FAQ/INDEX.html 
+ "HOWTOs%mini-nscape.xpm%"		Exec netscape \
					/usr/doc/HTML/ldp/HOWTO-INDEX.html 
+ "RHL4.2 Guide%mini-nscape.xpm%"	Exec netscape \
					/usr/doc/HTML/RHL-4.2-UG/manual/index.html
+ "Installation Guide%mini-nscape.xpm%"	Exec netscape \
			/usr/doc/HTML/ldp/install-guide-2.2.2.html/gs.html 
+ "Syst_Admin Guide%mini-nscape.xpm%"	Exec netscape \
					/usr/doc/HTML/LDP/sag-0.6/index.html 

# A titre d'exemple - adaptez a ce que vous voulez/avez



#------------------------------------------------------------------------------
#--------- Reglages
#------------------------------------------------------------------------------
 
DestroyMenu "Settings"
AddToMenu "Settings" \
  "Backgrounds%mini-paint.xpm%"		Popup Backgrounds
+ "Back Color%mini-colors.xpm"		Popup Backcolor
+ "Back Animation%mini-fractal.xpm%" 	Popup Background-Animation
+ "Mouse Settings%mini-mouse.xpm%" 	Popup Mouse-Settings
+ "Keyboard Settings%mini-keyboard.xpm%" Popup Keyboard-Settings
+ "Sound Card%mini-audiovol.xpm%"	Exec xmixer &
+ "X setup%mini-display.xpm%"		Exec xterm -T XF86Setup -e XF86Setup 
+ "Video tuning%mini-monitor.xpm%"	Exec xterm -T Xvidtune -e xvidtune 
+ "X configuration%mini-display.xpm%"	Exec xterm -T Xconfig -e Xconfigurator 



#------------------------------------------------------------------------------
#--------- Images en fonds d'cran
#------------------------------------------------------------------------------

DestroyMenu "Backgrounds"
AddToMenu "Backgrounds" \
  "PurpleHaze"	exec xv -root -quit /usr/local/X11R6/lib/X11/backgrounds/purplehaze.jpg
+ "Ether"	exec xv -root -quit /usr/local/X11R6/lib/X11/backgrounds/ether.gif
+ "Rivendel"	exec xv -root -max -quit /usr/local/X11R6/lib/X11/backgrounds/rivendel.jpg
+ "Turner"	exec xv -root -max -quit /usr/local/X11R6/lib/X11/backgrounds/snwstorm.gif
+ "Frosty"	exec xv -root -max -quit /usr/local/X11R6/lib/X11/backgrounds/frosty.gif

#------------------------------------------------------------------------------
#--------- Couleurs de fond d'cran
#------------------------------------------------------------------------------

DestroyMenu "Backcolor"
AddToMenu "Backcolor" \
  "Black"		exec xsetroot -solid Black
+ "Red"			exec xsetroot -solid Red
+ "Yellow"		exec xsetroot -solid Yellow
+ "Green"		exec xsetroot -solid Green
+ "Cyan"		exec xsetroot -solid Cyan4
+ "Blue"		exec xsetroot -solid Blue
+ "Magenta"		exec xsetroot -solid Magenta
+ "White"		exec xsetroot -solid White
+ "Blue decay"		exec bggen 100 100 255  0 0 100  | xv -root -quit  -
+ "Rainbow"		exec bggen red green blue | xv -root -quit -
+ "Full Rainbow" 	exec bggen black red yellow green blue purple black | xv -root -quit -  
+ "Magenta decay" 	exec bggen blue magenta | xv -root -quit -


#------------------------------------------------------------------------------
#--------- Animation du fond d'cran (a donne vite le tournis!)
#------------------------------------------------------------------------------

DestroyMenu "Background-Animation"
AddToMenu "Background-Animation" \
  "Braid"	exec xlock -inroot -mode braid 
+ "Flame"	exec xlock -inroot -mode flame 
+ "Grav"	exec xlock -inroot -mode grav 
+ "Pyro"	exec xlock -inroot -mode pyro 
+ "Qix"		exec xlock -inroot -mode qix 
+ "Rock"	exec xlock -inroot -mode rock 
+ "Slip"	exec xlock -inroot -mode spiral 
+ "Spline"	exec xlock -inroot -mode spline 
+ "Swarm"	exec xlock -inroot -mode swarm 
+ "Worm"	exec xlock -inroot -mode worm &
  # Stop the animation in the background
+ "Stop It"	exec kill -9 $(ps aux | grep xlock | grep -v grep | awk '{print $2}')

#------------------------------------------------------------------------------
#--------- Reglage de la souris
#------------------------------------------------------------------------------
DestroyMenu	Mouse-Settings
AddToMenu	Mouse-Settings	"Mouse Settings"	Title
+	"Mouse Slow"		exec	xset m 1 1
+	"Mouse Default"		exec	xset m default
+	"Mouse Fast"		exec	xset m 4 2
+	"Speedy Gonzales"	exec	xset m 10 2


#------------------------------------------------------------------------------
#--------- Reglage clavier
#------------------------------------------------------------------------------

DestroyMenu	Keyboard-Settings
AddToMenu	Keyboard-Settings	"Keyboard Settings"	Title
+	"Auto-repeat off"	exec	xset -r
+	"Auto-repeat on"	exec	xset r on


#------------------------------------------------------------------------------
#--------- Shutdown
#------------------------------------------------------------------------------

DestroyMenu "Shutdown"
AddToMenu "Shutdown" \
  "Quit fvwm95%mini-exclam.xpm%"	Module FvwmForm QuitVerify
+ ""					Nop
+ "Restart%mini-turn.xpm%"		Restart
+ "" 					Nop
#+ "Start fvwm2%mini-olwm.xpm%"		Restart fvwm2
+ "Start olvwm%mini-olwm.xpm%"		Restart olvwm
#+ "Start Afterstep%mini-olwm.xpm%"	Restart afterstep
+ "Start Enlightenment%mini-twm.xpm%"	Restart enlightenment
#+ "Start mwm%mini-mwm.xpm%"		Restart mwm
+ ""					Nop
+ "Screensaver%mini-display.xpm%" 	Exec xlock -nolock -nice 10 -mode random
+ "Screenlock%mini-lock.xpm%"		Exec xlock -nice 10 -mode random
+ ""					Nop
# Ces deux dernires ne marchent que si on est root:
+ "Halt%mini-stop.xpm%"	  		Exec shutdown -h now
+ "Reboot%mini-ray.xpm%" 		Exec shutdown -r now



#------------------------------------------------------------------------------
# Menu d'utilitaires, dclench par la souris
#------------------------------------------------------------------------------

AddToMenu "Utilities@utilities-menu.xpm@^#808080^" \
 "Console%mini-term.xpm%" 	        Exec xconsole -geometry 354x76+658+0 &
+ "Explorer%mini-ofolder.xpm%"		Exec explorer . &
+ "Top%mini-run.xpm%"			Exec xterm  -geometry 80x45+125+10  -T Top -n Top -e top &
+ "Restart%mini-turn.xpm%"		Restart
+ ""					Nop
+ "Shells%mini-sh1.xpm"			Popup Shells
+ "Editors%mini-edit.xpm%"		Popup Editors
+ "Programs%mini-x2.xpm%"		Popup Programs
+ ""					Nop
+ "Modules%mini-modules.xpm%"		Popup Module-Popup
+ ""					Nop
+ "Refresh Screen%mini-ray.xpm%"	Refresh
+ ""					Nop
+ "Exit Fvwm%mini-stop.xpm%"		Quit


#------------------------------------------------------------------------------
#--------- SHELLS
#------------------------------------------------------------------------------

DestroyMenu "Shells"
AddToMenu "Shells" \
  "Xterm	(9x15 font)%mini-sh1.xpm%"	Exec xterm -fn 9x15 
+ "NXterm	(9x15 font)%mini-sh1.xpm%" 	Exec nxterm -fn 9x15 
+ "Rxvt		(9x15 font)%mini-sh1.xpm%"	Exec rxvt -fn 9x15 
+ ""					    	Nop
+ "CmdTool %mini-term.xpm%"			Exec cmdtool 
+ ""					    	Nop
+ "Large Xterm	(10x20 font)%mini-sh.xpm%" 	Exec xterm -fn 10x20 
+ "Large NXterm	(10x20 font)%mini-sh.xpm%" 	Exec nxterm -fn 10x20 
+ "Large Rxvt	(10x20 font)%mini-sh.xpm%"	Exec rxvt -fn 10x20 


#------------------------------------------------------------------------------
#--------- Editeurs de texte 
#------------------------------------------------------------------------------
DestroyMenu "Editors"
AddToMenu "Editors" \
  "Textedit%mini-edit.xpm%" 	Exec textedit -geometry 630x490+95+5
+ "Xedit%mini-edit.xpm%" 	Exec xedit
+ "Emacs%mini-edit.xpm%"	Exec emacs



#------------------------------------------------------------------------------
# Menus dfinissant les oprations les plus courantes sur les fentres
#------------------------------------------------------------------------------


AddToMenu "Window" "Window Ops" Title
+ "&Move%mini-move.xpm%"                Function Move-or-Raise
+ "&Resize%mini-resize.xpm%"            Function Resize-or-Raise
+ "R&aise%mini-raise.xpm%"              Raise
+ "&Lower%mini-lower.xpm%"              Lower
+ "(De)Iconify%mini-iconify.xpm%"       Iconify
+ "(Un)Stick%mini.stick.xpm%"           Stick
+ "(Un)Maximize%mini-max1.xpm%"         Maximize 100 100
+ "(Un)Maxwide%mini-maxwide.xpm%"       Maximize 100 0
+ "(Un)Maxtall%mini-maxtall.xpm%"       Maximize   0 100
+ ""                                    Nop
+ "Kill%mini-crosbone.xpm%"             Destroy
+ "&Close"                              Delete
+ ""                                    Nop
+ "Switch to..."                        WindowList
+ "Refresh Screen%mini-ray.xpm%"        Refresh


#------------------------------------------------------------------------------
# Le mme, version 'light' 
#------------------------------------------------------------------------------

AddToMenu "Window-Ops2" "&Restore"        Iconify -1
+                       "&Move"           Move-or-Raise
+                       "&Size"           Resize-or-Raise
+                       "Mi&nimize"       Iconify 1
+                       "Ma&ximize"       Maximize 100 100
+                       ""                Nop
+                       "&Kill"           Destroy
+                       "&Close	Alt+F4"   Delete

#========================================================================#
# Et on dfinit une fonction complexe de plus - on ne pouvait pas la dfinir
# plus tot car elle fait appel  un menu 
#
# Cette fonction cre le menu qu'on obtient avec le bouton 3 de la souris
# sur la barre de titre d'une fentre:
#========================================================================#


AddToFunc "window_ops_func" "C" PopUp Window-Ops2
+              "M" PopUp Window-Ops2
+              "D" Delete  


#========================================================================#
# Dfinitions des boutons de la souris


#------------------------------------------------------------------------------
# D'abord, lorsque la souris n'est pas sur une fentre:
# Bouton 1 donne le menu 'Window ops'
# Bouton 2 donne le menu 'Utilities'
# Bouton 3 donne la liste des fentres actives

# Context: R=Root (c'est  dire sur le fond,pas sur une fentre)
# Modifi(er): touches CTRL,SHIFT,ALT etc
# sachant que A=AnyModifier, donc n'importe laquelle!
#------------------------------------------------------------------------------

#     Bouton	Context Modifi 	Fonction
Mouse 3		R   	A       Menu "Utilities" Nop
Mouse 1		R    	A       Menu "Window Ops" Nop
Mouse 2         R       A       WindowList

#========================================================================#
# Maintenant on dfinit les boutons des fentres
# Un bouton de souris sur le bouton de gauche donne le menu 'window ops' 
# le bouton 1 de souris  sur le bouton  l'extrme droite tue la fentre
# Un bouton sur le second bouton de droite maximise la fenetre
# Un bouton dans le troisime bouton de droite iconifie la fentre
# Notez: "Mouse 0"= n'importe quel bouton de la souris.
#========================================================================#

#     Button	Context Modif 	Function
Mouse 0		1    	A      	Function "window_ops_func"
Mouse 1         2       A       Delete
Mouse 0		4    	A     	Maximize 100 100
Mouse 0		6    	A     	Iconify


#========================================================================#
# Et maintenant le reste du contour de la fentre -
# Ici on va utiliser les fonctions Move-or-Lower etc dfinies plus haut
#
# Contexte: S=Sides (cts) T=Title (titre) F=??? (coins)
#========================================================================#


#------------------------------------------------------------------------------
# Bouton 1 dans les coins et cts  donne la fonction "Resize-or-Raise"
Mouse 1		FS	A	Function "Resize-or-Raise"

# Bouton 1 dans la barre de titre donne "Move-or-Raise"
Mouse 1		T	A	Function "Move-or-Raise"

# Bouton 2 dans les coins, cts  ou barre de titre
Mouse 2		FST	A	Function "window_ops_func"

# Bouton 3 dans le contour (excepts les boutons de la barre de titre)
Mouse 3		TSIF	A	RaiseLower

# Bouton 3 dans la fentre avec Meta  remonte/redescent la fentre
Mouse 3         W       M       RaiseLower
#------------------------------------------------------------------------------


#========================================================================#
# Maintenant on programme des raccourcis au clavier
# Apprenez  vous en servir: on ne peux trs vite plus s'en passer!
#========================================================================#


#------------------------------------------------------------------------------
# Quelques exemples d'utilisation des flches:
# flche+shift, et on va vers l'cran virtuel point par la flche
#------------------------------------------------------------------------------

Key Left	A	S	Scroll -100 0
Key Right	A	S	Scroll +100 +0
Key Up		A	S	Scroll +0   -100
Key Down	A	S	Scroll +0   +100

#------------------------------------------------------------------------------
# Presque pareil, avec les touches pageup/down
#------------------------------------------------------------------------------

Key Next	A       C       Scroll 100000 0
Key Next	R       N       Scroll 100000 0  
Key Prior	A       C       Scroll -100000 0
Key Prior	R       N       Scroll -100000 0


#------------------------------------------------------------------------------
# flche+shift+control dpace le curseur de 1% dans la page
#------------------------------------------------------------------------------

Key Left	A	SC	CursorMove -1 0
Key Right	A	SC	CursorMove +1 +0
Key Up		A	SC	CursorMove +0   -1
Key Down	A	SC	CursorMove +0   +1


#------------------------------------------------------------------------------
# Ceux-la j'aime bien : control+flche et on passe en revue les
# diffrentes fentres ouvertes....
#------------------------------------------------------------------------------

Key Left	A	C	Prev Focus
Key Right	A	C	Next [!iconic] Focus
Key Up		A	C	Prev Focus
Key Down	A	C	Next [iconic] Raise-Iconic

#------------------------------------------------------------------------------
# Mme chode, mais avec les touches Micro$oft
# J'ai renomm ces touches F25 et F26 via un fichier .Xmodmap
#------------------------------------------------------------------------------

Key F25		A	N	Prev Focus
Key F26 	A	N	Next [!iconic] Focus


#========================================================================#
# Dfinitions et caractrisations des modules
# Chacun d'entre eux a sa page de man - lisez-la!
#========================================================================#


#------------------------------------------------------------------------------
#------------------ FvwmAudio
#------------------------------------------------------------------------------

*FvwmAudioPlayCmd /usr/bin/play
*FvwmAudioDir    /usr/local/lib/sounds
*FvwmAudioDelay 1
*FvwmAudio destroy_window crash.au
*FvwmAudio add_window  drip.au



#------------------------------------------------------------------------------
#------------------ FvwmBanner
#------------------------------------------------------------------------------

*FvwmBannerTimeout 2


#------------------------------------------------------------------------------
#------------------ FvwmButtons
#------------------------------------------------------------------------------


Style "FvwmButtons"  NoTitle,NoHandles, Sticky, \
                     WindowListSkip, BorderWidth 4,CirculateSkip

# Par dfaut en haut  droite - dcommentez la ligne suivante et bidouillez
# les valeurs pour obtenir ce que vous voulez.

#*FvwmButtonsGeometry -5-34

*FvwmButtonsFore Black
*FvwmButtonsBack #c3c3c3
*FvwmButtonsFont -adobe-helvetica-bold-r-*-*-10-*-*-*-*-*-*-*

# Disposition : on prcise ranges ou colonnes, pas les deux
# Sur mon cran 17' j'ai une colonne - ici j'en ai mis deux pour
# montrer un ou deux gadgets.

*FvwmButtonsColumns 2

*FvwmButtons Nxterm	rterm.xpm   	Exec	"nxterm" nxterm
*FvwmButtons xemacs	xemacs-icon.xpm Exec	"emacs" xemacs 
*FvwmButtons xview	xv.color.xpm	Exec	"xv" xv 
*FvwmButtons Gimp	wilber.xpm	Exec	"The GIMP" gimp 
*FvwmButtons GV   	gv.xpm		Exec    "gv" gv
*FvwmButtons kill    	bomb_3d.xpm   	Destroy
*FvwmButtons (2x2, Swallow(UseOld) 	"Desktop" 'FvwmPager 0 0')
*FvwmButtons (2x1) - whatever(UseOld)    Swallow "xload" Exec nice -16 xload -nolabel \
                                        -update 4  -bg grey59 -geometry -1500-1500
*FvwmButtons(2x1, Frame 0, Swallow(UseOld) "XDaliClock" \
             'Exec nice xdaliclock -noseconds -24 \
             -fn "-adobe-helvetica-bold-r-*-*-34-*-*-*-*-*-*-*" \
             -fg black -bg LightGray -bw 0 -geometry 130x50-1500-1500')

#------------------------------------------------------------------------------
#------------------ MiniButtons
#------------------------------------------------------------------------------

Style "MiniButtons"  NoTitle,NoHandles,Sticky,StaysOnTop,WindowListSkip,BorderWidth 0

*MiniButtonsFore Black
*MiniButtonsBack #c0c0c0
*MiniButtonsFont -adobe-helvetica-bold-r-*-*-10-*-*-*-*-*-*-*
*MiniButtonsGeometry -5+5
*MiniButtonsRows 1
*MiniButtonsPadding 1 1

*MiniButtons -   mini-term.xpm        Exec    	"XTerm" color-xterm -ls -sb -fn 8x13 -title "Color xterm" 
*MiniButtons -   mini-filemgr.xpm     Exec    	"Xfm" xfm -title "File Manager" 
*MiniButtons -   mini-edit.xpm        Exec	"Textedit" textedit -En 32 
*MiniButtons -   mini-calc.xpm        Exec    	"Calculator" xcalc 
*MiniButtons -   mini-xv.xpm          Exec    	"xv" xv 
*MiniButtons -   mini-gv.xpm          Exec    	"ghostview" ghostview 
*MiniButtons -   mini-nscape.xpm      Exec    	"Netscape" netscape -geometry 790x543+0+0
#*MiniButtons -   mini-bomb.xpm        Destroy


#------------------------------------------------------------------------------
#------------------ NoClutter
#------------------------------------------------------------------------------

*FvwmNoClutter 3600 Iconify 1
*FvwmNoClutter 86400 Delete
*FvwmNoCLutter 172800 Destroy


#------------------------------------------------------------------------------
#------------------ FvwmIdent
#------------------------------------------------------------------------------

*FvwmIdentBack #000080
*FvwmIdentFore Yellow
*FvwmIdentFont -adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*


#------------------------------------------------------------------------------
#------------------ FvwmPager
#------------------------------------------------------------------------------

*FvwmPagerBack grey60
*FvwmPagerFore black
*FvwmPagerFont -adobe-helvetica-bold-r-*-*-10-*-*-*-*-*-*-*
*FvwmPagerHilight #c3c3c3
#*FvwmPagerGeometry -1500-1500
*FvwmPagerLabel 0 Desktop
*FvwmPagerLabel 1 Development
*FvwmPagerLabel 2 Internet
*FvwmPagerLabel 3 Misc
*FvwmPagerSmallFont 5x8


     
#-------------------------------------------------------------------------------
#------------------ FvwmTaskBar
#-------------------------------------------------------------------------------

Style "FvwmTaskBar" NoTitle,BorderWidth 4,HandleWidth 4,Sticky, \
                    StaysOnTop,WindowListSkip,CirculateSkip

*FvwmTaskBarGeometry +0-0
*FvwmTaskBarFore Black
*FvwmTaskBarBack #c0c0c0
*FvwmTaskBarFont -adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*
*FvwmTaskBarSelFont -adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*
*FvwmTaskBarStatusFont fixed
*FvwmTaskBarAction Click1 Iconify -1,Raise,Focus
*FvwmTaskBarAction Click2 Iconify
*FvwmTaskBarAction Click3 PopUp Window-Ops2
*FvwmTaskBarUseSkipList
*FvwmTaskBarAutoStick
*FvwmTaskBarStartName Start
*FvwmTaskBarStartMenu StartMenu
*FvwmTaskBarStartIcon mini-penguin.xpm
*FvwmTaskBarShowTips
*FvwmTaskBarShowTransients
#*FvwmTaskBarHighlightFocus
*FvwmTaskBarAutoHide
*FvwmTaskBarDeskOnly



# Now the goodies....

*FvwmTaskBarGoodyLoadablePlugins /usr/local/lib/X11/fvwm95/
*FvwmTaskBarGoodyLoadableQuiet

# Modem
*FvwmTaskBarGoodyLoadableSymbol CheckLockModuleSymbol
*FvwmTaskBarGoodyLoadableId .Modem
*FvwmTaskBarCheckLockModuleIcon.Modem mini-connect.xpm
*FvwmTaskBarCheckLockModuleTip.Modem Modem is in use
*FvwmTaskBarCheckLockModuleCommand.Modem Popup Network
*FvwmTaskBarCheckLockModuleLockFile.Modem /var/lock/LCK..modem

# Screen lock
*FvwmTaskBarGoodyLoadableSymbol GoodyModuleSymbol
*FvwmTaskBarGoodyLoadableId .LOCK
*FvwmTaskBarGoodyModuleIcon.LOCK mini-lock.xpm
*FvwmTaskBarGoodyModuleTip.LOCK Screen Locker
*FvwmTaskBarGoodyModuleCommand.LOCK Exec xlock -nice 10 -mode random

# Sound mixer
*FvwmTaskBarGoodyLoadableSymbol GoodyModuleSymbol
*FvwmTaskBarGoodyLoadableId .SPEAKER
*FvwmTaskBarGoodyModuleIcon.SPEAKER mini-speaker.xpm
*FvwmTaskBarGoodyModuleTip.SPEAKER Audio Control Panel
*FvwmTaskBarGoodyModuleCommand.SPEAKER Exec OXmixer

# Date
*FvwmTaskBarGoodyLoadableSymbol ShowDateModuleSymbol
*FvwmTaskBarGoodyLoadableId .DATE
*FvwmTaskBarShowDateModuleTip.DATE Date
*FvwmTaskBarShowDateModuleCommand.DATE Exec xmessage `date` 
*FvwmTaskBarShowDateModuleClockFormat.DATE %H:%M 
#*FvwmTaskBarShowDateModuleHourlyCommand.DATE exec xmessage hourly command

# Mail
*FvwmTaskBarGoodyLoadableSymbol MailCheckModuleSymbol
*FvwmTaskBarGoodyLoadableId .MAIL
*FvwmTaskBarMailCheckModuleMailIcon.MAIL mini-mail.xpm
*FvwmTaskBarMailCheckModuleCommand.MAIL Exec xterm -T Mail -e mail
*FvwmTaskBarMailCheckModuleNewMailIcon.MAIL mini-newmail.xpm
*FvwmTaskBarMailCheckModuleNewMailTip.MAIL You have new mail
*FvwmTaskBarMailCheckModuleNewMailCommand.MAIL beep
*FvwmTaskBarMailCheckModuleUnreadMailIcon.MAIL mini-unreadmail.xpm
*FvwmTaskBarMailCheckModuleMailFile.MAIL /var/spool/mail/$USER
*FvwmTaskBarMailCheckModuleAutoMailTip.MAIL
#*FvwmTaskBarMailCheckModuleMailTipUnblankScreen.MAIL
*FvwmTaskBarMailCheckModuleMailTipFormat.MAIL 1 0 10 2 10


#------------------------------------------------------------------------------
#------------------ FvwmWinList
#------------------------------------------------------------------------------

*FvwmWinListBack #c3c3c3
*FvwmWinListFore Black
*FvwmWinListFont -adobe-helvetica-bold-r-*-*-10-*-*-*-*-*-*-*
*FvwmWinListAction Click1 Iconify -1,Focus
*FvwmWinListAction Click2 Iconify
*FvwmWinListAction Click3 Module "FvwmIdent" FvwmIdent
*FvwmWinListUseSkipList
*FvwmWinListGeometry +0-1
 


#------------------------------------------------------------------------------
# Celui-ci est utilis par FvwmForm dans un menu
# - on peux en crire facilement soi-mme
#------------------------------------------------------------------------------

*QuitVerifyGrabServer
*QuitVerifyWarpPointer
*QuitVerifyFont		*helvetica*b*r*n*14*
*QuitVerifyButtonFont	*helvetica*b*o*n*14*
*QuitVerifyFore		Black
*QuitVerifyBack		Light Gray
*QuitVerifyItemFore	Wheat
*QuitVerifyItemBack	Gray50
# begin items
*QuitVerifyCommand	Beep
*QuitVerifyLine		center
*QuitVerifyText		"Do you really want to logout?"
*QuitVerifyLine		expand
*QuitVerifyButton	quit      "Logout"  ^M
*QuitVerifyCommand	Quit
*QuitVerifyButton	quit      "Cancel"  ^[
*QuitVerifyCommand	Nop
# Fvwm window style
Style "QuitVerify"	NoHandles, BorderWidth 5