/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.RMIHashes;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastRef;
import gnu.java.rmi.server.UnicastRemoteCall;
import gnu.java.rmi.server.UnicastRemoteStub;
import gnu.java.rmi.server.UnicastServer;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.Skeleton;
import java.util.Hashtable;

public class UnicastServerRef
extends UnicastRef {
    private static final Class[] stubprototype = new Class[]{UnicastServerRef.class$("java.rmi.server.RemoteRef")};
    Remote myself;
    private Skeleton skel;
    private RemoteStub stub;
    private Hashtable methods;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public UnicastServerRef(ObjID id, int port, RMIServerSocketFactory ssf) {
        super(id);
        this.manager = UnicastConnectionManager.getInstance(port, ssf);
    }

    public RemoteStub exportObject(Remote obj) throws RemoteException {
        if (this.myself == null) {
            this.myself = obj;
            Class cls = obj.getClass();
            this.stub = (RemoteStub)this.getHelperClass(cls, "_Stub");
            if (this.stub == null) {
                throw new RemoteException("failed to export: " + cls);
            }
            this.skel = (Skeleton)this.getHelperClass(cls, "_Skel");
            this.buildMethodHash(obj.getClass());
            UnicastServer.exportObject(this);
        }
        return this.stub;
    }

    private Object getHelperClass(Class cls, String type) {
        try {
            String classname = cls.getName();
            Class scls = Class.forName(classname + type);
            if (type.equals("_Stub")) {
                try {
                    Constructor con = scls.getConstructor(stubprototype);
                    return con.newInstance(new Object[]{this});
                }
                catch (NoSuchMethodException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (InvocationTargetException stub) {
                    // empty catch block
                }
                RemoteStub stub = (RemoteStub)scls.newInstance();
                UnicastRemoteStub.setStubRef(stub, this);
                return stub;
            }
            return scls.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public String getClientHost() throws ServerNotActiveException {
        throw new Error("Not implemented");
    }

    private void buildMethodHash(Class cls) {
        this.methods = new Hashtable();
        Method[] meths = cls.getMethods();
        for (int i = 0; i < meths.length; ++i) {
            if (meths[i].getDeclaringClass().getName().startsWith("java.")) continue;
            long hash = RMIHashes.getMethodHash(meths[i]);
            this.methods.put(new Long(hash), meths[i]);
        }
    }

    public Object incomingMessageCall(UnicastConnection conn, int method, long hash) throws Exception {
        if (method == -1) {
            Method meth = (Method)this.methods.get(new Long(hash));
            if (meth == null) {
                throw new NoSuchMethodException();
            }
            ObjectInputStream in = conn.getObjectInputStream();
            int nrargs = meth.getParameterTypes().length;
            Object[] args = new Object[nrargs];
            for (int i = 0; i < nrargs; ++i) {
                try {
                    args[i] = in.readObject();
                    continue;
                }
                catch (Exception t) {
                    t.printStackTrace();
                    throw t;
                }
            }
            return meth.invoke(this.myself, args);
        }
        if (this.skel == null) {
            throw new NoSuchMethodException();
        }
        UnicastRemoteCall call = new UnicastRemoteCall(conn);
        this.skel.dispatch(this.myself, call, method, hash);
        return call.returnValue();
    }
}

