/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.MenuItemPeer;
import java.io.Serializable;
import java.util.EventListener;

public class MenuItem
extends MenuComponent
implements Serializable {
    private static final long serialVersionUID = -21757335363267194L;
    private String actionCommand;
    private boolean enabled;
    private long eventMask;
    private String label;
    private MenuShortcut shortcut;
    private transient ActionListener action_listeners;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public MenuItem() {
    }

    public MenuItem(String label) {
        this.label = label;
    }

    public MenuItem(String label, MenuShortcut shortcut) {
        this.label = label;
        this.shortcut = shortcut;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String label) {
        this.label = label;
        if (this.peer != null) {
            MenuItemPeer mp = (MenuItemPeer)this.peer;
            mp.setLabel(label);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.peer != null) {
            MenuItemPeer mp = (MenuItemPeer)this.peer;
            mp.setEnabled(enabled);
        }
    }

    public void enable(boolean enabled) {
        this.setEnabled(enabled);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut shortcut) {
        this.shortcut = shortcut;
    }

    public void deleteShortcut() {
        this.shortcut = null;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    protected final void enableEvents(long events) {
        this.eventMask |= events;
    }

    protected final void disableEvents(long events) {
        this.eventMask &= events ^ (long)-1;
    }

    public void addNotify() {
        if (this.peer != null) {
            this.peer = this.getToolkit().createMenuItem(this);
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, listener);
        this.enableEvents(128);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, l);
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == MenuItem.class$("java.awt.event.ActionListener")) {
            return Component.getListenersImpl(listenerType, this.action_listeners);
        }
        return Component.getListenersImpl(listenerType, null);
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 1001 && e.id >= 1001 && (this.action_listeners != null || (this.eventMask & (long)128) != 0L)) {
            this.processEvent(e);
        }
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
        }
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.action_listeners != null) {
            this.action_listeners.actionPerformed(event);
        }
    }

    public String paramString() {
        return "label=" + this.label + ",enabled=" + this.enabled + ",actionCommand=" + this.actionCommand + "," + super.paramString();
    }
}

