/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class RMIClassLoader {
    private static MyClassLoader loader = new MyClassLoader();

    public static Class loadClass(String name) throws MalformedURLException, ClassNotFoundException {
        return RMIClassLoader.loadClass(System.getProperty("java.rmi.server.codebase"), name);
    }

    public static Class loadClass(URL codebase, String name) throws MalformedURLException, ClassNotFoundException {
        URL u = new URL(codebase, name + ".class");
        try {
            URLConnection conn = u.openConnection();
            DataInputStream strm = new DataInputStream(conn.getInputStream());
            byte[] data = new byte[conn.getContentLength()];
            strm.readFully(data);
            return loader.defineClass(name, data);
        }
        catch (IOException _) {
            throw new ClassNotFoundException(name);
        }
    }

    public static Class loadClass(String codebase, String name) throws MalformedURLException, ClassNotFoundException {
        StringTokenizer tok = new StringTokenizer(codebase, ":");
        while (tok.hasMoreTokens()) {
            try {
                return RMIClassLoader.loadClass(new URL(tok.nextToken()), name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    public static String getClassAnnotation(Class cl) {
        return null;
    }

    public static Object getSecurityContext(ClassLoader loader) {
        throw new Error("Not implemented");
    }

    static class MyClassLoader
    extends ClassLoader {
        MyClassLoader() {
        }

        Class defineClass(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }
}

