/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DQTMarkerSegment
extends MarkerSegment {
    List tables = new ArrayList();

    DQTMarkerSegment(float f2, boolean bl2) {
        super(219);
        this.tables.add(new Qtable(true, f2));
        if (bl2) {
            this.tables.add(new Qtable(false, f2));
        }
    }

    DQTMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        int n2 = this.length;
        while (n2 > 0) {
            Qtable qtable = new Qtable(jPEGBuffer);
            this.tables.add(qtable);
            n2 -= qtable.data.length + 1;
        }
        jPEGBuffer.bufAvail -= this.length;
    }

    DQTMarkerSegment(JPEGQTable[] jPEGQTableArray) {
        super(219);
        int n2 = 0;
        while (n2 < jPEGQTableArray.length) {
            this.tables.add(new Qtable(jPEGQTableArray[n2], n2));
            ++n2;
        }
    }

    DQTMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(219);
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        if (n2 < 1 || n2 > 4) {
            throw new IIOInvalidTreeException("Invalid DQT node", node);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.tables.add(new Qtable(nodeList.item(n3)));
            ++n3;
        }
    }

    protected Object clone() {
        DQTMarkerSegment dQTMarkerSegment = (DQTMarkerSegment)super.clone();
        dQTMarkerSegment.tables = new ArrayList(this.tables.size());
        Iterator iterator = this.tables.iterator();
        while (iterator.hasNext()) {
            Qtable qtable = (Qtable)iterator.next();
            dQTMarkerSegment.tables.add(qtable.clone());
        }
        return dQTMarkerSegment;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("dqt");
        int n2 = 0;
        while (n2 < this.tables.size()) {
            Qtable qtable = (Qtable)this.tables.get(n2);
            iIOMetadataNode.appendChild(qtable.getNativeNode());
            ++n2;
        }
        return iIOMetadataNode;
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
    }

    void print() {
        this.printTag("DQT");
        System.out.println("Num tables: " + Integer.toString(this.tables.size()));
        int n2 = 0;
        while (n2 < this.tables.size()) {
            Qtable qtable = (Qtable)this.tables.get(n2);
            qtable.print();
            ++n2;
        }
        System.out.println();
    }

    Qtable getChromaForLuma(Qtable qtable) {
        Qtable qtable2 = null;
        boolean bl2 = true;
        int n2 = 1;
        while (n2 < 64) {
            if (qtable.data[n2] != qtable.data[n2 - 1]) {
                bl2 = false;
                break;
            }
            ++n2;
        }
        if (bl2) {
            qtable2 = (Qtable)qtable.clone();
            qtable2.tableID = 1;
        } else {
            int n3 = 0;
            int n4 = 1;
            while (n4 < 64) {
                if (qtable.data[n4] > qtable.data[n3]) {
                    n3 = n4;
                }
                ++n4;
            }
            float f2 = (float)qtable.data[n3] / (float)JPEGQTable.K1Div2Luminance.getTable()[n3];
            JPEGQTable jPEGQTable = JPEGQTable.K2Div2Chrominance.getScaledInstance(f2, true);
            qtable2 = new Qtable(jPEGQTable, 1);
        }
        return qtable2;
    }

    Qtable getQtableFromNode(Node node) throws IIOInvalidTreeException {
        return new Qtable(node);
    }

    class Qtable
    implements Cloneable {
        int elementPrecision;
        int tableID;
        final int QTABLE_SIZE = 64;
        int[] data;
        private final int[] zigzag = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};

        Qtable(boolean bl2, float f2) {
            this.elementPrecision = 0;
            JPEGQTable jPEGQTable = null;
            if (bl2) {
                this.tableID = 0;
                jPEGQTable = JPEGQTable.K1Div2Luminance;
            } else {
                this.tableID = 1;
                jPEGQTable = JPEGQTable.K2Div2Chrominance;
            }
            if (f2 != 0.75f) {
                f2 = JPEG.convertToLinearQuality(f2);
                jPEGQTable = bl2 ? JPEGQTable.K1Luminance.getScaledInstance(f2, true) : JPEGQTable.K2Div2Chrominance.getScaledInstance(f2, true);
            }
            this.data = jPEGQTable.getTable();
        }

        Qtable(JPEGBuffer jPEGBuffer) throws IIOException {
            this.elementPrecision = jPEGBuffer.buf[jPEGBuffer.bufPtr] >>> 4;
            this.tableID = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xF;
            if (this.elementPrecision != 0) {
                throw new IIOException("Unsupported element precision");
            }
            this.data = new int[64];
            int n2 = 0;
            while (n2 < 64) {
                this.data[n2] = jPEGBuffer.buf[jPEGBuffer.bufPtr + this.zigzag[n2]] & 0xFF;
                ++n2;
            }
            jPEGBuffer.bufPtr += 64;
        }

        Qtable(JPEGQTable jPEGQTable, int n2) {
            this.elementPrecision = 0;
            this.tableID = n2;
            this.data = jPEGQTable.getTable();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Qtable(Node node) throws IIOInvalidTreeException {
            if (!node.getNodeName().equals("dqtable")) throw new IIOInvalidTreeException("Invalid node, expected dqtable", node);
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n2 = namedNodeMap.getLength();
            if (n2 < 1 || n2 > 2) {
                throw new IIOInvalidTreeException("dqtable node must have 1 or 2 attributes", node);
            }
            this.elementPrecision = 0;
            this.tableID = MarkerSegment.getAttributeValue(node, namedNodeMap, "qtableId", 0, 3, true);
            if (!(node instanceof IIOMetadataNode)) throw new IIOInvalidTreeException("dqtable node must have user object", node);
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
            JPEGQTable jPEGQTable = (JPEGQTable)iIOMetadataNode.getUserObject();
            if (jPEGQTable == null) {
                throw new IIOInvalidTreeException("dqtable node must have user object", node);
            }
            this.data = jPEGQTable.getTable();
        }

        protected Object clone() {
            Qtable qtable = null;
            try {
                qtable = (Qtable)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.data != null) {
                qtable.data = (int[])this.data.clone();
            }
            return qtable;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("dqtable");
            iIOMetadataNode.setAttribute("elementPrecision", Integer.toString(this.elementPrecision));
            iIOMetadataNode.setAttribute("qtableId", Integer.toString(this.tableID));
            iIOMetadataNode.setUserObject(new JPEGQTable(this.data));
            return iIOMetadataNode;
        }

        void print() {
            System.out.println("Table id: " + Integer.toString(this.tableID));
            System.out.println("Element precision: " + Integer.toString(this.elementPrecision));
            new JPEGQTable(this.data).toString();
        }
    }
}

