/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class WindowsInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private Color selectedTitleGradientColor;
    private Color notSelectedTitleGradientColor;
    private JPopupMenu systemPopupMenu;
    private JLabel systemLabel;

    public WindowsInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void addSubComponents() {
        this.add(this.systemLabel);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selectedTitleGradientColor = UIManager.getColor("InternalFrame.activeTitleGradient");
        this.notSelectedTitleGradientColor = UIManager.getColor("InternalFrame.inactiveTitleGradient");
        Color color = UIManager.getColor("InternalFrame.activeBorderColor");
        this.setBorder(BorderFactory.createLineBorder(color, 1));
    }

    public void paintComponent(Graphics graphics) {
        this.paintTitleBackground(graphics);
        if (this.frame.getTitle() != null) {
            int n2;
            boolean bl2 = this.frame.isSelected();
            Font font = graphics.getFont();
            graphics.setFont(this.getFont());
            if (bl2) {
                graphics.setColor(this.selectedTextColor);
            } else {
                graphics.setColor(this.notSelectedTextColor);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rectangle = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rectangle = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rectangle = this.closeButton.getBounds();
            }
            String string = this.frame.getTitle();
            if (WindowsGraphicsUtils.isLeftToRight(this.frame)) {
                if (rectangle.x == 0) {
                    rectangle.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                n2 = this.systemLabel.getX() + this.systemLabel.getWidth() + 2;
                int n4 = rectangle.x - n2 - 3;
                string = this.getTitle(this.frame.getTitle(), fontMetrics, n4);
            } else {
                n2 = this.systemLabel.getX() - 2 - SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            graphics.drawString(string, n2, n3);
            graphics.setFont(font);
        }
    }

    protected void paintTitleBackground(Graphics graphics) {
        Boolean bl2 = (Boolean)LookAndFeel.getDesktopPropertyValue("win.frame.captionGradientsOn", new Boolean(false));
        if (bl2.booleanValue() && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            boolean bl3 = this.frame.isSelected();
            int n2 = this.getWidth();
            if (bl3) {
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.selectedTitleColor, (int)((double)n2 * 0.75), 0.0f, this.selectedTitleGradientColor);
                graphics2D.setPaint(gradientPaint);
            } else {
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.notSelectedTitleColor, (int)((double)n2 * 0.75), 0.0f, this.notSelectedTitleGradientColor);
                graphics2D.setPaint(gradientPaint);
            }
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(paint);
        } else {
            super.paintTitleBackground(graphics);
        }
    }

    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenu();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.systemLabel = new JLabel(this.frame.getFrameIcon());
        this.systemLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Dimension dimension = new Dimension();
                Border border = WindowsInternalFrameTitlePane.this.frame.getBorder();
                if (border != null) {
                    dimension.width += border.getBorderInsets((Component)((WindowsInternalFrameTitlePane)WindowsInternalFrameTitlePane.this).frame).left + border.getBorderInsets((Component)((WindowsInternalFrameTitlePane)WindowsInternalFrameTitlePane.this).frame).right;
                    dimension.height += border.getBorderInsets((Component)((WindowsInternalFrameTitlePane)WindowsInternalFrameTitlePane.this).frame).bottom + border.getBorderInsets((Component)((WindowsInternalFrameTitlePane)WindowsInternalFrameTitlePane.this).frame).top;
                }
                if (!WindowsInternalFrameTitlePane.this.frame.isIcon()) {
                    WindowsInternalFrameTitlePane.this.systemPopupMenu.show(mouseEvent.getComponent(), WindowsInternalFrameTitlePane.this.getX() - dimension.width, WindowsInternalFrameTitlePane.this.getY() + WindowsInternalFrameTitlePane.this.getHeight() - dimension.height);
                } else {
                    WindowsInternalFrameTitlePane.this.systemPopupMenu.show(mouseEvent.getComponent(), WindowsInternalFrameTitlePane.this.getX() - dimension.width, WindowsInternalFrameTitlePane.this.getY() - ((WindowsInternalFrameTitlePane)WindowsInternalFrameTitlePane.this).systemPopupMenu.getPreferredSize().height - dimension.height);
                }
            }
        });
    }

    protected void addSystemMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jPopupMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jPopupMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jPopupMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        this.systemPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new WindowsPropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new WindowsTitlePaneLayout();
    }

    public class WindowsPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        public WindowsPropertyChangeHandler() {
            super(WindowsInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("frameIcon".equals(string) && WindowsInternalFrameTitlePane.this.systemLabel != null) {
                WindowsInternalFrameTitlePane.this.systemLabel.setIcon(WindowsInternalFrameTitlePane.this.frame.getFrameIcon());
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    public class WindowsTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        public WindowsTitlePaneLayout() {
            super(WindowsInternalFrameTitlePane.this);
        }

        public void layoutContainer(Container container) {
            boolean bl2 = WindowsGraphicsUtils.isLeftToRight(WindowsInternalFrameTitlePane.this.frame);
            int n2 = WindowsInternalFrameTitlePane.this.getWidth();
            int n3 = WindowsInternalFrameTitlePane.this.getHeight();
            int n4 = WindowsInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            Icon icon = WindowsInternalFrameTitlePane.this.frame.getFrameIcon();
            int n5 = 0;
            if (icon != null) {
                n5 = icon.getIconHeight();
            }
            int n6 = bl2 ? 2 : n2 - 16 - 2;
            WindowsInternalFrameTitlePane.this.systemLabel.setBounds(n6, (n3 - n5) / 2, 16, 16);
            int n7 = n6 = bl2 ? n2 - 16 - 2 : 2;
            if (WindowsInternalFrameTitlePane.this.frame.isClosable()) {
                WindowsInternalFrameTitlePane.this.closeButton.setBounds(n6, (n3 - n4) / 2 + 1, 16, 14);
                n6 += bl2 ? -18 : 18;
            }
            if (WindowsInternalFrameTitlePane.this.frame.isMaximizable()) {
                WindowsInternalFrameTitlePane.this.maxButton.setBounds(n6, (n3 - n4) / 2 + 1, 16, 14);
                n6 += bl2 ? -18 : 18;
            }
            if (WindowsInternalFrameTitlePane.this.frame.isIconifiable()) {
                WindowsInternalFrameTitlePane.this.iconButton.setBounds(n6, (n3 - n4) / 2 + 1, 16, 14);
            }
        }
    }
}

