/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;

class TableView
extends BoxView
implements ViewFactory {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private int cellSpacing;
    private int captionIndex = -1;
    private boolean relativeCells;
    private boolean multiRowCells;
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements totalColumnRequirements;
    SizeRequirements[] columnRequirements;
    RowIterator rowIterator = new RowIterator();
    ColumnIterator colIterator = new ColumnIterator();
    Vector rows = new Vector();
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    public TableView(Element element) {
        super(element, 1);
        this.totalColumnRequirements = new SizeRequirements();
    }

    protected RowView createTableRow(Element element) {
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.TR) {
            return new RowView(element);
        }
        return null;
    }

    public int getColumnCount() {
        return this.columnSpans.length;
    }

    public int getColumnSpan(int n2) {
        if (n2 < this.columnSpans.length) {
            return this.columnSpans[n2];
        }
        return 0;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getMultiRowSpan(int n2, int n3) {
        RowView rowView = this.getRow(n2);
        RowView rowView2 = this.getRow(n3);
        if (rowView != null && rowView2 != null) {
            int n4 = rowView.viewIndex;
            int n5 = rowView2.viewIndex;
            int n6 = this.getOffset(1, n5) - this.getOffset(1, n4) + this.getSpan(1, n5);
            return n6;
        }
        return 0;
    }

    public int getRowSpan(int n2) {
        RowView rowView = this.getRow(n2);
        if (rowView != null) {
            return this.getSpan(1, rowView.viewIndex);
        }
        return 0;
    }

    RowView getRow(int n2) {
        if (n2 < this.rows.size()) {
            return (RowView)this.rows.elementAt(n2);
        }
        return null;
    }

    protected int getColumnsOccupied(View view) {
        String string;
        AttributeSet attributeSet = view.getElement().getAttributes();
        if (attributeSet.isDefined(HTML.Attribute.COLSPAN) && (string = (String)attributeSet.getAttribute(HTML.Attribute.COLSPAN)) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected int getRowsOccupied(View view) {
        String string;
        AttributeSet attributeSet = view.getElement().getAttributes();
        if (attributeSet.isDefined(HTML.Attribute.ROWSPAN) && (string = (String)attributeSet.getAttribute(HTML.Attribute.ROWSPAN)) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected void invalidateGrid() {
        this.gridValid = false;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    void updateInsets() {
        short s2 = (short)this.painter.getInset(1, this);
        short s3 = (short)this.painter.getInset(3, this);
        if (this.captionIndex != -1) {
            View view = this.getView(this.captionIndex);
            short s4 = (short)view.getPreferredSpan(1);
            AttributeSet attributeSet = view.getAttributes();
            Object object = attributeSet.getAttribute(CSS.Attribute.CAPTION_SIDE);
            if (object != null && object.equals("bottom")) {
                s3 = (short)(s3 + s4);
            } else {
                s2 = (short)(s2 + s4);
            }
        }
        this.setInsets(s2, (short)this.painter.getInset(2, this), s3, (short)this.painter.getInset(4, this));
    }

    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
    }

    void updateGrid() {
        if (!this.gridValid) {
            this.relativeCells = false;
            this.multiRowCells = false;
            this.captionIndex = -1;
            this.rows.removeAllElements();
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                View view = this.getView(n3);
                if (view instanceof RowView) {
                    this.rows.addElement(view);
                    object = (RowView)view;
                    ((RowView)object).clearFilledColumns();
                    ((RowView)object).rowIndex = this.rows.size() - 1;
                    ((RowView)object).viewIndex = n3;
                } else {
                    HTML.Tag tag;
                    object = view.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (object instanceof HTML.Tag && (tag = (HTML.Tag)object) == HTML.Tag.CAPTION) {
                        this.captionIndex = n3;
                    }
                }
                ++n3;
            }
            int n4 = 0;
            int n5 = this.rows.size();
            int n6 = 0;
            while (n6 < n5) {
                RowView rowView = this.getRow(n6);
                int n7 = 0;
                int n8 = 0;
                while (n8 < rowView.getViewCount()) {
                    int n9;
                    AttributeSet attributeSet;
                    CSS.LengthValue lengthValue;
                    View view = rowView.getView(n8);
                    if (!this.relativeCells && (lengthValue = (CSS.LengthValue)(attributeSet = view.getAttributes()).getAttribute(CSS.Attribute.WIDTH)) != null && lengthValue.isPercentage()) {
                        this.relativeCells = true;
                    }
                    while (rowView.isFilled(n7)) {
                        ++n7;
                    }
                    int n10 = this.getRowsOccupied(view);
                    if (n10 > 1) {
                        this.multiRowCells = true;
                    }
                    if ((n9 = this.getColumnsOccupied(view)) > 1 || n10 > 1) {
                        int n11 = n6 + n10;
                        int n12 = n7 + n9;
                        int n13 = n6;
                        while (n13 < n11) {
                            int n14 = n7;
                            while (n14 < n12) {
                                if (n13 != n6 || n14 != n7) {
                                    this.addFill(n13, n14);
                                }
                                ++n14;
                            }
                            ++n13;
                        }
                        if (n9 > 1) {
                            n7 += n9 - 1;
                        }
                    }
                    ++n8;
                    ++n7;
                }
                n4 = Math.max(n4, n7);
                ++n6;
            }
            this.columnSpans = new int[n4];
            this.columnOffsets = new int[n4];
            this.columnRequirements = new SizeRequirements[n4];
            int n15 = 0;
            while (n15 < n4) {
                this.columnRequirements[n15] = new SizeRequirements();
                this.columnRequirements[n15].maximum = Integer.MAX_VALUE;
                ++n15;
            }
            this.gridValid = true;
        }
    }

    void addFill(int n2, int n3) {
        RowView rowView = this.getRow(n2);
        if (rowView != null) {
            rowView.fillColumn(n3);
        }
    }

    protected void layoutColumns(int n2, int[] nArray, int[] nArray2, SizeRequirements[] sizeRequirementsArray) {
        this.colIterator.setLayoutArrays(nArray, nArray2, n2);
        CSS.calculateTiledLayout(this.colIterator, n2);
    }

    void calculateColumnRequirements(int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl2 = false;
        int n6 = this.getRowCount();
        int n7 = 0;
        while (n7 < n6) {
            RowView rowView = this.getRow(n7);
            int n8 = 0;
            n5 = rowView.getViewCount();
            n4 = 0;
            while (n4 < n5) {
                View view = rowView.getView(n4);
                while (rowView.isFilled(n8)) {
                    ++n8;
                }
                int n9 = this.getRowsOccupied(view);
                n3 = this.getColumnsOccupied(view);
                if (n3 == 1) {
                    this.checkSingleColumnCell(n2, n8, view);
                } else {
                    bl2 = true;
                    n8 += n3 - 1;
                }
                ++n4;
                ++n8;
            }
            ++n7;
        }
        if (bl2) {
            int n10 = 0;
            while (n10 < n6) {
                RowView rowView = this.getRow(n10);
                n5 = 0;
                n4 = rowView.getViewCount();
                int n11 = 0;
                while (n11 < n4) {
                    View view = rowView.getView(n11);
                    while (rowView.isFilled(n5)) {
                        ++n5;
                    }
                    n3 = this.getColumnsOccupied(view);
                    if (n3 > 1) {
                        this.checkMultiColumnCell(n2, n5, n3, view);
                        n5 += n3 - 1;
                    }
                    ++n11;
                    ++n5;
                }
                ++n10;
            }
        }
    }

    void checkSingleColumnCell(int n2, int n3, View view) {
        SizeRequirements sizeRequirements = this.columnRequirements[n3];
        sizeRequirements.minimum = Math.max((int)view.getMinimumSpan(n2), sizeRequirements.minimum);
        sizeRequirements.preferred = Math.max((int)view.getPreferredSpan(n2), sizeRequirements.preferred);
    }

    void checkMultiColumnCell(int n2, int n3, int n4, View view) {
        int n5;
        int[] nArray;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n6 = 0;
        while (n6 < n4) {
            SizeRequirements sizeRequirements = this.columnRequirements[n3 + n6];
            l2 += (long)sizeRequirements.minimum;
            l3 += (long)sizeRequirements.preferred;
            l4 += (long)sizeRequirements.maximum;
            ++n6;
        }
        int n7 = (int)view.getMinimumSpan(n2);
        if ((long)n7 > l2) {
            SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n4];
            int n8 = 0;
            while (n8 < n4) {
                sizeRequirementsArray[n8] = this.columnRequirements[n3 + n8];
                ++n8;
            }
            int[] nArray2 = new int[n4];
            nArray = new int[n4];
            SizeRequirements.calculateTiledPositions(n7, null, sizeRequirementsArray, nArray, nArray2);
            int n9 = 0;
            while (n9 < n4) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[n9];
                sizeRequirements.minimum = Math.max(nArray2[n9], sizeRequirements.minimum);
                sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
                ++n9;
            }
        }
        if ((long)(n5 = (int)view.getPreferredSpan(n2)) > l3) {
            SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n4];
            int n10 = 0;
            while (n10 < n4) {
                sizeRequirementsArray[n10] = this.columnRequirements[n3 + n10];
                ++n10;
            }
            nArray = new int[n4];
            int[] nArray3 = new int[n4];
            SizeRequirements.calculateTiledPositions(n5, null, sizeRequirementsArray, nArray3, nArray);
            int n11 = 0;
            while (n11 < n4) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[n11];
                sizeRequirements.preferred = Math.max(nArray[n11], sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
                ++n11;
            }
        }
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        String string;
        this.updateGrid();
        this.calculateColumnRequirements(n2);
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        long l2 = 0L;
        long l3 = 0L;
        int n3 = this.columnRequirements.length;
        int n4 = 0;
        while (n4 < n3) {
            SizeRequirements sizeRequirements2 = this.columnRequirements[n4];
            l2 += (long)sizeRequirements2.minimum;
            l3 += (long)sizeRequirements2.preferred;
            ++n4;
        }
        int n5 = (n3 - 1) * this.cellSpacing;
        sizeRequirements.minimum = (int)(l2 += (long)n5);
        sizeRequirements.preferred = (int)(l3 += (long)n5);
        sizeRequirements.maximum = (int)l3;
        AttributeSet attributeSet = this.getAttributes();
        CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(CSS.Attribute.WIDTH);
        if (BlockView.spanSetFromAttributes(n2, sizeRequirements, lengthValue, null) && sizeRequirements.minimum < (int)l2) {
            sizeRequirements.minimum = sizeRequirements.preferred = (int)l2;
            sizeRequirements.maximum = sizeRequirements.preferred;
        }
        this.totalColumnRequirements.minimum = sizeRequirements.minimum;
        this.totalColumnRequirements.preferred = sizeRequirements.preferred;
        this.totalColumnRequirements.maximum = sizeRequirements.maximum;
        Object object = attributeSet.getAttribute(CSS.Attribute.TEXT_ALIGN);
        sizeRequirements.alignment = object != null ? ((string = object.toString()).equals("left") ? 0.0f : (string.equals("center") ? 0.5f : (string.equals("right") ? 1.0f : 0.0f))) : 0.0f;
        return sizeRequirements;
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        this.updateInsets();
        this.rowIterator.updateAdjustments();
        sizeRequirements = CSS.calculateTiledRequirements(this.rowIterator, sizeRequirements);
        sizeRequirements.maximum = sizeRequirements.preferred;
        return sizeRequirements;
    }

    protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        this.updateGrid();
        int n4 = this.getRowCount();
        int n5 = 0;
        while (n5 < n4) {
            RowView rowView = this.getRow(n5);
            rowView.layoutChanged(n3);
            ++n5;
        }
        this.layoutColumns(n2, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(n2, n3, nArray, nArray2);
    }

    protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        this.rowIterator.setLayoutArrays(nArray, nArray2);
        CSS.calculateTiledLayout(this.rowIterator, n2);
        if (this.captionIndex != -1) {
            int n4;
            View view = this.getView(this.captionIndex);
            nArray2[this.captionIndex] = n4 = (int)view.getPreferredSpan(1);
            short s2 = (short)this.painter.getInset(3, this);
            nArray[this.captionIndex] = s2 != this.getBottomInset() ? n2 + s2 : (int)(-this.getTopInset());
        }
    }

    protected View getViewAtPosition(int n2, Rectangle rectangle) {
        View view;
        int n3 = this.getViewCount();
        int n4 = 0;
        while (n4 < n3) {
            view = this.getView(n4);
            int n5 = view.getStartOffset();
            int n6 = view.getEndOffset();
            if (n2 >= n5 && n2 < n6) {
                if (rectangle != null) {
                    this.childAllocation(n4, rectangle);
                }
                return view;
            }
            ++n4;
        }
        if (n2 == this.getEndOffset()) {
            view = this.getView(n3 - 1);
            if (rectangle != null) {
                this.childAllocation(n3 - 1, rectangle);
            }
            return view;
        }
        return null;
    }

    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }
        return this.attr;
    }

    public void paint(Graphics graphics, Shape shape) {
        int n2;
        int n3;
        Rectangle rectangle = shape.getBounds();
        this.setSize(rectangle.width, rectangle.height);
        if (this.captionIndex != -1) {
            n3 = (int)this.painter.getInset(1, this);
            n2 = (int)this.painter.getInset(3, this);
            if (n3 != this.getTopInset()) {
                int n4 = this.getTopInset() - n3;
                rectangle.y += n4;
                rectangle.height -= n4;
            } else {
                rectangle.height -= this.getBottomInset() - n2;
            }
        }
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        n3 = this.getViewCount();
        n2 = 0;
        while (n2 < n3) {
            View view = this.getView(n2);
            view.paint(graphics, this.getChildAllocation(n2, shape));
            ++n2;
        }
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, this);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, shape, this);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, this);
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container;
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (shape != null && (container = this.getContainer()) != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void replace(int n2, int n3, View[] viewArray) {
        super.replace(n2, n3, viewArray);
        this.invalidateGrid();
    }

    public View create(Element element) {
        ViewFactory viewFactory;
        Object object;
        Object object2 = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object2 instanceof HTML.Tag) {
            object = (HTML.Tag)object2;
            if (object == HTML.Tag.TR) {
                return this.createTableRow(element);
            }
            if (object == HTML.Tag.TD || object == HTML.Tag.TH) {
                return new CellView(element);
            }
            if (object == HTML.Tag.CAPTION) {
                return new ParagraphView(element);
            }
        }
        if ((object = this.getParent()) != null && (viewFactory = ((View)object).getViewFactory()) != null) {
            return viewFactory.create(element);
        }
        return null;
    }

    class CellView
    extends BlockView {
        public CellView(Element element) {
            super(element, 1);
        }

        protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            super.layoutMajorAxis(n2, n3, nArray, nArray2);
            int n4 = 0;
            int n5 = nArray2.length;
            int n6 = 0;
            while (n6 < n5) {
                n4 += nArray2[n6];
                ++n6;
            }
            int n7 = 0;
            if (n4 < n2) {
                String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.VALIGN);
                if (string == null) {
                    AttributeSet attributeSet = this.getElement().getParentElement().getAttributes();
                    string = (String)attributeSet.getAttribute(HTML.Attribute.VALIGN);
                }
                if (string == null || string.equals("middle")) {
                    n7 = (n2 - n4) / 2;
                } else if (string.equals("bottom")) {
                    n7 = n2 - n4;
                }
            }
            if (n7 != 0) {
                int n8 = 0;
                while (n8 < n5) {
                    int n9 = n8++;
                    nArray[n9] = nArray[n9] + n7;
                }
            }
        }

        protected SizeRequirements calculateMajorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n2, sizeRequirements);
            sizeRequirements2.maximum = Integer.MAX_VALUE;
            return sizeRequirements2;
        }
    }

    public class RowView
    extends BoxView {
        private StyleSheet.BoxPainter painter;
        private AttributeSet attr;
        BitSet fillColumns = new BitSet();
        int rowIndex;
        int viewIndex;
        boolean multiRowCells;

        public RowView(Element element) {
            super(element, 0);
            this.setPropertiesFromAttributes();
        }

        void clearFilledColumns() {
            this.fillColumns.and(EMPTY);
        }

        void fillColumn(int n2) {
            this.fillColumns.set(n2);
        }

        boolean isFilled(int n2) {
            return this.fillColumns.get(n2);
        }

        int getColumnCount() {
            int n2 = 0;
            int n3 = this.fillColumns.size();
            int n4 = 0;
            while (n4 < n3) {
                if (this.fillColumns.get(n4)) {
                    ++n2;
                }
                ++n4;
            }
            return this.getViewCount() + n2;
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        protected StyleSheet getStyleSheet() {
            HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
            return hTMLDocument.getStyleSheet();
        }

        public void preferenceChanged(View view, boolean bl2, boolean bl3) {
            super.preferenceChanged(view, bl2, bl3);
            if (TableView.this.multiRowCells && bl3) {
                int n2 = this.rowIndex - 1;
                while (n2 >= 0) {
                    RowView rowView = TableView.this.getRow(n2);
                    if (rowView.multiRowCells) {
                        rowView.preferenceChanged(null, false, true);
                        break;
                    }
                    --n2;
                }
            }
        }

        protected SizeRequirements calculateMajorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = new SizeRequirements();
            sizeRequirements2.minimum = TableView.this.totalColumnRequirements.minimum;
            sizeRequirements2.maximum = TableView.this.totalColumnRequirements.maximum;
            sizeRequirements2.preferred = TableView.this.totalColumnRequirements.preferred;
            sizeRequirements2.alignment = 0.0f;
            return sizeRequirements2;
        }

        public float getMinimumSpan(int n2) {
            float f2 = n2 == 0 ? (float)(TableView.this.totalColumnRequirements.minimum + this.getLeftInset() + this.getRightInset()) : super.getMinimumSpan(n2);
            return f2;
        }

        public float getMaximumSpan(int n2) {
            float f2 = n2 == 0 ? 2.1474836E9f : super.getMaximumSpan(n2);
            return f2;
        }

        public float getPreferredSpan(int n2) {
            float f2 = n2 == 0 ? (float)(TableView.this.totalColumnRequirements.preferred + this.getLeftInset() + this.getRightInset()) : super.getPreferredSpan(n2);
            return f2;
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            super.changedUpdate(documentEvent, shape, viewFactory);
            int n2 = documentEvent.getOffset();
            if (n2 <= this.getStartOffset() && n2 + documentEvent.getLength() >= this.getEndOffset()) {
                this.setPropertiesFromAttributes();
            }
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
            super.paint(graphics, rectangle);
        }

        public void replace(int n2, int n3, View[] viewArray) {
            super.replace(n2, n3, viewArray);
            TableView.this.invalidateGrid();
        }

        protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            this.multiRowCells = false;
            int n3 = this.getViewCount();
            int n4 = 0;
            while (n4 < n3) {
                View view = this.getView(n4);
                if (TableView.this.getRowsOccupied(view) > 1) {
                    this.multiRowCells = true;
                    l4 = Math.max((long)((int)view.getMaximumSpan(n2)), l4);
                } else {
                    l2 = Math.max((long)((int)view.getMinimumSpan(n2)), l2);
                    l3 = Math.max((long)((int)view.getPreferredSpan(n2)), l3);
                    l4 = Math.max((long)((int)view.getMaximumSpan(n2)), l4);
                }
                ++n4;
            }
            if (sizeRequirements == null) {
                sizeRequirements = new SizeRequirements();
                sizeRequirements.alignment = 0.5f;
            }
            sizeRequirements.preferred = (int)l3;
            sizeRequirements.minimum = (int)l2;
            sizeRequirements.maximum = (int)l4;
            return sizeRequirements;
        }

        protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            int n4 = 0;
            int n5 = this.getViewCount();
            int n6 = 0;
            while (n6 < n5) {
                View view = this.getView(n6);
                while (this.isFilled(n4)) {
                    ++n4;
                }
                int n7 = TableView.this.getColumnsOccupied(view);
                nArray2[n6] = TableView.this.columnSpans[n4];
                nArray[n6] = TableView.this.columnOffsets[n4];
                if (n7 > 1) {
                    int n8 = TableView.this.columnSpans.length;
                    int n9 = 1;
                    while (n9 < n7) {
                        if (n4 + n9 < n8) {
                            int n10 = n6;
                            nArray2[n10] = nArray2[n10] + TableView.this.columnSpans[n4 + n9];
                        }
                        ++n9;
                    }
                    n4 += n7 - 1;
                }
                ++n6;
                ++n4;
            }
        }

        protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n2, n3, nArray, nArray2);
            int n4 = 0;
            int n5 = this.getViewCount();
            int n6 = 0;
            while (n6 < n5) {
                View view = this.getView(n6);
                while (this.isFilled(n4)) {
                    ++n4;
                }
                int n7 = TableView.this.getColumnsOccupied(view);
                int n8 = TableView.this.getRowsOccupied(view);
                if (n8 > 1) {
                    int n9 = this.rowIndex;
                    int n10 = Math.min(this.rowIndex + n8 - 1, TableView.this.getRowCount() - 1);
                    nArray2[n6] = TableView.this.getMultiRowSpan(n9, n10);
                }
                if (n7 > 1) {
                    n4 += n7 - 1;
                }
                ++n6;
                ++n4;
            }
        }

        public int getResizeWeight(int n2) {
            return 1;
        }

        protected View getViewAtPosition(int n2, Rectangle rectangle) {
            View view;
            int n3 = this.getViewCount();
            int n4 = 0;
            while (n4 < n3) {
                view = this.getView(n4);
                int n5 = view.getStartOffset();
                int n6 = view.getEndOffset();
                if (n2 >= n5 && n2 < n6) {
                    if (rectangle != null) {
                        this.childAllocation(n4, rectangle);
                    }
                    return view;
                }
                ++n4;
            }
            if (n2 == this.getEndOffset()) {
                view = this.getView(n3 - 1);
                if (rectangle != null) {
                    this.childAllocation(n3 - 1, rectangle);
                }
                return view;
            }
            return null;
        }

        void setPropertiesFromAttributes() {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
            this.painter = styleSheet.getBoxPainter(this.attr);
        }
    }

    class RowIterator
    implements CSS.LayoutIterator {
        private int row;
        private int[] adjustments;
        private int[] offsets;
        private int[] spans;

        RowIterator() {
        }

        void updateAdjustments() {
            int n2 = 1;
            if (TableView.this.multiRowCells) {
                int n3 = TableView.this.getRowCount();
                this.adjustments = new int[n3];
                int n4 = 0;
                while (n4 < n3) {
                    RowView rowView = TableView.this.getRow(n4);
                    if (rowView.multiRowCells) {
                        int n5 = rowView.getViewCount();
                        int n6 = 0;
                        while (n6 < n5) {
                            View view = rowView.getView(n6);
                            int n7 = TableView.this.getRowsOccupied(view);
                            if (n7 > 1) {
                                int n8 = (int)view.getPreferredSpan(n2);
                                this.adjustMultiRowSpan(n8, n7, n4);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            } else {
                this.adjustments = null;
            }
        }

        void adjustMultiRowSpan(int n2, int n3, int n4) {
            if (n4 + n3 > this.getCount() && (n3 = this.getCount() - n4) < 1) {
                return;
            }
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                RowView rowView = TableView.this.getRow(n4 + n6);
                n5 = (int)((float)n5 + rowView.getPreferredSpan(1));
                ++n6;
            }
            if (n2 > n5) {
                int n7 = n2 - n5;
                int n8 = n7 / n3;
                int n9 = n8 + (n7 - n8 * n3);
                RowView rowView = TableView.this.getRow(n4);
                this.adjustments[n4] = Math.max(this.adjustments[n4], n9);
                int n10 = 1;
                while (n10 < n3) {
                    this.adjustments[n4 + n10] = Math.max(this.adjustments[n4 + n10], n8);
                    ++n10;
                }
            }
        }

        void setLayoutArrays(int[] nArray, int[] nArray2) {
            this.offsets = nArray;
            this.spans = nArray2;
        }

        public void setOffset(int n2) {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                this.offsets[rowView.viewIndex] = n2;
            }
        }

        public int getOffset() {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                return this.offsets[rowView.viewIndex];
            }
            return 0;
        }

        public void setSpan(int n2) {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                this.spans[rowView.viewIndex] = n2;
            }
        }

        public int getSpan() {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                return this.spans[rowView.viewIndex];
            }
            return 0;
        }

        public int getCount() {
            return TableView.this.rows.size();
        }

        public void setIndex(int n2) {
            this.row = n2;
        }

        public float getMinimumSpan(float f2) {
            return this.getPreferredSpan(f2);
        }

        public float getPreferredSpan(float f2) {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                int n2 = this.adjustments != null ? this.adjustments[this.row] : 0;
                return rowView.getPreferredSpan(TableView.this.getAxis()) + (float)(n2 += 2 * TableView.this.cellSpacing);
            }
            return 0.0f;
        }

        public float getMaximumSpan(float f2) {
            return this.getPreferredSpan(f2);
        }

        public float getLeadingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        public float getTrailingCollapseSpan() {
            return TableView.this.cellSpacing;
        }
    }

    class ColumnIterator
    implements CSS.LayoutIterator {
        private int col;
        private int[] percentages;
        private int[] offsets;
        private int[] spans;

        ColumnIterator() {
        }

        void disablePercentages() {
            this.percentages = null;
        }

        private void updatePercentages(int n2) {
            if (TableView.this.relativeCells) {
                this.percentages = new int[TableView.this.columnRequirements.length];
                int n3 = TableView.this.getRowCount();
                int n4 = 0;
                while (n4 < n3) {
                    RowView rowView = TableView.this.getRow(n4);
                    int n5 = 0;
                    int n6 = rowView.getViewCount();
                    int n7 = 0;
                    while (n7 < n6) {
                        View view = rowView.getView(n7);
                        while (rowView.isFilled(n5)) {
                            ++n5;
                        }
                        int n8 = TableView.this.getRowsOccupied(view);
                        int n9 = TableView.this.getColumnsOccupied(view);
                        AttributeSet attributeSet = view.getAttributes();
                        CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(CSS.Attribute.WIDTH);
                        if (lengthValue != null && lengthValue.isPercentage()) {
                            int n10 = (int)(lengthValue.getValue(n2) / (float)n9 + 0.5f);
                            int n11 = 0;
                            while (n11 < n9) {
                                this.percentages[n5 + n11] = Math.max(this.percentages[n5 + n11], n10);
                                ++n11;
                            }
                        }
                        n5 += n9 - 1;
                        ++n7;
                        ++n5;
                    }
                    ++n4;
                }
            } else {
                this.percentages = null;
            }
        }

        public void setLayoutArrays(int[] nArray, int[] nArray2, int n2) {
            this.offsets = nArray;
            this.spans = nArray2;
            this.updatePercentages(n2);
        }

        public int getCount() {
            return TableView.this.columnRequirements.length;
        }

        public void setIndex(int n2) {
            this.col = n2;
        }

        public void setOffset(int n2) {
            this.offsets[this.col] = n2;
        }

        public int getOffset() {
            return this.offsets[this.col];
        }

        public void setSpan(int n2) {
            this.spans[this.col] = n2;
        }

        public int getSpan() {
            return this.spans[this.col];
        }

        public float getMinimumSpan(float f2) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], TableView.this.columnRequirements[this.col].minimum);
            }
            return TableView.this.columnRequirements[this.col].minimum;
        }

        public float getPreferredSpan(float f2) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], TableView.this.columnRequirements[this.col].preferred);
            }
            return TableView.this.columnRequirements[this.col].preferred;
        }

        public float getMaximumSpan(float f2) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], TableView.this.columnRequirements[this.col].preferred);
            }
            return TableView.this.columnRequirements[this.col].maximum;
        }

        public float getLeadingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        public float getTrailingCollapseSpan() {
            return TableView.this.cellSpacing;
        }
    }
}

