#ifndef _MFSK_H
#define _MFSK_H

#include "cmplx.h"
#include "trx.h"

#define	SampleRate	8000
#define	SymbolLen	512
#define	BaseTone	64
#define	NumTones	16
#define	SymbolRate	((float)SampleRate/SymbolLen)
#define	ToneSpacing	SymbolRate

#define	TxQueueSize	64
#define	PipeLen		(2*SymbolLen)

struct rxpipe {
	complex vector[NumTones];
	int symbol;
};

struct mfsk {
	/*
	 * Common stuff
	 */
	float phaseacc;

	/*
	 * RX related stuff
	 */
	struct filter *hilbert;
	struct sfft *sfft;
	struct viterbi *viterbi;

	struct rxpipe pipe[PipeLen];
	unsigned int pipeptr;

	unsigned int datashreg;

	complex currvector;
	complex prev1vector;
	complex prev2vector;

	int currsymbol;
	int prev1symbol;
	int prev2symbol;

	long int prevmetric;
	float averagemetric;

	unsigned int symbolphase;
	unsigned int symboltime;
	float syncaverage;
	int synccounter;

	/*
	 * TX related stuff
	 */
	struct fft *fft;

	unsigned int encstate;
	unsigned int bitshreg;
	int bitstate;
	int txstate;
};

#define	STATE_PREAMBLE		0
#define	STATE_START		1
#define	STATE_DATA		2
#define	STATE_END		3
#define	STATE_FLUSH		4
#define	STATE_FINISH		5
#define	STATE_TUNE		6

/* in mfsk.c */
extern void mfsk_init(struct trx *trx);

/* in mfskrx.c */
extern int mfsk_rxprocess(struct trx *trx, float *buf, int len);

/* in mfsktx.c */
extern int mfsk_txprocess(struct trx *trx);

#endif
