# Note that this is NOT a relocatable package
%define ver      0.6
%define rel      1
%define prefix   /usr
%define  sysconfdir	/etc

Summary: GTK+ DocBook Documentation Generator
Name: gtk-doc
Version: %ver
Release: %rel
Copyright: GPL
Group: Utilities/Text
Source: ftp://ftp.gtk.org/pub/gtk/v1.1/docs/rdp/gtk-doc-%{ver}.tar.gz
BuildRoot: /tmp/gtk-doc-root
Obsoletes: gtk-doc
Packager: John Gotts <jgotts@linuxsavvy.com>
URL: http://www.gtk.org/rdp/
Docdir: %{prefix}/doc
BuildArchitectures: noarch

%description
GTK+ DocBook documentation generator.

%changelog
* Wed Nov 15 2000 John Gotts <jgotts@linuxsavvy.com>
- Minor updates for 0.4.
* Thu Aug 26 1999 John E. Gotts <jgotts@engin.umich.edu>
- Created spec file.

%prep
%setup

%build
%ifarch alpha
	MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

if [ ! -f configure ]; then
	CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $MYARCH_FLAGS --prefix=%prefix \
		--sysconfdir=%{sysconfdir}
else
	CFLAGS="$RPM_OPT_FLAGS" ./configure $MYARCH_FLAGS --prefix=%prefix \
		--sysconfdir=%{sysconfdir}
fi

if [ "$SMP" != "" ]; then
	make -k -j$SMP "MAKE=make -k -j$SMP"
else
	make -k
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT/etc install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog INSTALL NEWS README doc/README
%doc doc/authors.txt doc/gnome.txt doc/gtk_button.txt doc/notes.txt
%doc doc/sections-file.txt doc/setting-up.txt doc/style-guide.txt
%{prefix}/bin/*
%{prefix}/share/gtk-doc/*
