#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Keep same perms on rc.bind.new:
if [ -e etc/rc.d/rc.bind ]; then
  cp -a etc/rc.d/rc.bind etc/rc.d/rc.bind.new.incoming
  cat etc/rc.d/rc.bind.new > etc/rc.d/rc.bind.new.incoming
  mv etc/rc.d/rc.bind.new.incoming etc/rc.d/rc.bind.new
fi

config etc/named.conf.new
config etc/rc.d/rc.bind.new

# Add a /var/named if it doesn't exist:
if [ ! -d var/named ]; then
  mkdir -p var/named
  chmod 755 var/named
fi

# Generate /etc/rndc.key if there's none there,
# and there also no /etc/rndc.conf (the other
# way to set this up).
if [ ! -r etc/rndc.key -a ! -r /etc/rndc.conf ]; then
  chroot . /sbin/ldconfig
  chroot . /usr/sbin/rndc-confgen -r /dev/urandom -a 2> /dev/null
fi
( cd usr/lib ; rm -rf libisc.so.36 )
( cd usr/lib ; ln -sf libisc.so.36.2.1 libisc.so.36 )
( cd usr/lib ; rm -rf libisc.so )
( cd usr/lib ; ln -sf libisc.so.36.2.1 libisc.so )
( cd usr/lib ; rm -rf libisccc.so.30 )
( cd usr/lib ; ln -sf libisccc.so.30.0.1 libisccc.so.30 )
( cd usr/lib ; rm -rf libisccc.so )
( cd usr/lib ; ln -sf libisccc.so.30.0.1 libisccc.so )
( cd usr/lib ; rm -rf libdns.so.38 )
( cd usr/lib ; ln -sf libdns.so.38.1.4 libdns.so.38 )
( cd usr/lib ; rm -rf libdns.so )
( cd usr/lib ; ln -sf libdns.so.38.1.4 libdns.so )
( cd usr/lib ; rm -rf libisccfg.so.30 )
( cd usr/lib ; ln -sf libisccfg.so.30.0.5 libisccfg.so.30 )
( cd usr/lib ; rm -rf libisccfg.so )
( cd usr/lib ; ln -sf libisccfg.so.30.0.5 libisccfg.so )
( cd usr/lib ; rm -rf libbind9.so.30 )
( cd usr/lib ; ln -sf libbind9.so.30.1.2 libbind9.so.30 )
( cd usr/lib ; rm -rf libbind9.so )
( cd usr/lib ; ln -sf libbind9.so.30.1.2 libbind9.so )
( cd usr/lib ; rm -rf liblwres.so.30 )
( cd usr/lib ; ln -sf liblwres.so.30.0.8 liblwres.so.30 )
( cd usr/lib ; rm -rf liblwres.so )
( cd usr/lib ; ln -sf liblwres.so.30.0.8 liblwres.so )
( cd usr/man/man3 ; rm -rf lwres_buffer_back.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_back.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_clear.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_clear.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_first.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_first.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_forward.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_forward.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_getmem.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_getmem.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_getuint16.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_getuint16.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_getuint32.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_getuint32.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_init.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_init.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_invalidate.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_invalidate.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_putmem.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_putmem.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_putuint16.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_putuint16.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_putuint32.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_putuint32.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_putuint8.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_putuint8.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_subtract.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_subtract.3.gz )
( cd usr/man/man3 ; rm -rf lwres_conf_clear.3.gz )
( cd usr/man/man3 ; ln -sf lwres_config.3.gz lwres_conf_clear.3.gz )
( cd usr/man/man3 ; rm -rf lwres_conf_get.3.gz )
( cd usr/man/man3 ; ln -sf lwres_config.3.gz lwres_conf_get.3.gz )
( cd usr/man/man3 ; rm -rf lwres_conf_init.3.gz )
( cd usr/man/man3 ; ln -sf lwres_config.3.gz lwres_conf_init.3.gz )
( cd usr/man/man3 ; rm -rf lwres_conf_parse.3.gz )
( cd usr/man/man3 ; ln -sf lwres_config.3.gz lwres_conf_parse.3.gz )
( cd usr/man/man3 ; rm -rf lwres_conf_print.3.gz )
( cd usr/man/man3 ; ln -sf lwres_config.3.gz lwres_conf_print.3.gz )
( cd usr/man/man3 ; rm -rf lwres_context_create.3.gz )
( cd usr/man/man3 ; ln -sf lwres_context.3.gz lwres_context_create.3.gz )
( cd usr/man/man3 ; rm -rf lwres_context_destroy.3.gz )
( cd usr/man/man3 ; ln -sf lwres_context.3.gz lwres_context_destroy.3.gz )
( cd usr/man/man3 ; rm -rf lwres_context_freemem.3.gz )
( cd usr/man/man3 ; ln -sf lwres_context.3.gz lwres_context_freemem.3.gz )
( cd usr/man/man3 ; rm -rf lwres_context_initserial.3.gz )
( cd usr/man/man3 ; ln -sf lwres_context.3.gz lwres_context_initserial.3.gz )
( cd usr/man/man3 ; rm -rf lwres_context_nextserial.3.gz )
( cd usr/man/man3 ; ln -sf lwres_context.3.gz lwres_context_nextserial.3.gz )
( cd usr/man/man3 ; rm -rf lwres_context_sendrecv.3.gz )
( cd usr/man/man3 ; ln -sf lwres_context.3.gz lwres_context_sendrecv.3.gz )
( cd usr/man/man3 ; rm -rf lwres_endhostent.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gethostent.3.gz lwres_endhostent.3.gz )
( cd usr/man/man3 ; rm -rf lwres_endhostent_r.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gethostent.3.gz lwres_endhostent_r.3.gz )
( cd usr/man/man3 ; rm -rf lwres_freehostent.3.gz )
( cd usr/man/man3 ; ln -sf lwres_getipnode.3.gz lwres_freehostent.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gabnrequest_free.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gabn.3.gz lwres_gabnrequest_free.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gabnrequest_parse.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gabn.3.gz lwres_gabnrequest_parse.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gabnrequest_render.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gabn.3.gz lwres_gabnrequest_render.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gabnresponse_free.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gabn.3.gz lwres_gabnresponse_free.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gabnresponse_parse.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gabn.3.gz lwres_gabnresponse_parse.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gabnresponse_render.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gabn.3.gz lwres_gabnresponse_render.3.gz )
( cd usr/man/man3 ; rm -rf lwres_getaddrsbyname.3.gz )
( cd usr/man/man3 ; ln -sf lwres_resutil.3.gz lwres_getaddrsbyname.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gethostbyaddr.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gethostent.3.gz lwres_gethostbyaddr.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gethostbyname.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gethostent.3.gz lwres_gethostbyname.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gethostbyname2.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gethostent.3.gz lwres_gethostbyname2.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gethostbyname_r.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gethostent.3.gz lwres_gethostbyname_r.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gethostent_r.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gethostent.3.gz lwres_gethostent_r.3.gz )
( cd usr/man/man3 ; rm -rf lwres_getipnodebyaddr.3.gz )
( cd usr/man/man3 ; ln -sf lwres_getipnode.3.gz lwres_getipnodebyaddr.3.gz )
( cd usr/man/man3 ; rm -rf lwres_getipnodebyname.3.gz )
( cd usr/man/man3 ; ln -sf lwres_getipnode.3.gz lwres_getipnodebyname.3.gz )
( cd usr/man/man3 ; rm -rf lwres_getnamebyaddr.3.gz )
( cd usr/man/man3 ; ln -sf lwres_resutil.3.gz lwres_getnamebyaddr.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gnbarequest_free.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gnba.3.gz lwres_gnbarequest_free.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gnbarequest_parse.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gnba.3.gz lwres_gnbarequest_parse.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gnbarequest_render.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gnba.3.gz lwres_gnbarequest_render.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gnbaresponse_free.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gnba.3.gz lwres_gnbaresponse_free.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gnbaresponse_render.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gnba.3.gz lwres_gnbaresponse_render.3.gz )
( cd usr/man/man3 ; rm -rf lwres_herror.3.gz )
( cd usr/man/man3 ; ln -sf lwres_hstrerror.3.gz lwres_herror.3.gz )
( cd usr/man/man3 ; rm -rf lwres_lwpacket_parseheader.3.gz )
( cd usr/man/man3 ; ln -sf lwres_packet.3.gz lwres_lwpacket_parseheader.3.gz )
( cd usr/man/man3 ; rm -rf lwres_lwpacket_renderheader.3.gz )
( cd usr/man/man3 ; ln -sf lwres_packet.3.gz lwres_lwpacket_renderheader.3.gz )
( cd usr/man/man3 ; rm -rf lwres_net_ntop.3.gz )
( cd usr/man/man3 ; ln -sf lwres_inetntop.3.gz lwres_net_ntop.3.gz )
( cd usr/man/man3 ; rm -rf lwres_nooprequest_free.3.gz )
( cd usr/man/man3 ; ln -sf lwres_noop.3.gz lwres_nooprequest_free.3.gz )
( cd usr/man/man3 ; rm -rf lwres_nooprequest_parse.3.gz )
( cd usr/man/man3 ; ln -sf lwres_noop.3.gz lwres_nooprequest_parse.3.gz )
( cd usr/man/man3 ; rm -rf lwres_nooprequest_render.3.gz )
( cd usr/man/man3 ; ln -sf lwres_noop.3.gz lwres_nooprequest_render.3.gz )
( cd usr/man/man3 ; rm -rf lwres_noopresponse_free.3.gz )
( cd usr/man/man3 ; ln -sf lwres_noop.3.gz lwres_noopresponse_free.3.gz )
( cd usr/man/man3 ; rm -rf lwres_noopresponse_parse.3.gz )
( cd usr/man/man3 ; ln -sf lwres_noop.3.gz lwres_noopresponse_parse.3.gz )
( cd usr/man/man3 ; rm -rf lwres_noopresponse_render.3.gz )
( cd usr/man/man3 ; ln -sf lwres_noop.3.gz lwres_noopresponse_render.3.gz )
( cd usr/man/man3 ; rm -rf lwres_sethostent.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gethostent.3.gz lwres_sethostent.3.gz )
( cd usr/man/man3 ; rm -rf lwres_sethostent_r.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gethostent.3.gz lwres_sethostent_r.3.gz )
( cd usr/man/man3 ; rm -rf lwres_string_parse.3.gz )
( cd usr/man/man3 ; ln -sf lwres_resutil.3.gz lwres_string_parse.3.gz )
( cd usr/man/man3 ; rm -rf lwres_addr_parse.3.gz )
( cd usr/man/man3 ; ln -sf lwres_resutil.3.gz lwres_addr_parse.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_add.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_add.3.gz )
( cd usr/man/man3 ; rm -rf lwres_buffer_getuint8.3.gz )
( cd usr/man/man3 ; ln -sf lwres_buffer.3.gz lwres_buffer_getuint8.3.gz )
( cd usr/man/man3 ; rm -rf lwres_context_allocmem.3.gz )
( cd usr/man/man3 ; ln -sf lwres_context.3.gz lwres_context_allocmem.3.gz )
( cd usr/man/man3 ; rm -rf lwres_freeaddrinfo.3.gz )
( cd usr/man/man3 ; ln -sf lwres_getaddrinfo.3.gz lwres_freeaddrinfo.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gethostbyaddr_r.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gethostent.3.gz lwres_gethostbyaddr_r.3.gz )
( cd usr/man/man3 ; rm -rf lwres_gnbaresponse_parse.3.gz )
( cd usr/man/man3 ; ln -sf lwres_gnba.3.gz lwres_gnbaresponse_parse.3.gz )
( cd usr/man/man8 ; rm -rf named-compilezone.8.gz )
( cd usr/man/man8 ; ln -sf named-checkzone.8.gz named-compilezone.8.gz )
( cd usr/sbin ; rm -rf lwresd )
( cd usr/sbin ; ln -sf named lwresd )
( cd usr/sbin ; rm -rf named-compilezone )
( cd usr/sbin ; ln -sf named-checkzone named-compilezone )
