.\" $Xorg: icccm.ms,v 1.3 2000/08/17 19:42:08 cpqbld Exp $
.\"
.\"
.\"
.\"
.\" $XFree86: xc/doc/specs/ICCCM/icccm.ms,v 1.3 2001/01/17 16:57:41 dawes Exp $
.\"
.\" Use tbl, eqn, -ms, and macros.t
.\" @(#)icccm.ms	1.50	16 Apr 1994	14:13:55
.EH ''''
.OH ''''
.EF ''''
.OF ''''
.ps 11
.nr PS 11
.hw time-stamp
.\"
.\" --- bP --- bulleted paragraph macro
.\"
.de bP
.IP \(bu 4
..
.\"
.\" --- cT --- centered title; centers $1, adds TOC entry unless $2 is "no"
.\"
.de cT
\\&		\" filler so that the following .sp really leaves a space
.sp 1
.ce 1
\\s+1\\fB\\$1\\fP\\s-1
.sp 1
.if !'\\$2'no' \{\
.XS \\n(PN
\\$1
.XE
\}
..
.\"
.\" --- dA --- double arrow string
.\"
.ds dA "\o'\(<-\(->'
\&
.sp 8
.ce 9999
.B
\s+2Inter-Client Communication Conventions Manual\s0

Version 2.0.xf86.1

XFree86 4.0.2

XFree86, Inc.

.I "based on"

Version 2.0

X Consortium Standard

X Version 11, Release 6.4
.R
.ce 0
.sp 6
.ce 9999
\s+1David Rosenthal\s0
.sp 6p
\s+1Sun Microsystems, Inc.\s0
.sp 2
\s+1Version 2 edited by Stuart W. Marks\s0
.sp 6p
\s+1SunSoft, Inc.\s0
.ce 0
.bp
\&
.ps 9
.nr PS 9
.sp 8
.LP
X Window System is a trademark of X Consortium, Inc.
.LP             
.LP
Copyright \(co 1988, 1991, 1993, 1994
X Consortium
.LP
Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:
.LP
The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.
.LP
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
.LP
Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
.LP
.sp 2
Copyright \(co 1987, 1988, 1989, 1993, 1994
Sun Microsystems, Inc.
.LP 
Permission to use, copy, modify, and distribute this documentation 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission 
notice appear in all copies.
Sun Microsystems makes no representations about the 
suitability for any purpose of the information in this document. 
This documentation is provided as is without express or implied warranty. 
.ps 11
.nr PS 11
.af PN i
.EF ''\\\\n(PN''
.OF ''\\\\n(PN''
.bp +4		\" the TOC is three pages long
.\" force preface onto odd page
.if e \{\
\&
.bp
\}
.cT "Preface to Version 2.0"
.LP
The goal of the ICCCM Version 2.0 effort was to add new facilities, to fix
problems with earlier drafts, and to improve readability and
understandability, while maintaining compatibility with the earlier
versions.  This document is the product of over two years of discussion among
the members of the X Consortium's \fBwmtalk\fP working group.  The following
people deserve thanks for their contributions:
.LP
.Ds
.ta 3i
Gabe Beged-Dov	Bill Janssen
Chan Benson	Vania Joloboff
Jordan Brown	Phil Karlton
Larry Cable	Kaleb Keithley
Ellis Cohen	Mark Manasse
Donna Converse	Ralph Mor
Brian Cripe	Todd Newman
Susan Dahlberg	Bob Scheifler
Peter Daifuku	Keith Taylor
Andrew deBlois	Jim VanGilder
Clive Feather	Mike Wexler
Stephen Gildea	Michael Yee
Christian Jacobi
.De
.LP
It has been a privilege for me to work with this fine group of people.
.sp
Stuart W. Marks
.br
December 1993
.br
.bp
.cT "Preface to Version 1.1"
.LP
David Rosenthal had overall architectural responsibility 
for the conventions defined in this document;
he wrote most of the text and edited the document, 
but its development has been a communal effort.
The details were thrashed out in meetings at the January 1988 MIT X Conference
and at the 1988 Summer Usenix conference,
and through months (and megabytes) of argument
on the
.PN wmtalk
mail alias.
Thanks are due to everyone who contributed,
and especially to the following people.
.LP
For the Selection section:
.LP
.Ds
Jerry Farrell
Phil Karlton
Loretta Guarino Reid
Mark Manasse
Bob Scheifler
.De
.LP
For the Cut-Buffer section:
.LP
.Ds
Andrew Palay
.De
.LP
For the Window and Session Manager sections:
.LP
.Ds
.ta 3i
Todd Brunhoff	Matt Landau
Ellis Cohen	Mark Manasse
Jim Fulton	Bob Scheifler
Hania Gajewska	Ralph Swick
Jordan Hubbard	Mike Wexler
Kerry Kimbrough	Glenn Widener
Audrey Ishizaki	
.De
.LP
For the Device Color Characterization section:
.Ds
Keith Packard
.De
.LP
In addition, thanks are due to those who contributed to the public review:
.LP
.Ds
.ta 3i
Gary Combs	John Irwin
Errol Crary	Vania Joloboff
Nancy Cyprych	John Laporta
John Diamant	Ken Lee
Clive Feather	Stuart Marks
Burns Fisher	Alan Mimms
Richard Greco	Colas Nahaboo
Tim Greenwood	Mark Patrick
Kee Hinckley	Steve Pitschke
Brian Holt	Brad Reed
John Interrante	John Thomas
.De
.bp 1
.af PN 1
.EH '\fBInter-Client Communication Conventions\fP''\fBX11, Release 6.4\fP'
.OH '\fBInter-Client Communication Conventions\fP''\fBX11, Release 6.4\fP'
.EF ''\fB % \fP''
.OF ''\fB % \fP''
.nH 1 Introduction
.LP
It was an explicit design goal of X Version 11 to specify mechanism,
not policy.
As a result,  
a client that converses with the server using the protocol defined 
by the \fIX Window System Protocol\fP, \fIVersion 11\fP may operate correctly 
in isolation but may not coexist properly with others sharing the same server.
.LP
Being a good citizen in the X Version 11 world involves adhering to
conventions that govern inter-client communications in the following areas:
.bP
Selection mechanism
.bP
Cut buffers
.bP
Window manager
.bP
Session manager
.bP
Manipulation of shared resources
.bP
Device color characterization
.LP
This document proposes suitable conventions without attempting to enforce 
any particular user interface.
To permit clients written in different languages to communicate,
these conventions are expressed solely in terms of protocol operations,
not in terms of their associated Xlib interfaces,
which are probably more familiar.
The binding of these operations to the Xlib interface for C
and to the equivalent interfaces for other languages
is the subject of other documents.
.nH 2 "Evolution of the Conventions"
.LP
In the interests of timely acceptance,
the \fIInter-Client Communication Conventions Manual\fP (ICCCM)
covers only a minimal set of required conventions.
These conventions will be added to and updated as appropriate,
based on the experiences of the X Consortium.
.LP
As far as possible,
these conventions are upwardly compatible with those in the February 25, 1988,
draft that was distributed with the X Version 11, Release 2, of the software.
In some areas,
semantic problems were discovered with those conventions,
and, thus, complete upward compatibility could not be assured.
These areas are noted in the text and are summarized in Appendix A.
.LP
In the course of developing these conventions,
a number of minor changes to the protocol were identified as desirable.
They also are identified in the text, are summarized in Appendix B,
and are offered as input to a future protocol revision process.
If and when a protocol revision incorporating these changes is undertaken,
it is anticipated that the ICCCM will need to be revised.
Because it is difficult to ensure that clients and servers are upgraded
simultaneously, 
clients using the revised conventions should examine the minor protocol 
revision number and be prepared to use the older conventions 
when communicating with an older server.
.LP
It is expected that these revisions will ensure that clients using 
the conventions appropriate to protocol minor revision \fIn\fP 
will interoperate correctly with those that use the conventions 
appropriate to protocol minor revision \fIn\fP + 1 if the server supports both.
.nH 2 Atoms
.LP
Many of the conventions use atoms.
To assist the reader,
the following sections attempt to amplify the description of atoms 
that is provided in the protocol specification.
.nH 3 "What Are Atoms?"
.LP
At the conceptual level, 
atoms are unique names that clients can use to communicate information 
to each other.
They can be thought of as a bundle of octets,
like a string but without an encoding being specified.
The elements are not necessarily ASCII characters,
and no case folding happens.\**
.FS
The comment in the protocol specification for 
.PN InternAtom 
that ISO Latin-1 encoding should be used is in the nature of a convention;
the server treats the string as a byte sequence.
.FE
.LP
The protocol designers felt that passing these
sequences of bytes back and forth across the wire would be too costly.
Further, they thought it important that events 
as they appear on the wire have a fixed size (in fact, 32 bytes)
and that because some events contain atoms, a fixed-size representation 
for them was needed.
.LP
To allow a fixed-size representation,
a protocol request 
.Pn ( InternAtom )
was provided to register a byte sequence with the server,
which returns a 32-bit value (with the top three bits zero) 
that maps to the byte sequence.
The inverse operator is also available 
.Pn ( GetAtomName ).
.nH 3 "Predefined Atoms"
.LP
The protocol specifies a number of atoms as being predefined:
.QP
Predefined atoms are not strictly necessary
and may not be useful in all environments,
but they will eliminate many 
.PN InternAtom
requests in most applications.
Note that they are predefined only in the sense of having numeric values, 
not in the sense of having required semantics.
.LP
Predefined atoms are an implementation trick to avoid the cost of interning
many of the atoms that are expected to be used during the startup phase 
of all applications.
The results of the 
.PN Intern\%Atom 
requests, which require a handshake, can be assumed \fIa priori\fP.
.LP
Language interfaces should probably cache the atom-name mappings 
and get them only when required.
The CLX interface, for instance, makes no distinction between predefined atoms
and other atoms; all atoms are viewed as symbols at the interface.
However, a CLX implementation will typically keep a symbol or atom cache 
and will typically initialize this cache with the predefined atoms.
.nH 3 "Naming Conventions"
.LP
The built-in atoms are composed of uppercase ASCII characters with the
logical words separated by an underscore character (_), for example,  
WM_ICON_NAME.
The protocol specification recommends that atoms used 
for private vendor-specific reasons should begin with an underscore.
To prevent conflicts among organizations, 
additional prefixes should be chosen 
(for example,  _DEC_WM_DECORATION_GEOMETRY).
.LP
The names were chosen in this fashion to make it easy to use them in a
natural way within LISP.
Keyword constructors allow the programmer to specify the atoms as LISP atoms.
If the atoms were not all uppercase,
special quoting conventions would have to be used.
.nH 3 Semantics
.LP
The core protocol imposes no semantics on atoms except as they are used in
FONTPROP structures.
For further information on FONTPROP semantics,
see the \fIX Logical Font Description Conventions\fP.
.nH 3 "Name Spaces"
.LP
The protocol defines six distinct spaces in which atoms are interpreted.
Any particular atom may or may not have some valid interpretation
with respect to each of these name spaces.
.br
.ne 6
.TS H
l l lw(3.6i).
_
.sp 6p
.B
Space	Briefly	Examples
.sp 6p
_
.sp 6p
.TH
.R
Property name	Name	WM_HINTS, WM_NAME, RGB_BEST_MAP, .\^.\^.
Property type	Type	WM_HINTS, CURSOR, RGB_COLOR_MAP, .\^.\^.
Selection name	Selection	PRIMARY, SECONDARY, CLIPBOARD
Selection target	Target	FILE_NAME, POSTSCRIPT, PIXMAP, .\^.\^.
Font property		QUAD_WIDTH, POINT_SIZE, .\^.\^.
T{
.PN ClientMessage
type
T}	T{
T}	T{
WM_SAVE_YOURSELF, _DEC_SAVE_EDITS, \&.\^.\^.
T}
.sp 6p
_
.TE
.nH 3 "Discriminated Names"
.LP
Sometimes a protocol requires an arbitrary number of similar
objects that need unique names (usually because the objects are created
dynamically, so that names cannot be invented in advance). For example, a
colormap-generating program might use the selection mechanism to offer
colormaps for each screen and so needs a selection name for each screen.
Such names are called \*Qdiscriminated names\*U and are discriminated by
some entity. This entity can be:
.DS
    A screen
    An X resource (a window, a colormap, a visual, etc.)
    A client
.DE
.LP
If it is only necessary to generate a fixed set of names for each value
of the discriminating entity, then the discriminated names are formed by
suffixing an ordinary name according to the value of the entity.
.LP
If \fIname\fP is a descriptive portion for the name, \fId\fP is a decimal
number with no leading zeroes, and \fIx\fP is a hexadecimal number with
exactly 8 digits, and using uppercase letters, then such discriminated names
shall have the form:
.br
.ne 6
.TS
lB lB lB
l l l .
_
.sp 6p
Name Discriminated by	Form	Example
.sp 6p
_
.sp 6p
screen number	\fIname\fP_S\fId\fP	WM_COMMS_S2
X resource	\fIname\fP_R\fIx\fP	GROUP_LEADER_R1234ABCD
.sp 6p
_
.TE
.LP
To discriminate a name by client, use an X resource ID created by that
client.  This resource can be of any type.
.LP
Sometimes it is simply necessary to generate a unique set of names (for
example, for the properties on a window used by a MULTIPLE selection).
These names should have the form:
.DS
.ta 2i
U\fId\fP	(e.g.,  U0  U1  U2  U3  .\^.\^.)
.DE
.LP
if the names stand totally alone, and the form:
.DS
.ta 2i
\fIname\fP_U\fId\fP	(e.g.,  FOO_U0  BAR_U0  FOO_U1  BAR_U1  .\^.\^.)
.DE
.LP
if they come in sets (here there are two sets, named \*QFOO\*U and
\*QBAR\*U).  The stand-alone U\fId\fP form should be used only if it is
clear that the module using it has complete control over the relevant
namespace or has the active cooperation of all other entities that might
also use these names. (Naming properties on a window created specifically
for a particular selection is such a use; naming properties on the root
window is almost certainly not.)
.LP
In a particularly difficult case, it might be necessary to combine both
forms of discrimination. If this happens, the U form should come after
the other form, thus:
.DS
    FOO_R12345678_U23
.DE
.NT Rationale
Existing protocols will not be changed to use these naming conventions,
because doing so will cause too much disruption.  However, it is expected
that future protocols \(em both standard and private \(em will use these
conventions.
.NE
.nH 1 "Peer-to-Peer Communication by Means of Selections"
.LP
Selections are the primary mechanism that X Version 11 defines 
for the exchange of information between clients,
for example, by cutting and pasting between windows.
Note that there can be an arbitrary number of selections
(each named by an atom) and that they are global to the server.
Section 2.6 discusses the choice of an atom.
Each selection is owned by a client and is attached to a window.
.LP
Selections communicate between an owner and a requestor.
The owner has the data representing the value of its selection,
and the requestor receives it.
A requestor wishing to obtain the value of a selection provides the following:
.bP
The name of the selection
.bP
The name of a property
.bP
A window
.bP
The atom representing the data type required
.bP
Optionally, some parameters for the request
.LP
If the selection is currently owned,
the owner receives an event and is expected to do the following:
.bP
Convert the contents of the selection to the requested data type
.bP
Place this data in the named property on the named window
.bP
Send the requestor an event to let it know the property is available
.LP
Clients are strongly encouraged to use this mechanism.
In particular,
displaying text in a permanent window without providing the ability 
to select and convert it into a string is definitely considered antisocial.
.LP
Note that all data transferred between an owner and a requestor must usually 
go by means of the server in an X Version 11 environment.
A client cannot assume that another client can open the same files
or even communicate directly.
The other client may be talking to the server by means of 
a completely different networking mechanism (for example,  one client might
be DECnet and the other TCP/IP).
Thus, passing indirect references to data 
(such as, file names, host names, and port numbers) 
is permitted only if both clients specifically agree.
.nH 2 "Acquiring Selection Ownership"
.LP
A client wishing to acquire ownership of a particular selection
should call 
.PN SetSelectionOwner,
which is defined as follows:
.LP
.sM
.IN "SetSelectionOwner" "" "@DEF@"
.PN SetSelectionOwner
.IP "" .2i
\fIselection\fP\^: ATOM
.br
\fIowner\fP\^: WINDOW or
.PN None
.br
\fItime\fP\^: TIMESTAMP or
.PN CurrentTime
.LP
.eM
.LP
The client should set the specified selection to the atom that represents 
the selection,
set the specified owner to some window that the client created,
and set the specified time to some time between the current last-change time 
of the selection concerned and the current server time.
This time value usually will be obtained from the timestamp of the event 
that triggers the acquisition of the selection.
Clients should not set the time
value to 
.PN CurrentTime ,
because if they do so, they have no way of finding
when they gained ownership of the selection.
Clients must use a window they created so that requestors
can route events to the owner of the selection.\**
.FS
At present, no part of the protocol requires requestors
to send events to the owner of a selection.
This restriction is imposed to prepare for possible future extensions.
.FE
.NT Convention
Clients attempting to acquire a selection must set the time value of the 
.PN Set\%Selection\%Owner 
request to the timestamp of the event triggering the acquisition attempt, 
not to 
.PN CurrentTime .
A zero-length append to a property is a way to obtain a timestamp for
this purpose;
the timestamp is in the corresponding 
.PN Property\%Notify
event.
.NE
.LP
If the time in the 
.PN SetSelectionOwner 
request is in the future relative to the server's current time 
or is in the past relative to the last time the specified selection 
changed hands, the 
.PN SetSelectionOwner
request appears to the client to succeed,
but ownership is not actually transferred.
.LP
Because clients cannot name other clients directly,
the specified owner window is used to refer to the owning client
in the replies to 
.PN GetSelectionOwner ,
in 
.PN SelectionRequest 
and
.PN SelectionClear
events, and possibly as a place to put properties describing the selection
in question.
To discover the owner of a particular selection,
a client should invoke
.PN GetSelectionOwner ,
which is defined as follows:
.LP
.sM
.IN "GetSelectionOwner" "" "@DEF@"
.PN GetSelectionOwner
.IP "" .2i
\fIselection\fP\^: ATOM
.LP
\(->
.IP "" .2i
owner: WINDOW or
.PN None
.LP
.eM
.NT Convention
Clients are expected to provide some visible confirmation
of selection ownership.
To make this feedback reliable,
a client must perform a sequence like the following:
.sp
.Ds 0
SetSelectionOwner(selection=PRIMARY, owner=Window, time=timestamp)
owner = GetSelectionOwner(selection=PRIMARY)
if (owner != Window) Failure
.De
.NE
.LP
If the 
.PN SetSelectionOwner
request succeeds (not merely appears to succeed),
the client that issues it is recorded by the server as being the owner 
of the selection for the time period starting at the specified time.
.nH 2 "Responsibilities of the Selection Owner"
.LP
When a requestor wants the value of a selection,
the owner receives a 
.PN SelectionRequest
event, which is defined as follows:
.LP
.sM
.IN "SelectionRequest" "" "@DEF@"
.PN SelectionRequest
.IP "" .2i
\fIowner\fP\^: WINDOW
.br
\fIselection\fP\^: ATOM
.br
\fItarget\fP\^: ATOM
.br
\fIproperty\fP\^: ATOM or
.PN None
.br
\fIrequestor\fP\^: WINDOW
.br
\fItime\fP\^: TIMESTAMP or
.PN CurrentTime
.LP
.eM
.LP
The specified owner and selection will be the values that were specified in
the
.PN SetSelection\%Owner 
request.
The owner should compare the timestamp with the period 
it has owned the selection and, if the time is outside,
refuse the 
.PN SelectionRequest 
by sending the requestor window a 
.PN SelectionNotify 
event with the property set to 
.PN None 
(by means of a
.PN SendEvent
request with an empty event mask).
.LP
More advanced selection owners are free to maintain a history
of the value of the selection and to respond to requests for the
value of the selection during periods they owned it
even though they do not own it now.
.LP
If the specified property is 
.PN None ,
the requestor is an obsolete client.
Owners are encouraged to support these clients by using the specified target
atom as the property name to be used for the reply.
.LP
Otherwise,
the owner should use the target to decide the form into which the selection
should be converted.
Some targets may be defined such that requestors can pass parameters
along with the request.  The owner will find these parameters in the
property named in the selection request.  The type, format, and
contents of this property are dependent upon the definition of the
target.  If the target is not defined to have parameters, the owner
should ignore the property if it is present.
If the selection cannot be converted
into a form based on the target (and parameters, if any),
the owner should refuse the 
.PN Selection\%Request
as previously described.
.LP
If the specified property is not 
.PN None ,
the owner should place the data resulting from converting the selection 
into the specified property on the requestor window
and should set the property's type to some appropriate value,
which need not be the same as the specified target.
.NT Convention
All properties used to reply to 
.PN SelectionRequest
events must be placed on the requestor window.
.NE
.LP
In either case, 
if the data comprising the selection cannot be stored on the requestor window 
(for example, because the server cannot provide sufficient memory),
the owner must refuse the 
.PN SelectionRequest ,
as previously described.
See also section 2.5.
.LP
If the property is successfully stored,
the owner should acknowledge the successful conversion
by sending the requestor window a 
.PN SelectionNotify 
event (by means of a
.PN SendEvent
request with an empty mask).
.PN SelectionNotify
is defined as follows:
.LP
.sM
.IN "SelectionNotify" "" "@DEF@"
.PN SelectionNotify
.IP "" .2i
\fIrequestor\fP\^: WINDOW
.br
\fIselection\fP, \fItarget\fP\^: ATOM
.br
\fIproperty\fP\^: ATOM or
.PN None
.br
\fItime\fP\^: TIMESTAMP or
.PN CurrentTime
.LP
.eM
.LP
The owner should set the specified selection, target, time, 
and property arguments to the values received in the 
.PN SelectionRequest 
event.
(Note that setting the property argument to 
.PN None 
indicates that the conversion requested could not be made.)
.NT Convention
The selection, target, time, and property arguments in the 
.PN SelectionNotify 
event should be set to the values received in the 
.PN SelectionRequest 
event.
.NE
.LP
If the owner receives more than one
.PN Selection\%Request
event with the same requestor, selection, target, and timestamp it must
respond to them in the same order in which they were received.
.NT Rationale
It is possible for a requestor to have multiple outstanding requests that
use the same requestor window, selection, target, and timestamp, and that
differ only in the property.  If this occurs, and one of the conversion
requests fails, the resulting
.PN Selection\%Notify
event will have its property argument set to 
.PN None .
This may make it impossible for the requestor to determine which conversion
request had failed, unless the requests are responded to in order.
.NE
.LP
The data stored in the property must eventually be deleted.
A convention is needed to assign the responsibility for doing so.
.NT Convention
Selection requestors are responsible for deleting properties whose
names they receive in 
.PN SelectionNotify 
events (see section 2.4) or in properties with type MULTIPLE.
.NE
.LP
A selection owner will often need confirmation that the data comprising the
selection has actually been transferred.
(For example, 
if the operation has side effects on the owner's internal data structures, 
these should not take place until the requestor has indicated 
that it has successfully received the data.)
Owners should express interest in 
.PN PropertyNotify 
events for the specified requestor window 
and wait until the property in the 
.PN SelectionNotify 
event has been deleted before assuming that the selection data has been
transferred.  For the MULTIPLE request, if the different conversions require
separate confirmation, the selection owner can also watch for the deletion
of the individual properties named in the property in the
.PN Selection\%Notify
event.
.LP
When some other client acquires a selection,
the previous owner receives a 
.PN SelectionClear 
event, which is defined as follows:
.LP
.sM
.IN "SelectionClear" "" "@DEF@"
.PN SelectionClear
.IP "" .2i
\fIowner\fP\^: WINDOW
.br
\fIselection\fP\^: ATOM
.br
\fItime\fP\^: TIMESTAMP
.LP
.eM
.LP
The timestamp argument is the time at which the ownership changed hands,
and the owner argument is the window the previous owner specified in its
.PN SetSelectionOwner 
request.
.LP
If an owner loses ownership while it has a transfer in progress (that is,
before it receives notification that the requestor has received all the data),
it must continue to service the ongoing transfer until it is complete.
.LP
If the selection value completely changes, but the owner happens
to be the same client (for example, selecting a totally different
piece of text in the same \fBxterm\fP as before), then the client should
reacquire the selection ownership as if it were not the owner,
providing a new timestamp. If the selection value is modified, but
can still reasonably be viewed as the same selected object,\** the
owner should take no action.
.FS
The division between these two cases is a matter of judgment
on the part of the software developer.
.FE
.nH 2 "Giving Up Selection Ownership"
.LP
Clients may either give up selection ownership voluntarily 
or lose it forcibly as the result of some other client's actions.
.nH 3 "Voluntarily Giving Up Selection Ownership"
.LP
To relinquish ownership of a selection voluntarily,
a client should execute a 
.PN SetSelection\%Owner
request for that selection atom, with owner specified as 
.PN None
and the time specified as the timestamp that was used to acquire the selection.
.LP
Alternatively,
the client may destroy the window used as the owner value of the 
.PN SetSelection\%Owner
request, or the client may terminate.
In both cases,
the ownership of the selection involved will revert to 
.PN None .
.nH 3 "Forcibly Giving Up Selection Ownership"
.LP
If a client gives up ownership of a selection
or if some other client executes a 
.PN SetSelection\%Owner 
for it and thus reassigns it forcibly,
the previous owner will receive a 
.PN Selection\%Clear 
event. For the definition of a 
.PN Selection\%Clear
event, see section 2.2.
.LP
The timestamp is the time the selection changed hands.
The specified owner is the window that was specified by the current owner 
in its 
.PN SetSelectionOwner
request.
.nH 2 "Requesting a Selection"
.LP
A client that wishes to obtain the value of a selection in a particular
form (the requestor) issues a 
.PN ConvertSelection 
request, which is defined as follows:
.LP
.sM
.IN "ConvertSelection" "" "@DEF@"
.PN ConvertSelection
.IP "" .2i
\fIselection\fP, \fItarget\fP\^: ATOM
.br
\fIproperty\fP\^: ATOM or
.PN None
.br
\fIrequestor\fP\^: WINDOW
.br
\fItime\fP\^: TIMESTAMP or
.PN CurrentTime
.LP
.eM
.LP
The selection argument specifies the particular selection involved,
and the target argument specifies the required form of the information.
For information about the choice of suitable atoms to use,
see section 2.6.
The requestor should set the requestor argument to a window that it created;
the owner will place the reply property there.
The requestor should set the time argument to the timestamp on the event 
that triggered the request for the selection value.
Note that clients should not specify 
.PN CurrentTime .
.NT Convention
Clients should not use 
.PN CurrentTime 
for the time argument of a 
.PN ConvertSelection
request.
Instead, they should use the timestamp of the event that caused the request 
to be made.
.NE
.LP
The requestor should set the property argument to the name of a property 
that the owner can use to report the value of the selection.
Requestors should ensure that the named property does not exist
on the window before issuing the
.PN Convert\%Selection
request.\** The exception to this rule is when the requestor intends to pass
parameters with the request (see below).
.NT Rationale
It is necessary for requestors to delete the property before issuing the
request so that the target can later be extended to take parameters without
introducing an incompatibility.  Also note that the requestor of a selection
need not know the client that owns the selection nor the window on which
the selection was acquired.
.NE
.FS
This requirement is new in version 2.0, and, in general, existing
clients do not conform to this requirement.  To prevent these clients
from breaking, no existing targets should be extended to take
parameters until sufficient time has passed for clients to be updated.
Note that the MULTIPLE target was defined to take parameters in version
1.0 and its definition is not changing.  There is thus no conformance
problem with MULTIPLE.
.FE
.LP
Some targets may be defined such that requestors can pass parameters
along with the request.  If the requestor wishes to provide parameters
to a request, they should be placed in the specified property on the
requestor window before the requestor issues the
.PN Convert\%Selection
request, and this property should be named in the request.
.LP
Some targets may be defined so that parameters are optional.  If no
parameters are to be supplied with the request of such a target, the
requestor must ensure that the property does not exist before issuing
the
.PN Convert\%Selection
request.
.LP
The protocol allows the property field to be set to 
.PN None ,
in which case the owner is supposed to choose a property name.
However, it is difficult for the owner to make this choice safely.
.NT Conventions
.IP 1. 5
Requestors should not use 
.PN None
for the property argument of a
.PN ConvertSelection
request.
.IP 2. 5
Owners receiving 
.PN ConvertSelection 
requests with a property argument of
.PN None
are talking to an obsolete client.
They should choose the target atom as the property name to be used 
for the reply.
.NE
.LP
The result of the 
.PN ConvertSelection
request is that a 
.PN SelectionNotify
event will be received.
For the definition of a
.PN SelectionNotify
event, see section 2.2.
.LP
The requestor, selection, time, and target arguments will be the same
as those on the 
.PN ConvertSelection 
request.
.LP
If the property argument is 
.PN None ,
the conversion has been refused.
This can mean either that there is no owner for the selection, 
that the owner does not support the conversion implied by the target,
or that the server did not have sufficient space to accommodate the data.
.LP
If the property argument is not 
.PN None ,
then that property will exist on the requestor window.
The value of the selection can be retrieved from this
property by using the 
.PN GetProperty
request, which is defined as follows:
.LP
.sM
.IN "GetProperty" "" "@DEF@"
.PN GetProperty
.IP "" .2i
\fIwindow\fP\^: WINDOW
.br
\fIproperty\fP\^: ATOM
.br
\fItype\fP\^: ATOM or
.PN AnyPropertyType
.br
\fIlong-offset\fP, \fIlong-length\fP\^: CARD32
.br
\fIdelete\fP\^: BOOL
.LP
\(->
.IP "" .2i
type: ATOM or
.PN None
.br
format: {0, 8, 16, 32}
.br
bytes-after: CARD32
.br
value: LISTofINT8 or LISTofINT16 or LISTofINT32
.LP
.eM
.LP
When using 
.PN GetProperty 
to retrieve the value of a selection,  
the property argument should be set to the corresponding value in the 
.PN SelectionNotify
event.
Because the requestor has no way of knowing beforehand what type 
the selection owner will use,
the type argument should be set to 
.PN AnyPropertyType .
Several 
.PN GetProperty 
requests may be needed to retrieve all the data in the selection;
each should set the long-offset argument to the amount of data received so far,
and the size argument to some reasonable buffer size (see section 2.5).
If the returned value of bytes-after is zero,
the whole property has been transferred.
.LP
Once all the data in the selection has been retrieved
(which may require getting the values of several properties \(em
see section 2.7),
the requestor should delete the property in the 
.PN SelectionNotify
request by using a 
.PN GetProperty
request with the delete argument set to
.PN True .
As previously discussed,
the owner has no way of knowing when the data has been
transferred to the requestor unless the property is removed.
.NT Convention
The requestor must delete the property named in the 
.PN SelectionNotify
once all the data has been retrieved.
The requestor should invoke either 
.PN DeleteProperty 
or
.PN GetProperty (delete==True)
after it has successfully retrieved all the data in the selection.
For further information,
see section 2.5.
.NE
.nH 2 "Large Data Transfers"
.LP
Selections can get large, which poses two problems:
.bP
Transferring large amounts of data to the server is expensive.
.bP
All servers will have limits on the amount of data that can be stored
in properties.
Exceeding this limit will result in an 
.PN Alloc
error on the 
.PN ChangeProperty 
request that the selection owner uses to store the data.
.LP
The problem of limited server resources is addressed by the following
conventions:
.NT Conventions
.IP 1. 5
Selection owners should transfer the data describing a large selection
(relative to the maximum-request-size they received 
in the connection handshake) using the INCR property mechanism 
(see section 2.7.2).
.IP 2. 5
Any client using 
.PN SetSelectionOwner
to acquire selection ownership should arrange to process 
.PN Alloc
errors in property change requests.
For clients using Xlib,
this involves using the
.PN XSetErrorHandler
function to override the default handler.
.IP 3. 5
A selection owner must confirm that no 
.PN Alloc
error occurred while storing the properties for a selection 
before replying with a confirming 
.PN SelectionNotify
event.
.IP 4. 5
When storing large amounts of data (relative to maximum-request-size),
clients should use a sequence of 
.PN ChangeProperty (mode==Append)
requests for reasonable quantities of data.
This avoids locking servers up and limits the waste of data an
.PN Alloc 
error would cause.
.IP 5. 5
If an 
.PN Alloc 
error occurs during the storing of the selection data,
all properties stored for this selection should be deleted
and the 
.PN ConvertSelection
request should be refused (see section 2.2).
.IP 6. 5
To avoid locking servers up for inordinate lengths of time,
requestors retrieving large quantities of data from a property
should perform a series of 
.PN GetProperty 
requests, each asking for a reasonable amount of data.
.NE
.NT "Advice to Implementors"
Single-threaded servers should take care to avoid locking up during large
data transfers.
.NE
.nH 2 "Use of Selection Atoms"
.LP
Defining a new atom consumes resources in the server
that are not released until the server reinitializes.
Thus, reducing the need for newly minted atoms is an important goal
for the use of the selection atoms.
.nH 3 "Selection Atoms"
.LP
There can be an arbitrary number of selections, each named by an atom.
To conform with the inter-client conventions, however,
clients need deal with only these three selections:
.bP
PRIMARY
.bP
SECONDARY
.bP
CLIPBOARD
.LP
Other selections may be used freely for private communication among
related groups of clients.
.nH 4 "The PRIMARY Selection"
.LP
The selection named by the atom PRIMARY is used for all commands
that take only a single argument and is the principal means of communication 
between clients that use the selection mechanism.
.nH 4 "The SECONDARY Selection"
.LP
The selection named by the atom SECONDARY is used:
.bP
As the second argument to commands taking two arguments 
(for example, \*Qexchange primary and secondary selections\*U)
.bP
As a means of obtaining data when there is a primary selection
and the user does not want to disturb it
.nH 4 "The CLIPBOARD Selection"
.LP
The selection named by the atom CLIPBOARD is used to hold data
that is being transferred between clients, 
that is, data that usually is being cut and then pasted
or copied and then pasted.
Whenever a client wants to transfer data to the clipboard:
.bP
It should assert ownership of the CLIPBOARD.
.bP
If it succeeds in acquiring ownership,
it should be prepared to respond to a request for the contents of the CLIPBOARD
in the usual way (retaining the data to be able to return it).
The request may be generated by the clipboard client described below.
.bP
If it fails to acquire ownership,
a cutting client should not actually perform the cut or provide feedback 
that would suggest that it has actually transferred data to the clipboard.
.LP
The owner should repeat this process whenever the data to be transferred
would change.
.LP
Clients wanting to paste data from the clipboard should request 
the contents of the CLIPBOARD selection in the usual way.
.LP
Except while a client is actually deleting or copying data,
the owner of the CLIPBOARD selection may be a single, special client
implemented for the purpose.
This client maintains the content of the clipboard up-to-date
and responds to requests for data from the clipboard as follows:
.bP
It should assert ownership of the CLIPBOARD selection
and reassert it any time the clipboard data changes.
.bP
If it loses the selection (because another client has some new data 
for the clipboard),
it should:
.RS
.IP \- 5
Obtain the contents of the selection from the new owner by using the timestamp
in the 
.PN SelectionClear
event.
.IP \- 5
Attempt to reassert ownership of the CLIPBOARD selection 
by using the same timestamp.
.IP \- 5
Restart the process using a newly acquired timestamp if this attempt fails.
This timestamp should be obtained by asking the current owner of the
CLIPBOARD selection to convert it to a TIMESTAMP.
If this conversion is refused or if the same timestamp is received twice,
the clipboard client should acquire a fresh timestamp in the
usual way (for example by a zero-length append to a property).
.RE
.bP
It should respond to requests for the CLIPBOARD contents in the usual way.
.LP
A special CLIPBOARD client is not necessary.
The protocol used by the cutting client and the pasting client
is the same whether the CLIPBOARD client is running or not.
The reasons for running the special client include:
.bP
Stability \- If the cutting client were to crash or terminate,
the clipboard value would still be available.
.bP
Feedback \- The clipboard client can display the contents of the clipboard.
.bP
Simplicity \- A client deleting data does not have to retain it for so long,
thus reducing the chance of race conditions causing problems.
.LP
The reasons not to run the clipboard client include:
.bP
Performance \- Data is transferred only if it is actually required 
(that is, when some client actually wants the data).
.bP
Flexibility \- The clipboard data may be available as more than one target.
.nH 3 "Target Atoms"
.LP
The atom that a requestor supplies as the target of a 
.PN ConvertSelection
request determines the form of the data supplied.
The set of such atoms is extensible, 
but a generally accepted base set of target atoms is needed.
As a starting point for this, 
the following table contains those that have been suggested so far.
.br
.ne 6
.\" This table has very tricky formatting.  Several targets are too long to
.\" fit, so the table format needs to change around them.  If the table
.\" format changes, it will need to be changed in several places.  There are
.\" also two footnotes in this table, but the footnote text can't be
.\" embedded in the table.  This means that the auto-numbering needs to be
.\" dinked around with after the end of the table.
.TS H
lw(1.8i) lw(1i) lw(3i) .
_
.sp 6p
.B
Atom	Type 	Data Received
.R
.sp 6p
_
.sp 6p
.TH
.T&
l s s .
ADOBE_PORTABLE_DOCUMENT_FORMAT
.T&
lw(1.8i) lw(1i) lw(3i) .
	STRING	T{
[1]
T}
.sp 6p
APPLE_PICT	APPLE_PICT	T{
[2]
T}
BACKGROUND	PIXEL	A list of pixel values
BITMAP	BITMAP	A list of bitmap IDs
CHARACTER_POSITION	SPAN	T{
The start and end of the selection in bytes
T}
CLASS	TEXT	(see section 4.1.2.5)
CLIENT_WINDOW	WINDOW	T{
Any top-level window owned by the selection owner
T}
COLORMAP	COLORMAP	A list of colormap IDs
COLUMN_NUMBER	SPAN	T{
The start and end column numbers
T}
COMPOUND_TEXT	COMPOUND_TEXT	Compound Text
DELETE	NULL	(see section 2.6.3.1)
DRAWABLE	DRAWABLE	A list of drawable IDs
.sp 6p
.T&
l s s .
ENCAPSULATED_POSTSCRIPT
.T&
lw(1.8i) lw(1i) lw(3i) .
	STRING	T{
[3], Appendix H\|\**
T}
.sp 6p
.T&
l s s .
ENCAPSULATED_POSTSCRIPT_INTERCHANGE
.T&
lw(1.8i) lw(1i) lw(3i) .
	STRING	T{
[3], Appendix H
T}
.sp 6p
FILE_NAME	TEXT	The full path name of a file
FOREGROUND	PIXEL	T{
A list of pixel values
T}
HOST_NAME	TEXT	(see section 4.1.2.9)
INSERT_PROPERTY	NULL	(see section 2.6.3.3)
INSERT_SELECTION	NULL	(see section 2.6.3.2)
LENGTH	INTEGER	T{
The number of bytes in the selection\|\**
T}
LINE_NUMBER	SPAN	T{
The start and end line numbers
T}
LIST_LENGTH	INTEGER	T{
The number of disjoint parts of the selection
T}
MODULE	TEXT	T{
The name of the selected procedure
T}
MULTIPLE	ATOM_PAIR	T{
(see the discussion that follows)
T}
NAME	TEXT	(see section 4.1.2.1)
ODIF	TEXT	T{
ISO Office Document Interchange Format
T}
OWNER_OS	TEXT	T{
The operating system of the owner client
T}
PIXMAP	T{
PIXMAP\|\**
T}	T{
A list of pixmap IDs
T}
POSTSCRIPT	STRING	T{
[3]
T}
PROCEDURE	TEXT	T{
The name of the selected procedure
T}
PROCESS	INTEGER, TEXT	T{
The process ID of the owner
T}
STRING	STRING	ISO Latin-1 (+TAB+NEWLINE) text
TARGETS	ATOM	A list of valid target atoms
TASK	INTEGER, TEXT	T{
The task ID of the owner
T}
TEXT	TEXT	T{
The text in the owner's choice of encoding
T}
TIMESTAMP	INTEGER	T{
The timestamp used to acquire the selection
T}
USER	TEXT	T{
The name of the user running the owner
T}
UTF8_STRING	TEXT	T{
UTF-8 text
T}
.sp 6p
_
.TE
.\" Conditionalized on groff because
.\" groff keeps track of footnotes and fn references separately,
.\" so resetting isn't necessary (and referencing \n* gives a warning).
.if !\n(GS .nr * \n*-3	\" decrement by the number of footnotes in the table
.if 0 \{\
HACK!  There are several footnotes in the table above, each marked with the
construct "\**".  The actual footnote text is here, because I haven't found
a way to place it within the table itself.  This causes a numbering problem,
because each \** increments the footnote counter (number register *) and the
FS macro uses its current value.  To get around this, we decrement the *
register by the number of footnotes in the table.  Then, before calling each
FS macro, we increment the register.

Also note that footnotes must appear within the T{ T} construct in tables.
If they don't, strange numbering problems will result, probably as a result
of multiple evaluation.
\}
.\" These footnotes are in the wrong order because Sun tbl numbers the
.\" footnote references wrong in the above table.  Thus this doesn't
.\" do the right thing with gtbl, which gets the order right.
.if !\n(GS .nr * +1
.FS
Earlier versions of this document erroneously specified that conversion of
the PIXMAP target returns a property of type DRAWABLE instead of PIXMAP.
Implementors should be aware of this and may want to support the DRAWABLE
type as well to allow for compatibility with older clients.
.FE
.if !\n(GS .nr * +1
.FS
The targets ENCAPSULATED_POSTSCRIPT and ENCAPSULATED_POSTSCRIPT_INTERCHANGE
are equivalent to the targets _ADOBE_EPS and _ADOBE_EPSI (respectively) that
appear in the selection targets registry.  The _ADOBE_ targets are
deprecated, but clients are encouraged to continue to support them for
backward compatibility.
.FE
.if !\n(GS .nr * +1
.FS
This definition is ambiguous, as the selection may be converted into any of
several targets that may return differing amounts of data.  The requestor
has no way of knowing which, if any, of these targets corresponds to the
result of LENGTH.  Clients are advised that no guarantees can be made about
the result of a conversion to LENGTH; its use is thus deprecated.
.FE
.LP
References:
.IP [1] 5
Adobe Systems, Incorporated.
.I
Portable Document Format Reference Manual.
.R
Reading, MA, Addison-Wesley, ISBN 0-201-62628-4.
.IP [2] 5
Apple Computer, Incorporated.
.I
Inside Macintosh, Volume V.
.R
Chapter 4, \*QColor QuickDraw,\*U Color \%Picture Format.
ISBN 0-201-17719-6.
.IP [3] 5
Adobe Systems, Incorporated.
.I
PostScript Language Reference Manual.
.R
Reading, MA, Addison-Wesley, ISBN 0-201-18127-4.
.LP
It is expected that this table will grow over time.
.LP
Selection owners are required to support the following targets.
All other targets are optional.
.bP
TARGETS \- The owner should return a list of atoms that represent
the targets for which an attempt to convert the current selection
will succeed (barring unforseeable problems such as 
.PN Alloc 
errors).
This list should include all the required atoms.
.bP
MULTIPLE \- The MULTIPLE target atom is valid only when a property 
is specified on the 
.PN ConvertSelection 
request.
If the property argument in the 
.PN SelectionRequest 
event is 
.PN None 
and the target is MULTIPLE, 
it should be refused.
.IP
When a selection owner receives a 
.PN SelectionRequest (target==MULTIPLE)
request,
the contents of the property named in the request will be a list of atom pairs:
the first atom naming a target and the second naming a property 
.Pn ( None 
is not valid here).
The effect should be as if the owner had received a sequence of
.PN SelectionRequest 
events (one for each atom pair) except that:
.RS
.IP \- 5
The owner should reply with a 
.PN SelectionNotify 
only when all the requested conversions have been performed.
.IP \- 5
If the owner fails to convert the target named by an atom 
in the MULTIPLE property,
it should replace that atom in the property with
.PN None .
.RE
.NT Convention
The entries in a MULTIPLE property must be processed in the order
they appear in the property.
For further information,
see section 2.6.3.
.NE
.RS
.LP
The requestor should delete each individual property when it has
copied the data from that conversion, and the property specified in the
MULTIPLE request when it has copied all the data.
.LP
The requests are otherwise to be processed independently, and they
should succeed or fail independently.  The MULTIPLE target is an
optimization that reduces the amount of protocol traffic between the
owner and the requestor; it is not a transaction mechanism.  For
example, a client may issue a MULTIPLE request with two targets: a data
target and the DELETE target.  The DELETE target will still be processed
even if the conversion of the data target fails.
.RE
.bP
TIMESTAMP \- To avoid some race conditions,
it is important that requestors be able to discover the timestamp 
the owner used to acquire ownership.
Until and unless the protocol is changed so that a
.PN GetSelectionOwner
request returns the timestamp used to acquire ownership,
selection owners must support conversion to TIMESTAMP,
returning the timestamp they used to obtain the selection.
.nH 3 "Selection Targets with Side Effects"
.LP
Some targets (for example, DELETE) have side effects.
To render these targets unambiguous,
the entries in a MULTIPLE property must be processed in the order 
that they appear in the property.
.LP
In general,
targets with side effects will return no information,
that is, they will return a zero length property of type NULL.
(Type NULL means the result of
.PN InternAtom
on the string \*QNULL\*U, not the value zero.)
In all cases,
the requested side effect must be performed before the conversion is accepted.
If the requested side effect cannot be performed,
the corresponding conversion request must be refused.
.NT Conventions
.IP 1. 5
Targets with side effects should return no information
(that is, they should have a zero-length property of type NULL).
.IP 2. 5
The side effect of a target must be performed before the conversion is accepted.
.IP 3. 5
If the side effect of a target cannot be performed,
the corresponding conversion request must be refused.
.NE
.NT Problem
The need to delay responding to the 
.PN ConvertSelection 
request until a further conversion has succeeded poses problems 
for the Intrinsics interface that need to be addressed.
.NE
.LP
These side-effect targets are used to implement operations such as
\*Qexchange PRIMARY and SECONDARY selections.\*U
.nH 4 "DELETE"
.LP
When the owner of a selection receives a request to convert it to DELETE,
it should delete the corresponding selection
(whatever doing so means for its internal data structures)
and return a zero-length property of type NULL if the deletion was successful.
.nH 4 "INSERT_SELECTION"
.LP
When the owner of a selection receives a request to convert it to 
INSERT_SELECTION,
the property named will be of type ATOM_PAIR.
The first atom will name a selection,
and the second will name a target.
The owner should use the selection mechanism to convert the named selection
into the named target and should insert it at the location of the selection
for which it got the INSERT_SELECTION request
(whatever doing so means for its internal data structures).
.nH 4 "INSERT_PROPERTY"
.LP
When the owner of a selection receives a request to convert it to
INSERT_PROPERTY, 
it should insert the property named in the request at the location 
of the selection for which it got the INSERT_SELECTION request
(whatever doing so means for its internal data structures).
.nH 2 "Use of Selection Properties"
.LP
The names of the properties used in selection data transfer are chosen by
the requestor.
The use of 
.PN None 
property fields in 
.PN ConvertSelection 
requests (which request the selection owner to choose a name)
is not permitted by these conventions.
.LP
The selection owner always chooses the type of the property 
in the selection data transfer.
Some types have special semantics assigned by convention,
and these are reviewed in the following sections.
.LP
In all cases,
a request for conversion to a target should return either
a property of one of the types listed in the previous table for that target
or a property of type INCR and then a property of one of the listed types.
.LP
Certain selection properties may contain resource IDs.  The selection owner
should ensure that the resource is not destroyed and that its contents are
not changed until after the selection transfer is complete.  Requestors that
rely on the existence or on the proper contents of a resource must operate
on the resource (for example, by copying the contents of a pixmap) before
deleting the selection property.
.LP
The selection owner will return a list of zero or more items
of the type indicated by the property type.
In general,
the number of items in the list will correspond to the number 
of disjoint parts of the selection.
Some targets (for example, side-effect targets) will be of length zero
irrespective of the number of disjoint selection parts.
In the case of fixed-size items,
the requestor may determine the number of items by the property size.
Selection property types are listed in the table below.
For variable-length items such as text, 
the separators are also listed.
.br
.ne 6
.TS H
l c l.
_
.sp 6p
.B
Type Atom	Format	Separator
.R
.sp 6p
_
.sp 6p
.TH
APPLE_PICT	8	T{
Self-sizing
T}
ATOM	32	Fixed-size
ATOM_PAIR	32	Fixed-size
BITMAP	32	Fixed-size
C_STRING	8	T{
Zero
T}
COLORMAP	32	T{
Fixed-size
T}
COMPOUND_TEXT	8	Zero
DRAWABLE	32	Fixed-size
INCR	32	Fixed-size
INTEGER	32	Fixed-size
PIXEL	32	T{
Fixed-size
T}
PIXMAP	32	Fixed-size
SPAN	32	Fixed-size
STRING	8	Zero
UTF8_STRING	8	Zero
WINDOW	32	Fixed-size
.sp 6p
_
.TE
.LP
It is expected that this table will grow over time.
.nH 3 "TEXT Properties"
.LP
In general, 
the encoding for the characters in a text string property is specified 
by its type.
It is highly desirable for there to be a simple, invertible mapping 
between string property types and any character set names
embedded within font names in any font naming standard adopted by the
Consortium.
.LP
The atom TEXT is a polymorphic target.
Requesting conversion into TEXT will convert into whatever encoding 
is convenient for the owner.
The encoding chosen will be indicated by the type of the property returned.
TEXT is not defined as a type;
it will never be the returned type from a selection conversion request.
.LP
If the requestor wants the owner to return the contents of the selection
in a specific encoding,
it should request conversion into the name of that encoding.
.LP
In the table in section 2.6.2,
the word TEXT (in the Type column) is used to indicate one 
of the registered encoding names.
The type would not actually be TEXT;
it would be STRING or some other ATOM naming the encoding chosen by the owner.
.LP
STRING as a type or a target specifies the ISO Latin-1 character set plus the
control characters TAB (hex 09) and NEWLINE (hex 0A).
The spacing interpretation of TAB is context dependent.
Other ASCII control characters are explicitly not included in STRING 
at the present time.
.LP
COMPOUND_TEXT as a type or a target specifies the Compound Text interchange
format; see the \fICompound Text Encoding\fP.
.LP
UTF8_STRING as a type or a target specifies an UTF-8 encoded string, with
NEWLINE (U+000A, hex 0A) as end-of-line marker.
.LP
There are some text objects where the source or intended user, as the
case may be, does not have a specific character set for the text, but
instead merely requires a zero-terminated sequence of bytes with no
other restriction; no element of the selection mechanism may assume that
any byte value is forbidden or that any two differing sequences are
equivalent.\**  For these objects, the type C_STRING should be used.
.FS
Note that this is different from STRING, where many byte values are
forbidden, and from COMPOUND_TEXT, where, for example, inserting the
sequence 27,\ 40,\ 66 (designate ASCII into GL) at the start does not alter
the meaning.
.FE
.NT Rationale
An example of the need for C_STRING is to transmit the names of
files; many operating systems do not interpret filenames as having
a character set. For example, the same character string uses a
different sequence of bytes in ASCII and EBCDIC, and so most
operating systems see these as different filenames and offer no
way to treat them as the same. Thus no character-set based
property type is suitable.
.NE
.LP
Type STRING, COMPOUND_TEXT, UTF8_STRING, and C_STRING properties will
consist of a list of elements separated by null characters; other encodings
will need to specify an appropriate list format.
.nH 3 "INCR Properties"
.LP
Requestors may receive a property of type INCR\**
in response to any target that results in selection data.
.FS
These properties were called INCREMENTAL in an earlier draft.
The protocol for using them has changed, 
and so the name has changed to avoid confusion.
.FE
This indicates that the owner will send the actual data incrementally.
The contents of the INCR property will be an integer,  
which represents a lower bound on the number of bytes of data in the selection.
The requestor and the selection owner transfer the data in the selection 
in the following manner.
.LP
The selection requestor starts the transfer process by deleting
the (type==INCR) property forming the reply to the selection.
.LP
The selection owner then:
.bP
Appends the data in suitable-size chunks to the
same property on the same window as the selection reply
with a type corresponding to the actual type of the converted selection.
The size should be less than the maximum-request-size in the connection
handshake.
.bP
Waits between each append for a 
.PN PropertyNotify (state==Deleted) 
event that shows that the requestor has read the data.
The reason for doing this is to limit the consumption of space in the server.
.bP
Waits (after the entire data has been transferred to the server) until a 
.PN PropertyNotify (state==Deleted)
event that shows that the data has been read by the requestor
and then writes zero-length data to the property.
.LP
The selection requestor:
.bP
Waits for the 
.PN SelectionNotify 
event.
.bP
Loops:
.RS
.IP \- 5
Retrieving data using 
.PN GetProperty 
with the delete argument
.PN True .
.IP \- 5
Waiting for a 
.PN PropertyNotify 
with the state argument 
.PN NewValue .
.RE
.bP
Waits until the property named by the
.PN PropertyNotify
event is zero-length.
.bP
Deletes the zero-length property.
.LP
The type of the converted selection is the type of the first partial property.
The remaining partial properties must have the same type.
.nH 3 "DRAWABLE Properties"
.LP
Requestors may receive properties of type PIXMAP, BITMAP, DRAWABLE, or WINDOW,
which contain an appropriate ID.
While information about these drawables is available from the server by means of
the 
.PN GetGeometry 
request,
the following items are not:
.bP
Foreground pixel
.bP
Background pixel
.bP
Colormap ID
.LP
In general,
requestors converting into targets whose returned type in the table 
in section 2.6.2 is one of the DRAWABLE types should expect to convert also 
into the following targets (using the MULTIPLE mechanism):
.bP
FOREGROUND returns a PIXEL value.
.bP
BACKGROUND returns a PIXEL value.
.bP
COLORMAP returns a colormap ID.
.nH 3 "SPAN Properties"
.LP
Properties with type SPAN contain a list of cardinal-pairs
with the length of the cardinals determined by the format.
The first specifies the starting position,
and the second specifies the ending position plus one.
The base is zero.
If they are the same,
the span is zero-length and is before the specified position.
The units are implied by the target atom, 
such as LINE_NUMBER or CHARACTER_POSITION.
.nH 2 "Manager Selections"
.LP
Certain clients, often called managers, take on responsibility
for managing shared resources.  A client that manages a shared
resource should take ownership of an appropriate selection,
named using the conventions described in sections 1.2.3
and 1.2.6.  A client that manages multiple
shared resources (or groups of resources) should take
ownership of a selection for each one.
.LP
The manager may support conversion of various targets
for that selection.  Managers are encouraged to use this
technique as the primary means by which clients interact
with the managed resource.  Note that the conventions for
interacting with the window manager predate this section;
as a result many interactions with the window manager use
other techniques.
.LP
Before a manager takes ownership of a manager selection, it
should use the
.PN GetSelection\%Owner
request to check whether the selection is already owned by another client,
and, where appropriate, it should ask the user if the new manager should
replace the old one.  If so, it may then take ownership of the selection.
Managers should acquire the selection using a window created expressly for
this purpose.  Managers must conform to the rules for selection owners
described in sections 2.1 and 2.2, and they must also support the required
targets listed in section 2.6.2.
.LP
If a manager loses ownership of a manager selection, this
means that a new manager is taking over its responsibilities.
The old manager must release all resources it has managed
and must then destroy the window that owned the selection.
For example, a window manager losing ownership of WM_S2
must deselect from
.PN SubstructureRedirect
on the root window of screen 2 before destroying the window that owned
WM_S2.
.LP
When the new manager notices that the window owning the selection
has been destroyed, it knows that it can successfully proceed to
control the resource it is planning to manage.  If the old
manager does not destroy the window within a reasonable time,
the new manager should check with the user before destroying
the window itself or killing the old manager.
.LP
If a manager wants to give up, on its own, management of a shared
resource controlled by a selection, it must do so by releasing
the resources it is managing and then by destroying the
window that owns the selection.  It should not first disown
the selection, since this introduces a race condition.
.LP
Clients who are interested in knowing when the owner of a
manager selection is no longer managing the corresponding shared
resource should select for
.PN StructureNotify
on the window owning the selection so they can be notified when the window
is destroyed.  Clients are warned that after doing a
.PN GetSelectionOwner
and selecting for
.PN StructureNotify ,
they should do a
.PN GetSelectionOwner
again to ensure that the owner did not change after initially getting the
selection owner and before selecting for 
.PN StructureNotify .
.LP
Immediately after a manager successfully acquires ownership of a
manager selection, it should announce its arrival by sending a
.PN ClientMessage
event.  This event should be sent using the
.PN SendEvent
protocol request with the following arguments:
.br
.ne 6
.TS
l lw(4.5i) .
_
.sp 6p
.B
Argument	Value
.R
.sp 6p
_
.sp 6p
destination:	T{
the root window of screen 0, or the root
window of the appropriate screen if the
manager is managing a screen-specific resource
T}
propagate:	False
event-mask:	T{
.PN StructureNotify
T}
event:	T{
.PN ClientMessage
T}
\h'4n'type:	MANAGER
\h'4n'format:	32
T{
\h'4n'data[0]:\|\**
T}	timestamp
\h'4n'data[1]:	manager selection atom
\h'4n'data[2]:	the window owning the selection
\h'4n'data[3]:	manager-selection-specific data
\h'4n'data[4]:	manager-selection-specific data
.sp 6p
_
.TE
.FS
We use the notation data[n] to indicate the n\s-2\uth\d\s0 element 
of the LISTofINT8, LISTofINT16, or LISTofINT32 in the data field of the 
.PN ClientMessage ,
according to the format field.
The list is indexed from zero.
.FE
.LP
Clients that wish to know when a specific manager has started should
select for
.PN Structure\%Notify
on the appropriate root window and should watch for the appropriate MANAGER
.PN Client\%Message .
.nH 1 "Peer-to-Peer Communication by Means of Cut Buffers"
.LP
The cut buffer mechanism is much simpler but much less powerful 
than the selection mechanism.
The selection mechanism is active in that it provides a link 
between the owner and requestor clients.
The cut buffer mechanism is passive;
an owner places data in a cut buffer from which a requestor retrieves
the data at some later time.
.LP
The cut buffers consist of eight properties on the root of screen zero,
named by the predefined atoms CUT_BUFFER0 to CUT_BUFFER7.
These properties must, at present, have type STRING and format 8.
A client that uses the cut buffer mechanism must initially ensure that
all eight properties exist by using
.PN ChangeProperty 
requests to append zero-length data to each.
.LP
A client that stores data in the cut buffers (an owner) first must rotate the
ring of buffers by plus 1 by using
.PN RotateProperties 
requests to rename each buffer;
that is, CUT_BUFFER0 to CUT_BUFFER1, CUT_BUFFER1 to CUT_BUFFER2, .\^.\^.\|,
and CUT_BUFFER7 to CUT_BUFFER0.
It then must store the data into CUT_BUFFER0 by using a
.PN Change\%Property 
request in mode 
.PN Replace .
.LP
A client that obtains data from the cut buffers should use a
.PN GetProperty 
request to retrieve the contents of CUT_BUFFER0.
.LP
In response to a specific user request,
a client may rotate the cut buffers by minus 1 by using 
.PN RotateProperties 
requests to rename each buffer;
that is, CUT_BUFFER7 to CUT_BUFFER6, CUT_BUFFER6 to CUT_BUFFER5, .\^.\^.\|,
and CUT_BUFFER0 to CUT_BUFFER7.
.LP
Data should be stored to the cut buffers
and the ring rotated only when requested by explicit user action.
Users depend on their mental model of cut buffer operation
and need to be able to identify operations that transfer data to and fro.
.nH 1 "Client-to-Window-Manager Communication"
.LP
To permit window managers to perform their role of mediating the competing
demands for resources such as screen space,
the clients being managed must adhere to certain conventions
and must expect the window managers to do likewise.
These conventions are covered here from the client's point of view.
.LP
In general,
these conventions are somewhat complex
and will undoubtedly change as new window management paradigms are developed.
Thus, there is a strong bias toward defining only those conventions
that are essential and that apply generally to all window management paradigms.
Clients designed to run with a particular window manager can easily
define private protocols to add to these conventions,
but they must be aware that their users may decide to run some other
window manager no matter how much the designers of the private protocol
are convinced that they have seen the \*Qone true light\*U of user interfaces.
.LP
It is a principle of these conventions that a general client should
neither know nor care which window manager is running or, indeed, 
if one is running at all.
The conventions do not support all client functions 
without a window manager running;
for example, the concept of Iconic 
is not directly supported by clients.
If no window manager is running,
the concept of Iconic does not apply.
A goal of the conventions is to make it possible to kill and
restart window managers without loss of functionality.
.LP
Each window manager will implement a particular window management policy;
the choice of an appropriate window management policy
for the user's circumstances is not one for an individual client to
make but will be made by the user or the user's system administrator.
This does not exclude the possibility of writing clients that
use a private protocol to restrict themselves to operating only
under a specific window manager.
Rather, 
it merely ensures that no claim of general utility is made for such programs.
.LP
For example,
the claim is often made: 
\*QThe client I'm writing is important, and it needs to be on top.\*U
Perhaps it is important when it is being run in earnest,
and it should then be run under the control of a window manager 
that recognizes \*Qimportant\*U windows through some private protocol 
and ensures that they are on top.
However, imagine, for example, that the \*Qimportant\*U client is being debugged.
Then,  ensuring that it is always on top is no longer 
the appropriate window management policy,
and it should be run under a window manager that allows other windows 
(for example, the debugger) to appear on top.
.nH 2 "Client's Actions"
.LP
In general, 
the object of the X Version 11 design is that clients should,
as far as possible, do exactly what they would do in the absence 
of a window manager, except for the following:
.bP
Hinting to the window manager about the resources they would like
to obtain
.bP
Cooperating with the window manager by accepting the resources they
are allocated even if they are not those requested
.bP
Being prepared for resource allocations to change at any time
.nH 3 "Creating a Top-Level Window"
.LP
A client's \fItop-level window\fP is a window whose override-redirect
attribute is
.PN False .
It must either be a child of a root window, or it must have been a child of
a root window immediately prior to having been reparented by the window
manager.  If the client reparents the window away from the root, the window
is no longer a top-level window; but it can become a top-level window again
if the client reparents it back to the root.
.LP
A client usually would expect to create its top-level windows
as children of one or more of the root windows by using some
boilerplate like the following:
.LP
.Ds 0
.TA 2i
.ta 2i
win = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), xsh.x, xsh.y, 
	xsh.width, xsh.height, bw, bd, bg);
.De
.LP
If a particular one of the root windows was required, however,
it could use something like the following:
.LP
.Ds 0
.TA 2i
.ta 2i
win = XCreateSimpleWindow(dpy, RootWindow(dpy, screen), xsh.x, xsh.y, 
	xsh.width, xsh.height, bw, bd, bg);
.De
.LP
Ideally,
it should be possible to override the choice of a root window 
and allow clients (including window managers) to treat a nonroot window 
as a pseudo-root.
This would allow, for example, the testing of window managers and the
use of application-specific window managers to control the subwindows
owned by the members of a related suite of clients.
Doing so properly requires an extension,
the design of which is under study.
.LP
From the client's point of view,
the window manager will regard its top-level window as being in 
one of three states:
.bP
Normal
.bP
Iconic
.bP
Withdrawn
.LP
Newly created windows start in the Withdrawn state.
Transitions between states happen when the top-level window is mapped
and unmapped and when the window manager receives certain messages.
For further details, see sections 4.1.2.4 and 4.1.4.
.nH 3 "Client Properties"
.LP
Once the client has one or more top-level windows, 
it should place properties on those windows to inform the window manager 
of the behavior that the client desires.
Window managers will assume values they find convenient 
for any of these properties that are not supplied;
clients that depend on particular values must explicitly supply them.
The window manager will not change properties written by the client.
.LP
The window manager will examine the contents of these
properties when the window makes the transition from the Withdrawn state
and will monitor some properties for changes while the window is 
in the Iconic or Normal state.
When the client changes one of these properties, 
it must use 
.PN Replace
mode to overwrite the entire property with new data;
the window manager will retain no memory of the old value of the property.
All fields of the property must be set to suitable values in a single 
.PN Replace
mode 
.PN ChangeProperty
request.
This ensures that the full contents of the property will be
available to a new window manager if the existing one crashes,
if it is shut down and restarted,
or if the session needs to be shut down and restarted by the session manager.
.NT Convention
Clients writing or rewriting window manager properties must
ensure that the entire content of each property remains valid
at all times.
.NE
.LP
Some of these properties may contain the IDs of resources, such as
windows or pixmaps.  Clients should ensure that these resources exist
for at least as long as the window on which the property resides.
.LP
If these properties are longer than expected,
clients should ignore the remainder of the property.
Extending these properties is reserved to the X Consortium;
private extensions to them are forbidden.
Private additional communication between clients and window managers 
should take place using separate properties.
The only exception to this rule is the WM_PROTOCOLS property, which may be
of arbitrary length and which may contain atoms representing private
protocols (see section 4.1.2.7).
.LP
The next sections describe each of the properties the clients
need to set, in turn.
They are summarized in the table in section 4.4.
.nH 4 "WM_NAME Property"
.LP
The WM_NAME property is an uninterpreted string 
that the client wants the window manager to display
in association with the window (for example, in a window headline bar).
.LP
The encoding used for this string 
(and all other uninterpreted string properties) 
is implied by the type of the property.
The type atoms to be used for this purpose are described in section 2.7.1.
.LP
Window managers are expected to make an effort to display this information.
Simply ignoring WM_NAME is not acceptable behavior.
Clients can assume that at least the first part of this string
is visible to the user and that if the information is not visible to the user,
it is because the user has taken an explicit action to make it invisible.
.LP
On the other hand,
there is no guarantee that the user can see the WM_NAME string 
even if the window manager supports window headlines.
The user may have placed the headline off-screen
or have covered it by other windows.
WM_NAME should not be used for application-critical information 
or to announce asynchronous changes of an application's state 
that require timely user response.
The expected uses are to permit the user to identify one of a
number of instances of the same client
and to provide the user with noncritical state information.
.LP
Even window managers that support headline bars will place some limit 
on the length of the WM_NAME string that can be visible;
brevity here will pay dividends.
.nH 4 "WM_ICON_NAME Property"
.LP
The WM_ICON_NAME property is an uninterpreted string 
that the client wants to be displayed in association with the window 
when it is iconified (for example, in an icon label).
In other respects, 
including the type, it is similar to WM_NAME.
For obvious geometric reasons,
fewer characters will normally be visible in WM_ICON_NAME than WM_NAME.
.LP
Clients should not attempt to display this string in their icon pixmaps
or windows; rather, they should rely on the window manager to do so.
.nH 4 "WM_NORMAL_HINTS Property"
.LP
The type of the WM_NORMAL_HINTS property is WM_SIZE_HINTS.
Its contents are as follows:
.br
.ne 6
.TS H
lw(1i) lw(1i) lw(2i).
_
.sp 6p
.B
Field	Type	Comments
.sp 6p
_
.sp 6p
.TH
.R
flags	CARD32	(see the next table)
pad	4*CARD32	For backwards compatibility
min_width	INT32	If missing, assume base_width
min_height	INT32	If missing, assume base_height
max_width	INT32
max_height	INT32
width_inc	INT32
height_inc	INT32
min_aspect	(INT32,INT32)
max_aspect	(INT32,INT32)
base_width	INT32	If missing, assume min_width
base_height	INT32	If missing, assume min_height
win_gravity	INT32	T{
If missing, assume
.PN NorthWest
T}
.sp 6p
_
.TE
.LP
The WM_SIZE_HINTS.flags bit definitions are as follows:
.br
.ne 6
.TS H
lw(1i) nw(.5i) lw(3i).
_
.sp 6p
.B
Name	Value	Field
.sp 6p
_
.sp 6p
.TH
.R
T{
.PN USPosition
T}	1	User-specified x, y
T{
.PN USSize
T}	2	User-specified width, height
T{
.PN PPosition
T}	4	Program-specified position
T{
.PN PSize
T}	8	Program-specified size
T{
.PN PMinSize
T}	16	Program-specified minimum size
T{
.PN PMaxSize
T}	32	Program-specified maximum size
T{
.PN PResizeInc
T}	64	Program-specified resize increments
T{
.PN PAspect
T}	128	Program-specified min and max aspect ratios
T{
.PN PBaseSize
T}	256	Program-specified base size
T{
.PN PWinGravity
T}	512	Program-specified window gravity
.sp 6p
_
.TE
.LP
To indicate that the size and position of the window 
(when a transition from the Withdrawn state occurs) was specified by the user, 
the client should set the
.PN USPosition
and
.PN USSize
flags, 
which allow a window manager to know that the user specifically asked where
the window should be placed or how the window should be sized and that
further interaction is superfluous.
To indicate that it was specified by the client without any user involvement,
the client should set 
.PN PPosition
and 
.PN PSize .
.LP
The size specifiers refer to the width and height of the client's
window excluding borders.
.LP
The win_gravity may be any of the values specified for WINGRAVITY in
the core protocol except for
.PN Unmap :
.PN NorthWest 
(1), 
.PN North 
(2), 
.PN NorthEast 
(3), 
.PN West 
(4), 
.PN Center
(5),
.PN East
(6), 
.PN SouthWest
(7),
.PN South
(8), and 
.PN SouthEast
(9).  It specifies how and whether the client window wants to be shifted to
make room for the window manager frame.
.LP
If the win_gravity is
.PN Static ,
the window manager frame is positioned
so that the inside border of the client window inside the frame is
in the same position on the screen as it was when the client
requested the transition from Withdrawn state.  Other values of
win_gravity specify a window reference point.  For
.PN NorthWest ,
.PN NorthEast ,
.PN SouthWest ,
and
.PN SouthEast
the reference point is the specified outer corner of the window (on the
outside border edge).  For
.PN North ,
.PN South ,
.PN East ,
and
.PN West
the reference point is the center of the specified outer edge of the window
border.  For
.PN Center
the reference point is the center of the window.  The reference point of the
window manager frame is placed at the location on the screen where the
reference point of the client window was when the client requested the
transition from Withdrawn state.
.LP
The min_width and min_height elements specify the
minimum size that the window can be for the client to be useful.
The max_width and max_height elements specify the maximum size.
The base_width and base_height elements in conjunction with width_inc
and height_inc define an arithmetic progression of preferred window
widths and heights for non-negative integers \fIi\fP and \fIj\fP:
.LP
.Ds
.EQ C
width ~ = ~ base_width ~ + ~ ( i ~ times ~ width_inc )
.EN
.EQ C
height ~ = ~ base_height ~ + ~ ( j ~ times ~ height_inc )
.EN
.De
.LP
Window managers are encouraged to use \fIi\fP and \fIj\fP 
instead of width and height in reporting window sizes to users.
If a base size is not provided, 
the minimum size is to be used in its place and vice versa.
.LP
The min_aspect and max_aspect fields are fractions with the numerator first
and the denominator second, and they allow a client to specify the range of
aspect ratios it prefers.  Window managers that honor aspect ratios should
take into account the base size in determining the preferred window size.  If
a base size is provided along with the aspect ratio fields, the base size
should be subtracted from the window size prior to checking that the aspect
ratio falls in range.  If a base size is not provided, nothing should be
subtracted from the window size.  (The minimum size is not to be used in
place of the base size for this purpose.)
.nH 4 "WM_HINTS Property"
.LP
The WM_HINTS property (whose type is WM_HINTS)
is used to communicate to the window manager.
It conveys the information the window manager needs 
other than the window geometry,
which is available from the window itself;
the constraints on that geometry,
which is available from the WM_NORMAL_HINTS structure;
and various strings,
which need separate properties, such as WM_NAME.
The contents of the properties are as follows:
.br
.ne 6
.TS H
l l l.
_
.sp 6p
.B
Field	Type	Comments
.sp 6p
_
.sp 6p
.TH
.R
flags	CARD32	(see the next table)
input	CARD32	The client's input model
initial_state	CARD32	The state when first mapped
icon_pixmap	PIXMAP	The pixmap for the icon image
icon_window	WINDOW	The window for the icon image
icon_x	INT32	The icon location
icon_y	INT32
icon_mask	PIXMAP	The mask for the icon shape
window_group	WINDOW	The ID of the group leader window
.sp 6p
_
.TE
.LP
The WM_HINTS.flags bit definitions are as follows:
.br
.ne 6
.TS H
lw(1.5i) nw(.5i) lw(1.5i).
_
.sp 6p
.B
Name	Value	Field
.sp 6p
_
.sp 6p
.TH
.R
T{
.PN InputHint
T}	1	input
T{
.PN StateHint
T}	2	initial_state
T{
.PN IconPixmapHint
T}	4	icon_pixmap
T{
.PN IconWindowHint
T}	8	icon_window
T{
.PN IconPositionHint
T}	16	icon_x & icon_y
T{
.PN IconMaskHint
T}	32	icon_mask
T{
.PN WindowGroupHint
T}	64	window_group
T{
.PN MessageHint
T}	128	(this bit is obsolete)
T{
.PN UrgencyHint
T}	256	urgency
.sp 6p
_
.TE
.LP
Window managers are free to assume convenient values for all fields of
the WM_HINTS property if a window is mapped without one.
.LP
The input field is used to communicate to the window manager the input focus
model used by the client (see section 4.1.7).
.LP
Clients with the Globally Active and No Input models should set the
input flag to
.PN False .
Clients with the Passive and Locally Active models should set the input
flag to
.PN True .
.LP
From the client's point of view, 
the window manager will regard the client's top-level window as being 
in one of three states:
.bP
Normal
.bP
Iconic
.bP
Withdrawn
.LP
The semantics of these states are described in section 4.1.4.
Newly created windows start in the Withdrawn state.
Transitions between states happen when a
top-level window is mapped and unmapped
and when the window manager receives certain messages.
.LP
The value of the initial_state field determines the state the client
wishes to be in at the time the top-level window is mapped 
from the Withdrawn state, as shown in the following table:
.br
.ne 6
.TS H
l n l.
_
.sp 6p
.B
State	Value	Comments
.sp 6p
_
.sp 6p
.TH
.R
T{
.PN NormalState
T}	1	The window is visible.
T{
.PN IconicState
T}	3	The icon is visible.
.sp 6p
_
.TE
.LP
The icon_pixmap field may specify a pixmap to be used as an icon.
This pixmap should be:
.bP
One of the sizes specified in the WM_ICON_SIZE property 
on the root if it exists (see section 4.1.3.2).
.bP
1-bit deep.
The window manager will select, through the defaults database,
suitable background (for the 0 bits) and foreground (for the 1 bits) colors.
These defaults can, of course, specify different colors for the icons 
of different clients.
.LP
The icon_mask specifies which pixels of the icon_pixmap should be used as the
icon, allowing for icons to appear nonrectangular.
.LP
The icon_window field is the ID of a window the client wants used as its icon.
Most, but not all, window managers will support icon windows.
Those that do not are likely to have a user interface in which small
windows that behave like icons are completely inappropriate.
Clients should not attempt to remedy the omission by working around it.
.LP
Clients that need more capabilities from the icons than a simple 2-color
bitmap should use icon windows.
Rules for clients that do are set out in section 4.1.9.
.LP
The (icon_x,icon_y) coordinate is a hint to the window manager 
as to where it should position the icon.
The policies of the window manager control the positioning of icons,
so clients should not depend on attention being paid to this hint.
.LP
The window_group field lets the client specify that this window belongs 
to a group of windows.
An example is a single client manipulating multiple 
children of the root window.
.NT Conventions
.IP 1. 5
The window_group field should be set to the ID of the group leader.
The window group leader may be a window that exists only for that purpose;
a placeholder group leader of this kind would never be mapped
either by the client or by the window manager.
.IP 2. 5
The properties of the window group leader are those for the group as
a whole (for example, the icon to be shown when the entire group is iconified).
.NE
.LP
Window managers may provide facilities for manipulating the group as a whole.
Clients, at present, have no way to operate on the group as a whole.
.LP
The messages bit, if set in the flags field, indicates that the
client is using an obsolete window manager communication protocol,\**
rather than the WM_PROTOCOLS mechanism of section 4.1.2.7.
.FS
This obsolete protocol was described in the July 27, 1988,
draft of the ICCCM.
Windows using it can also be detected because their WM_HINTS properties are
4 bytes longer than expected.
Window managers are free to support clients using the obsolete protocol
in a backwards compatibility mode.
.FE
.LP
The
.PN UrgencyHint
flag, if set in the flags field, indicates that the client deems the window
contents to be urgent, requiring the timely response of the user.  The
window manager must make some effort to draw the user's attention to this
window while this flag is set.  The window manager must also monitor the
state of this flag for the entire time the window is in the Normal or Iconic
state and must take appropriate action when the state of the flag changes.
The flag is otherwise independent of the window's state; in particular, the
window manager is not required to deiconify the window if the client sets
the flag on an Iconic window.  Clients must provide some means by which the
user can cause the
.PN UrgencyHint
flag to be set to zero or the window to be withdrawn.  The user's action can
either mitigate the actual condition that made the window urgent, or it can
merely shut off the alarm.
.NT Rationale
This mechanism is useful for alarm dialog boxes or reminder windows, in
cases where mapping the window is not enough (e.g., in the presence of
multi-workspace or virtual desktop window managers), and where using an
override-redirect window is too intrusive.  For example, the window manager
may attract attention to an urgent window by adding an indicator to its
title bar or its icon.  Window managers may also take additional action
for a window that is newly urgent, such as by flashing its icon (if the
window is iconic) or by raising it to the top of the stack.
.NE
.nH 4 "WM_CLASS Property"
.LP
The WM_CLASS property (of type STRING without control characters)
contains two consecutive null-terminated strings.
These specify the Instance and Class names to be used by both the client 
and the window manager for looking up resources for the application 
or as identifying information.
This property must be present when the window leaves the Withdrawn state
and may be changed only while the window is in the Withdrawn state.
Window managers may examine the property only when they start up 
and when the window leaves the Withdrawn state,
but there should be no need for a client to change its state dynamically.
.LP
The two strings, respectively, are:
.bP
A string that names the particular instance of the application to which
the client that owns this window belongs.
Resources that are specified by instance name override any resources
that are specified by class name.
Instance names can be specified by the user in an operating-system specific 
manner.
On POSIX-conformant systems,
the following conventions are used:
.RS
.IP \- 5
If \*Q\-name NAME\*U is given on the command line,
NAME is used as the instance name.
.IP \- 5
Otherwise, if the environment variable RESOURCE_NAME is set,
its value will be used as the instance name.
.IP \- 5
Otherwise,
the trailing part of the name used to invoke the program
(argv[0] stripped of any directory names) is used as the instance name.
.RE
.bP
A string that names the general class of applications to which the client 
that owns this window belongs.
Resources that are specified by class apply to all applications 
that have the same class name.
Class names are specified by the application writer.
Examples of commonly used class names include: 
\*QEmacs\*U, \*QXTerm\*U, \*QXClock\*U, \*QXLoad\*U, and so on.
.LP
Note that WM_CLASS strings are null-terminated
and, thus, differ from the general conventions that STRING properties 
are null-separated.
This inconsistency is necessary for backwards compatibility.
.nH 4 "WM_TRANSIENT_FOR Property"
.LP
The WM_TRANSIENT_FOR property (of type WINDOW)
contains the ID of another top-level window.
The implication is that this window is a pop-up on behalf of the named window,
and window managers may decide not to decorate transient windows
or may treat them differently in other ways.
In particular,
window managers should present newly mapped WM_TRANSIENT_FOR
windows without requiring any user interaction,
even if mapping top-level windows normally does require interaction.
Dialogue boxes, for example, are an example of windows that should have
WM_TRANSIENT_FOR set.
.LP
It is important not to confuse WM_TRANSIENT_FOR with override-redirect.
WM_TRANSIENT_FOR should be used in those cases where the pointer
is not grabbed while the window is mapped (in other words, 
if other windows are allowed to be active while the transient is up).
If other windows must be prevented from processing input
(for example, when implementing pop-up menus),
use override-redirect and grab the pointer while the window is mapped.
.nH 4 "WM_PROTOCOLS Property"
.LP
The WM_PROTOCOLS property (of type ATOM) is a list of atoms.
Each atom identifies a communication protocol between the client 
and the window manager in which the client is willing to participate.
Atoms can identify both standard protocols and private protocols
specific to individual window managers.
.LP
All the protocols in which a client can volunteer to take part 
involve the window manager sending the client a 
.PN ClientMessage
event and the client taking appropriate action.
For details of the contents of the event,
see section 4.2.8.
In each case,
the protocol transactions are initiated by the window manager.
.LP
The WM_PROTOCOLS property is not required.
If it is not present,
the client does not want to participate in any window manager protocols.
.LP
The X Consortium will maintain a registry of protocols to avoid collisions 
in the name space.
The following table lists the protocols that have been defined to date.
.br
.ne 6
.TS H
l c l.
_
.sp 6p
.B
Protocol	Section	Purpose
.sp 6p
_
.sp 6p
.TH
.R
WM_TAKE_FOCUS	4.1.7	Assignment of input focus
WM_SAVE_YOURSELF	Appendix C	Save client state request (deprecated)
WM_DELETE_WINDOW	4.2.8.1	Request to delete top-level window
.sp 6p
_
.TE
It is expected that this table will grow over time.
.nH 4 "WM_COLORMAP_WINDOWS Property"
.LP
The WM_COLORMAP_WINDOWS property (of type WINDOW) on a top-level window 
is a list of the IDs of windows that may need colormaps installed
that differ from the colormap of the top-level window.
The window manager will watch this list of windows for changes in their
colormap attributes.
The top-level window is always (implicitly or explicitly) on the watch list.
For the details of this mechanism,
see section 4.1.8.
.nH 4 "WM_CLIENT_MACHINE Property"
.LP
The client should set the WM_CLIENT_MACHINE property (of one of the TEXT
types) to a string that forms the name of the machine running the client as
seen from the machine running the server.
.nH 3 "Window Manager Properties"
.LP
The properties that were described in the previous section are those 
that the client is responsible for maintaining on its top-level windows.
This section describes the properties that the window manager places on
client's top-level windows and on the root.
.nH 4 "WM_STATE Property"
.LP
The window manager will place a WM_STATE property (of type WM_STATE) on each
top-level client window that is not in the Withdrawn state.  Top-level
windows in the Withdrawn state may or may not have the WM_STATE property.
Once the top-level window has been withdrawn, the client may re-use it for
another purpose.  Clients that do so should remove the WM_STATE property if
it is still present.
.LP
Some clients (such as \fBxprop\fP) will ask the user to click over a window
on which the program is to operate.  Typically, the intent is for this to be
a top-level window.  To find a top-level window, clients should search the
window hierarchy beneath the selected location for a window with the
WM_STATE property.  This search must be recursive in order to cover all
window manager reparenting possibilities.  If no window with a WM_STATE
property is found, it is recommended that programs use a mapped
child-of-root window if one is present beneath the selected location.
.LP
The contents of the WM_STATE property are defined as follows:
.br
.ne 6
.TS H
l l l.
_
.sp 6p
.B
Field	Type	Comments
.R
.sp 6p
_
.sp 6p
.TH
state	CARD32	(see the next table)
icon	WINDOW	ID of icon window
.sp 6p
_
.TE
.LP
The following table lists the WM_STATE.state values:
.br
.ne 6
.TS H
l n.
_
.sp 6p
.B
State	Value
.R
.sp 6p
_
.sp 6p
.TH
T{
.PN WithdrawnState
T}	0
T{
.PN NormalState
T}	1
T{
.PN IconicState
T}	3
.sp 6p
_
.TE
.LP
Adding other fields to this property is reserved to the X Consortium.
Values for the state field other than those defined in the above
table are reserved for use by the X Consortium.
.LP
The state field describes the window manager's idea of the state 
the window is in, which may not match the client's idea as expressed 
in the initial_state field of the WM_HINTS property 
(for example, if the user has asked the window manager to iconify the window).
If it is 
.PN Normal\%State ,
the window manager believes the client should be animating its window.
If it is 
.PN IconicState ,
the client should animate its icon window.
In either state,
clients should be prepared to handle exposure events from either window.
.LP
When the window is withdrawn, the window manager will either change the
state field's value to
.PN Withdrawn\%State
or it will remove the WM_STATE property entirely.
.LP
The icon field should contain the window ID of the window that the
window manager uses as the icon for the window on which this property is
set.  If no such window exists, the icon field should be
.PN None .
Note that this window could be but is not necessarily the same window as the
icon window that the client may have specified in its WM_HINTS property.
The WM_STATE icon may be a window that the window manager has supplied and
that contains the client's icon pixmap, or it may be an ancestor of the
client's icon window.
.nH 4 "WM_ICON_SIZE Property"
.LP
A window manager that wishes to place constraints on the sizes of icon
pixmaps and/or windows should place a property called WM_ICON_SIZE on the root.
The contents of this property are listed in the following table. 
.br
.ne 6
.TS H
l l l.
_
.sp 6p
.B
Field	Type	Comments
.sp 6p
_
.sp 6p
.TH
.R
min_width	CARD32	The data for the icon size series
min_height	CARD32
max_width	CARD32
max_height	CARD32
width_inc	CARD32
height_inc	CARD32
.sp 6p
_
.TE
.LP
For more details see section 14.1.12 in \fIXlib \- C Language X Interface\fP.
.nH 3 "Changing Window State"
.LP
From the client's point of view,
the window manager will regard each of the client's top-level 
windows as being in one of three states,
whose semantics are as follows:
.bP
.PN NormalState
\- The client's top-level window is viewable.
.bP
.PN IconicState
\- The client's top-level window is iconic
(whatever that means for this window manager).
The client can assume that its top-level window is not viewable,
its icon_window (if any) will be viewable
and, failing that, 
its icon_pixmap (if any) or its WM_ICON_NAME will be displayed.
.bP
.PN WithdrawnState
\- Neither the client's top-level window nor its icon is visible.
.LP
In fact,
the window manager may implement states with semantics 
other than those described above.
For example,
a window manager might implement a concept of an \*Qinactive\*U state
in which an infrequently used client's window would be represented 
as a string in a menu.
But this state is invisible to the client,
which would see itself merely as being in the Iconic state.
.LP
Newly created top-level windows are in the Withdrawn state.
Once the window has been provided with suitable properties,
the client is free to change its state as follows:
.bP
Withdrawn \(-> Normal \- The client should map the window with 
WM_HINTS.initial_state being 
.PN NormalState .
.bP
Withdrawn \(-> Iconic \- The client should map the window with 
WM_HINTS.initial_state being 
.PN IconicState .
.bP
Normal \(-> Iconic \- The client should send a
.PN ClientMessage
event as described later in this section.
.bP
Normal \(-> Withdrawn \- The client should unmap the window and follow it 
with a synthetic 
.PN UnmapNotify
event as described later in this section.
.bP
Iconic \(-> Normal \- The client should map the window.
The contents of WM_HINTS.initial_state are irrelevant in this case.
.bP
Iconic \(-> Withdrawn \- The client should unmap the window 
and follow it with a synthetic 
.PN UnmapNotify
event as described later in this section.
.LP
Only the client can effect a transition into or out of the Withdrawn
state.
Once a client's window
has left the Withdrawn state,
the window will be mapped if it is in the Normal state and the window will be
unmapped if it is in the Iconic state.  Reparenting window managers
must unmap the client's window when it is in the Iconic state, even if an
ancestor window being unmapped renders the client's window unviewable.
Conversely, if a reparenting window manager renders the client's window
unviewable by unmapping an ancestor, the client's window is by definition in
the Iconic state and must also be unmapped.
.NT "Advice to Implementors"
Clients can select for
.PN StructureNotify
on their
top-level windows to track transitions between Normal and Iconic states.
Receipt of a
.PN MapNotify
event will indicate a transition to the Normal state, and receipt of an
.PN UnmapNotify
event will indicate a transition to the Iconic state.
.NE
.LP
When changing the state of the window to Withdrawn, the client must (in
addition to unmapping the window) send a synthetic
.PN UnmapNotify
event by
using a
.PN SendEvent
request with the following arguments:
.br
.ne 6
.TS
l lw(3.5i).
_
.sp 6p
.B
Argument	Value
.sp 6p
_
.sp 6p
.R
destination:	The root
propagate:	T{
.PN False
T}
event-mask:	T{
.Pn ( SubstructureRedirect|SubstructureNotify )
T}
T{
event: an 
.PN UnmapNotify
with:
T}	T{
T}
\h'4n'event:	The root
\h'4n'window:	The window itself
\h'4n'from-configure:	T{
.PN False
T}
.sp 6p
_
.TE
.NT Rationale
The reason for requiring the client to send a synthetic
.PN UnmapNotify
event is to ensure that the window manager
gets some notification of the client's desire to change state,
even though the window may already be unmapped when the desire is expressed.
.NE
.NT "Advice to Implementors"
For compatibility with obsolete clients, 
window managers should trigger the transition to the Withdrawn state
on the real 
.PN UnmapNotify
rather than waiting for the synthetic one.
They should also trigger the transition if they receive a synthetic 
.PN UnmapNotify
on a window for which they have not yet received a real 
.PN UnmapNotify .
.NE
.LP
When a client withdraws a window,
the window manager will then update or remove the WM_STATE
property as described in section 4.1.3.1.
Clients that want to re-use a client window (e.g., by mapping it again or
reparenting it elsewhere) after withdrawing it must wait for the
withdrawal to be complete before proceeding.  The preferred method for
doing this is for clients to wait for the window manager to update or
remove the WM_STATE property.\**
.FS
Earlier versions of these conventions prohibited clients from
reading the WM_STATE property.  Clients operating under the earlier
conventions used the technique of tracking
.PN ReparentNotify
events to wait for the top-level window to be reparented back to the root
window.  This is still a valid technique; however, it works only for
reparenting window managers, and the WM_STATE technique is to be preferred.
.FE
.LP
If the transition is from the Normal to the Iconic state,
the client should send a 
.PN ClientMessage 
event to the root with:
.bP
Window == the window to be iconified
.bP
Type\** == the atom WM_CHANGE_STATE
.FS
The type field of the 
.PN ClientMessage 
event (called the message_type field by Xlib) should not be confused with
the code field of the event itself,
which will have the value 33 
.Pn ( ClientMessage ).
.FE
.bP
Format == 32
.bP
Data[0] == IconicState
.NT Rationale
The format of this 
.PN ClientMessage 
event does not match the format of 
.PN ClientMessages
in section 4.2.8.
This is because they are sent by the window manager to clients,
and this message is sent by clients to the window manager.
.NE
.LP
Other values of data[0] are reserved for future extensions to these
conventions.  The parameters of the 
.PN SendEvent 
request should be those described for the synthetic
.PN UnmapNotify
event.
.NT "Advice to Implementors"
Clients can also select for 
.PN VisibilityChange
events on their top-level or icon windows.
They will then receive a 
.PN VisibilityNotify (state==FullyObscured)
event when the window concerned becomes completely
obscured even though mapped (and thus, perhaps a waste
of time to update) and a 
.PN VisibilityNotify (state!=FullyObscured)
event when it becomes even partly viewable.
.NE
.NT "Advice to Implementors"
When a window makes a transition from the Normal state to either the Iconic
or the Withdrawn state, clients should be aware that the window manager
may make transients for this window inaccessible.  Clients should not rely
on transient windows being available to the user when the transient owner
window is not in the Normal state.  When withdrawing a window, clients are
advised to withdraw transients for the window.
.NE
.nH 3 "Configuring the Window"
.LP
Clients can resize and reposition their top-level windows by using the 
.PN ConfigureWindow 
request.
The attributes of the window that can be altered 
with this request are as follows:
.bP
The [x,y] location of the window's upper left-outer corner
.bP
The [width,height] of the inner region of the window (excluding
borders)
.bP
The border width of the window
.bP
The window's position in the stack
.LP
The coordinate system in which the location is expressed is that of the root
(irrespective of any reparenting that may have occurred).
The border width to be used and win_gravity position hint
to be used are those most recently requested by the client.
Client configure requests are interpreted by the window manager
in the same manner as the initial window geometry mapped from
the Withdrawn state, as described in section 4.1.2.3.
Clients must be aware that there is no guarantee that the window manager
will allocate them the requested size or location and must be prepared to
deal with any size and location.
If the window manager decides to respond to a 
.PN ConfigureRequest
request by:
.bP
Not changing the size, location, border width, or stacking order
of the window at all.
.IP
A client will receive a synthetic 
.PN ConfigureNotify
event that describes the (unchanged) geometry of the window.
The (x,y) coordinates will be in the root coordinate system,
adjusted for the border width the client requested,
irrespective of any reparenting that has taken place.
The border_width will be the border width the client requested.
The client will not receive a real
.PN ConfigureNotify
event because no change has actually taken place.
.bP
Moving or restacking the window without resizing it or
changing its border width.
.IP
A client will receive a synthetic 
.PN ConfigureNotify 
event following the change that describes the new geometry of the window.
The event's (x,y) coordinates will be in the root coordinate system adjusted 
for the border width the client requested.
The border_width will be the border width the client requested.
The client may not receive a real 
.PN ConfigureNotify
event that describes this change because the window manager may have reparented
the top-level window.
If the client does receive a real event,
the synthetic event will follow the real one.
.bP
Resizing the window or changing its border width (regardless of whether the
window was also moved or restacked).
.IP
A client that has selected for 
.PN StructureNotify
events will receive a real
.PN ConfigureNotify
event.
Note that the coordinates in this event are relative to the parent,
which may not be the root if the window has been reparented.
The coordinates will reflect the actual border width of the window
(which the window manager may have changed).
The 
.PN Translate\%Coordinates
request can be used to convert the coordinates if required.
.LP
The general rule is that coordinates in real 
.PN ConfigureNotify
events are in the parent's space; 
in synthetic events, they are in the root space.
.NT "Advice to Implementors"
Clients cannot distinguish between the case where a top-level window is
resized and moved from the case where the window is resized but not moved,
since a real
.PN ConfigureNotify
event will be received in both cases.  Clients that are concerned with
keeping track of the absolute position of a top-level window should keep a
piece of state indicating whether they are certain of its position.  Upon
receipt of a real
.PN ConfigureNotify
event on the top-level window, the client should note that the position is
unknown.  Upon receipt of a synthetic
.PN ConfigureNotify
event, the client should note the position as known, using the position in
this event.  If the client receives a
.PN KeyPress ,
.PN KeyRelease ,
.PN ButtonPress ,
.PN ButtonRelease ,
.PN MotionNotify ,
.PN EnterNotify ,
or
.PN LeaveNotify
event on the window (or on any descendant), the client can deduce the
top-level window's position from the difference between the (event-x,
event-y) and (root-x, root-y) coordinates in these events.  Only when the
position is unknown does the client need to use the
.PN Translate\%Coordinates
request to find the position of a top-level window.
.NE
.LP
Clients should be aware that their borders may not be visible.
Window managers are free to use reparenting techniques to
decorate client's top-level windows with borders containing
titles,  controls, and other details to maintain a consistent look-and-feel.
If they do,
they are likely to override the client's attempts to set the border width
and set it to zero.
Clients, therefore, should not depend on the top-level window's border 
being visible or use it to display any critical information.
Other window managers will allow the top-level windows border to
be visible.
.NT Convention
Clients should set the desired value of the border-width attribute on all 
.PN ConfigureWindow
requests to avoid a race condition.
.NE
.LP
Clients that change their position in the stack must be aware 
that they may have been reparented,
which means that windows that used to be siblings no longer are.
Using a nonsibling as the sibling parameter on a 
.PN ConfigureWindow 
request will cause an error.
.NT Convention
Clients that use a
.PN ConfigureWindow
request to request a change in their position in the stack 
should do so using 
.PN None
in the sibling field.
.NE
.LP
Clients that must position themselves in the stack relative to some
window that was originally a sibling must do the 
.PN ConfigureWindow
request (in case they are running under a nonreparenting window manager),
be prepared to deal with a resulting error,
and then follow with a synthetic 
.PN ConfigureRequest 
event by invoking a
.PN SendEvent
request with the following arguments:
.br
.ne 6
.TS
l lw(3.5i).
_
.sp 6p
.B
Argument	Value
.sp 6p
_
.sp 6p
.R
destination:	The root
propagate:	T{
.PN False
T}
event-mask:	T{
.Pn ( SubstructureRedirect|SubstructureNotify )
T}
T{
event: a 
.PN ConfigureRequest 
with:
T}	T{
T}
\h'4n'event:	The root
\h'4n'window:	The window itself
T{
\h'4n'\&.\^.\^.
T}	T{
Other parameters from the
.PN ConfigureWindow
request
T}
.sp 6p
_
.TE
.LP
Window managers are in any case free to position windows in the stack as
they see fit, and so clients should not rely on receiving the stacking
order they have requested.  Clients should ignore the above-sibling
field of both real and synthetic
.PN ConfigureNotify
events received on their top-level windows because this field may not
contain useful information.
.nH 3 "Changing Window Attributes"
.LP
The attributes that may be supplied when a window is created may be
changed by using the 
.PN ChangeWindowAttributes
request.
The window attributes are listed in the following table:
.br
.ne 6
.TS H
l l
l c.
_
.sp 6p
.B
Attribute	Private to Client
.sp 6p
_
.sp 6p
.TH
.R
Background pixmap	Yes
Background pixel	Yes
Border pixmap	Yes
Border pixel	Yes
Bit gravity	Yes
Window gravity	No
Backing-store hint	Yes
Save-under hint	No
Event mask	No
Do-not-propagate mask	Yes
Override-redirect flag	No
Colormap	Yes
Cursor	Yes
.sp 6p
_
.TE
.LP
Most attributes are private to the client and will never be interfered with
by the window manager.
For the attributes that are not private to the client:
.bP
The window manager is free to override the window gravity;
a reparenting window manager may want to set the top-level window's
window gravity for its own purposes.
.bP
Clients are free to set the save-under hint on their top-level windows,
but they must be aware that the hint may be overridden by the window manager.
.bP
Windows, in effect, have per-client event masks,
and so, clients may select for whatever events are convenient irrespective 
of any events the window manager is selecting for.
There are some events for which only one client at a time may select,
but the window manager should not select for them on any of the client's
windows.
.bP
Clients can set override-redirect on top-level windows but are
encouraged not to do so except as described in sections 4.1.10 and 4.2.9.
.nH 3 "Input Focus"
.LP
There are four models of input handling:
.bP
No Input \- The client never expects keyboard input.
An example would be 
.PN xload
or another output-only client.
.bP
Passive Input \- The client expects keyboard input but never explicitly sets 
the input focus.
An example would be a simple client with no subwindows,
which will accept input in 
.PN PointerRoot
mode or when the window manager sets the input focus to its top-level window 
(in click-to-type mode).
.bP
Locally Active Input \- The client expects keyboard input and explicitly sets 
the input focus, 
but it only does so when one of its windows already has the focus.
An example would be a client with subwindows defining various data
entry fields that uses Next and Prev keys to move the input focus
between the fields.
It does so when its top-level window has acquired the focus in 
.PN PointerRoot
mode or when the window manager sets the input focus to its top-level window 
(in click-to-type mode).
.bP
Globally Active Input \- The client expects keyboard input and explicitly sets 
the input focus, 
even when it is in windows the client does not own.
An example would be a client with a scroll bar that wants to allow
users to scroll the window without disturbing the input focus even if
it is in some other window.
It wants to acquire the input focus when the user clicks in the scrolled
region but not when the user clicks in the scroll bar itself.
Thus, it wants to prevent the window manager from setting the input focus 
to any of its windows.
.LP
The four input models and the corresponding values of the input field
and the presence or absence of the WM_TAKE_FOCUS atom in the
WM_PROTOCOLS property are listed in the following table:
.br
.ne 6
.TS H
l l l
l c c.
_
.sp 6p
.B
Input Model	Input Field	WM_TAKE_FOCUS
.sp 6p
_
.sp 6p
.TH
.R
T{
No Input
T}	T{
.PN False
T}	T{
Absent
T}
T{
Passive
T}	T{
.PN True
T}	T{
Absent
T}
T{
Locally Active
T}	T{
.PN True
T}	T{
Present
T}
T{
Globally Active
T}	T{
.PN False
T}	T{
Present
T}
.sp 6p
_
.TE
.LP
Passive and Locally Active clients set the input field of WM_HINTS to
.PN True ,
which indicates that they require window manager assistance  in acquiring the
input focus.
No Input and Globally Active clients set the input field to
.PN False ,
which requests that the window manager not set the input focus 
to their top-level window.
.LP
Clients that use a
.PN SetInputFocus
request must set the time field to the timestamp of the event 
that caused them to make the attempt.
This cannot be a 
.PN FocusIn
event because they do not have timestamps.
Clients may also acquire 
the focus without a corresponding 
.PN EnterNotify .
Note that clients must not use 
.PN CurrentTime 
in the time field.
.LP
Clients using the Globally Active model can only use a
.PN SetInputFocus
request to acquire the input focus when they do not already have it on
receipt of one of the following events:
.bP
.PN ButtonPress
.bP
.PN ButtonRelease
.bP
Passive-grabbed 
.PN KeyPress
.bP
Passive-grabbed
.PN KeyRelease
.LP
In general,
clients should avoid using passive-grabbed key events for this purpose,
except when they are unavoidable (as, for example, a selection tool 
that establishes a passive grab on the keys that cut,  copy,  or paste).
.LP
The method by which the user commands the window manager to
set the focus to a window is up to the window manager.
For example, 
clients cannot determine whether they will see the click 
that transfers the focus.
.LP
Windows with the atom WM_TAKE_FOCUS in their WM_PROTOCOLS property
may receive a 
.PN ClientMessage 
event from the window manager (as described in section 4.2.8)
with WM_TAKE_FOCUS in its data[0] field and a valid timestamp
(i.e., not
.PN CurrentTime )
in its data[1] field.
If they want the focus,
they should respond with a 
.PN SetInputFocus
request with its window field set to the window of theirs 
that last had the input focus or to their default input window,
and the time field set to the timestamp in the message.
For further information,
see section 4.2.7.
.LP
A client could receive WM_TAKE_FOCUS when opening from an icon
or when the user has clicked outside the top-level window in an area that
indicates to the window manager that it should assign the focus 
(for example, clicking in the headline bar can be used to assign the focus).
.LP
The goal is to support window managers that want to assign the input focus
to a top-level window in such a way that the top-level window either
can assign it to one of its subwindows or can decline the offer of the focus.
For example, a clock or a text editor with no currently open frames 
might not want to take focus even though the window manager generally 
believes that clients should take the input focus after being deiconified 
or raised.
.LP
Clients that set the input focus need to decide a value for the
revert-to field of the 
.PN SetInputFocus
request.
This determines the behavior of the input focus 
if the window the focus has been set to becomes not viewable.
The value can be any of the following:
.bP
.PN Parent
\- In general, 
clients should use this value when assigning focus to one of their subwindows.
Unmapping the subwindow will cause focus to revert to the parent,
which is probably what you want.
.bP
.PN PointerRoot 
\- Using
this value with a click-to-type focus management policy
leads to race conditions because the window becoming unviewable may
coincide with the window manager deciding to move the focus elsewhere.
.bP
.PN None 
\- Using
this value causes problems if the window manager reparents 
the window, as most window managers will, and then crashes.
The input focus will be 
.PN None , 
and there will probably be no way to change it.
.LP
Note that neither
.PN PointerRoot
nor
.PN None
is really safe to use.
.NT Convention
Clients that invoke a
.PN SetInputFocus 
request should set the revert-to argument to 
.PN Parent .
.NE
.LP
A convention is also required for clients that want to give up the
input focus.
There is no safe value set for them to set the input focus to;
therefore, they should ignore input material.
.NT Convention
Clients should not give up the input focus of their own volition.
They should ignore input that they receive instead.
.NE
.nH 3 "Colormaps"
.LP
The window manager is responsible for installing and uninstalling 
colormaps on behalf of clients with top-level windows that
the window manager manages.
.LP
Clients provide the window manager with hints as to which colormaps to
install and uninstall.  Clients must not install or uninstall colormaps
themselves (except under the circumstances noted below).  When a client's
top-level window gets the colormap focus (as a result of whatever colormap
focus policy is implemented by the window manager), the window manager will
ensure that one or more of the client's colormaps are installed.
.LP
Clients whose top-level windows and subwindows all use the same colormap
should set its ID in the colormap field of the top-level window's
attributes.  They should not set a WM_COLORMAP_WINDOWS property on the
top-level window.  If they want to change the colormap, they should change
the top-level window's colormap attribute.  The window manager will track
changes to the window's colormap attribute and install colormaps as
appropriate.
.LP
Clients that create windows can use the value 
.PN CopyFrom\%Parent
to inherit their parent's colormap.  Window managers will ensure that the
root window's colormap field contains a colormap that is suitable for
clients to inherit.  In particular, the colormap will provide
distinguishable colors for
.PN BlackPixel 
and 
.PN WhitePixel .
.LP
Top-level windows that have subwindows or override-redirect pop-up windows
whose colormap requirements differ from the top-level window should have a
WM_COLORMAP_WINDOWS property.  This property contains a list of IDs for
windows whose colormaps the window manager should attempt to have installed
when, in the course of its individual colormap focus policy, it assigns the
colormap focus to the top-level window (see section 4.1.2.8).  The list is
ordered by the importance to the client of having the colormaps installed.
The window manager will track changes to this property and will track
changes to the colormap attribute of the windows in the property.
.LP
If the relative importance of colormaps changes, the client should update
the WM_COLORMAP_WINDOWS property to reflect the new ordering.  If the
top-level window does not appear in the list, the window manager will assume
it to be of higher priority than any window in the list.
.LP
WM_TRANSIENT_FOR windows can either have their own WM_COLORMAP_WINDOWS
property or appear in the property of the window they are transient for,
as appropriate.
.NT Rationale
An alternative design was considered for how clients should hint to the
window manager about their colormap requirements.  This alternative design
specified a list of colormaps instead of a list of windows.  The current
design, a list of windows, was chosen for two reasons.  First, it allows
window managers to find the visuals of the colormaps, thus permitting
visual-dependent colormap installation policies.  Second, it allows window
managers to select for
.PN Visibility\%Change
events on the windows concerned and to ensure that colormaps are only
installed if the windows that need them are visible.  The alternative design
allows for neither of these policies.
.NE
.NT "Advice to Implementors"
Clients should be aware of the min-installed-maps and max-installed-maps
fields of the connection setup information, and the effect that the minimum
value has on the \*Qrequired list\*U defined by the Protocol in the
description of the
.PN Install\%Colormap
request.  Briefly, the min-installed-maps most recently installed maps are
guaranteed to be installed.  This value is often one; clients needing
multiple colormaps should beware.
.NE
.LP
Whenever possible, clients should use the mechanisms described above and let
the window manager handle colormap installation.  However, clients are
permitted to perform colormap installation on their own while they have the
pointer grabbed.  A client performing colormap installation must notify the
window manager prior to the first installation.  When the client has
finished its colormap installation, it must also notify the window manager.
The client notifies the window manager by issuing a
.PN Send\%Event
request with the following arguments:
.br
.LP
.ne 6
.TS
tab(/) ;
lB lB
l lw(3.5i)
.
_
.sp 6p
Argument/Value
.sp 6p
_
destination:/T{
the root window of the screen on
which the colormap is being installed
T}
propagate:/T{
.PN False
T}
event-mask:/T{
.PN ColormapChange
T}
T{
event: a
.PN ClientMessage
with:
T}
\h'2m'window:/the root window, as above
\h'2m'type:/WM_COLORMAP_NOTIFY
\h'2m'format:/32
\h'2m'data[0]:/T{
the timestamp of the event that caused
the client to start or stop installing colormaps
T}
\h'2m'data[1]:/T{
1 if the client is starting colormap installation, 0 if the client is
finished with colormap installation
T}
\h'2m'data[2]:/reserved, must be zero
\h'2m'data[3]:/reserved, must be zero
\h'2m'data[4]:/reserved, must be zero
.sp 6p
_
.TE
.LP
This feature was introduced in version 2.0 of this document, and there will
be a significant period of time before all window managers can be expected
to implement this feature.  Before using this feature, clients must check
the compliance level of the window manager (using the mechanism described in
section 4.3) to verify that it supports this feature.  This is necessary to
prevent colormap installation conflicts between clients and older window
managers.
.LP
Window managers should refrain from installing colormaps while a client has
requested control of colormap installation.  The window manager should
continue to track the set of installed colormaps so that it can reinstate
its colormap focus policy when the client has finished colormap installation.
.LP
This technique has race conditions that may result in the colormaps
continuing to be installed even after a client has issued its notification
message.  For example, the window manager may have issued some
.PN Install\%Colormap
requests that are not executed until after the
client's 
.PN SendEvent \%
and
.PN Install\%Colormap
requests, thus uninstalling the client's colormaps.  If this occurs while
the client still has the pointer grabbed and before the client has issued
the \*Qfinished\*U message, the client may reinstall the desired colormaps.
.NT "Advice to Implementors"
Clients are expected to use this mechanism for things such as
pop-up windows and for animations that use override-redirect windows.
.\" Avoid .LP within a .NT, because it resets the margins.  The .NT
.\" macro should probably be fixed.
.br
.sp \n(PDu
If a client fails to issue the \*Qfinished\*U message, the window manager
may be left in a state where its colormap installation policy is suspended.
Window manager implementors may want to implement a feature that resets
colormap installation policy in response to a command from the user.
.NE
.nH 3 "Icons"
.LP
A client can hint to the window manager about the desired appearance 
of its icon by setting:
.bP
A string in WM_ICON_NAME.
.IP
All clients should do this  
because it provides a fallback for window managers whose ideas 
about icons differ widely from those of the client.
.bP
A 
.PN Pixmap 
into the icon_pixmap field of the WM_HINTS property
and possibly another into the icon_mask field.
.IP
The window manager is expected to display the pixmap masked by the mask.
The pixmap should be one of the sizes found in the WM_ICON_SIZE property
on the root.
If this property is not found,
the window manager is unlikely to display icon pixmaps.
Window managers usually will clip or tile pixmaps that do not match
WM_ICON_SIZE.
.bP
A window into the icon_window field of the WM_HINTS property.
.IP
The window manager is expected to map that window whenever the client is
in the Iconic state.
In general,
the size of the icon window should be one of those specified in WM_ICON_SIZE 
on the root, if it exists.
Window managers are free to resize icon windows.
.LP
In the Iconic state,
the window manager usually will ensure that:
.bP
If the window's WM_HINTS.icon_window is set,
the window it names is visible.
.bP
If the window's WM_HINTS.icon_window is not set
but the window's WM_HINTS.icon_pixmap is set,
the pixmap it names is visible.
.bP
Otherwise,
the window's WM_ICON_NAME string is visible.
.LP
Clients should observe the following conventions about their icon windows:
.NT Conventions
.IP 1. 5
The icon window should be an 
.PN InputOutput
child of the root.
.IP 2. 5
The icon window should be one of the sizes specified 
in the WM_ICON_SIZE property on the root.
.IP 3. 5
The icon window should use the root visual and default colormap 
for the screen in question.
.IP 4. 5
Clients should not map their icon windows.
.IP 5. 5
Clients should not unmap their icon windows.
.IP 6. 5
Clients should not configure their icon windows.
.IP 7. 5
Clients should not set override-redirect on their icon windows
or select for 
.PN Resize\%Redirect 
events on them.
.IP 8. 5
Clients must not depend on being able to receive input events
by means of their icon windows.
.IP 9. 5
Clients must not manipulate the borders of their icon windows.
.IP 10. 5
Clients must select for 
.PN Exposure
events on their icon window and repaint it when requested.
.NE
.LP
Window managers will differ as to whether they support input events
to client's icon windows;
most will allow the client to receive some subset of the keys and buttons.
.LP
Window managers will ignore any WM_NAME, WM_ICON_NAME, WM_NORMAL_HINTS,
WM_HINTS, WM_CLASS, WM_TRANSIENT_FOR, WM_PROTOCOLS, WM_COLORMAP_WINDOWS,
WM_COMMAND, or WM_CLIENT_MACHINE
properties they find on icon windows.
.nH 3 "Pop-up Windows"
.LP
Clients that wish to pop up a window can do one of three things:
.IP 1. 5
They can create and map another normal top-level window,
which will get decorated and managed as normal by the window manager.
See the discussion of window groups that follows.
.IP 2. 5
If the window will be visible for a relatively short time
and deserves a somewhat lighter treatment,
they can set the WM_TRANSIENT_FOR property.
They can expect less decoration but can set all the normal
window manager properties on the window.
An example would be a dialog box.
.IP 3. 5
If the window will be visible for a very short time
and should not be decorated at all,
the client can set override-redirect on the window.
In general,
this should be done only if the pointer is grabbed while the window is mapped.
The window manager will never interfere with these windows,
which should be used with caution.
An example of an appropriate use is a pop-up menu.
.NT "Advice to Implementors"
The user will not be able to move, resize, restack, or transfer the input
focus to override-redirect windows, since the window manager is not managing
them.  If it is necessary for a client to receive keystrokes on an
override-redirect window, either the client must grab the keyboard or the
client must have another top-level window that is not override-redirect and
that has selected the Locally Active or Globally Active focus model.  The
client may set the focus to the override-redirect window when the other
window receives a WM_TAKE_FOCUS message or one of the events listed in
section 4.1.7 in the description of the Globally Active focus model.
.NE
.LP
Window managers are free to decide if WM_TRANSIENT_FOR windows
should be iconified when the window they are transient for is.
Clients displaying WM_TRANSIENT_FOR windows that have 
(or request to have) the window they are transient for iconified
do not need to request that the same operation be performed
on the WM_TRANSIENT_FOR window;
the window manager will change its state if that is the policy it wishes 
to enforce.
.nH 3 "Window Groups"
.LP
A set of top-level windows that should be treated from the user's point of view
as related (even though they may belong to a number of clients) should be linked
together using the window_group field of the WM_HINTS structure.
.LP
One of the windows (that is, the one the others point to) 
will be the group leader and will carry the group as opposed 
to the individual properties.
Window managers may treat the group leader differently 
from other windows in the group.
For example,
group leaders may have the full set of decorations,
and other group members may have a restricted set.
.LP
It is not necessary that the client ever map the group leader;
it may be a window that exists solely as a placeholder.
.LP
It is up to the window manager to determine the policy 
for treating the windows in a group.
At present, 
there is no way for a client to request a group, 
as opposed to an individual, operation.
.nH 2 "Client Responses to Window Manager Actions"
.LP
The window manager performs a number of operations on client resources,
primarily on their top-level windows.
Clients must not try to fight this but may elect to receive notification 
of the window manager's operations.
.nH 3 "Reparenting"
.LP
Clients must be aware that some window managers will reparent 
their top-level windows
so that a window that was created as a child of the root will be displayed 
as a child of some window belonging to the window manager.
The effects that this reparenting will have on the client are as follows:
.bP
The parent value returned by a 
.PN QueryTree
request will no longer be the value supplied to the 
.PN CreateWindow 
request that created the reparented window.
There should be no need for the client to be aware of the identity 
of the window to which the top-level window has been reparented.
In particular,
a client that wishes to create further top-level windows should continue 
to use the root as the parent for these new windows.
.bP
The server will interpret the (x,y) coordinates in a 
.PN ConfigureWindow
request in the new parent's coordinate space.
In fact, they usually will not be interpreted by the server
because a reparenting window manager usually will have intercepted
these operations (see section 4.2.2).
Clients should use the root coordinate space for these requests
(see section 4.1.5).
.bP
.PN ConfigureWindow
requests that name a specific sibling window may fail because the window named,
which used to be a sibling, no longer is after the reparenting operation
(see section 4.1.5).
.bP
The (x,y) coordinates returned by a 
.PN GetGeometry
request are in the parent's coordinate space 
and are thus not directly useful after a reparent operation.
.bP
A background of 
.PN ParentRelative
will have unpredictable results.
.bP
A cursor of 
.PN None
will have unpredictable results.
.LP
Clients that want to be notified when they are reparented can select for
.PN StructureNotify
events on their top-level window.
They will receive a 
.PN ReparentNotify
event if and when reparenting takes place.
When a client withdraws a top-level window, the window manager will
reparent it back to the root window if the window had been reparented
elsewhere.
.LP
If the window manager reparents a client's window,
the reparented window will be placed in the save-set 
of the parent window.
This means that the reparented window will not be destroyed 
if the window manager terminates and will be remapped if it was unmapped.
Note that this applies to all client windows the window manager reparents,
including transient windows and client icon windows.
.nH 3 "Redirection of Operations"
.LP
Clients must be aware that some window managers will arrange 
for some client requests to be intercepted and redirected.
Redirected requests are not executed; 
they result instead in events being sent to the window manager,
which may decide to do nothing, to alter the arguments, 
or to perform the request on behalf of the client.
.LP
The possibility that a request may be redirected means 
that a client cannot assume that any redirectable request is actually
performed when the request is issued or is actually performed at all.
The requests that may be redirected are
.PN \%MapWindow ,
.PN Configure\%Window ,
and
.PN Circulate\%Window .
.NT "Advice to Implementors"
The following is incorrect because the 
.PN MapWindow
request may be intercepted and the
.PN PolyLine
output made to an unmapped window:
.LP
.DS
MapWindow A
PolyLine A GC <point> <point> .\^.\^.
.DE
.LP
The client must wait for an 
.PN Expose
event before drawing in the window.\**
.FS
This is true even if the client set the backing-store attribute to 
.PN Always .
The backing-store attribute is a only a hint, 
and the server may stop maintaining backing store contents at any time.
.FE
.LP
This next example incorrectly assumes that the 
.PN ConfigureWindow
request is actually executed with the arguments supplied:
.LP
.DS
ConfigureWindow width=N height=M
<output assuming window is N by M>
.DE
.LP
The client should select for
.PN Structure\%Notify
on its window and monitor the window's size by tracking
.PN Configure\%Notify
events.
.LP
Clients must be especially careful when attempting to set the focus to a
window that they have just mapped.  This sequence may result in an X
protocol error:
.LP
.DS
MapWindow B
SetInputFocus B
.DE
.LP
If the
.PN Map\%Window
request has been intercepted, the window will still be
unmapped, causing the
.PN SetInput\%Focus
request to generate the error.  The solution to this problem is for clients
to select for
.PN Visibility\%Change
on the window and to delay the issuance of the
.PN SetInput\%Focus
request until they have received a 
.PN Visibility\%Notify
event indicating that the window is visible.
.LP
This technique does not guarantee correct operation.  The user may have
iconified the window by the time the
.PN SetInput\%Focus
request reaches the server, still causing an error.  Or the window manager
may decide to map the window into Iconic state, in which case the window
will not be visible.  This will delay the generation of the
.PN Visibility\%Notify
event indefinitely.  Clients must be prepared to handle these cases.
.NE
.LP
A window with the override-redirect bit set is immune from redirection,
but the bit should be set on top-level windows only in cases 
where other windows should be prevented from processing input
while the override-redirect window is mapped (see section 4.1.10)
and while responding to 
.PN ResizeRequest
events (see section 4.2.9).
.LP
Clients that have no non-Withdrawn top-level windows 
and that map an override-redirect top-level window are taking over total
responsibility for the state of the system.
It is their responsibility to:
.bP
Prevent any preexisting window manager from interfering with their activities
.bP
Restore the status quo exactly after they unmap the window
so that any preexisting window manager does not get confused
.LP
In effect,  clients of this kind are acting as temporary window managers.
Doing so is strongly discouraged because these clients will be unaware
of the user interface policies the window manager is trying to maintain
and because their user interface behavior is likely to conflict with that of
less demanding clients.
.nH 3 "Window Move"
.LP
If the window manager moves a top-level window without changing its size,
the client will receive a synthetic 
.PN ConfigureNotify
event following the move that describes the new location
in terms of the root coordinate space.
Clients must not respond to being moved by attempting to move
themselves to a better location.
.LP
Any real 
.PN ConfigureNotify
event on a top-level window implies that the window's position 
on the root may have changed,
even though the event reports that the window's position 
in its parent is unchanged because the window may have been reparented.
Note that the coordinates in the event will not, in this case,
be directly useful.
.LP
The window manager will send these events by using a
.PN SendEvent
request with the following arguments:
.br
.ne 6
.TS
l l.
_
.sp 6p
.B
Argument	Value
.sp 6p
_
.sp 6p
.R
destination:	The client's window
propagate:	T{
.PN False
T}
event-mask:	T{
.PN StructureNotify
T}
.sp 6p
_
.TE
.nH 3 "Window Resize"
.LP
The client can elect to receive notification of being resized by selecting for
.PN StructureNotify
events on its top-level windows.
It will receive a 
.PN ConfigureNotify
event.
The size information in the event will be correct,
but the location will be in the parent window (which may not be the root).
.LP
The response of the client to being resized should be to accept
the size it has been given and to do its best with it.
Clients must not respond to being resized by attempting to resize
themselves to a better size.
If the size is impossible to work with,
clients are free to request to change to the Iconic state.
.nH 3 "Iconify and Deiconify"
.LP
A top-level window that is not Withdrawn will be 
in the Normal state if it is mapped and in the Iconic state if it is unmapped.
This will be true even if the window has been reparented;
the window manager will unmap the window as well as its parent
when switching to the Iconic state.
.LP
The client can elect to be notified of these state changes by selecting for 
.PN StructureNotify 
events on the top-level window.
It will receive a
.PN UnmapNotify
event when it goes Iconic and a
.PN MapNotify
event when it goes Normal.
.nH 3 "Colormap Change"
.LP
Clients that wish to be notified of their colormaps being installed
or uninstalled should select for 
.PN ColormapNotify
events on their top-level windows and on any windows they have named 
in WM_COLORMAP_WINDOWS properties on their top-level windows.
They will receive 
.PN ColormapNotify
events with the new field FALSE when the colormap for that window 
is installed or uninstalled.
.nH 3 "Input Focus"
.LP
Clients can request notification that they have the input focus by selecting
for 
.PN FocusChange
events on their top-level windows;
they will receive 
.PN FocusIn 
and 
.PN FocusOut
events.
Clients that need to set the input focus to one of their
subwindows should not do so unless
they have set WM_TAKE_FOCUS in their WM_PROTOCOLS property 
and have done one of the following:
.bP
Set the input field of WM_HINTS to 
.PN True
and actually have the input focus in one of their top-level windows
.bP
Set the input field of WM_HINTS to 
.PN False
and have received a suitable event as described in section 4.1.7
.bP
Have received a WM_TAKE_FOCUS message as described in section 4.1.7
.LP
Clients should not warp the pointer in an attempt to transfer the focus;
they should set the focus and leave the pointer alone.
For further information,
see section 6.2.
.LP
Once a client satisfies these conditions,
it may transfer the focus to another of its windows by using the 
.PN SetInputFocus
request, which is defined as follows:
.LP
.sM
.IN "SetInputFocus" "" "@DEF@"
.PN SetInputFocus
.IP "" .2i
\fIfocus\fP\^: WINDOW or
.PN PointerRoot
or
.PN None
.br
\fIrevert-to\fP\^:
.Pn { Parent ,
.PN PointerRoot ,
.PN None }
.br
\fItime\fP\^: TIMESTAMP or
.PN CurrentTime
.LP
.eM
.NT Conventions
.IP 1. 5
Clients that use a  
.PN SetInputFocus
request must set the time argument to the timestamp of the event 
that caused them to make the attempt.
This cannot be a 
.PN FocusIn
event because they do not have timestamps.
Clients may also acquire the focus without a corresponding 
.PN EnterNotify 
event.
Clients must not use 
.PN CurrentTime
for the time argument.
.IP 2. 5
Clients that use a  
.PN SetInputFocus
request to set the focus to one of their windows must set 
the revert-to field to 
.PN Parent .
.NE
.nH 3 "ClientMessage Events"
.LP
There is no way for clients to prevent themselves being sent
.PN ClientMessage
events.
.LP
Top-level windows with a WM_PROTOCOLS property may be sent 
.PN ClientMessage
events specific to the protocols named by the atoms in the property 
(see section 4.1.2.7).
For all protocols, the 
.PN ClientMessage
events have the following:
.bP
WM_PROTOCOLS as the type field
.bP
Format 32
.bP
The atom that names their protocol in the data[0] field
.bP
A timestamp in their data[1] field
.LP
The remaining fields of the event,
including the window field,
are determined by the protocol.
.LP
These events will be sent by using a
.PN SendEvent
request with the following arguments:
.br
.ne 6
.TS
l l.
_
.sp 6p
.B
Argument	Value
.sp 6p
_
.sp 6p
.R
destination:	The client's window
propagate:	T{
.PN False
T}
event-mask:	() empty
event:	As specified by the protocol
.sp 6p
_
.TE
.nH 4 "Window Deletion"
.LP
Clients, usually those with multiple top-level windows, whose server
connection must survive the deletion of some of their top-level windows,
should include the atom WM_DELETE_WINDOW in the WM_PROTOCOLS property on
each such window.  They will receive a
.PN ClientMessage 
event as described above whose data[0] field is WM_DELETE_WINDOW.
.LP
Clients receiving a WM_DELETE_WINDOW message should behave as if the user
selected \*Qdelete window\*U from a hypothetical menu.
They should perform any confirmation dialog with the user
and, if they decide to complete the deletion, should do the following:
.bP
Either change the window's state to Withdrawn (as described in section 4.1.4)
or destroy the window.
.bP
Destroy any internal state associated with the window.
.LP
If the user aborts the deletion during the confirmation dialog,
the client should ignore the message.
.LP
Clients are permitted to interact with the user and ask, for example,
whether a file associated with the window to be deleted should be saved
or the window deletion should be cancelled.
Clients are not required to destroy the window itself;
the resource may be reused,
but all associated state (for example, backing store) should be released.
.LP
If the client aborts a destroy and the user then selects DELETE WINDOW again,
the window manager should start the WM_DELETE_WINDOW protocol again.
Window managers should not use 
.PN DestroyWindow
requests on a window that has WM_DELETE_WINDOW in its WM_PROTOCOLS property.
.LP
Clients that choose not to include WM_DELETE_WINDOW in the WM_PROTOCOLS
property may be disconnected from the server
if the user asks for one of the client's top-level windows to be deleted.
.nH 3 "Redirecting Requests"
.LP
Normal clients can use the redirection mechanism just as window managers do
by selecting for 
.PN SubstructureRedirect
events on a parent window or 
.PN ResizeRedirect
events on a window itself.
However, at most,
one client per window can select for these events,
and a convention is needed to avoid clashes.
.NT Convention
Clients (including window managers) should select for 
.PN SubstructureRedirect
and
.PN ResizeRedirect
events only on windows that they own.
.NE
.LP
In particular, 
clients that need to take some special action if they are resized can select
for 
.PN Resize\%Redirect
events on their top-level windows.
They will receive a
.PN ResizeRequest
event if the window manager resizes their window,
and the resize will not actually take place.
Clients are free to make what use they like of the information
that the window manager wants to change their size,
but they must configure the window to the width and height specified 
in the event in a timely fashion.
To ensure that the resize will actually happen at this stage
instead of being intercepted and executed by the window manager
(and thus restarting the process),
the client needs temporarily to set override-redirect on the window.
.NT Convention
Clients receiving 
.PN ResizeRequest
events must respond by doing the following:
.bP
Setting override-redirect on the window specified in the event
.bP
Configuring the window specified in the event 
to the width and height specified in the event as soon as possible 
and before making any other geometry requests
.bP
Clearing override-redirect on the window specified in the event
.NE
.LP
If a window manager detects that a client is not obeying this convention,
it is free to take whatever measures it deems appropriate to deal with
the client.
.nH 2 "Communication with the Window Manager by Means of Selections"
.LP
For each screen they manage, window managers will acquire ownership of a
selection named WM_S\fIn\fP, where \fIn\fP is the screen number, as
described in section 1.2.6.  Window managers should comply with the
conventions for \*QManager Selections\*U described in section 2.8.  The
intent is for clients to be able to request a variety of information or
services by issuing conversion requests on this selection.  Window managers
should support conversion of the following target on their manager
selection:
.LP
.br
.ne 8
.TS
l l lw(3.5i) .
_
.sp 6p
.B
Atom	Type	Data Received
.R
.sp 6p
_
.sp 6p
VERSION	INTEGER	T{
Two integers, which are the major and minor
release numbers (respectively) of the ICCCM
with which the window manager complies.  For
this version of the ICCCM, the numbers are
2 and 0.\**
T}
.sp 6p
_
.TE
.FS
As a special case, clients not wishing to implement a selection
request may simply issue a
.PN GetSelectionOwner
request on the appropriate WM_S\fIn\fP selection.  If this selection is owned,
clients may assume that the window manager complies with ICCCM version 2.0
or later.
.FE
.nH 2 "Summary of Window Manager Property Types"
.LP
The window manager properties are summarized in the following table
(see also section 14.1 of \fIXlib \- C Language X Interface\fP).
.br
.ne 6
.TS H
l l n c.
_
.sp 6p
.B
Name	Type	Format	See Section
.sp 6p
_
.sp 6p
.TH
.R
WM_CLASS	STRING	8	4.1.2.5
WM_CLIENT_MACHINE	TEXT	\&	4.1.2.9
WM_COLORMAP_WINDOWS	WINDOW	32	4.1.2.8
WM_HINTS	WM_HINTS	32	4.1.2.4
WM_ICON_NAME	TEXT		4.1.2.2
WM_ICON_SIZE	WM_ICON_SIZE	32	4.1.3.2
WM_NAME	TEXT		4.1.2.1
WM_NORMAL_HINTS	WM_SIZE_HINTS	32	4.1.2.3
WM_PROTOCOLS	ATOM	32	4.1.2.7
WM_STATE	WM_STATE	32	4.1.3.1
WM_TRANSIENT_FOR	WINDOW	32	4.1.2.6
.sp 6p
_
.TE
.nH 1 "Session Management and Additional Inter-Client Exchanges"
.LP
This section contains some conventions for clients that participate in
session management.  See
.I
X Session Management Protocol
.R
for further details.  Clients that do not support this protocol cannot
expect their window state (e.g., WM_STATE, position, size, and stacking order)
to be preserved across sessions.
.nH 2 "Client Support for Session Management"
.LP
Each session participant will obtain a unique client identifier (client-ID)
from the session manager.  The client must identify one top-level window as
the \*Qclient leader.\*U This window must be created by the client.  It may
be in any state, including the Withdrawn state.  The client leader window
must have a SM_CLIENT_ID property, which contains the client-ID obtained
from the session management protocol.  That property must:
.bP
Be of type STRING
.bP
Be of format 8
.bP
Contain the client-ID as a string of XPCS characters encoded using ISO
8859-1
.LP
All top-level, nontransient windows created by a client on the same display
as the client leader must have a WM_CLIENT_LEADER property. This property
contains a window ID that identifies the client leader window.  The client
leader window must have a WM_CLIENT_LEADER property containing its own
window ID (i.e., the client leader window is pointing to itself).  Transient
windows need not have a WM_CLIENT_LEADER property if the client leader can
be determined using the information in the WM_TRANSIENT_FOR property.  The
WM_CLIENT_LEADER property must:
.bP
Be of type WINDOW
.bP
Be of format 32
.bP
Contain the window ID of the client leader window
.LP
A client must withdraw all of its top-level windows on the same display
before modifiying either the WM_CLIENT_LEADER or the SM_CLIENT_ID property
of its client leader window.
.LP
It is necessary that other clients be able to uniquely identify a window
(across sessions) among all windows related to the same client-ID.  For
example, a window manager can require this unique ID to restore geometry
information from a previous session, or a workspace manager could use it to
restore information about which windows are in which workspace.  A client
may optionally provide a WM_WINDOW_ROLE property to uniquely identify a
window within the scope specified above.  The combination of SM_CLIENT_ID
and WM_WINDOW_ROLE can be used by other clients to uniquely identify a
window across sessions.
.LP
If the WM_WINDOW_ROLE property is not specified on a top-level window, a
client that needs to uniquely identify that window will try to use instead
the values of WM_CLASS and WM_NAME.  If a client has multiple windows with
identical WM_CLASS and WM_NAME properties, then it should provide a
WM_WINDOW_ROLE property.
.LP
The client must set the WM_WINDOW_ROLE property to a string that uniquely
identifies that window among all windows that have the same client leader
window.  The property must:
.bP
Be of type STRING
.bP
Be of format 8
.bP
Contain a string restricted to the XPCS characters, encoded in ISO 8859-1
.nH 2 "Window Manager Support for Session Management"
.LP
A window manager supporting session management must register with the
session manager and obtain its own client-ID.  The window manager should
save and restore information such as the WM_STATE, the layout of windows on
the screen, and their stacking order for every client window that has a
valid SM_CLIENT_ID property (on itself, or on the window named by
WM_CLIENT_LEADER) and that can be uniquely identified.
Clients are allowed to change this state during the first phase of the
session checkpoint process.  Therefore, window managers should request a
second checkpoint phase and save clients' state only during that phase.
.nH 2 "Support for ICE Client Rendezvous"
.IN "ICE Rendezvous"
.LP
The Inter-Client Exchange protocol (ICE) defined as of X11R6 
specifies a generic communication framework, independent of the X
server, for data exchange between arbitrary clients.  ICE also defines 
a protocol for any two ICE clients who also have X connections 
to the same X server to locate (rendezvous with) each other.  
.LP
This protocol, called the "ICE X Rendezvous" protocol, is defined in
the ICE specification, Appendix B,
and uses the property ICE_PROTOCOLS plus
.PN ClientMessage
events.  Refer to that specification for complete details.
.nH 1 "Manipulation of Shared Resources"
.LP
X Version 11 permits clients to manipulate a number of shared resources,
for example, the input focus, the pointer, and colormaps.
Conventions are required so that clients share resources in an
orderly fashion.
.nH 2 "The Input Focus"
.LP
Clients that explicitly set the input focus must observe one of two modes:
.bP
Locally active mode
.bP
Globally active mode
.NT Conventions
.IP 1. 5
Locally active clients should set the input focus to one of their windows 
only when it is already in one of their windows
or when they receive a WM_TAKE_FOCUS message.
They should set the input field of the WM_HINTS structure to
.PN True .
.IP 2. 5
Globally active clients should set the input focus to one of their windows 
only when they receive a button event and a passive-grabbed key event,
or when they receive a WM_TAKE_FOCUS message.
They should set the input field of the WM_HINTS structure to
.PN False .
.IP 3. 5
In addition, clients should use the timestamp of the event 
that caused them to attempt to set the input focus as the time field on the 
.PN SetInputFocus
request, not
.PN CurrentTime .
.NE
.nH 2 "The Pointer"
.LP
In general, clients should not warp the pointer.
Window managers, however, may do so
(for example, to maintain the invariant that the pointer is always
in the window with the input focus).
Other window managers may want to preserve the illusion that the user
is in sole control of the pointer.
.NT Conventions
.IP 1. 5
Clients should not warp the pointer.
.IP 2. 5
Clients that insist on warping the pointer should do so only
with the src-window argument of the 
.PN WarpPointer 
request set to one of their windows.
.NE
.nH 2 "Grabs"
.LP
A client's attempt to establish a button or a key grab on a window
will fail if some other client has already established a conflicting
grab on the same window.
The grabs, therefore, are shared resources,
and their use requires conventions.
.LP
In conformance with the principle that clients should behave,
as far as possible,
when a window manager is running as they would when it is not,
a client that has the input focus may assume that it can receive all 
the available keys and buttons.
.NT Convention
Window managers should ensure that they provide some mechanism for
their clients to receive events from all keys and all buttons,
except for events involving keys whose KeySyms are registered as being for
window management functions (for example, a hypothetical WINDOW KeySym).
.NE
.LP
In other words,
window managers must provide some mechanism by which a client
can receive events from every key and button (regardless of modifiers)
unless and until the X Consortium registers some KeySyms as being reserved 
for window management functions.
Currently, no KeySyms are registered for window management functions.
.LP
Even so, clients are advised to allow the key and button combinations
used to elicit program actions to be modified,
because some window managers may choose not to observe this convention
or may not provide a convenient method for the user to transmit events
from some keys.
.NT Convention
Clients should establish button and key grabs only on windows that
they own.
.NE
.LP
In particular, this convention means that a window manager that wishes 
to establish a grab over the client's top-level window should either establish 
the grab on the root or reparent the window and establish the grab 
on a proper ancestor.
In some cases,
a window manager may want to consume the event received,
placing the window in a state where a subsequent such event will go to
the client.
Examples are:
.bP
Clicking in a window to set focus with the click not being offered 
to the client
.bP
Clicking in a buried window to raise it, again, with the click not offered 
to the client
.LP
More typically,
a window manager should add to, rather than replace, the client's semantics 
for key+button combinations by allowing the event to be used by the client 
after the window manager is done with it.
To ensure this,
the window manager should establish the grab on the parent 
by using the following:
.LP
.Ds
pointer/keyboard-mode == Synchronous
.De
.LP
Then, the window manager should release the grab by using an
.PN AllowEvents 
request with the following specified:
.LP
.Ds
mode == ReplayPointer/Keyboard
.De
.LP
In this way,
the client will receive the events as if they had not been intercepted.
.LP
Obviously,
these conventions place some constraints on possible user interface policies.
There is a trade-off here between freedom for window managers to implement
their user interface policies and freedom for clients to implement theirs.
The dilemma is resolved by:
.bP
Allowing window managers to decide if and when a client will receive an
event from any given key or button
.bP
Placing a requirement on the window manager to provide some mechanism,
perhaps a \*QQuote\*U key,
by which the user can send an event from any key or button to the client
.nH 2 "Colormaps"
.LP
Section 4.1.8 prescribes conventions for clients to communicate with the
window manager about their colormap needs.  If your clients are
.PN DirectColor
type applications,
you should consult section 14.3 of \fIXlib \- C Language X Interface\fP
for conventions connected with sharing standard colormaps.
They should look for and create the properties described there on
the root window of the appropriate screen.
.LP
The contents of the RGB_COLOR_MAP type property are as follows:
.br
.ne 6
.TS H
l l l.
_
.sp 6p
.B
Field	Type	Comments
.sp 6p
_
.sp 6p
.TH
.R
colormap	COLORMAP	ID of the colormap described
red_max	CARD32	Values for pixel calculations
red_mult	CARD32
green_max	CARD32
green_mult	CARD32
blue_max	CARD32
blue_mult	CARD32
base_pixel	CARD32
visual_id	VISUALID	Visual to which colormap belongs
kill_id	CARD32	ID for destroying the resources
.sp 6p
_
.TE
.LP
When deleting or replacing an RGB_COLOR_MAP,
it is not sufficient to delete the property;
it is important to free the associated colormap resources as well.
If kill_id is greater than one,
the resources should be freed by issuing a 
.PN KillClient
request with kill_id as the argument.
If kill_id is one,
the resources should be freed by issuing a
.PN FreeColormap
request with colormap as the colormap
argument.
If kill_id is zero,
no attempt should be made to free the resources.
A client that creates an RGB_COLOR_MAP for which the colormap resource 
is created specifically for this purpose should set kill_id to one 
(and can create more than one such standard colormap 
using a single connection).
A client that creates an RGB_COLOR_MAP for which the colormap resource 
is shared in some way (for example, is the default colormap 
for the root window) should create an arbitrary resource and use its 
resource ID for kill_id (and should create no other standard colormaps 
on the connection).
.NT Convention
If an RGB_COLOR_MAP property is too short to contain the visual_id field,
it can be assumed that the visual_id is the root visual 
of the appropriate screen.
If an RGB_COLOR_MAP property is too short to contain the kill_id field,
a value of zero can be assumed.
.NE
.LP
During the connection handshake,
the server informs the client of the default colormap for each screen.
This is a colormap for the root visual,
and clients can use it to improve the extent of colormap sharing
if they use the root visual.
.nH 2 "The Keyboard Mapping"
.LP
The X server contains a table (which is read by 
.PN GetKeyboardMapping
requests) that describes the set of symbols appearing 
on the corresponding key for each keycode generated by the server.
This table does not affect the server's operations in any way;
it is simply a database used by clients that attempt to understand 
the keycodes they receive.
Nevertheless, it is a shared resource and requires conventions.
.LP
It is possible for clients to modify this table by using a
.PN ChangeKeyboardMapping
request.
In general, clients should not do this.
In particular, this is not the way in which clients should implement 
key bindings or key remapping.
The conversion between a sequence of keycodes received from the server
and a string in a particular encoding is a private matter for each client
(as it must be in a world where applications may be using different
encodings to support different languages and fonts).
See the Xlib reference manual for converting keyboard events to text.
.LP
The only valid reason for using a
.PN ChangeKeyboardMapping
request is when the symbols written on the keys have changed as, for example,
when a Dvorak key conversion kit or a set of APL keycaps has been installed.
Of course, a client may have to take the change to the keycap on trust.
.LP
The following illustrates a permissible interaction between a client 
and a user:
.IP Client: 10
\*QYou just started me on a server without a Pause key.
Please choose a key to be the Pause key and press it now.\*U
.IP User: 10
Presses the Scroll Lock key
.IP Client: 10
\*QAdding Pause to the symbols on the Scroll Lock key: Confirm or Abort.\*U
.IP User: 10
Confirms
.IP Client: 10
Uses a
.PN ChangeKeyboardMapping
request to add Pause to the keycode that already contains Scroll Lock and
issues this request, \*QPlease paint Pause on the Scroll Lock key.\*U
.NT Convention
Clients should not use 
.PN ChangeKeyboardMapping
requests.
.NE
.LP
If a client succeeds in changing the keyboard mapping table,
all clients will receive 
.PN MappingNotify (request==Keyboard)
events.
There is no mechanism to avoid receiving these events.
.NT Convention
Clients receiving 
.PN MappingNotify (request==Keyboard)
events should update any internal keycode translation tables they are using.
.NE
.nH 2 "The Modifier Mapping"
.LP
X Version 11 supports 8 modifier bits of which 3 are preassigned 
to Shift, Lock, and Control.
Each modifier bit is controlled by the state of a set of keys,
and these sets are specified in a table accessed by
.PN GetModifierMapping
and
.PN SetModifierMapping
requests.
This table is a shared resource and requires conventions.
.LP
A client that needs to use one of the preassigned modifiers should assume 
that the modifier table has been set up correctly to control these modifiers.
The Lock modifier should be interpreted as Caps Lock or Shift Lock
according as the keycodes in its controlling set include XK_Caps_Lock
or XK_Shift_Lock.
.NT Convention
Clients should determine the meaning of a modifier bit from the KeySyms
being used to control it.
.NE
.LP
A client that needs to use an extra modifier (for example, META) should do
the following:
.bP
Scan the existing modifier mappings.
If it finds a modifier that contains a keycode whose set of KeySyms
includes XK_Meta_L or XK_Meta_R,
it should use that modifier bit.
.bP
If there is no existing modifier controlled by  XK_Meta_L or XK_Meta_R,
it should select an unused modifier bit (one with an empty controlling set)
and do the following:
.RS
.IP \- 5
If there is a keycode with XL_Meta_L in its set of KeySyms,
add that keycode to the set for the chosen modifier.
.IP \- 5
If there is a keycode with XL_Meta_R in its set of KeySyms,
add that keycode to the set for the chosen modifier.
.IP \- 5
If the controlling set is still empty,
interact with the user to select one or more keys to be META.
.RE
.bP
If there are no unused modifier bits,
ask the user to take corrective action.
.NT Conventions
.IP 1. 5
Clients needing a modifier not currently in use should assign keycodes
carrying suitable KeySyms to an unused modifier bit.
.IP 2. 5
Clients assigning their own modifier bits should ask the user politely to
remove his or her hands from the key in question if their 
.PN SetModifierMapping
request returns a 
.PN Busy
status.
.NE
.LP
There is no good solution to the problem of reclaiming assignments
to the five nonpreassigned modifiers when they are no longer being used.
.NT Convention
The user must use
.PN xmodmap
or some other utility to deassign obsolete modifier mappings by hand.
.NE
.LP
When a client succeeds in performing a 
.PN SetModifierMapping
request,
all clients will receive 
.PN MappingNotify (request==Modifier)
events.
There is no mechanism for preventing these events from being received.
A client that uses one of the nonpreassigned modifiers that receives
one of these events should do a 
.PN GetModifierMapping
request to discover the new mapping,
and if the modifier it is using has been cleared,
it should reinstall the modifier.
.LP
Note that a
.PN GrabServer
request must be used to make the 
.PN GetModifierMapping 
and
.PN SetModifierMapping
pair in these transactions atomic.
.nH 1 "Device Color Characterization"
.LP
.EQ
delim @@
define oc % "\\fR{\\fP" %
define cc % "\\fR}\\fP" %
.EN
The X protocol provides explicit Red, Green, and Blue (RGB) values,
which are used to directly drive a monitor, and color names.  RGB values
provide a mechanism for accessing the full capabilities of the display
device, but at the expense of having the color perceived by the user remain
unknowable through the protocol.  Color names were originally designed to
provide access to a device-independent color database by having the server
vendor tune the definitions of the colors in that textual database.
Unfortunately, this still does not provide the client any way of using
an existing device-independent color, nor for the client to get
device-independent color information back about colors that it has selected.
.LP
Furthermore, the client must be able to discover which set of colors are
displayable by the device (the device gamut), both to allow colors to be
intelligently modified to fit within the device capabilities (gamut
compression) and to enable the user interface to display a representation of
the reachable color space to the user (gamut display).
.LP
Therefore, a system is needed that will provide full access to
device-independent color spaces for X clients.  This system should use a
standard mechanism for naming the colors, be able to provide names for
existing colors, and provide means by which unreachable colors can be
modified to fall within the device gamut.
.LP
We are fortunate in this area to have a seminal work, the 1931 CIE color
standard, which is nearly universally agreed upon as adequate for describing
colors on CRT devices.  This standard uses a tri-stimulus model called CIE
XYZ in which each perceivable color is specified as a triplet of numbers.
Other appropriate device-independent color models do exist, but most of them
are directly traceable back to this original work.
.LP
X device color characterization
provides device-independent color spaces to X clients.  It does this by
providing the barest possible amount of information to the client that
allows the client to construct a mapping between CIE XYZ and the regular X
RGB color descriptions.
.LP
Device color characterization is defined by
the name and contents of two window properties that,
together, permit converting between CIE XYZ space and
linear RGB device space (such as standard CRTs).
Linear RGB devices require just two
pieces of information to completely characterize them:
.IP \(bu 5
A @3 times 3@ matrix @M@ and its inverse @M sup -1@, which convert between
XYZ and RGB intensity (@RGB sub intensity@):
.EQ C
RGB sub intensity ~ = ~ M ~ times ~ XYZ
.EN
.EQ C
XYZ ~ = ~ M sup -1 ~ times ~ RGB sub intensity
.EN
.IP \(bu 5
A way of mapping between RGB intensity and RGB protocol value.  XDCCC
supports three mechanisms which will be outlined later.
.LP
If other device types are eventually necessary, additional
properties will be required to describe them.
.nH 2 "XYZ \*(dA RGB Conversion Matrices"
.LP
Because of the limited dynamic range of both XYZ and RGB intensity,
these matrices will be encoded using a fixed-point representation of a
32-bit two's complement number scaled by @2 sup 27@, giving a range of @-16@ to
@16 - epsilon@, where @epsilon ~ = ~ 2 sup -27@.
.LP
These matrices will be packed into an 18-element list of 32-bit values,
XYZ \(-> RGB matrix first, in row major order and stored in the
XDCCC_LINEAR_RGB_MATRICES properties (format = 32) on the root window of
each screen, using values appropriate for that screen.
.LP
This will be encoded as shown in the following table:
.br
.ne 6
.TS
center;
c s s
c c c
l l l.
XDCCC_LINEAR_RGB_MATRICES property contents
.sp 6p
_
.sp 6p
.B
Field	Type	Comments
.R
.sp 6p
_
.sp 6p
@M sub 0,0@	INT32	Interpreted as a fixed-point number @-16~<=~x~<~16@
@M sub 0,1@	INT32	
\&.\^.\^.
@M sub 3,3@	INT32	
@{M sup -1} sub 0,0@	INT32	
@{M sup -1} sub 0,1@	INT32	
\&.\^.\^.
@{M sup -1} sub 3,3@	INT32	
.sp 6p
_
.TE
.nH 2 "Intensity \*(dA RGB Value Conversion"
.LP
XDCCC provides two representations for describing the conversion
between RGB intensity and the actual X protocol RGB values:
.DS
.TA .5i
.ta .5i
0	RGB value/RGB intensity level pairs
1	RGB intensity ramp
.DE
.LP
In both cases, the relevant data will be stored in the
XDCCC_LINEAR_RGB_CORRECTION properties on the root window of each screen,
using values appropriate for that screen, in whatever format provides
adequate resolution.  Each property can consist of multiple entries
concatenated together, if different visuals for the screen require different
conversion data.  An entry with a VisualID of 0 specifies data for all
visuals of the screen that are not otherwise explicitly listed.
.LP
The first representation is an array of RGB value/intensity level pairs, with
the RGB values in strictly increasing order.  When converting, the client must
linearly interpolate between adjacent entries in the table to compute the
desired value.  This allows the server to perform gamma correction
itself and encode that fact in a short two-element correction table.  The
intensity will be encoded as an unsigned number to be interpreted as a value
between 0 and 1 (inclusive).  The precision of this value will depend on the
format of the property in which it is stored (8, 16, or 32 bits).  For 16-bit
and 32-bit formats, the RGB value will simply be the value stored in the
property.  When stored in 8-bit format, the RGB value can be computed from
the value in the property by:
.EQ C
RGB sub value ~ = ~ { Property ~ Value ~ times ~ 65535 } over 255
.EN
.LP
Because the three electron guns in the device may not be exactly alike in
response characteristics, it is necessary to allow for three separate
tables, one each for red, green, and blue.  Therefore, each table will be
preceded by the number of entries in that table, and the set of tables will be
preceded by the number of tables.
When three tables are provided, they will be in red, green, blue order.
.LP
This will be encoded as shown in the following table:
.br
.ne 6
.TS
center;
c s s
c c c
l l l.
XDCCC_LINEAR_RGB_CORRECTION Property Contents for Type 0 Correction
.sp 6p
_
.sp 6p
.B
Field	Type	Comments
.R
.sp 6p
_
.sp 6p
VisualID0	CARD	Most significant portion of VisualID
VisualID1	CARD	Exists if and only if the property format is 8
VisualID2	CARD	Exists if and only if the property format is 8
VisualID3	CARD	T{
Least significant portion, exists if and only if the property format
is 8 or 16
T}
type	CARD	0 for this type of correction
count	CARD	Number of tables following (either 1 or 3)
length	CARD	Number of pairs \- 1 following in this table
value	CARD	X Protocol RGB value
intensity	CARD	Interpret as a number @0~<=~intensity~<=~1@
\&.\^.\^.	.\^.\^.	Total of \fIlength+1\fP pairs of value/intensity values
lengthg	CARD	T{
Number of pairs \- 1 following in this table (if and
only if \fIcount\fP is 3)
T}
value	CARD	X Protocol RGB value
intensity	CARD	Interpret as a number @0~<=~intensity~<=~1@
\&.\^.\^.	.\^.\^.	Total of \fIlengthg+1\fP pairs of value/intensity values
lengthb	CARD	T{
Number of pairs \- 1 following in this table (if and
only if \fIcount\fP is 3)
T}
value	CARD	X Protocol RGB value
intensity	CARD	Interpret as a number @0~<=~intensity~<=~1@
\&.\^.\^.	.\^.\^.	Total of \fIlengthb+1\fP pairs of value/intensity values
.sp 6p
_
.TE
.LP
The VisualID is stored in 4, 2, or 1 pieces, depending on whether
the property format is 8, 16, or 32, respectively.  The VisualID is always
stored most significant piece first.
Note that the length fields are stored as one less than the actual length,
so 256 entries can be stored in format 8.
.LP
The second representation is a simple array of intensities for a linear subset
of RGB values.  The expected size of this table is the bits-per-rgb-value of
the screen, but it can be any length.  This is similar to the first mechanism,
except that the RGB value numbers are implicitly defined by the index in the
array (indices start at 0):
.EQ C
RGB sub value ~ = ~ { Array ~ Index ~ times ~ 65535 } over
{ Array ~ Size ~ - ~ 1 }
.EN
When converting, the client may linearly interpolate between entries in this
table.  The intensity values will be encoded just as in the first
representation.
.LP
This will be encoded as shown in the following table:
.br
.ne 6
.TS
center;
c s s
c c c
l l l.
XDCCC_LINEAR_RGB_CORRECTION Property Contents for Type 1 Correction
.sp 6p
_
.sp 6p
.B
Field	Type	Comments
.R
.sp 6p
_
.sp 6p
VisualID0	CARD	Most significant portion of VisualID
VisualID1	CARD	Exists if and only if the property format is 8
VisualID2	CARD	Exists if and only if the property format is 8
VisualID3	CARD	T{
Least significant portion, exists if and only if
the property format is 8 or 16
T}
type	CARD	1 for this type of correction
count	CARD	Number of tables following (either 1 or 3)
length	CARD	Number of elements \- 1 following in this table
intensity	CARD	Interpret as a number @0~<=~intensity~<=~1@
\&.\^.\^.	.\^.\^.	Total of \fIlength+1\fP intensity elements
lengthg	CARD	T{
Number of elements \- 1 following in this table (if and
only if \fIcount\fP is 3)
T}
intensity	CARD	Interpret as a number @0~<=~intensity~<=~1@
\&.\^.\^.	.\^.\^.	Total of \fIlengthg+1\fP intensity elements
lengthb	CARD	T{
Number of elements \- 1 following in this table (if and
only if \fIcount\fP is 3)
T}
intensity	CARD	Interpret as a number @0~<=~intensity~<=~1@
\&.\^.\^.	.\^.\^.	Total of \fIlengthb+1\fP intensity elements
.sp 6p
_
.TE
.nH 1 "Conclusion"
.LP
This document provides the protocol-level specification of the minimal
conventions needed to ensure that X Version 11 clients can interoperate
properly.  This document specifies interoperability conventions only for the
X Version 11 protocol.  Clients should be aware of other protocols that
should be used for better interoperation in the X environment.  The reader
is referred to
.I
X Session Management Protocol
.R
for information on session management, and to
.I
Inter-Client Exchange Protocol
.R
for information on general-purpose communication among clients.
.nH 2 "The X Registry"
.IN "Registry"
.IN "X Registry"
.LP
The X Consortium maintains a registry of certain X-related items, to aid in
avoiding conflicts and in sharing of such items.  Readers are
encouraged to use the registry.  The classes of items kept in the registry
that are relevant to the ICCCM include property names, property types,
selection names, selection targets, WM_PROTOCOLS protocols,
.PN Client\%Message
types, and application classes.  Requests to register items, or questions
about registration, should be addressed to
.EQ
delim off
.EN
.DS
	xregistry@x.org
.DE
or to
.DS
	Registry
	X Consortium
	201 Broadway
	Cambridge, MA 02139-1955
	USA
.DE
Electronic mail will be acknowledged upon receipt.  Please allow up to 4
weeks for a formal response to registration and inquiries.
.LP
The registry is published as part of the X software distribution from the X
Consortium.  All registered items must have the postal address of someone
responsible for the item or a reference to a document describing the item
and the postal address of where to write to obtain the document.
.bp
.\" Set registers to number the appendixes A.1, B.1, C.1, ...
.nr H1 0
.af H1 A
.cT "Appendix A" no
.nH 1 "Revision History"
.LP
This appendix describes the revision history of this document and
summarizes the incompatibilities between this and earlier versions.
.nH 2 "The X11R2 Draft"
.LP
The February 25, 1988, draft that was distributed as part of X Version 11,
Release 2, was clearly labeled as such,
and many areas were explicitly labeled as liable to change.
Nevertheless, in the revision work done since then,
we have been very careful not to introduce gratuitous incompatibility.
As far as possible,
we have tried to ensure that clients obeying the conventions
in the X11R2 draft would still work.
.nH 2 "The July 27, 1988, Draft"
.LP
The Consortium review was based on a draft dated July 27, 1988.  This draft
included several areas in which incompatibilities with the X11R2 draft were
necessary:
.bP
The use of property 
.PN None
in 
.PN ConvertSelection
requests is no longer allowed.
Owners that receive them are free to use the target atom as the property 
to respond with,
which will work in most cases.
.bP
The protocol for INCREMENTAL type properties as selection replies has changed,
and the name has been changed to INCR.
Selection requestors are free to implement the earlier protocol 
if they receive properties of type INCREMENTAL.
.bP
The protocol for INDIRECT type properties as selection replies has changed,
and the name has been changed to MULTIPLE.
Selection requestors are free to implement the earlier protocol 
if they receive properties of type INDIRECT.
.bP
The protocol for the special CLIPBOARD client has changed.
The earlier protocol is subject to race conditions and should not be used.
.bP
The set of state values in WM_HINTS.initial_state has been reduced,
but the values that are still valid are unchanged.
Window managers should treat the other values sensibly.
.bP
The methods an application uses to change the state of its top-level window
have changed but in such a way that cases that used to work will still work.
.bP
The x, y, width, and height fields have been removed from the WM_NORMAL_HINTS
property and replaced by pad fields.
Values set into these fields will be ignored.
The position and size of the window should be set by setting the appropriate
window attributes.
.bP
A pair of base fields and a win_gravity field have been added 
to the WM_NORMAL_HINTS property.
Window managers will assume values for these fields if the client
sets a short property.
.nH 2 "The Public Review Drafts"
.LP
The Consortium review resulted in several incompatible changes.  These
changes were included in drafts that were distributed for public review
during the first half of 1989.
.bP
The messages field of the WM_HINTS property was found to be unwieldy
and difficult to evolve.
It has been replaced by the WM_PROTOCOLS property,
but clients that use the earlier mechanism can be detected 
because they set the messages bit in the flags field of the WM_HINTS property,
and window managers can provide a backwards compatibility mode.
.bP
The mechanism described in the earlier draft by which clients installed
their own subwindow colormaps could not be made to work reliably
and mandated some features of the look and feel.
It has been replaced by the WM_COLORMAP_WINDOWS property.
Clients that use the earlier mechanism can be detected by the WM_COLORMAPS
property they set on their top-level window,
but providing a reliable backwards compatibility mode is not possible.
.bP
The recommendations for window manager treatment of top-level window borders
have been changed as those in the earlier draft produced problems
with Visibility events.
For nonwindow manager clients,
there is no incompatibility.
.bP
The pseudoroot facility in the earlier draft has been removed.
Although it has been successfully implemented,
it turns out to be inadequate to support the uses envisaged.
An extension will be required to support these uses fully,
and it was felt that the maximum freedom should be left to the designers
of the extension.
In general,
the previous mechanism was invisible to clients and no incompatibility
should result.
.bP
The addition of the WM_DELETE_WINDOW protocol (which prevents the danger
that multi-window clients may be terminated unexpectedly)
has meant some changes in the WM_SAVE_YOURSELF protocol,
to ensure that the two protocols are orthogonal.
Clients using the earlier protocol can be detected (see WM_PROTOCOLS above)
and supported in a backwards compatibility mode.
.bP
The conventions in Section 14.3.1. of \fIXlib \- C Language X Interface\fP
regarding properties of type RGB_COLOR_MAP have been changed,  
but clients that use the earlier conventions can be detected 
because their properties are 4 bytes shorter.
These clients will work correctly if the server supports only a single Visual
or if they use only the Visual of the root.
These are the only cases in which they would have worked, anyway.
.nH 2 "Version 1.0, July 1989"
.LP
The public review resulted in a set of mostly editorial changes.  The
changes in version 1.0 that introduced some degree of incompatibility with
the earlier drafts are:
.bP
A new section (6.3) was added covering the window manager's
use of Grabs.
The restrictions it imposes should affect only window managers.
.bP
The TARGETS selection target has been clarified,
and it may be necessary for clients to add some entries to their replies.
.bP
A selection owner using INCR transfer should no longer replace targets in
a MULTIPLE property with the atom INCR.
.bP
The contents of the 
.PN ClientMessage
event sent by a client to iconify itself has been clarified,
but there should be no incompatibility because the earlier contents
would not in fact have worked.
.bP
The border-width in synthetic 
.PN ConfigureNotify
events is now specified,
but this should not cause any incompatibility.
.bP
Clients are now asked to set a border-width on all 
.PN ConfigureWindow
requests.
.bP
Window manager properties on icon windows now will be ignored,
but there should be no incompatibility 
because there was no specification that they be obeyed previously.
.bP
The ordering of real and synthetic 
.PN ConfigureNotify
events is now specified,
but any incompatibility should affect only window managers.
.bP
The semantics of WM_SAVE_YOURSELF have been clarified and restricted to
be a checkpoint operation only.
Clients that were using it as part of a shutdown sequence may need to
be modified,
especially if they were interacting with the user during the shutdown.
.bP
A kill_id field has been added to RGB_COLOR_MAP properties.
Clients using earlier conventions can be detected by the size of their
RGB_COLOR_MAP properties,
and the cases that would have worked will still work.
.nH 2 "Version 1.1"
.LP
Version 1.1 was released with X11R5 in September 1991.  In addition to some
minor editorial changes, there were a few semantic changes since Version
1.0:
.bP
The section on Device Color Characterization was added.
.bP
The meaning of the NULL property type was clarified.
.bP
Appropriate references to Compound Text were added.
.nH 2 "Public Review Draft, December 1993"
.LP
The following changes have been made in preparing the public review draft
for Version 2.0.
.bP
[P01] Addition of advice to clients on how to keep track of a top-level
window's absolute position on the screen.
.bP
[P03] A technique for clients to detect when it is safe to reuse a
top-level window has been added.
.bP
[P06] Section 4.1.8, on colormaps, has been rewritten.  A new feature that
allows clients to install their own colormaps has also been added.
.bP
[P08] The LENGTH target has been deprecated.
.bP
[P11] The manager selections facility was added.
.bP
[P17] The definition of the aspect ratio fields of the WM_NORMAL_HINTS
property has been changed to include the base size.
.bP
[P19]
.PN StaticGravity
has been added to the list of values allowed for the win_gravity field of
the WM_HINTS property.  The meaning of the
.PN CenterGravity
value has been clarified.
.bP
[P20] A means for clients to query the ICCCM compliance level of the window
manager has been added.
.bP
[P22] The definition of the MULTIPLE selection target has been clarified.
.bP
[P25] A definition of \*Qtop-level window\*U has been added.  The WM_STATE
property has been defined and exposed to clients.
.bP
[P26] The definition of window states has been clarified and the wording
regarding window state changes has been made more consistent.
.bP
[P27] Clarified the rules governing when window managers are required to send
synthetic
.PN \%ConfigureNotify
events.
.bP
[P28] Added a recommended technique for setting the input focus to a window
as soon as it is mapped.
.bP
[P29] The required lifetime of resource IDs named in window manager
properties has been specified.
.bP
[P30] Advice for dealing with keystrokes and override-redirect windows has
been added.
.bP
[P31] A statement on the ownership of resources transferred through the
selection mechanism has been added.
.bP
[P32] The definition of the CLIENT_WINDOW target has been clarified.
.bP
[P33] A rule about requiring the selection owner to reacquire the
selection under certain circumstances has been added.
.bP
[P42] Added several new selection targets.
.bP
[P44] Ambiguous wording regarding the withdrawal of top-level windows
has been removed.
.bP
[P45] A facility for requestors to pass parameters during a selection
request has been added.
.bP
[P49] A convention on discrimated names has been added.
.bP
[P57] The C_STRING property type was added.
.bP
[P62] An ordering requirement on processing selection requests was added.
.bP
[P63] The
.PN VisibleHint
flag was added.
.bP
[P64] The session management section has been updated to align with the new
session management protocol.  The old session management conventions have
been moved to Appendix C.
.bP
References to the never-forthcoming \fIWindow and Session Manager
Conventions Manual\fP have been removed.
.bP
Information on the X Registry and references to the session management and
ICE documents have been added.
.bP
Numerous editorial and typographical improvements have been made.
.nH 2 "Version 2.0, April 1994"
.LP
The following changes have been made in preparation for releasing
the final edition of Version 2.0 with X11R6.
.bP
The PIXMAP selection target has been revised to return a property of type
PIXMAP instead of type DRAWABLE.
.bP
The session management section has been revised slightly to correspond with
the changes to the \fIX Session Management Protocol\fP.
.bP
Window managers are now prohibited from placing
.PN CurrentTime
in the timestamp field of WM_TAKE_FOCUS messages.
.bP
In the WM_HINTS property, the
.PN VisibleHint
flag has been renamed to
.PN UrgencyHint .
Its semantics have also been defined more thoroughly.
.bP
Additional editorial and typographical changes have been made.
.bp
.cT "Appendix B" no
.nH 1 "Suggested Protocol Revisions"
.LP
During the development of these conventions,
a number of inadequacies have been discovered in the
core X11 protocol.
They are summarized here as input to an eventual protocol revision
design process:
.bP
There is no way for anyone to find out the last-change time of
a selection.
The
.PN Get\%Selection\%Owner
request should be changed to return the last-change time as well as the owner.
.bP
There is no way for a client to find out which selection atoms are valid.
.bP
There would be no need for WM_TAKE_FOCUS if the 
.PN FocusIn
event contained a timestamp and a previous-focus field.
This could avoid the potential race condition.
There is space in the event for this information;
it should be added at the next protocol revision.
.bP
There is a race condition in the
.PN Install\%Colormap 
request.
It does not take a timestamp and may be executed after the top-level colormap
has been uninstalled.
The next protocol revision should provide the timestamp in the
.PN Install\%Colormap ,
.PN Uninstall\%Colormap ,
.PN List\%Installed\%Colormaps 
requests and in the 
.PN Colormap\%Notify
event.
The timestamp should be used in a similar way to the last-focus-change
time for the input focus.  The lack of timestamps in these packets is the
reason for restricting colormap installation to the window manager.
.bP
The protocol needs to be changed to provide some way of identifying
the Visual and the Screen of a colormap.
.bP
There should be some way to reclaim assignments to the five nonpreassigned
modifiers when they are no longer needed.  The manual method is unpleasantly
low-tech.
.bp
.cT "Appendix C" no
.nH 1 "Obsolete Session Manager Conventions"
.LP
This appendix contains obsolete conventions for session management using X
properties and messages.  The conventions described here are deprecated and
are described only for historical interest.  For further information on
session management, see
.I
X Session Management Protocol.
.R
.nH 2 "Properties"
.LP
The client communicates with the session manager by placing two properties
(WM_COMMAND and WM_CLIENT_MACHINE) on its top-level window.
If the client has a group of top-level windows,
these properties should be placed on the group leader window.
.LP
The window manager is responsible for placing a WM_STATE property
on each top-level client window for use by session managers and other clients
that need to be able to identify top-level client windows and their state.
.nH 3 "WM_COMMAND Property"
.LP
The WM_COMMAND property represents the command used to start or restart the
client.  By updating this property, clients should ensure that it always
reflects a command that will restart them in their current state.  The
content and type of the property depend on the operating system of the
machine running the client.  On POSIX-conformant systems using ISO Latin-1
characters for their command lines, the property should:
.bP
Be of type STRING
.bP
Contain a list of null-terminated strings
.bP
Be initialized from argv
.IP
Other systems will need to set appropriate conventions for the type 
and contents of WM_COMMAND properties.
Window and session managers should not assume that STRING is 
the type of WM_COMMAND or that they will be able to understand 
or display its contents.
.LP
Note that WM_COMMAND strings are null-terminated
and differ from the general conventions that STRING properties
are null-separated.
This inconsistency is necessary for backwards compatibility.
.LP
A client with multiple top-level windows should ensure 
that exactly one of them has a WM_COMMAND with nonzero length.
Zero-length WM_COMMAND properties can be used to reply to WM_SAVE_YOURSELF
messages on other top-level windows but will otherwise be ignored.
.nH 3 "WM_CLIENT_MACHINE Property"
.LP
This property is described in section 4.1.2.9.
.nH 2 "Termination"
.LP
Because they communicate by means of unreliable network connections, clients
must be prepared for their connection to the server to be terminated at any
time without warning.  They cannot depend on getting notification that
termination is imminent or on being able to use the server to negotiate with
the user about their fate.  For example, clients cannot depend on being able
to put up a dialog box.
.LP
Similarly, clients may terminate at any time without notice to the session
manager.  When a client terminates itself rather than being terminated by
the session manager, it is viewed as having resigned from the session in
question, and it will not be revived if the session is revived.
.nH 2 "Client Responses to Session Manager Actions"
.LP
Clients may need to respond to session manager actions in two ways:
.bP
Saving their internal state
.bP
Deleting a window
.nH 3 "Saving Client State"
.LP
Clients that want to be warned when the session manager feels 
that they should save their internal state (for example,
when termination impends) should include the atom WM_SAVE_YOURSELF 
in the WM_PROTOCOLS property on their top-level windows to participate 
in the WM_SAVE_YOURSELF protocol.
They will receive a 
.PN ClientMessage
event as described in section 4.2.8 
with the atom WM_SAVE_YOURSELF in its data[0] field.
.LP
Clients that receive WM_SAVE_YOURSELF should place themselves in a state from
which they can be restarted and should update WM_COMMAND to
be a command that will restart them in this state.
The session manager will be waiting for a 
.PN PropertyNotify
event on WM_COMMAND as a confirmation that the client has saved its state.
Therefore, WM_COMMAND should be updated (perhaps with a zero-length append)
even if its contents are correct.
No interactions with the user are permitted during this process.
.LP
Once it has received this confirmation,
the session manager will feel free to terminate the client if that is what 
the user asked for.
Otherwise,
if the user asked for the session to be put to sleep,
the session manager will ensure that the client does not
receive any mouse or keyboard events.
.LP
After receiving a WM_SAVE_YOURSELF, saving its state, and updating WM_COMMAND,
the client should not change its state (in the sense of doing anything 
that would require a change to WM_COMMAND) until it receives a mouse 
or keyboard event.
Once it does so,
it can assume that the danger is over.
The session manager will ensure that these events do not reach
clients until the danger is over or until the clients have been killed.
.LP
Irrespective of how they are arranged in window groups,
clients with multiple top-level windows should ensure the following:
.bP
Only one of their top-level windows has a nonzero-length WM_COMMAND
property.
.bP
They respond to a WM_SAVE_YOURSELF message by:
.RS
.IP \- 5
First, updating the nonzero-length WM_COMMAND property, if necessary
.IP \- 5
Second, updating the WM_COMMAND property on the window for which they received
the WM_SAVE_YOURSELF message if it was not updated in the first step
.RE
.LP
Receiving WM_SAVE_YOURSELF on a window is, conceptually, a command 
to save the entire client state.\**
.FS
This convention has changed since earlier drafts because of the 
introduction of the protocol in the next section.
In the public review draft,
there was ambiguity as to whether WM_SAVE_YOURSELF was a checkpoint 
or a shutdown facility.
It is now unambiguously a checkpoint facility;
if a shutdown facility is judged to be necessary,
a separate WM_PROTOCOLS protocol will be developed and registered 
with the X Consortium.
.FE
.nH 3 "Window Deletion"
.LP
Windows are deleted using the WM_DELETE_WINDOW protocol, which
is described in section 4.2.8.1.
.nH 2 "Summary of Session Manager Property Types"
.LP
The session manager properties are listed in the following table:
.br
.ne 6
.TS H
l l n c.
_
.sp 6p
.B
Name	Type	Format	See Section
.sp 6p
_
.sp 6p
.TH
.R
WM_CLIENT_MACHINE	TEXT		4.1.2.9
WM_COMMAND	TEXT		C.1.1
WM_STATE	WM_STATE	32	4.1.3.1
.sp 6p
_
.TE
.\" Finish up!
.YZ 3
