/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libgnome/gnome-help.h>

#include "nsReadableUtils.h"

#include "GnomeHelpProtocolHandler.h"

/* Implementation file */
NS_IMPL_ISUPPORTS1 (GGnomeHelpProtocolHandler, nsIProtocolHandler)

/* nsIChannel newChannel (in nsIURI aURI); */
NS_IMETHODIMP GGnomeHelpProtocolHandler::NewChannel(nsIURI *aURI,
						    nsIChannel **_retval)
{
	nsresult rv;
	mURI = aURI;

	nsCString host;
	rv = aURI->GetHost (host);
	if (NS_FAILED(rv)) return rv;

	nsCString path;
	rv = aURI->GetPath (path);
	if (NS_FAILED(rv)) return rv;

	if (FindInReadable(NS_LITERAL_CSTRING(".sgml"), path))
	{
		mDocName = path;
	}
	else
	{
		nsCString fileName = host;
		fileName += ".sgml";
		char *helpPath = gnome_help_file_find_file (
					const_cast<char *>(host.get()),
					const_cast<char *>(fileName.get()));
		mDocName = helpPath;
		g_free (helpPath);
	}

	rv = CreatePage ();
	NS_IF_ADDREF (*_retval = mChannel);
	return rv;
}

////////////////////////////////////////////////////////////////////////////////

