/*
 *  Copyright (C) 1999-2001 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GTM_APPLET_H
#define _GTM_APPLET_H

#include <config.h>

/* Applet commands */
typedef enum {
    GTM_ACTION_NONE,
    GTM_ACTION_NEW_URL,
    GTM_ACTION_OPEN_GTM,
} GTMAppletCmd;

typedef enum {
    GTM_ADDURL_NO_ERROR,
    GTM_ADDURL_GTM_ERROR,
    GTM_ADDURL_REPEAT_ERROR,
    GTM_ADDURL_CORBA_ERROR
} GTMAppletError;

typedef enum {
    PROTOCOL_NONE,
    PROTOCOL_HTTP,
    PROTOCOL_FTP,
    PROTOCOL_HTTPS
} Protocol;

typedef struct 
{
    gboolean confirm_dnd_url;
    GTMAppletCmd binding_button1_click;
    Protocol presume_protocol;
} Properties;

/* The applet properties */
extern Properties gtm_applet_prop;

gboolean gtm_open (void);

GTMAppletError gtm_add_url (gchar *url, gchar *dir, gboolean use_proxy,
                            gboolean use_auto_dl);

#endif /* _GTM_APPLET_H */
