;; autoload.jl -- Initialise auto-load functions
;; $Id: autoload.jl,v 1.14 2001/01/07 00:15:10 jsh Exp $

;; Copyright (C) 1999 John Harper <john@dcs.warwick.ac.uk>

;; This file is part of sawmill.

;; sawmill is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; sawmill is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with sawmill; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;; to rebuild this file, load a tags file containing all lisp files
;; into Jade, then run:

;; (tags-map-buffers
;;  (lambda (buffer)
;;    (add-autoloads "SOURCE-DIR/lisp/sawfish/wm/autoload.jl" buffer)))

;;; ::autoload-start::
(autoload-command (quote customize) (quote sawfish.wm.customize))
(autoload-command (quote popup-window-menu) (quote sawfish.wm.menus))
(autoload-command (quote popup-root-menu) (quote sawfish.wm.menus))
(autoload-command (quote popup-apps-menu) (quote sawfish.wm.menus))
(autoload-window-animator 'wireframe 'sawfish.wm.animation.outline)
(autoload-window-animator 'solid 'sawfish.wm.animation.outline)
(autoload-command (quote next-workspace-window) (quote sawfish.wm.commands.cycle))
(autoload-command (quote previous-workspace-window) (quote sawfish.wm.commands.cycle))
(autoload-command (quote next-window) (quote sawfish.wm.commands.cycle))
(autoload-command (quote previous-window) (quote sawfish.wm.commands.cycle))
(autoload-command (quote describe-symbol) (quote sawfish.wm.commands.describe) #:user-level (quote expert))
(autoload-command (quote describe-symbol-to-screen) (quote sawfish.wm.commands.describe) #:user-level (quote expert))
(autoload-command (quote apropos-function) (quote sawfish.wm.commands.describe) #:user-level (quote expert))
(autoload-command (quote apropos-function-to-screen) (quote sawfish.wm.commands.describe) #:user-level (quote expert))
(autoload-command (quote apropos-variable) (quote sawfish.wm.commands.describe) #:user-level (quote expert))
(autoload-command (quote apropos-variable-to-screen) (quote sawfish.wm.commands.describe) #:user-level (quote expert))
(autoload-command (quote gnome-toggle-skip-winlist) (quote sawfish.wm.commands.gnome))
(autoload-command (quote gnome-set-skip-winlist) (quote sawfish.wm.commands.gnome))
(autoload-command (quote gnome-clear-skip-winlist) (quote sawfish.wm.commands.gnome))
(autoload-command (quote gnome-toggle-skip-tasklist) (quote sawfish.wm.commands.gnome))
(autoload-command (quote gnome-set-skip-tasklist) (quote sawfish.wm.commands.gnome))
(autoload-command (quote gnome-clear-skip-tasklist) (quote sawfish.wm.commands.gnome))
(autoload-command (quote gnome-logout) (quote sawfish.wm.commands.gnome))
(autoload-command (quote gnome-www-page) (quote sawfish.wm.commands.gnome))
(autoload-command (quote gnome-help-browser) (quote sawfish.wm.commands.gnome))
(autoload-command (quote gnome-about) (quote sawfish.wm.commands.gnome))
(autoload-command (quote make-group-sticky) (quote sawfish.wm.commands.groups))
(autoload-command (quote make-group-unsticky) (quote sawfish.wm.commands.groups))
(autoload-command (quote toggle-group-sticky) (quote sawfish.wm.commands.groups))
(autoload-command (quote send-group-to-current-workspace) (quote sawfish.wm.commands.groups))
(autoload-command (quote send-group-to-next-workspace) (quote sawfish.wm.commands.groups))
(autoload-command (quote send-group-to-previous-workspace) (quote sawfish.wm.commands.groups))
(autoload-command (quote move-group-to-current-viewport) (quote sawfish.wm.commands.groups))
(autoload-command (quote move-group-left) (quote sawfish.wm.commands.groups))
(autoload-command (quote move-group-right) (quote sawfish.wm.commands.groups))
(autoload-command (quote move-group-up) (quote sawfish.wm.commands.groups))
(autoload-command (quote move-group-down) (quote sawfish.wm.commands.groups))
(autoload-command (quote raise-group) (quote sawfish.wm.commands.groups) #:user-level (quote expert))
(autoload-command (quote lower-group) (quote sawfish.wm.commands.groups) #:user-level (quote expert))
(autoload-command (quote raise-lower-group) (quote sawfish.wm.commands.groups) #:user-level (quote expert))
(autoload-command (quote raise-group-depth) (quote sawfish.wm.commands.groups))
(autoload-command (quote lower-group-depth) (quote sawfish.wm.commands.groups))
(autoload-command (quote delete-group) (quote sawfish.wm.commands.groups))
(autoload-command (quote grow-window-left) (quote sawfish.wm.commands.grow-pack))
(autoload-command (quote grow-window-right) (quote sawfish.wm.commands.grow-pack))
(autoload-command (quote grow-window-up) (quote sawfish.wm.commands.grow-pack))
(autoload-command (quote grow-window-down) (quote sawfish.wm.commands.grow-pack))
(autoload-command (quote pack-window-left) (quote sawfish.wm.commands.grow-pack))
(autoload-command (quote pack-window-right) (quote sawfish.wm.commands.grow-pack))
(autoload-command (quote pack-window-up) (quote sawfish.wm.commands.grow-pack))
(autoload-command (quote pack-window-down) (quote sawfish.wm.commands.grow-pack))
(autoload-command (quote help:show-faq) (quote sawfish.wm.commands.help))
(autoload-command (quote help:show-news) (quote sawfish.wm.commands.help))
(autoload-command (quote help:show-programmer-manual) (quote sawfish.wm.commands.help))
(autoload-command (quote help:show-homepage) (quote sawfish.wm.commands.help))
(autoload-command (quote help:about) (quote sawfish.wm.commands.help))
(autoload-command (quote move-cursor-right) (quote sawfish.wm.commands.move-cursor))
(autoload-command (quote move-cursor-left) (quote sawfish.wm.commands.move-cursor))
(autoload-command (quote move-cursor-up) (quote sawfish.wm.commands.move-cursor))
(autoload-command (quote move-cursor-down) (quote sawfish.wm.commands.move-cursor))
(autoload-command (quote move-cursor-right-fine) (quote sawfish.wm.commands.move-cursor))
(autoload-command (quote move-cursor-left-fine) (quote sawfish.wm.commands.move-cursor))
(autoload-command (quote move-cursor-up-fine) (quote sawfish.wm.commands.move-cursor))
(autoload-command (quote move-cursor-down-fine) (quote sawfish.wm.commands.move-cursor))
(autoload-command (quote move-window-interactively) (quote sawfish.wm.commands.move-resize))
(autoload-command (quote resize-window-interactively) (quote sawfish.wm.commands.move-resize))
(autoload-command (quote move-selected-window) (quote sawfish.wm.commands.move-resize))
(autoload-command (quote resize-selected-window) (quote sawfish.wm.commands.move-resize))
(autoload-command (quote raise-and-pass-through-click) (quote sawfish.wm.commands.raise-commands))
(autoload-command (quote raise-and-pass-through-click-if-focused) (quote sawfish.wm.commands.raise-commands))
(autoload-command (quote raise-or-pass-through-click) (quote sawfish.wm.commands.raise-commands))
(autoload-command (quote raise-window-and-pass-through-click) (quote sawfish.wm.commands.raise-commands) #:user-level (quote expert))
(autoload-command (quote raise-group-and-pass-through-click) (quote sawfish.wm.commands.raise-commands) #:user-level (quote expert))
(autoload-command (quote raise-transients-and-pass-through-click) (quote sawfish.wm.commands.raise-commands) #:user-level (quote expert))
(autoload-command (quote size-window-add-row) (quote sawfish.wm.commands.size-window))
(autoload-command (quote size-window-subtract-row) (quote sawfish.wm.commands.size-window))
(autoload-command (quote size-window-add-column) (quote sawfish.wm.commands.size-window))
(autoload-command (quote size-window-subtract-column) (quote sawfish.wm.commands.size-window))
(autoload-command (quote slide-window-left) (quote sawfish.wm.commands.slide-window))
(autoload-command (quote slide-window-right) (quote sawfish.wm.commands.slide-window))
(autoload-command (quote slide-window-up) (quote sawfish.wm.commands.slide-window))
(autoload-command (quote slide-window-down) (quote sawfish.wm.commands.slide-window))
(autoload-command (quote slide-group-left) (quote sawfish.wm.commands.slide-window))
(autoload-command (quote slide-group-right) (quote sawfish.wm.commands.slide-window))
(autoload-command (quote slide-group-up) (quote sawfish.wm.commands.slide-window))
(autoload-command (quote slide-group-down) (quote sawfish.wm.commands.slide-window))
(autoload-command (quote set-viewport-linear) (quote sawfish.wm.commands.viewport-linear) #:type (backquote (and (labelled (backquote-unquote (_ "Index:")) (number 0)))))
(autoload-command (quote set-window-viewport-linear) (quote sawfish.wm.commands.viewport-linear) #:type (backquote (and (labelled (backquote-unquote (_ "Index:")) (number 0)))))
(autoload-command 'set-viewport-linear:1 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-window-viewport-linear:1 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-viewport-linear:2 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-window-viewport-linear:2 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-viewport-linear:3 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-window-viewport-linear:3 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-viewport-linear:4 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-window-viewport-linear:4 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-viewport-linear:5 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-window-viewport-linear:5 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-viewport-linear:6 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-window-viewport-linear:6 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-viewport-linear:7 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-window-viewport-linear:7 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-viewport-linear:8 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-window-viewport-linear:8 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-viewport-linear:9 'sawfish.wm.commands.viewport-linear)
(autoload-command 'set-window-viewport-linear:9 'sawfish.wm.commands.viewport-linear)
(put 'set-viewport-linear:1 'deprecated-command t)
(put 'set-window-viewport-linear:1 'deprecated-command t)
(put 'set-viewport-linear:2 'deprecated-command t)
(put 'set-window-viewport-linear:2 'deprecated-command t)
(put 'set-viewport-linear:3 'deprecated-command t)
(put 'set-window-viewport-linear:3 'deprecated-command t)
(put 'set-viewport-linear:4 'deprecated-command t)
(put 'set-window-viewport-linear:4 'deprecated-command t)
(put 'set-viewport-linear:5 'deprecated-command t)
(put 'set-window-viewport-linear:5 'deprecated-command t)
(put 'set-viewport-linear:6 'deprecated-command t)
(put 'set-window-viewport-linear:6 'deprecated-command t)
(put 'set-viewport-linear:7 'deprecated-command t)
(put 'set-window-viewport-linear:7 'deprecated-command t)
(put 'set-viewport-linear:8 'deprecated-command t)
(put 'set-window-viewport-linear:8 'deprecated-command t)
(put 'set-viewport-linear:9 'deprecated-command t)
(put 'set-window-viewport-linear:9 'deprecated-command t)
(defgroup cycle "Window Cycling" :group focus :require sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-windows 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-windows-backwards 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-group 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-group-backwards 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-prefix 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-prefix-backwards 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-class 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-class-backwards 'sawfish.wm.commands.x-cycle)
(autoload-command (quote xterm) (quote sawfish.wm.commands.xterm))
(autoload-command (quote 3d-hack) (quote sawfish.wm.ext.3d-hack) #:user-level (quote expert))
(defgroup audio "Sound" :require sawfish.wm.ext.audio-events)
(defgroup edge-flip "Edge Flipping" :group workspace :require sawfish.wm.ext.edge-flip)
(defgroup match-window "Matched Windows" :layout single :require sawfish.wm.ext.match-window)
(defgroup shade-hover "Shade Hover" :group focus :require sawfish.wm.ext.shade-hover)
(defgroup tooltips "Tooltips" :group misc :require sawfish.wm.ext.tooltips)
(autoload-placement-mode 'first-fit 'sawfish.wm.placement.smart)
(autoload-placement-mode 'best-fit 'sawfish.wm.placement.smart)
(autoload-placement-mode 'best-fit-group 'sawfish.wm.placement.smart)
(autoload-placement-mode 'first-fit-or-interactive 'sawfish.wm.placement.smart)
(autoload-placement-mode 'stagger 'sawfish.wm.placement.stagger)
(autoload-command (quote maximize-window) (quote sawfish.wm.state.maximize))
(autoload-command (quote unmaximize-window) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-window-vertically) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-window-horizontally) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-window-toggle) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-window-horizontally-toggle) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-window-vertically-toggle) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-fill-window) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-fill-window-vertically) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-fill-window-horizontally) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-fill-window-toggle) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-fill-window-horizontally-toggle) (quote sawfish.wm.state.maximize))
(autoload-command (quote maximize-fill-window-vertically-toggle) (quote sawfish.wm.state.maximize))
(autoload-command (quote describe-key) (quote sawfish.wm.util.keymap))
(autoload-command (quote describe-key-to-screen) (quote sawfish.wm.util.keymap))
(autoload-command (quote quote-event) (quote sawfish.wm.util.keymap))
(autoload-command (quote move-viewport-next) (quote sawfish.wm.commands.viewport-extras))
(autoload-command (quote move-viewport-previous) (quote sawfish.wm.commands.viewport-extras))
(autoload-command (quote move-window-previous) (quote sawfish.wm.commands.viewport-extras))
(autoload-command (quote move-window-next) (quote sawfish.wm.commands.viewport-extras))
(autoload-placement-mode 'top-left 'sawfish.wm.placement.top-left)
(autoload-placement-mode 'off-center 'sawfish.wm.placement.off-center)
;;; ::autoload-end::
