/* This file is part of the KDE project

   Copyright (C) 2001 Lukas Tinkl <lukas@kde.org>
                      Andreas Schlapbach <schlpbch@iam.unibe.ch>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef kimdialogplugin_h
#define kimdialogplugin_h

#include <qcheckbox.h>
#include <qlineedit.h>
#include <qspinbox.h>

#include <kcolorbtn.h>
#include <kurlrequester.h>
#include <kdialogbase.h>

class QProgressDialog;
class KURL;

typedef QMap<QString,QString> CommentMap;

class RecursionSpinBox : public QSpinBox
{
  public:
    RecursionSpinBox(QWidget *parent=0, const char *name=0);
    RecursionSpinBox(int lower, int upper, int step, QWidget *parent=0, const char *name=0);
    ~RecursionSpinBox();

  protected:
    QString mapValueToText(int v);
};

class KIGPDialog : public KDialogBase
{
 Q_OBJECT

 public:
  KIGPDialog(QWidget *parent=0, const QString& path=0, const char *name=0 );
  ~KIGPDialog();

  bool isDialogOk() const;
  bool printImageName() const;
  bool printImageSize() const;
  bool printImageProperty() const;
  bool copyOriginalFiles() const;
  bool useCommentFile() const;
  bool recurseSubDirectories() const;
  int recursionLevel() const;
  bool generateXHTML() const;

  int getImagesPerRow() const;

  const QString getTitle() const;
  const QString getImageName() const;
  const QString getCommentFile() const;
  const QString getFontName() const;
  const QString getFontSize() const;

  const QColor getBackgroundColor() const;
  const QColor getForegroundColor() const;

 protected slots:
  void slotUseCommentFile();
  void slotRecurseSubDirectories();
  void slotOk();
  void slotCancel();
    void imageUrlChanged(const QString & );
 private:
  KColorButton *m_foregroundColor;
  KColorButton *m_backgroundColor;

  QLineEdit *m_title;

  QSpinBox *m_imagesPerRow;
  QSpinBox *m_fontSize;

  RecursionSpinBox *m_recursionLevel;

  QCheckBox *m_copyOriginalFiles;
  QCheckBox *m_imageName;
  QCheckBox *m_imageSize;
  QCheckBox *m_imageProperty;
  QCheckBox *m_useCommentFile;
  QCheckBox *m_recurseSubDirectories;
  QCheckBox *m_generateXHTML;

  QComboBox* m_fontName;

  KURLRequester *m_imageNameReq;
  KURLRequester *m_commentFileReq;
  bool m_dialogOk;

 private:
  void setupLookPage(const QString& path);
  void setupDirectoryPage(const QString& path);
};

#endif
