#include "AddMessage.moc"
#include <qwidget.h>
#include <qlabel.h>
#include <klocale.h>
#include <qtooltip.h>
#include <qbuttongroup.h>
#include <kapplication.h>
#include <stdlib.h>

AddMessage::AddMessage(ftpaccess *f, bool rdm, 
		       QWidget * parent, char * wname): QWidget(parent, wname)
{
	int y, w;
	ftpxs=f;
	readme=rdm;
	if(rdm)
		this->setCaption(i18n("Add Readme"));
	else
		this->setCaption(i18n("Add Message"));
	resize(320,260);
	setFixedSize(320,260);
	w=320;

	QButtonGroup *a=new QButtonGroup();
	atLogin=new QRadioButton(i18n("Display at &login"),this);
	a->insert(atLogin);
	atLogin->setGeometry(5,5,w/2-10,atLogin->height());
	connect(atLogin,SIGNAL(clicked()),SLOT(atChanged()));
	QToolTip::add(atLogin,i18n("Message will be displayed after a user logs in.\nThe file has to be relative to the chrooted directory for anonymous/guest users."));
	atCwd=new QRadioButton(i18n("Display at &CWD"),this);
	atCwd->setGeometry(w/2+5,5,w/2-10,atCwd->height());
	connect(atCwd,SIGNAL(clicked()),SLOT(atChanged()));
	a->insert(atCwd);
	QToolTip::add(atCwd,i18n("Message will be displayed when a user enters the specified directory.\nPath has to be relative to chroot for anonymous/guest users."));
	atLogin->setChecked(true);
	y=atLogin->y()+atLogin->height()+5;
	filename=new InputFileCtl(i18n("&Message file"),0,false,0,this);
	filename->setGeometry(5,y,w-10,filename->height());
	QToolTip::add(filename,i18n("Filename of the message file - remember to make this relative to chroot!"));
	y+=filename->height();
	dir=new InputFileCtl(i18n("&Directory"),0,true,i18n("Sele&ct"),this);
	dir->setGeometry(5,y,w-10,dir->height());
	QToolTip::add(dir,i18n("Directory in which the message will be displayed.\nMay be globbed: For example * means show in every directory.\nThis is especially useful if you're using ratios."));
	y+=dir->height();

	QButtonGroup *b=new QButtonGroup();
	anyClass=new QRadioButton(i18n("Display for &any class"),this);
	QToolTip::add(anyClass,i18n("The message will be displayed to everyone"));
	b->insert(anyClass);
	anyClass->setGeometry(5,y,w-10,anyClass->height());
	connect(anyClass,SIGNAL(clicked()),SLOT(clsChanged()));
	selClasses=new QRadioButton(i18n("Displa&y for selected classes:"),this);
	QToolTip::add(selClasses,i18n("The message will be displayed only to members of the classes below."));
	b->insert(selClasses);
	selClasses->setGeometry(w/2+5,y,w-10,selClasses->height());
	connect(selClasses,SIGNAL(clicked()),SLOT(clsChanged()));
	y+=selClasses->height();
	anyClass->setChecked(true);
	classes=new QListBox(this);
	classes->setMultiSelection(true);
	ftpclass *c=0;
	classes->clear();
	while((c=ftpxs->getNextClass(c)))
		classes->insertItem(c->getName());
	classes->update();
	classes->setGeometry(5,y,w-10,height()-y-selClasses->height()-15);
	y+=classes->height()+5;
	QToolTip::add(classes,i18n("The message will be displayed to members of the classes selected here."));

	ok=new QPushButton(i18n("&OK"),this);
	ok->setDefault(true);
	ok->setGeometry(5,y,this->width()/2-10,ok->height());
	connect(ok,SIGNAL(clicked()),SLOT(okButtonPressed()));
	cancel=new QPushButton(i18n("&Cancel"),this);
	connect(cancel,SIGNAL(clicked()),SLOT(cancelButtonPressed()));
	cancel->setGeometry(this->width()/2+5,y,this->width()/2-10,cancel->height());

	atChanged(); clsChanged(); // Disable controls we won't need...

	show();
}
AddMessage::~AddMessage()
{
	delete filename;
	delete ok;
	delete cancel;
}
void AddMessage::okButtonPressed()
{
	QString cls;
	if(selClasses->isChecked()) {
		for(unsigned int i=0;i<classes->count();i++)
			if(classes->isSelected(i)) {
				cls = classes->text(i) + ' ';
			}
		if(!cls.isEmpty())
			cls.truncate(cls.length() -1); // remove last space
	}
	message=new ftpmessage(readme,atLogin->isChecked(),filename->text(),dir->text(),cls);
	emit MessageAdded(readme,message);
	delete this;
}
void AddMessage::cancelButtonPressed()
{
	delete this;
}
void AddMessage::atChanged()
{
	dir->setEnabled(atCwd->isChecked());
}
void AddMessage::clsChanged()
{
	classes->setEnabled(selClasses->isChecked());
}
