/* This file is part of KDE PIM
   Copyright (C) 1999 Don Sanders <sanders@kde.org>

   License: BSD
*/

#ifndef CONTACTENTRYLIST_H 
#define CONTACTENTRYLIST_H 

#include <qtextstream.h>
#include <qptrlist.h>
#include <qstringlist.h>

#include <kabc/addressbook.h>

#include "contactentry.h"


typedef QDictIterator<ContactEntry> ContactEntryListIterator;

class ContactEntryList
{
public:
  ContactEntryList();
  ~ContactEntryList();

  void commit();
  void refresh();
  QString insert( ContactEntry *item );
  void unremove( const QString &key, ContactEntry *item );
  void remove( const QString &key );
  /** Removes all items in the trash from the list */
  void emptyTrash();
  ContactEntry* find( const QString &key );
  void replace( const QString &key, ContactEntry *item );
  QStringList keys() const;
  QDict<ContactEntry> getDict() const;
  
 protected:
  ContactEntry *KabEntryToContactEntry( const KABC::Addressee &entry );
  KABC::Addressee ContactEntryToKabEntry( ContactEntry *entry );

  void readAddress( KABC::Address ad, ContactEntry *ce, const QString &type );
  void readPhoneNumber( KABC::Addressee a, int kabcType,
                        ContactEntry *ce, const QString &type );
                        
  void writeCustom( KABC::Addressee &a, ContactEntry *entry,
                    const QString &type );
  void writeAddress( KABC::Addressee &a, ContactEntry *entry,
                     const QString &type, int kabcType );
  void writePhoneNumber( KABC::Addressee &a, ContactEntry *entry,
                         const QString &type, int kabcType );

private:

  KABC::AddressBook *mAddressBook;
  QStringList removedKeys;
  QDict<ContactEntry> ceDict;
};

#endif
