/***************************************************************************
                            kde_KAccel.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KACCEL
#define KDE_KACCEL

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Handle shortcuts.

 Allow a user to configure shortcuts
 through application configuration files or through the
 @ref KKeyChooser GUI.

 A @ref KAccel contains a list of @ref KAccelAction objects.

 For example, CTRL+Key_P could be a shortcut for printing a document. The key
 codes are listed in qnamespace.h. "Print" could be the action name for printing.
 The action name identifies the shortcut in configuration files and the
 @ref KKeyChooser GUI.

 A KAccel object handles key events sent to its parent widget and to all
 children of this parent widget.  The most recently created KAccel object
 has precedence over any KAccel objects created before it.
 When a shortcut pressed, KAccel calls the slot to which it has been
 connected.

 Reconfiguration of a given shortcut can be prevented by specifying
 that an accelerator item is not configurable when it is inserted. A special
 group of non-configurable key bindings are known as the
 standard accelerators.

 The standard accelerators appear repeatedly in applications for
 standard document actions such as printing and saving. A convenience method is
 available to insert and connect these accelerators which are configurable on
 a desktop-wide basis.

 It is possible for a user to choose to have no key associated with
 an action.

 The translated first argument for @ref insertItem() is used only
 in the configuration dialog.
<pre>
 KAccel* pAccel = new KAccel( this );

 // Insert an action "Scroll Up" which is associated with the "Up" key:
 pAccel->insert( "Scroll Up", i18n("Scroll up"),
                       i18n("Scroll up the current document by one line."),
                       Qt::Key_Up, this, SLOT(slotScrollUp()) );
 // Insert an standard acclerator action.
 pAccel->insert( KStdAccel::Print, this, SLOT(slotPrint()) );

 // Update the shortcuts by read any user-defined settings from the
 //  application's config file.
 pAccel->readSettings();
</pre>

 @version $Id: kde_KAccel.h,v 1.3 2002/02/21 00:43:08 rdale Exp $
 
 @short Configurable shortcut support.

*/
kde_KAccel * kde_new_KAccel(qt_QWidget * pParent, char* psName);
kde_KAccel * kde_new_KAccel1(qt_QWidget * watch, qt_QObject * parent, char* psName);
void kde_del_KAccel( kde_KAccel* p );
kde_KAccelActions* kde_KAccel_actions(kde_KAccel* instPointer);
kde_KAccelActions* kde_KAccel_actions1(kde_KAccel* instPointer);
int kde_KAccel_isEnabled(kde_KAccel* instPointer);
void kde_KAccel_setEnabled(kde_KAccel* instPointer,int bEnabled);
//int kde_KAccel_getAutoUpdate(kde_KAccel* instPointer);
int kde_KAccel_setAutoUpdate(kde_KAccel* instPointer,int bAuto);

/** 
 Create an accelerator action.

 Usage:
<pre>
 insert( "Do Something", i18n("Do Something"),
   i18n("This action allows you to do something really great with this program to "
        "the currently open document."),
   ALT+Key_D, this, SLOT(slotDoSomething()) );
</pre>

*/
kde_KAccelAction* kde_KAccel_insert(kde_KAccel* instPointer,qt_QString * sAction, qt_QString * sLabel, qt_QString * sWhatsThis, kde_KShortcut* cutDef, qt_QObject * pObjSlot, char* psMethodSlot, int bConfigurable, int bEnabled);

/** 
 Same as first insert(), but with separate shortcuts defined for
 3- and 4- modifier defaults.
	 
*/
kde_KAccelAction* kde_KAccel_insert1(kde_KAccel* instPointer,qt_QString * sAction, qt_QString * sLabel, qt_QString * sWhatsThis, kde_KShortcut* cutDef3, kde_KShortcut* cutDef4, qt_QObject * pObjSlot, char* psMethodSlot, int bConfigurable, int bEnabled);

/** 
 This is an overloaded function provided for convenience.
 The advantage of this is when you want to use the same text for the name
 of the action as for the user-visible label.

 Usage: insert( I18N_NOOP("Do Something"), ALT+Key_D, this, SLOT(slotDoSomething()) );

*/
kde_KAccelAction* kde_KAccel_insert2(kde_KAccel* instPointer,char* psAction, kde_KShortcut* cutDef, qt_QObject * pObjSlot, char* psMethodSlot, int bConfigurable, int bEnabled);

/** 
 Similar to the first insert() method, but with the action
 name, short description, help text, and default shortcuts all
 set according to one of the standard accelerators.

*/
kde_KAccelAction* kde_KAccel_insert3(kde_KAccel* instPointer,int identifier, qt_QObject * pObjSlot, char* psMethodSlot, int bConfigurable, int bEnabled);

/** 
 Use this to insert a label into the action list.  This will be
 displayed when the user configures shortcuts.
	 
*/
kde_KAccelAction* kde_KAccel_insert4(kde_KAccel* instPointer,qt_QString * sName, qt_QString * sLabel);
int kde_KAccel_remove(kde_KAccel* instPointer,qt_QString * sAction);
int kde_KAccel_updateConnections(kde_KAccel* instPointer);

/**  Return the shortcut associated with the action named by @p sAction. 
*/
kde_KShortcut* kde_KAccel_shortcut(kde_KAccel* instPointer,qt_QString * sAction);

/**  Set the shortcut to be associated with the action named by @p sAction. 
*/
int kde_KAccel_setShortcut(kde_KAccel* instPointer,qt_QString * sAction, kde_KShortcut* arg1);

/**  Set the slot to be called when the shortcut of the action named
 by @p sAction is pressed. 
*/
int kde_KAccel_setSlot(kde_KAccel* instPointer,qt_QString * sAction, qt_QObject * pObjSlot, char* psMethodSlot);

/**  Enable or disable the action named by @p sAction. 
*/
int kde_KAccel_setEnabled1(kde_KAccel* instPointer,qt_QString * sAction, int bEnabled);

/** 
 Read all shortcuts from @p pConfig, or (if @p pConfig
 is zero) from the application's configuration file
 @ref KGlobal::config().

 The group in which the configuration is stored can be
 set with @ref setConfigGroup().
	 
*/
int kde_KAccel_readSettings(kde_KAccel* instPointer,kde_KConfigBase* pConfig);

/** 
 Write the current shortcuts to @p pConfig,
 or (if @p pConfig is zero) to the application's
 configuration file.
	 
*/
int kde_KAccel_writeSettings(kde_KAccel* instPointer,kde_KConfigBase* pConfig);
void kde_KAccel_setConfigGroup(kde_KAccel* instPointer,qt_QString * arg1);
void kde_KAccel_emitKeycodeChanged(kde_KAccel* instPointer);
int kde_KAccel_insertItem(kde_KAccel* instPointer,qt_QString * sLabel, qt_QString * sAction, char* psKey, int nIDMenu, qt_QPopupMenu* pMenu, int bConfigurable);
int kde_KAccel_insertItem1(kde_KAccel* instPointer,qt_QString * sLabel, qt_QString * sAction, int key, int nIDMenu, qt_QPopupMenu* pMenu, int bConfigurable);
int kde_KAccel_insertStdItem(kde_KAccel* instPointer,int identifier, qt_QString * descr);
int kde_KAccel_connectItem(kde_KAccel* instPointer,qt_QString * sAction, qt_QObject * pObjSlot, char* psMethodSlot, int bActivate);
int kde_KAccel_connectItem1(kde_KAccel* instPointer,int accel, qt_QObject * pObjSlot, char* psMethodSlot);
int kde_KAccel_removeItem(kde_KAccel* instPointer,qt_QString * sAction);
int kde_KAccel_setItemEnabled(kde_KAccel* instPointer,qt_QString * sAction, int bEnable);
void kde_KAccel_changeMenuAccel(kde_KAccel* instPointer,qt_QPopupMenu* menu, int identifier, qt_QString * action);
void kde_KAccel_changeMenuAccel1(kde_KAccel* instPointer,qt_QPopupMenu* menu, int identifier, int accel);

/** 
 @depricated.  Use shortcut().
 Retrieve the key code of the accelerator item with the action name
 @p action, or zero if either the action name cannot be
 found or the current key is set to no key.
	 
*/
int kde_KAccel_currentKey(kde_KAccel* instPointer,qt_QString * action);

/** 
 @depricated.  Use actions().actionPtr().
 Return the name of the accelerator item with the keycode @p key,
 or @ref QString::null if the item cannot be found.
	 
*/
qt_QString * kde_KAccel_findKey(kde_KAccel* instPointer,int key);
int kde_KAccel_stringToKey( qt_QString * arg1);

#endif
