/***************************************************************************
                            kde_KFileTreeBranch.h -  description
                             -------------------
    begin                : Tue Mar 19 20:11:49 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Tue Mar 19 20:11:49 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFILETREEBRANCH
#define KDE_KFILETREEBRANCH

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This is the branch class of the KFileTreeView, which represents one
 branch in the treeview. Every branch has a root which is an url. The branch lists
 the files unter the root. Every branch uses its own dirlister and can have
 its own filter etc.

 
 @short Branch object for @ref KFileTreeView object.

*/

/** 
 constructs a branch for KFileTreeView. Does not yet start to list it.

*/
kde_KFileTreeBranch * kde_new_KFileTreeBranch(kde_KFileTreeView* arg1, kde_KURL* url, qt_QString * name, qt_QPixmap * pix, int showHidden, kde_KFileTreeViewItem* branchRoot);

/** 

*/
kde_KURL* kde_KFileTreeBranch_rootUrl(kde_KFileTreeBranch* instPointer);

/** 
 sets a @ref KFileTreeViewItem as root widget for the branch.
 That must be created outside of the branch. All KFileTreeViewItems
 the branch is allocating will become children of that object.

*/
void kde_KFileTreeBranch_setRoot(kde_KFileTreeBranch* instPointer,kde_KFileTreeViewItem* r);

/** 

*/
kde_KFileTreeViewItem* kde_KFileTreeBranch_root(kde_KFileTreeBranch* instPointer);

/** 

*/
qt_QString * kde_KFileTreeBranch_name(kde_KFileTreeBranch* instPointer);

/** 
 sets the name of the branch.
    
*/
void kde_KFileTreeBranch_setName(kde_KFileTreeBranch* instPointer,qt_QString * n);
qt_QPixmap * kde_KFileTreeBranch_pixmap(kde_KFileTreeBranch* instPointer);
qt_QPixmap * kde_KFileTreeBranch_openPixmap(kde_KFileTreeBranch* instPointer);

/** 

*/
int kde_KFileTreeBranch_showExtensions(kde_KFileTreeBranch* instPointer);

/** 
 sets the root of the branch open or closed.
    
*/
void kde_KFileTreeBranch_setOpen(kde_KFileTreeBranch* instPointer,int setopen);

/** 
 sets if children recursion is wanted or not. If this is switched off, the
 child directories of a just opened directory are not listed internally.
 That means that it can not be determined if the sub directories are
 expandable or not. If this is switched off there will be no call to
 @ref setExpandable.

*/
void kde_KFileTreeBranch_setChildRecurse(kde_KFileTreeBranch* instPointer,int t);

/** 

*/
int kde_KFileTreeBranch_childRecurse(kde_KFileTreeBranch* instPointer);

/** 
 populates a branch. This method must be called after a branch was added
 to  a @ref KFileTreeView using method @ref addBranch.

*/
int kde_KFileTreeBranch_populate(kde_KFileTreeBranch* instPointer,kde_KURL* url, kde_KFileTreeViewItem* currItem);

/** 
 sets printing of the file extensions on or off. If you pass false to this
 slot, all items of this branch will not show their file extensions in the
 tree.

*/
void kde_KFileTreeBranch_setShowExtensions(kde_KFileTreeBranch* instPointer,int visible);
void kde_KFileTreeBranch_setOpenPixmap(kde_KFileTreeBranch* instPointer,qt_QPixmap * pix);

/** 
 allocates a @ref KFileTreeViewItem for the branch
 for new items.
    
*/
kde_KFileTreeViewItem* kde_KFileTreeBranch_createTreeViewItem(kde_KFileTreeBranch* instPointer,kde_KFileTreeViewItem* parent, kde_KFileItem* fileItem);

/** 
 find the according KFileTreeViewItem by an url 
    
*/
kde_KFileTreeViewItem* kde_KFileTreeBranch_findTVIByURL(kde_KFileTreeBranch* instPointer,kde_KURL* arg1);
void kde_KFileTreeBranch_virtual_hook(kde_KFileTreeBranch* instPointer,int identifier, void* data);

#endif
