/***************************************************************************
                            kde_KIconTheme.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KICONTHEME
#define KDE_KICONTHEME

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Class to use/access icon themes in KDE. This class is used by the
 iconloader but can be used by others too.
 
 @short 
 Class to use/access icon themes in KDE.
*/

/**  Load an icon theme by name.  
*/
kde_KIconTheme * kde_new_KIconTheme(qt_QString * name, qt_QString * appName);
void kde_del_KIconTheme( kde_KIconTheme* p );

/**  The stylized name of the icon theme. 
*/
qt_QString * kde_KIconTheme_name(kde_KIconTheme* instPointer);

/**  A description for the icon theme. 
*/
qt_QString * kde_KIconTheme_description(kde_KIconTheme* instPointer);

/**  Return the name of the "example" icon. 
*/
qt_QString * kde_KIconTheme_example(kde_KIconTheme* instPointer);

/**  Return the name of the screenshot. 
*/
qt_QString * kde_KIconTheme_screenshot(kde_KIconTheme* instPointer);

/**  Returns the name of this theme's link overlay. 
*/
qt_QString * kde_KIconTheme_linkOverlay(kde_KIconTheme* instPointer);

/**  Returns the name of this theme's zip overlay. 
*/
qt_QString * kde_KIconTheme_zipOverlay(kde_KIconTheme* instPointer);

/**  Returns the name of this theme's lock overlay. 
*/
qt_QString * kde_KIconTheme_lockOverlay(kde_KIconTheme* instPointer);

/**  Returns the toplevel theme directory. 
*/
qt_QString * kde_KIconTheme_dir(kde_KIconTheme* instPointer);

/**  The themes this icon theme falls back on. 
*/
qt_QStringList* kde_KIconTheme_inherits(kde_KIconTheme* instPointer);

/**  The icon theme exists? 
*/
int kde_KIconTheme_isValid(kde_KIconTheme* instPointer);

/**  The minimum display depth required for this theme. This can either
 be 8 or 32 
*/
int kde_KIconTheme_depth(kde_KIconTheme* instPointer);

/**  The default size of this theme for a certain icon group.

*/
int kde_KIconTheme_defaultSize(kde_KIconTheme* instPointer,int group);

/**  Query available icons for a size and context. 
*/
qt_QStringList* kde_KIconTheme_queryIcons(kde_KIconTheme* instPointer,int size, int context);

/**  Query available icons for a context and preferred size. 
*/
qt_QStringList* kde_KIconTheme_queryIconsByContext(kde_KIconTheme* instPointer,int size, int context);

/**  Lookup an icon in the theme.

*/
kde_KIcon* kde_KIconTheme_iconPath(kde_KIconTheme* instPointer,qt_QString * name, int size, int match);

/**  List all icon themes installed on the system, global and local. 
*/
qt_QStringList* kde_KIconTheme_list( );

/**  Returns the current icon theme. 
*/
qt_QString * kde_KIconTheme_current( );
void kde_KIconTheme_reconfigure( );

#endif
