/***************************************************************************
                            kde_KMimeType.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KMIMETYPE
#define KDE_KMIMETYPE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Represent a mime type, like "text/plain".

 The starting point you need is often the static methods.
 See also @ref KServiceType.
 
 @short 
 Represent a mime type, like "text/plain".
*/

/** 
 Constructor.

 You may pass in arguments to create a mimetype with
 specific properties.
   
*/
kde_KMimeType * kde_new_KMimeType(qt_QString * _fullpath, qt_QString * _type, qt_QString * _icon, qt_QString * _comment, qt_QStringList* _patterns);

/** 
 Construct a mimetype and take all information from a config file.
   
*/
kde_KMimeType * kde_new_KMimeType1(qt_QString * _fullpath);

/** 
 Construct a mimetype and take all information from a desktop file.
   
*/
kde_KMimeType * kde_new_KMimeType2(kde_KDesktopFile* config);

/** 

 The stream must already be positionned at the correct offset
   
*/
kde_KMimeType * kde_new_KMimeType3(qt_QDataStream * _str, int offset);
void kde_del_KMimeType( kde_KMimeType* p );

/** 
 Return the filename of the icon associated with the mimetype.

 The arguments are unused, but provided so that KMimeType-derived classes
 can use them (e.g. @ref KFolderType uses the URL to return one out of 2 icons)

*/
qt_QString * kde_KMimeType_icon(kde_KMimeType* instPointer,qt_QString * arg1, int arg2);

/** 
 This function differs from the above only in that a @ref KURL may be
 provided instead of a @ref QString for convenience.
   
*/
qt_QString * kde_KMimeType_icon1(kde_KMimeType* instPointer,kde_KURL* arg1, int arg2);

/** 
 Use this function only if you don't have a special URL
 for which you search a pixmap.

 This function is useful to find
 out, which icon is usually chosen for a certain mime type. Since
 no URL is passed, it is impossible to obey icon hints in desktop
 entries for example.

*/
qt_QPixmap * kde_KMimeType_pixmap(kde_KMimeType* instPointer,int _group, int _force_size, int _state, qt_QString* _path);

/** 
 Find the pixmap for a given file of this mimetype.

 Convenience method that uses @ref icon(), but also locates and
 load the pixmap.

*/
qt_QPixmap * kde_KMimeType_pixmap1(kde_KMimeType* instPointer,kde_KURL* _url, int _group, int _force_size, int _state, qt_QString* _path);

/** 

*/
qt_QString * kde_KMimeType_comment(kde_KMimeType* instPointer);

/** 
 The arguments are unused, but provided so that KMimeType derived classes
 can use them.

*/
qt_QString * kde_KMimeType_comment1(kde_KMimeType* instPointer,qt_QString * arg1, int arg2);

/** 
 This function differs from the above only in that a @ref KURL may be
 provided instead of a @ref QString for convenience.
   
*/
qt_QString * kde_KMimeType_comment2(kde_KMimeType* instPointer,kde_KURL* arg1, int arg2);

/** 
 Retrieve the list of patterns associated with the MIME Type.
   
*/
qt_QStringList* kde_KMimeType_patterns(kde_KMimeType* instPointer);

/** 
 Load the mimetype from a stream.
   
*/
void kde_KMimeType_load(kde_KMimeType* instPointer,qt_QDataStream * arg1);

/** 
 Save the mimetype to a stream.
   
*/
void kde_KMimeType_save(kde_KMimeType* instPointer,qt_QDataStream * arg1);
qt_QVariant * kde_KMimeType_property(kde_KMimeType* instPointer,qt_QString * _name);
qt_QStringList* kde_KMimeType_propertyNames(kde_KMimeType* instPointer);

/** 
 Convenience method to find the pixmap for a URL

 Call this one when you don't know the mimetype.

*/
qt_QPixmap * kde_KMimeType_pixmapForURL( kde_KURL* _url, long _mode, int _group, int _force_size, int _state, qt_QString* _path);

/** 
 The same functionality as pixmapForURL, but this method returns the name
 of the icon to load. You'll have to use KIconLoader to load the pixmap for it.
 The advantage of this method is that you can store the result, and then use it
 later on for any kind of size.
   
*/
qt_QString * kde_KMimeType_iconForURL( kde_KURL* _url, long _mode);

/** 

 If unavailable, returns QString::null.
   
*/
qt_QString * kde_KMimeType_favIconForURL( kde_KURL* url);

/** 
 Retrieve a pointer to the mime type @p _name or a pointer to the default
         mime type "application/octet-stream".

 0L is @em never returned.

 @em Very @em important: Don't store the result in a KMimeType* !

*/
void * kde_KMimeType_mimeType( qt_QString * _name);

/** 
 This function looks at mode_t first.

 If that does not help it
 looks at the extension.  This is fine for FTP, FILE, TAR and
 friends, but is not for HTTP ( cgi scripts! ). You should use
 @ref KRun instead, but this function returns immediately while
 @ref KRun is async. If no extension matches, then
 @ref KMimeMagic is used if the URL a local file or
 "application/octet-stream" is returned otherwise.

*/
void * kde_KMimeType_findByURL( kde_KURL* _url, long _mode, int _is_local_file, int _fast_mode);

/** 
 Same as findByURL but for local files only - convenience method.

 Equivalent to KURL u; u.setPath(path); return findByURL( u, mode, true, fast_mode );
   
*/
void * kde_KMimeType_findByPath( qt_QString * path, long mode, int fast_mode);

/** 
 Tries to find out the MIME type of a data chunk by looking for
 certain magic numbers and characteristic strings in it.
 Returns application/octet-stream of the type can not be found
 this way.
 If accuracy is not a null pointer, *accuracy is set to the
 accuracy of the match (which is in the range 0..100).
   
*/
void * kde_KMimeType_findByContent( qt_QByteArray* data, int* accuracy);

/** 
 Tries to find out the MIME type of a file by looking for
 certain magic numbers and characteristic strings in it.
 This function is similar to the previous one. Note that the
 file name is not used for determining the file type, it is just
 used for loading the file's contents.
 If accuracy is not a null pointer, *accuracy is set to the
 accuracy of the match (which is in the range 0..100).
   
*/
void * kde_KMimeType_findByFileContent( qt_QString * fileName, int* accuracy);

/** 
 Get all the mimetypes.

 Useful for showing the list of
 available mimetypes.
 More memory consuming than the ones above, don't use unless
 really necessary.
   
*/
//kde_List kde_KMimeType_allMimeTypes( );

/** 

*/
qt_QString * kde_KMimeType_defaultMimeType( );
void kde_KMimeType_loadInternal(kde_KMimeType* instPointer,qt_QDataStream * arg1);
void kde_KMimeType_init(kde_KMimeType* instPointer,kde_KDesktopFile* arg1);

/** 
 Signal a missing mime type
   
*/
//void kde_KMimeType_errorMissingMimeType( qt_QString * _type);

/** 
 This function makes sure that the default mime type exists.
   
*/
//void kde_KMimeType_buildDefaultType( );

/** 
 This function makes sure that vital mime types are installed.
   
*/
//void kde_KMimeType_checkEssentialMimeTypes( );

#endif
