/***************************************************************************
                            kde_KMultipleDrag.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KMULTIPLEDRAG
#define KDE_KMULTIPLEDRAG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This class makes it easy for applications to provide a drag object
 (for drag-n-drop or for clipboard) that has several representations
 of the same data, under different formats.

 Instead of creating a specific class for each case (as would otherwise
 be necessary), you can simply create independent drag objects (e.g.
 a QImageDrag object and a KURLDrag object), and bundle them together
 using KMultipleDrag.

 Sample code for this:

 KMultipleDrag *drag = new KMultipleDrag( parentWidget );
 drag->addDragObject( new QImageDrag( someQImage, 0L ) );
 drag->addDragObject( KURLDrag::newDrag( someKURL, 0L ) );
 drag->drag();

 Note that the drag objects added to the multiple drag become owned by it.
 For that reason their parent should be 0L.

 @author David Faure <david@mandrakesoft.com>
 
 @short 
 This class makes it easy for applications to provide a drag object
 (for drag-n-drop or for clipboard) that has several representations
 of the same data, under different formats.
*/
kde_KMultipleDrag * kde_new_KMultipleDrag(qt_QWidget * dragSource, char* name);

/** 
 Call this to add each underlying drag object to the multipledrag.
     
*/
void kde_KMultipleDrag_addDragObject(kde_KMultipleDrag* instPointer,qt_QDragObject* dragObject);
qt_QByteArray* kde_KMultipleDrag_encodedData(kde_KMultipleDrag* instPointer,char* mime);
char* kde_KMultipleDrag_format(kde_KMultipleDrag* instPointer,int i);

#endif
