/***************************************************************************
                            kde_KTempFile.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KTEMPFILE
#define KDE_KTEMPFILE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 The KTempFile class creates and opens a unique file for temporary use.

 This is especially useful if you need to create a file in a world
 writable directory like /tmp without being vulnerable to so called
 symlink attacks.

 KDE applications, however, shouldn't create files in /tmp in the first 
 place but use the "tmp" resource instead. The standard KTempFile 
 constructor will do that by default.

 To create a temporary file that starts with a certain name
 in the "tmp" resource, one should use:
 KTempFile(locateLocal("tmp", prefix), extension);

 KTempFile does not create any missing directories, but locateLocal() does.

 See also @ref KStandardDirs

 @author Waldo Bastian <bastian@kde.org>
 
 @short 
 The KTempFile class creates and opens a unique file for temporary use.
*/

/** 
 Creates a temporary file with the name:
  <filePrefix><six letters><fileExtension>

 The default @p filePrefix is "$KDEHOME/tmp-$HOST/appname"
 The default @p fileExtension is ".tmp"

*/
kde_KTempFile * kde_new_KTempFile(qt_QString * filePrefix, qt_QString * fileExtension, int mode);

/** 
 The destructor closes the file.
 If autoDelete is enabled the file gets unlinked as well.

*/
void kde_del_KTempFile( kde_KTempFile* p );

/** 
 Turn automatic deletion on or off.
 Automatic deletion is off by default.

*/
void kde_KTempFile_setAutoDelete(kde_KTempFile* instPointer,int autoDelete);

/** 
 Returns the status of the file based on errno. (see errno.h) 
 0 means OK.

 You should check the status after object creation to check 
 whether a file could be created in the first place.

 You may check the status after closing the file to verify that
 the file has indeed been written correctly.

*/
int kde_KTempFile_status(kde_KTempFile* instPointer);

/** 
 The name of the file.

*/
qt_QString * kde_KTempFile_name(kde_KTempFile* instPointer);

/** 
 An integer file descriptor open for writing to the file 

*/
int kde_KTempFile_handle(kde_KTempFile* instPointer);

/** 

*/
//FILE* kde_KTempFile_fstream(kde_KTempFile* instPointer);

/** 

*/
qt_QTextStream* kde_KTempFile_textStream(kde_KTempFile* instPointer);

/** 

*/
qt_QDataStream* kde_KTempFile_dataStream(kde_KTempFile* instPointer);

/** 
 A QFile open for writing to the file

*/
qt_QFile* kde_KTempFile_file(kde_KTempFile* instPointer);

/** 
 Unlinks the file from the directory. The file is
 deleted once the last reader/writer closes it.

*/
void kde_KTempFile_unlink(kde_KTempFile* instPointer);

/** 
 Closes the file.
 Returns 'true' is successful, or 'false' if an error has occured.
 See status() for details about errors.

*/
int kde_KTempFile_close(kde_KTempFile* instPointer);

/** 
 Constructor used by KSaveFile

*/
kde_KTempFile * kde_new_KTempFile1(int arg1);

/** 

 Create function used internally by KTempFile and KSaveFile

*/
int kde_KTempFile_create(kde_KTempFile* instPointer,qt_QString * filePrefix, qt_QString * fileExtension, int mode);
void kde_KTempFile_setError(kde_KTempFile* instPointer,int error);

#endif
