/***************************************************************************
                            kde_KTipDatabase.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KTIPDATABASE
#define KDE_KTIPDATABASE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A database for tips-of-the-day.

 This class provides convenient access to a database containing
 tips of the day. The database is stored in a XML file and parsed
 when a KTipDatabase object is created.

 Once the file is read in, you can access the tips to display
 them in the tip of the day dialog.

 The state of the tipdialog is saved to the applications's config file
 in the group "TipOfDay" with a bool entry "RunOnStart". Check this value
 if you want to allow the user to enable/disable the tipdialog in the
 application's configuration dialog.

 
 @author Matthias Hoelzer-Kluepfel <mhk@caldera.de>

 @short 
 A database for tips-of-the-day.
*/

/** 
 The constructor.

 This reads in the tips from a file with the given name. If no name is
 given, a file called 'application-name/tips' will be loaded.

*/
kde_KTipDatabase * kde_new_KTipDatabase(qt_QString * tipFile);

/** 
 Returns the current tip.
   
*/
qt_QString * kde_KTipDatabase_tip(kde_KTipDatabase* instPointer);

/** 
 The next tip will become the current one.
   
*/
void kde_KTipDatabase_nextTip(kde_KTipDatabase* instPointer);

/** 
 The previous tip will become the current one.
   
*/
void kde_KTipDatabase_prevTip(kde_KTipDatabase* instPointer);

#endif
