/***************************************************************************
                            KFileDialog.java -  description
                             -------------------
    begin                : Fri Mar 15 15:14:30 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar 15 15:14:30 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Provides a user (and developer) friendly way to
 select files and directories.

 The widget can be used as a drop in replacement for the
 {@link QFileDialog} widget, but has greater functionality and a nicer GUI.

 You will usually want to use one of the static methods
 {@link #getOpenFileName}, {@link #getSaveFileName}, {@link #getOpenURL}
 or for multiple files {@link #getOpenFileNames} or {@link #getOpenURLs}.

 The dialog has been designed to allow applications to customise it
 by subclassing. It uses geometry management to ensure that subclasses
 can easily add children that will be incorporated into the layout.

 See {@link KFileDialogSignals} for signals emitted by KFileDialog.

 See {@link KFileDialogEventHandling} for event handlers to override in subclasses of KFileDialog.

 @author Richard J. Moore <rich@kde.org>, Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A file selection dialog.

*/
public class KFileDialog extends KDialogBase  {
	protected KFileDialog(Class dummy){super((Class) null);}

	private native void newKFileDialog( String startDir, String filter, QWidget parent, String name, boolean modal);

/** 
 Constructs a file dialog.

*/
	public KFileDialog( String startDir, String filter, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKFileDialog( startDir, filter, parent, name, modal);
	}

/** 
 Destructs the file dialog.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

*/
	public native KURL selectedURL();

/** 

*/
	public native ArrayList selectedURLs();

/** 

*/
	public native KURL baseURL();

/** 
 Returns the full path of the selected file in the local filesystem.
 (Local files only)
     
*/
	public native String selectedFile();

/** 
 Returns a list of all selected local files.
     
*/
	public native ArrayList selectedFiles();

/** 
 Sets the directory to view.

*/
	public native void setURL( KURL url, boolean clearforward);
	public native void setURL( KURL url);

/** 
 Sets the file name to preselect to <code>name</code>

 This takes absolute URLs and relative file names.
     
*/
	public native void setSelection( String name);

/** 
 Sets the operational mode of the filedialog to <code>Saving</code>, <code>Opening</code>
 or <code>Other.</code> This will set some flags that are specific to loading
 or saving files. E.g. {@link #setKeepLocation} makes mostly sense for
 a save-as dialog. So setOperationMode( KFileDialog.Saving ); sets
 setKeepLocation for example.

 The default mode is <code>Other.</code>

 Call this method right after instantiating KFileDialog.

*/
	public native void setOperationMode( int arg1);

/** 

*/
	public native int operationMode();

/** 
 Sets whether the filename/url should be kept when changing directories.
 This is for example useful when having a predefined filename where
 the full path for that file is searched.

 This is implicitly set when {@link #operationMode} is KFileDialog.Saving

 getSaveFileName() and getSaveURL() set this to true by default, so that
 you can type in the filename and change the directory without having
 to type the name again.
     
*/
	public native void setKeepLocation( boolean keep);

/** 

*/
	public native boolean keepsLocation();

/** 
 Sets the filter to be used to <code>filter.</code>

 You can set more
 filters for the user to select seperated by '\n'. Every
 filter entry is defined through namefilter|text to diplay.
 If no | is found in the expression, just the namefilter is
 shown. Examples:

 <pre>
 kfile.setFilter(".cpp|C++ Source Files\n.h|Header files");
 kfile.setFilter(".cpp");
 kfile.setFilter(".cpp|Sources (.cpp)");
 kfile.setFilter(".cpp .cc .C|C++ Source Files\n.h .H|Header files");
 </pre>

 Note: The text to display is not parsed in any way. So, if you
 want to show the suffix to select by a specific filter, you must
 repeat it.

 If the filter contains a '/', a mimetype-filter is assumed. You can
 specify multiple mimetypes like this (separated with space):

 <pre>
 kfile.setFilter( "image/png text/html text/plain" );
 </pre>

*/
	public native void setFilter( String filter);

/** 
 Returns the current filter as entered by the user or one of the
 predefined set via {@link #setFilter}.

*/
	public native String currentFilter();

/** 
 Sets the filter up to specify the output type.

 Do not use in conjunction with {@link #setFilter}

     
*/
//	public native void setFilterMimeType( String label, KMimeType_List types, KMimeType_Ptr defaultType);

/** 
 Returns the mimetype for the desired output format.

 This is only valid if {@link #setFilterMimeType} has been called
 previously.

*/
//	public native KMimeType_Ptr currentFilterMimeType();

/** 
 Sets the filter up to specify the output type.

 Do not use in conjunction with {@link #setFilter}
     
*/
	public native void setMimeFilter( String[] types, String defaultType);
	public native void setMimeFilter( String[] types);

/** 
 The mimetype for the desired output format.

 This is only valid if {@link #setMimeFilter} has been called
 previously.

*/
	public native String currentMimeFilter();

/** 
  Clears any mime- or namefilter. Does not reload the directory.
     
*/
	public native void clearFilter();

/** 

 Add a preview widget and enter the preview mode.

 In this mode
 the dialog is split and the right part contains your widget.
 This widget has to inherit {@link QWidget} and it has to implement
 a slot {@link #showPreview}; which is called
 every time the file changes. You may want to look at
 koffice/lib/kofficecore/koFilterManager.cc for some hints :)

 Ownership is transferred to KFileDialog. You need to create the
 preview-widget with "new", i.e. on the heap.
     
*/
	public native void setPreviewWidget( QWidget w);

/** 
 Adds a preview widget and enters the preview mode.

 In this mode the dialog is split and the right part contains your
 preview widget.

 Ownership is transferred to KFileDialog. You need to create the
 preview-widget with "new", i.e. on the heap.

*/
	public native void setPreviewWidget( KPreviewWidgetBase w);

/** 

     
*/
	public native void setMode( int m);

/** 
 Sets the mode of the dialog.

 The mode is defined as (in kfile.h):
 <pre>    enum Mode {
                      File         = 1,
                      Directory    = 2,
                      Files        = 4,
                      ExistingOnly = 8,
                      LocalOnly    = 16
                    };
 </pre>
 You can OR the values, e.g.
 <pre>
 KFile.Mode mode = static_cast<KFile.Mode>( KFile.Files |
                                              KFile.ExistingOnly |
                                              KFile.LocalOnly );
 setMode( mode );
 </pre>
     
*/
//	public native void setMode( int m);

/** 
 Returns the mode of the filedialog.

*/
	public native int mode();

/** 
 Sets the text to be displayed in front of the selection.

 The default is "Location".
 Most useful if you want to make clear what
 the location is used for.
     
*/
	public native void setLocationLabel( String text);

/** 
 Returns a pointer to the toolbar.

 You can use this to insert custom
 items into it, e.g.:
 <pre>
      yourAction = new KAction( i18n("Your Action"), 0,
                                this, SLOT(" yourSlot()"),
                                this, "action name" );
      yourAction.plug( kfileDialog.toolBar() );
 </pre>
     
*/
	public native KToolBar toolBar();

/** 

*/
	public native KPushButton okButton();

/** 

*/
	public native KPushButton cancelButton();

/** 

*/
	public native KActionCollection actionCollection();

/** 
 Creates a modal file dialog and return the selected
 filename or an empty string if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
	public static native String getOpenFileName( String startDir, String filter, QWidget parent, String caption);
	public static native String getOpenFileName();

/** 
 Creates a modal file dialog and returns the selected
 filenames or an empty list if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
	public static native ArrayList getOpenFileNames( String startDir, String filter, QWidget parent, String caption);

/** 
 Creates a modal file dialog and returns the selected
 URL or an empty string if none was chosen.

 Note that with
 this method the user must select an existing URL.

*/
	public static native KURL getOpenURL( String startDir, String filter, QWidget parent, String caption);
	public static native KURL getOpenURL();

/** 
 Creates a modal file dialog and returns the selected
 URLs or an empty list if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
	public static native ArrayList getOpenURLs( String startDir, String filter, QWidget parent, String caption);

/** 
 Creates a modal file dialog and returns the selected
 filename or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing filename.

*/
	public static native String getSaveFileName( String startDir, String filter, QWidget parent, String caption);
	public static native String getSaveFileName();

/** 
 Creates a modal file dialog and returns the selected
 filename or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing filename.

*/
	public static native KURL getSaveURL( String startDir, String filter, QWidget parent, String caption);
	public static native KURL getSaveURL();

/** 
 Creates a modal file dialog and returns the selected
 directory or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing directory.

*/
	public static native String getExistingDirectory( String startDir, QWidget parent, String caption);
	public static native String getExistingDirectory();

/** 
 Creates a modal file dialog with an image previewer and returns the
 selected url or an empty string if none was chosen.

*/
	public static native KURL getImageOpenURL( String startDir, QWidget parent, String caption);
	public static native KURL getImageOpenURL();

/** 
 adds a entry of the current directory. If disableUpdating is set
 to true, it will care about clever updating

*/
	protected native void addDirEntry( KFileItem entry, boolean disableUpdating);

/** 
 rebuild geometry managment.

      
*/
	protected native void initGUI();

/** 
 called when an item is highlighted/selected in multiselection mode.
 handles setting the locationEdit.
     
*/
	protected native void multiSelectionChanged();

/** 
 Reads configuration and applies it (size, recent directories, ...)
     
*/
	protected native void readConfig( KConfig arg1, String group);
	protected native void readConfig( KConfig arg1);

/** 
 Saves the current configuration
     
*/
	protected native void writeConfig( KConfig arg1, String group);
	protected native void writeConfig( KConfig arg1);

/** 
 Reads the recent used files and inserts them into the location combobox
     
*/
	protected native void readRecentFiles( KConfig arg1);

/** 
 Saves the entries from the location combobox.
     
*/
	protected native void saveRecentFiles( KConfig arg1);

/** 
 Parses the string "line" for files. If line doesn't contain any ", the
 whole line will be interpreted as one file. If the number of " is odd,
 an empty list will be returned. Otherwise, all items enclosed in " "
 will be returned as correct urls.
     
*/
	protected native ArrayList tokenize( String line);
	protected native ArrayList parseSelectedURLs();
	protected native void urlEntered( KURL arg1);
	protected native void enterURL( KURL url);
	protected native void enterURL( String url);
	protected native void locationActivated( String url);
	protected native void toolbarCallback( int arg1);
	protected native void slotFilterChanged();
	protected native void pathComboChanged( String arg1);
	protected native void fileHighlighted( KFileItem i);
	protected native void fileSelected( KFileItem i);
	protected native void slotStatResult( Job job);
	protected native void slotLoadingFinished();
	protected native void dirCompletion( String arg1);
	protected native void fileCompletion( String arg1);
	protected native void updateStatusLine( int dirs, int files);
	protected native void slotOk();
	protected native void accept();
	protected native void slotCancel();
	protected native void addToRecentDocuments();
	public static final int Other = 0;
	public static final int Opening = 0;
	public static final int Saving = 1;
}
