/***************************************************************************
                            KIntSpinBox.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

  An integer inputline with scrollbar and slider.

  The class provides an easy interface to use other
  numeric systems then the decimal.

 See {@link KIntSpinBoxSignals} for signals emitted by KIntSpinBox.

 See {@link KIntSpinBoxEventHandling} for event handlers to override in subclasses of KIntSpinBox.

 @short A spin box widget for non-decimal numbers.
 
*/
public class KIntSpinBox extends QSpinBox  {
	protected KIntSpinBox(Class dummy){super((Class) null);}

	private native void newKIntSpinBox( QWidget parent, String name);

/** 
  Constructor.

  Constructs a widget with an integer inputline with a little scrollbar
  and a slider, with minimal value 0, maximal value 99, step 1, base 10
  and initial value 0.
     
*/
	public KIntSpinBox( QWidget parent, String name) {
		super((Class) null);
		newKIntSpinBox( parent, name);
	}
	private native void newKIntSpinBox();
	public KIntSpinBox() {
		super((Class) null);
		newKIntSpinBox();
	}
	private native void newKIntSpinBox( int lower, int upper, int step, int value, int base, QWidget parent, String name);

/** 
  Constructor.

  Constructs a widget with an integer inputline with a little scrollbar
  and a slider.

*/
	public KIntSpinBox( int lower, int upper, int step, int value, int base, QWidget parent, String name) {
		super((Class) null);
		newKIntSpinBox( lower, upper, step, value, base, parent, name);
	}
	private native void newKIntSpinBox( int lower, int upper, int step, int value);
	public KIntSpinBox( int lower, int upper, int step, int value) {
		super((Class) null);
		newKIntSpinBox( lower, upper, step, value);
	}

/** 
  Destructor.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the base in which the numbers in the spin box are represented.
     
*/
	public native void setBase( int base);

/** 

*/
	public native int base();

/** 
 sets focus and optionally marks all text

     
*/
	public native void setEditFocus( boolean mark);

/** 
  Overloaded the method in QSpinBox
  to make use of the base given in the constructor.
     
*/
	protected native String mapValueToText( int arg1);

/** 
  Overloaded the method in QSpinBox
  to make use of the base given in the constructor.
     
*/
	protected native int mapTextToValue( int[] arg1);
}
