/***************************************************************************
                            KServiceType.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A service type is the generic notion for a mimetype, a type of service
 instead of a type of file.
 For instance, KOfficeFilter is a service type.
 It is associated to services according to the user profile (kuserprofile.h)
 
 @short 
 A service type is the generic notion for a mimetype, a type of service
 instead of a type of file.
*/
public class KServiceType extends KSycocaEntry  {
	protected KServiceType(Class dummy){super((Class) null);}

	private native void newKServiceType( String _fullpath, String _name, String _icon, String _comment);

/** 
 Constructor.  You may pass in arguments to create a servicetype with
 specific properties
   
*/
	public KServiceType( String _fullpath, String _name, String _icon, String _comment) {
		super((Class) null);
		newKServiceType( _fullpath, _name, _icon, _comment);
	}
	private native void newKServiceType( String _fullpath);

/** 
 Construct a service type and take all informations from a config file.

*/
	public KServiceType( String _fullpath) {
		super((Class) null);
		newKServiceType( _fullpath);
	}
	private native void newKServiceType( KDesktopFile config);

/** 
 Construct a service type and take all informations from a deskop file.
   
*/
	public KServiceType( KDesktopFile config) {
		super((Class) null);
		newKServiceType( config);
	}
	private native void newKServiceType( QDataStream _str, int offset);

/** 

 The stream must already be positionned at the correct offset
   
*/
	public KServiceType( QDataStream _str, int offset) {
		super((Class) null);
		newKServiceType( _str, offset);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

*/
	public native String icon();

/** 

*/
	public native String comment();

/** 

*/
	public native String name();

/** 

*/
	public native String desktopEntryPath();

/** 

*/
	public native boolean isDerived();

/** 
 If this service type inherits from another service type,
 return the name of the parent. Otherwise String.null.
   
*/
	public native String parentServiceType();
	public native QVariant property( String _name);
	public native ArrayList propertyNames();
	public native boolean isValid();
	public native int propertyDef( String _name);
	public native ArrayList propertyDefNames();
	public native String propertyDefs();

/** 
 Save ourselves to the data stream.
   
*/
	public native void save( QDataStream arg1);

/** 
 Load ourselves from the data stream.
   
*/
	public native void load( QDataStream arg1);

/** 

*/
	public static native int serviceType( String _name);

/** 

*/
//	public static native KService_List offers( String _servicetype);

/** 

*/
	public static native List allServiceTypes();
	protected native void init( KDesktopFile config);
}
