/***************************************************************************
                            KSimpleConfig.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KDE Configuration entries

 This is a trivial extension of {@link KConfig} for applications that need
 only one configuration file and no default system.
 A difference with KConfig is that when the data in memory is written back
 it is not merged with what is on disk.
 Whatever is in memory simply replaces what is on disk entirely.

 See {@link KSimpleConfigSignals} for signals emitted by KSimpleConfig.

 See {@link KSimpleConfigEventHandling} for event handlers to override in subclasses of KSimpleConfig.

 @author Kalle Dalheimer <kalle@kde.org>, Preston Brown <pbrown@kde.org>

 @version $Id: KSimpleConfig.java,v 1.5 2002/01/31 04:49:01 rdale Exp $

 @short KDE Configuration Management class with deletion ability.
*/
public class KSimpleConfig extends KConfig  {
	protected KSimpleConfig(Class dummy){super((Class) null);}

	private native void newKSimpleConfig( String fileName, boolean bReadOnly);

/** 
 Construct a KSimpleConfig object and make it either read-write
 or read-only.

*/
	public KSimpleConfig( String fileName, boolean bReadOnly) {
		super((Class) null);
		newKSimpleConfig( fileName, bReadOnly);
	}
	private native void newKSimpleConfig( String fileName);
	public KSimpleConfig( String fileName) {
		super((Class) null);
		newKSimpleConfig( fileName);
	}

/** 
 Destructor.

 Writes back any dirty configuration entries.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native void sync();
}
