/***************************************************************************
                            PartManager.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The part manager is an object which knows about a collection of parts
 (even nested ones) and handles activation/deactivation.

 Applications that want to embed parts without merging GUIs
 only use a KParts.PartManager. Those who want to merge GUIs use a
 {@link KParts#MainWindow} for example, in addition to a part manager.

 Parts know about the part manager to add nested parts to it.
 See also {@link KParts#Part}.manager() and {@link KParts#Part}.setManager().
 
 See {@link PartManagerSignals} for signals emitted by PartManager.

 See {@link PartManagerEventHandling} for event handlers to override in subclasses of PartManager.

 @short 
 The part manager is an object which knows about a collection of parts
 (even nested ones) and handles activation/deactivation.
*/
public class PartManager extends QObject  {
	protected PartManager(Class dummy){super((Class) null);}

	private native void newPartManager( QWidget parent, String name);

/** 
 Constructs a part manager.

*/
	public PartManager( QWidget parent, String name) {
		super((Class) null);
		newPartManager( parent, name);
	}
	private native void newPartManager( QWidget parent);
	public PartManager( QWidget parent) {
		super((Class) null);
		newPartManager( parent);
	}
	private native void newPartManager( QWidget topLevel, QObject parent, String name);

/** 
 Constructs a part manager.

*/
	public PartManager( QWidget topLevel, QObject parent, String name) {
		super((Class) null);
		newPartManager( topLevel, parent, name);
	}
	private native void newPartManager( QWidget topLevel, QObject parent);
	public PartManager( QWidget topLevel, QObject parent) {
		super((Class) null);
		newPartManager( topLevel, parent);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the selection policy of the partmanager.
   
*/
	public native void setSelectionPolicy( int policy);

/** 
 Returns the current selection policy.
   
*/
	public native int selectionPolicy();

/** 
 Specifies whether the partmanager should handle/allow nested parts
 or not.

  This is a property the shell has to set/specify. Per
 default we assume that the shell cannot handle nested
 parts. However in case of a KOffice shell for example we allow
 nested parts.  A Part is nested (a child part) if its parent
 object inherits {@link KParts#Part}.  If a child part is activated and
 nested parts are not allowed/handled, then the top parent part in
 the tree is activated.
   
*/
	public native void setAllowNestedParts( boolean allow);

/** 

*/
	public native boolean allowNestedParts();

/** 
 Specifies whether the partmanager should ignore mouse click events for
 scrollbars or not. If the partmanager ignores them, then clicking on the
 scrollbars of a non-active/non-selected part will not change the selection
 or activation state.

 The default value is false (read: scrollbars are NOT ignored).
   
*/
	public native void setIgnoreScrollBars( boolean ignore);

/** 

*/
	public native boolean ignoreScrollBars();

/** 

   
*/
	public native boolean eventFilter( QObject obj, QEvent ev);

/** 
 Adds a part to the manager.

 Sets it to the active part automatically if <code>setActive</code> is true (default ).
   
*/
	public native void addPart( Part part, boolean setActive);
	public native void addPart( Part part);

/** 
 Removes a part from the manager (this does not delete the object) .

 Sets the active part to 0 if <code>part</code> is the {@link #activePart} .
   
*/
	public native void removePart( Part part);

/** 
 Replaces <code>oldPart</code> with <code>newPart</code>, and sets <code>newPart</code> as active if
 <code>setActive</code> is true.
 This is an optimised version of {@link removePart} + {@link addPart}
   
*/
	public native void replacePart( Part oldPart, Part newPart, boolean setActive);
	public native void replacePart( Part oldPart, Part newPart);

/** 
 Sets the active part.

 The active part receives activation events.

 <code>widget</code> can be used to specify which widget was responsible for the activation.
 This is important if you have multiple views for a document/part , like in KOffice .
   
*/
	public native void setActivePart( Part part, QWidget widget);
	public native void setActivePart( Part part);

/** 
 Returns the active part.

*/
	public native Part activePart();

/** 
 Returns the active widget of the current active part (see {@link activePart} ).
   
*/
	public native QWidget activeWidget();

/** 
 Sets the selected part.

 The selected part receives selection events.

 <code>widget</code> can be used to specify which widget was responsible for the selection.
 This is important if you have multiple views for a document/part , like in KOffice .
   
*/
	public native void setSelectedPart( Part part, QWidget widget);
	public native void setSelectedPart( Part part);

/** 
 Returns the current selected part.
   
*/
	public native Part selectedPart();

/** 
 Returns the selected widget of the current selected part (see {@link selectedPart} ).
   
*/
	public native QWidget selectedWidget();

/** 
 Returns the list of parts being managed by the partmanager.
   
*/
//	public native QPtrList<Part>* parts();

/** 
 Adds the <code>topLevel</code> widget to the list of managed toplevel widgets.
 Usually a PartManager only listens for events (for activation/selection)
 for one toplevel widget (and its children) , the one specified in the
 constructor. Sometimes however (like for example when using the KDE dockwidget
 library) , it is necessary to extend this.
   
*/
	public native void addManagedTopLevelWidget( QWidget topLevel);

/** 
 Removes the <code>topLevel</code> widget from the list of managed toplevel widgets.

*/
	public native void removeManagedTopLevelWidget( QWidget topLevel);

/** 
 Changes the active instance when the active part changes.
 The active instance is used by KBugReport and KAboutDialog.
 Override if you really need to - usually you don't need to.
   
*/
	protected native void setActiveInstance( KInstanceInterface instance);

/** 
 Removes a part when it is destroyed.

*/
	protected native void slotObjectDestroyed();

/** 

   
*/
	protected native void slotWidgetDestroyed();

/** 

   
*/
	protected native void slotManagedTopLevelWidgetDestroyed();
	public static final int Direct = 0;
	public static final int TriState = 1;
}
