/***************************************************************************
                            StatusbarProgress.java -  description
                             -------------------
    begin                : Wed Jan 30 16:02:13 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Jan 30 16:02:13 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is a special IO progress widget.

 Similarly to {@link #DefaultProgress},
 it's purpose is to show a progress of the IO operation.

 Instead of creating a separate window, this is only a widget that can be
 easily embedded in a statusbar.

 Usage of StatusbarProgress is little different.
 This dialog will be a part of some application.
 <pre>
 // create a dialog
 StatusbarProgress statusProgress;
 statusProgress = new StatusbarProgress( statusBar() );
 statusBar().insertWidget( statusProgress, statusProgress.width() , 0 );
 ...
 // create job and connect it to the progress
 CopyJob job = KIO.copy(...);
 statusProgress.setJob( job );
 ...
 </pre>

 See {@link StatusbarProgressSignals} for signals emitted by StatusbarProgress.

 See {@link StatusbarProgressEventHandling} for event handlers to override in subclasses of StatusbarProgress.

 @author Matej Koss <koss@miesto.sk>

 @short IO progress widget for embedding in a statusbar.

*/
public class StatusbarProgress extends ProgressBase  {
	protected StatusbarProgress(Class dummy){super((Class) null);}

	private native void newStatusbarProgress( QWidget parent, boolean button);
	public StatusbarProgress( QWidget parent, boolean button) {
		super((Class) null);
		newStatusbarProgress( parent, button);
	}
	private native void newStatusbarProgress( QWidget parent);
	public StatusbarProgress( QWidget parent) {
		super((Class) null);
		newStatusbarProgress( parent);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native void setJob( Job job);
	public native void slotClean();
	public native void slotTotalSize( Job arg1, int size);
	public native void slotPercent( Job arg1, long percent);
	public native void slotSpeed( Job arg1, long bytes_per_second);
	protected native void setMode();
	public native boolean eventFilter( QObject arg1, QEvent arg2);
	public static final int None = 0;
	public static final int Label = 1;
	public static final int Progress = 2;
}
