/*
 * KdeMenuSample.java
 *
 * Created on 8. Mrz 2002, 20:31
 */

//package com.werpu.sample3;

//import com.werpu.common.*;
import org.kde.koala.kdejava;
import org.kde.qt.qtjava;

import org.kde.koala.KMainWindow;
import org.kde.qt.QPopupMenu;
import org.kde.qt.QTextView;
import org.kde.koala.KMenuBar;
import org.kde.koala.KApplication;
import org.kde.koala.KURL;
import org.kde.koala.KFileDialog;
import org.kde.koala.KMessageBox;
import org.kde.qt.QColor;
import org.kde.qt.QButton;
import org.kde.koala.KPushButton;



/**
 * @author  Werner Punz werpu@gmx.at
 * To Java translated KDE Menu Example from
 * The kde.org KDE Tutorial from Antonio Larrosa Jimnez 
 * http://person.wanadoo.es/antlarr/tutorial
 */
public class KdeMenuSample extends KMainWindow {
    
   static {
      qtjava.initialize();
      kdejava.initialize();
	}
    
    KApplication kApp = null;

    /** Creates a new instance of KdeMenuSample */
    public KdeMenuSample(KApplication kApp) {
        super(null,"Menu Sample",1);
        this.kApp = kApp;
        setCaption("KDE3 Tutorial");
        createMenu();
        QTextView centralWidget = createTextView();
        
        this.setCentralWidget(centralWidget);
    }
    
    
    /**
     * creates the file menu
     */
    private QPopupMenu createFileMenu() {
        QPopupMenu fileMenu = new QPopupMenu(this);
        fileMenu.insertItem("&Open",this,this.SLOT("fileOpen()"));
        fileMenu.insertItem("&Save",this,this.SLOT("fileSave()"));
        fileMenu.insertItem("&Quit",kApp,kApp.SLOT("quit()"));
        return fileMenu;
    }
    
    /**
     * creates the about menu
     */
    private QPopupMenu createAboutMenu() {
        StringBuffer aboutText = new StringBuffer();
        
        aboutText.append("Menu Example: \n ");
        aboutText.append("Originally written by Antonio Larrosa Jimnez larossa@kde.org \n");
        aboutText.append("Translated to Java by Werner Punz werpu@gmx.at \n");
        aboutText.append("Simple KDE Tutorial\n");
        aboutText.append("This tutorial comes with ABSOLUTELY NO WARRANTY\n");
        aboutText.append("This is free software, and you are welcome to redistribute it\n");
        aboutText.append("under certain conditions\n");
        
        QPopupMenu aboutMenu = helpMenu(aboutText.toString(),true);
        
        return aboutMenu;
    }
    
    /**
     * creates the menu
     */
    private void createMenu() {
       KMenuBar mainMenu = (KMenuBar) menuBar();
       mainMenu.insertItem("&File",createFileMenu());
       mainMenu.insertSeparator();
       mainMenu.insertItem("&About",createAboutMenu());
    }
       
    /**
     * creates the textview of the window
     */
    private QTextView createTextView() {
        StringBuffer textBuf = new StringBuffer();
        textBuf.append("<H2>Hello World !</H2><BR>This is a simple");
        textBuf.append(" window with <I><font size=5><B>R<font color=red");
        textBuf.append(" size=5>ich </font><font color=blue size=5>Text");
        textBuf.append("</font></B></I> capabilities<BR>Try to resize");
        textBuf.append(" this window, all this is automatic !</H2>");
        
        QTextView mainTextView = new QTextView(this,"");
        mainTextView.setText(textBuf.toString());
        
        
        return mainTextView;
    }
    
    //--------------------------------------------------------------
    //Slots
    //--------------------------------------------------------------
    public void fileOpen() {
         //System.out.println("File Open");
         KURL filename = KFileDialog.getOpenURL("", "*", this,"Open File" );
         String msg = "Now this app should open the url " + filename.url();
         KMessageBox.information(this , msg, "Information" , "fileOpenInformationDialog" );
    }
    
    public void fileSave() {
        KURL filename = KFileDialog.getSaveURL( "" , "*", this, "Save File" );
    }
    
    //----------------------------------------------------------------
    // main method
    //----------------------------------------------------------------
    public static void main(String [] argv) {
        KApplication menuApp = new KApplication(argv,"A simple menu example");
        KdeMenuSample mainWnd = new KdeMenuSample(menuApp);
        
        mainWnd.resize(100,300);
        menuApp.setMainWidget(mainWnd);
        
        mainWnd.show();
        menuApp.exec();
    }
}
