/***************************************************************************
                            HTMLStyleElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLSTYLEELEMENT_H
#define HTMLSTYLEELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Style information. A more detailed style sheet object model is
 planned to be defined in a separate document. See the <a
 href="http://www.w3.org/TR/REC-html40/present/styles.-[html edef]-STYLE">
 STYLE element definition </a> in HTML 4.0.

 
 @short 
 Style information.
*/
@class StyleSheet; 

@interface HTMLStyleElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Enables/disables the style sheet.

     
*/
- (BOOL) disabled;

/** 
 see @ref disabled
     
*/
- setDisabled: (BOOL)arg1;

/** 
 Designed for use with one or more target media. See the <a
 href="http://www.w3.org/TR/REC-html40/present/styles.-[html adef]-media">
 media attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) media;

/** 
 see @ref media
     
*/
- setMedia: (NSString *)arg1;

/** 
 The style sheet language (Internet media type). See the <a
 href="http://www.w3.org/TR/REC-html40/present/styles.-[html adef]-type-STYLE">
 type attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) type;

/** 
 see @ref type
     
*/
- setType: (NSString *)arg1;

/** 
 Introduced in DOM Level 2
 This method is from the LinkStyle interface

 The style sheet.
     
*/
- (StyleSheet*) sheet;
@end

#endif
