/***************************************************************************
                            KAboutData.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KABOUTDATA_H
#define KABOUTDATA_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This class is used to store information about a program. It can store
 such values as version number, program name, home page, email address
 for bug reporting, multiple authors and contributors
 (using @ref KAboutPerson), license and copyright information.

 Currently, the values set here are shown by the "About" box
 (see @ref KAboutDialog), used by the bug report dialog (see @ref KBugReport),
 and by the help shown on command line (see @ref KCmdLineArgs).

 @author Espen Sand (espen@kde.org), David Faure (faure@kde.org)

 @version $Id: KAboutData.h,v 1.3 2002/03/15 02:12:19 rdale Exp $
 
 @short Holds information needed by the "About" box and other
 classes.

*/
@interface  KAboutData : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Constructor.

     
*/
- initWithText: (NSString *)appName programName: (NSString *)programName version: (NSString *)version shortDescription: (NSString *)shortDescription licenseType: (int)licenseType copyrightStatement: (NSString *)copyrightStatement text: (NSString *)text homePageAddress: (NSString *)homePageAddress bugsEmailAddress: (NSString *)bugsEmailAddress;
- initWithText: (NSString *)appName programName: (NSString *)programName version: (NSString *)version ;
- (void) dealloc;

/** 
 Defines an author. You can call this function as many times you
 need. Each entry is appended to a list. The person in the first entry
 is assumed to be the leader of the project.

     
*/
- addAuthor: (NSString *)name task: (NSString *)task emailAddress: (NSString *)emailAddress webAddress: (NSString *)webAddress;
- addAuthor: (NSString *)name ;

/** 
 Defines a person that deserves credit. You can call this function
 as many times you need. Each entry is appended to a list.

     
*/
- addCredit: (NSString *)name task: (NSString *)task emailAddress: (NSString *)emailAddress webAddress: (NSString *)webAddress;
- addCredit: (NSString *)name ;

/** 
 Sets the name of the translator of the gui. Since this depends
 on the language, just use a dummy text marked for translation.

 For example:
 setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names")
 ,I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

 The translator can then translate this dummy text with his name
 or with a list of names separated with ",".
 If there is no translation or the application is used with the
 default language, this function call is ignored.

 Note: If you are using the default KDE automake environment,
 there is no need to use this function, because the two
 default strings above are added to the applications po file
 automatically.

*/
- setTranslator: (NSString *)name emailAddress: (NSString *)emailAddress;

/** 
 Defines a licence text.

 The text will be translated if it got marked for
 translations with the -I18N_NOOP macro.

 Example:
 setLicenseText( I18N_NOOP("This is my license"));

 NOTE: No copy of the text is made.
     
*/
- setLicenseText: (NSString *)license;

/** 
 Defines a licence text. 

*/
- setLicenseTextFile: (NSString *)file;

/** 

*/
- (NSString *) appName;

/** 

*/
- (NSString *) programName;

/** 

*/
- (NSString *) version;

/** 

*/
- (NSString *) shortDescription;

/** 

*/
- (NSString *) homepage;

/** 

*/
- (NSString *) bugAddress;

/** 

*/
- (NSString *) otherText;

/** 
 Returns the license. If the licenseType argument of the constructor has been
 used, any text defined by @ref setLicenseText is ignored,
 and the standard text for the chosen license will be returned.

*/
- (NSString *) license;

/** 

*/
- (NSString *) copyrightStatement;

/**  

*/
+ (NSString *) aboutTranslationTeam;
+ (int) License_Custom;
+ (int) License_File;
+ (int) License_Unknown;
+ (int) License_GPL;
+ (int) License_GPL_V2;
+ (int) License_LGPL;
+ (int) License_LGPL_V2;
+ (int) License_BSD;
+ (int) License_Artistic;
+ (int) License_QPL;
+ (int) License_QPL_V1_0;
@end

#endif
