/***************************************************************************
                            KApplication.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KAPPLICATION_H
#define KAPPLICATION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KInstance.h>
#include <qtobjc/QApplication.h>

/**

 Controls and provides information to all KDE applications.

 Only one object of this class can be instantiated in a single app.
 This instance is always accessible via the @ref -kApplication method.

 This class provides the following services to all KDE applications.

 @author Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: KApplication.h,v 1.3 2002/03/15 02:12:19 rdale Exp $

 @short Controls and provides information to all KDE applications.

*/
@class DCOPClient; 
@class KURL; 
@class QPixmap; 

@interface KApplication : QApplication 

/** 
 This constructor takes aboutData and command line
  arguments from @ref KCmdLineArgs.

*/
- initWithBOOL: (BOOL)allowStyles GUIenabled: (BOOL)GUIenabled;
- init;

/** 
 Constructor. Parses command-line arguments. Use this constructor to use KApplication
 in a Motif or Xt program.

*/
//- initWithDisplay: (Display*)display argc: (int)argc argv: (NSString *)argv rAppName: (NSString *)rAppName allowStyles: (BOOL)allowStyles GUIenabled: (BOOL)GUIenabled;
//- initWithDisplay: (Display*)display argc: (int)argc argv: (NSString *)argv rAppName: (NSString *)rAppName ;

/** 

 Constructor. Parses command-line arguments.

*/
- initWithInt: (int)argc argv: (NSString *)argv rAppName: (NSString *)rAppName allowStyles: (BOOL)allowStyles GUIenabled: (BOOL)GUIenabled;
- initWithInt: (int)argc argv: (NSString *)argv rAppName: (NSString *)rAppName ;
- (void) dealloc;

/** 
 Returns the application session config object.

*/
- (KConfig*) sessionConfig;

/** 
 Is the application restored from the session manager?

*/
- (BOOL) isRestored;

/** 
 Disables session management for this application.

 Useful in case  your application is started by the
 initial "startkde" script.
   
*/
- disableSessionManagement;

/** 
 Asks the session manager to shut the session down.

 Using confirm == ShutdownConfirmYes or sdtype != ShutdownTypeDefault or
 sdmode != ShutdownModeDefault causes the use of ksmserver's DCOP
 interface. The remaining two combinations use the standard XSMP and
 will work with any session manager compliant with it.

 Returns TRUE on sucess, FALSE if the session manager could not be
 contacted.
   
*/
- (BOOL) requestShutDown: (int)confirm sdtype: (int)sdtype sdmode: (int)sdmode;
- (BOOL) requestShutDown;

/** 
 Propagates the network address of the session manager in the
 SESSION_MANAGER environment variable so that child processes can
 pick it up.

 If SESSION_MANAGER isn't defined yet, the address is searched in
 $HOME/.KSMserver.

 This function is called by clients that are started outside the
 session ( i.e. before ksmserver is started), but want to launch
 other processes that should participate in the session.  Examples
 are kdesktop or kicker.
   
*/
- propagateSessionManager;
- commitData: (QSessionManager*)sm;
- saveState: (QSessionManager*)sm;

/** 
 Returns a @ref QPixmap with the application icon.
   
*/
- (QPixmap*) icon;

/** 
 Returns the name of the application icon.
   
*/
- (NSString *) iconName;

/** 
 Returns the mini-icon for the application as a @ref QPixmap.
   
*/
- (QPixmap*) miniIcon;

/** 
 Returns the name of the mini-icon for the application.
   
*/
- (NSString *) miniIconName;

/** 
   Sets the top widget of the application.

  This means basically applying the right window caption and
  icon. An application may have several top widgets. You don't
  need to call this function manually when using @ref KMainWindow.

*/
- setTopWidget: (QWidget *)topWidget;

/** 
 Invokes the KHelpCenter HTML help viewer from docbook sources.

*/
- invokeHelp: (NSString *)anchor appname: (NSString *)appname;
- invokeHelp;

/** 

 Invoke the khelpcenter HTML help viewer from HTML sources.
 Please use -invokeHelp instead.

*/
- invokeHTMLHelp: (NSString *)aFilename aTopic: (NSString *)aTopic;
- invokeHTMLHelp: (NSString *)aFilename ;

/** 
 Convenience method; invokes the standard email application.

*/
- invokeMailer: (NSString *)address subject: (NSString *)subject;

/** 
 Invokes the standard email application.

*/
- invokeMailer: (KURL*)mailtoURL;

/** 
 Convenience method; invokes the standard email application.

 All parameters are optional.

*/
- invokeMailer: (NSString *)to cc: (NSString *)cc bcc: (NSString *)bcc subject: (NSString *)subject body: (NSString *)body messageFile: (NSString *)messageFile attachURLs: (NSArray *)attachURLs;
- invokeMailer: (NSString *)to cc: (NSString *)cc bcc: (NSString *)bcc subject: (NSString *)subject body: (NSString *)body ;

/** 
 Invokes the standard browser.

*/
- invokeBrowser: (NSString *)url;

/** 
 Returns a text for the window caption.

 This may be set by
 "-caption", otherwise it will be equivalent to the name of the
 executable.
   
*/
- (NSString *) caption;

/** 

   
*/
//- (KStyle*) kstyle;

/** 
 Builds a caption that contains the application name along with the
 @ref -userCaption using a standard layout.

 To make a compliant caption
 for your window, simply do: @p setCaption(-[kapp makeStdCaption]);

*/
- (NSString *) makeStdCaption: (NSString *)userCaption withAppName: (BOOL)withAppName modified: (BOOL)modified;

/** 
 Get a file name in order to make a temporary copy of your document.

*/
- (NSString *) tempSaveName: (NSString *)pFilename;

/** 
 Check whether  an auto-save file exists for the document you want to
 open.

*/
- (NSString *) checkRecoverFile: (NSString *)pFilename bRecover: (BOOL)bRecover;

/** 
 Get the X11 display
   
*/
//- (Display*) getDisplay;

/** 
 Enables style plugins.

 This is useful only to applications that normally
 do not display a GUI and create the KApplication with
 allowStyles set to false.
   
*/
- enableStyles;

/** 
 Disables style plugins.

 Current style plugins do not get unloaded.

 This is only useful when used in combination with @ref enableStyles.
   
*/
- disableStyles;

/** 
  Installs widget filter as global X11 event filter.

 The widget
  filter receives XEvents in its standard @ref -[QWidget x11Event] function.

  Warning: Only do this when absolutely necessary. An installed X11 filter
  can slow things down.

*/
- installX11EventFilter: (QWidget *)filter;

/** 
 Adds a message type to the KIPC event mask. You can only add "system
 messages" to the event mask. These are the messages with id < 32.
 Messages with id >= 32 are user messages.

*/
- addKipcEventMask: (int)identifier;

/** 
 Removes a message type from the KIPC event mask. This message will not
 be handled anymore.

*/
- removeKipcEventMask: (int)identifier;

/** 
 Returns the app startup notification identifier for this running application.
   
*/
- (NSString *) startupId;

/** 
 Sets a new value for the application startup notification window property for newly
 created toplevel windows.
   
*/
- setStartupId: (NSString *)startup_id;

/** 
 Returns the argument to --geometry if any, so the geometry can be set
 wherever necessary
    
*/
- (NSString *) geometryArgument;

/** 
 Install a Qt SQL property map with entries for all KDE widgets
 Call this in any application using KDE widgets in QSqlForm or QDataView.
   
*/
- installKDEPropertyMap;

/** 

   
*/
- (BOOL) notify: (QObject *)receiver event: (QEvent *)event;

/** 

    
*/
- (int) xioErrhandler;

/** 

   
*/
//- iceIOErrorHandler: (_IceConn*)conn;

/** 
 Tells KApplication about one more operation that should be finished
 before the application exits. The standard behavior is to exit on the
 "last window closed" event, but some events should outlive the last window closed
 (e.g. a file copy for a file manager, or 'compacting folders on exit' for a mail client).
   
*/
- ref;

/** 
 Tells KApplication that one operation such as those described in @ref ref just finished.
 The application exits if the counter is back to 0.
   
*/
- deref;

/** 
 Add Qt and KDE command line options to KCmdLineArgs.
    
*/
+ addCmdLineOptions;

/** 
 Returns the current application object.

 This is similar to the global @ref QApplication pointer qApp. It
 allows access to the single global KApplication object, since
 more than one cannot be created in the same application. It
 saves you the trouble of having to pass the pointer explicitly
 to every function that may require it.
   
*/
+ (KApplication*) kApplication;

/** 
 Returns a pointer to a @ref DCOPClient for the application.
 If a client does not exist yet, it is created when this
 function is called.
   
*/
+ (DCOPClient*) dcopClient;

/** 
 Disable automatic dcop registration
 Must be called before creating a KApplication instance to have an effect.
   
*/
+ disableAutoDcopRegistration;

/** 
 Returns the DCOP name of the service launcher. This will be something like
 klaucher_$host_$uid.
   
*/
+ (NSString *) launcher;

/** 
 Starts a service based on the (translated) name of the service.
 E.g. "Web Browser"

*/
+ (int) startServiceByName: (NSString *)_name URL: (NSString *)URL error: (NSString *)error dcopService: (NSString *)dcopService pid: (int*)pid startup_id: (NSString *)startup_id noWait: (BOOL)noWait;
+ (int) startServiceByName: (NSString *)_name URL: (NSString *)URL ;
+ (int) startServiceByName: (NSString *)_name URLs: (NSArray *)URLs error: (NSString *)error dcopService: (NSString *)dcopService pid: (int*)pid startup_id: (NSString *)startup_id noWait: (BOOL)noWait;
+ (int) startServiceByName: (NSString *)_name ;

/** 
 Starts a service based on the desktop path of the service.
 E.g. "Applications/konqueror.desktop" or "/home/user/bla/myfile.desktop"

*/
+ (int) startServiceByDesktopPath: (NSString *)_name URL: (NSString *)URL error: (NSString *)error dcopService: (NSString *)dcopService pid: (int*)pid startup_id: (NSString *)startup_id noWait: (BOOL)noWait;
+ (int) startServiceByDesktopPath: (NSString *)_name URL: (NSString *)URL ;
+ (int) startServiceByDesktopPath: (NSString *)_name URLs: (NSArray *)URLs error: (NSString *)error dcopService: (NSString *)dcopService pid: (int*)pid startup_id: (NSString *)startup_id noWait: (BOOL)noWait;
+ (int) startServiceByDesktopPath: (NSString *)_name ;

/** 
 Starts a service based on the desktop name of the service.
 E.g. "konqueror"

*/
+ (int) startServiceByDesktopName: (NSString *)_name URL: (NSString *)URL error: (NSString *)error dcopService: (NSString *)dcopService pid: (int*)pid startup_id: (NSString *)startup_id noWait: (BOOL)noWait;
+ (int) startServiceByDesktopName: (NSString *)_name URL: (NSString *)URL ;
+ (int) startServiceByDesktopName: (NSString *)_name URLs: (NSArray *)URLs error: (NSString *)error dcopService: (NSString *)dcopService pid: (int*)pid startup_id: (NSString *)startup_id noWait: (BOOL)noWait;
+ (int) startServiceByDesktopName: (NSString *)_name ;

/** 
 Starts a program via kdeinit.
 There will be no application startup notification, so you should
 use it only for starting internal processes.

 program name and arguments are converted to according to the
 local encoding and passed as is to kdeinit.

*/
+ (int) kdeinitExec: (NSString *)name args: (NSArray *)args error: (NSString *)error pid: (int*)pid;
//+ (int) kdeinitExec: (NSString *)name ;

/** 
 Starts a program via kdeinit and wait for it to finish.

 Like kdeinitExec but it waits till the program is finished.
 As such it behaves similar to the system(...) function.
   
*/
+ (int) kdeinitExecWait: (NSString *)name args: (NSArray *)args error: (NSString *)error pid: (int*)pid;
+ (int) kdeinitExecWait: (NSString *)name ;

/** 
 Generates a uniform random number.

*/
+ (int) random;

/** 
 Generates a random string.  It operates in the range [A-Za-z0-9]

*/
+ (NSString *) randomString: (int)length;

/** 

   
*/
+ startKdeinit;

/** 

   
*/
- initWithBOOL: (BOOL)allowStyles GUIenabled: (BOOL)GUIenabled _instance: (KInstance*)_instance;

/** 
 Used to catch X11 events
   
*/
//- (BOOL) x11EventFilter: (XEvent*)arg1;
+ (int) CaptionAppLast;
+ (int) CaptionAppFirst;
+ (int) CaptionNoApp;
+ (int) ShutdownConfirmDefault;
+ (int) ShutdownConfirmNo;
+ (int) ShutdownConfirmYes;
+ (int) ShutdownTypeDefault;
+ (int) ShutdownTypeNone;
+ (int) ShutdownTypeReboot;
+ (int) ShutdownTypeHalt;
+ (int) ShutdownModeDefault;
+ (int) ShutdownModeSchedule;
+ (int) ShutdownModeTryNow;
+ (int) ShutdownModeForceNow;
+ (int) SETTINGS_MOUSE;
+ (int) SETTINGS_COMPLETION;
+ (int) SETTINGS_PATHS;
+ (int) SETTINGS_POPUPMENU;
+ (int) SETTINGS_QT;
+ (int) SETTINGS_SHORTCUTS;
@end

@interface KApplication (KInstanceImplementation) <KInstanceInterface>
@end

/** Override these methods in subclasses of KApplication to customise event handling behaviour */
@protocol KApplicationEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
