/***************************************************************************
                            KButtonBox.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KBUTTONBOX_H
#define KBUTTONBOX_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 Container widget for buttons. 

 This class uses Qt layout control to place the buttons; can handle
 both vertical and horizontal button placement.  The default border
 is now @p 0 (making it easier to deal with layouts). The space
 between buttons is now more Motif compliant.

 @author Mario Weilguni <mweilguni@sime.com>

 @version $Id: KButtonBox.h,v 1.3 2002/03/15 02:12:19 rdale Exp $

 @short 
 Container widget for buttons.
*/
@class QPushButton; 

@interface KButtonBox : QWidget 

/** 
 Create an empty container for buttons.

 If @p _orientation is @p Vertical, the buttons inserted with 
 @ref -addButton are laid out from top to bottom, otherwise they 
 are laid out from left to right.
    
*/
- initWithWidget: (QWidget *)parent _orientation: (int)_orientation border: (int)border _autoborder: (int)_autoborder;
- initWithWidget: (QWidget *)parent ;

/** 
 Free private data field
    
*/
- (void) dealloc;

/** 

 This size is
 calculated by the width/height of all buttons plus border/autoborder.
    
*/
- (QSize*) sizeHint;

/** 
 Add a new @ref QPushButton.  

*/
- (QPushButton*) addButton: (NSString *)text noexpand: (BOOL)noexpand;
- (QPushButton*) addButton: (NSString *)text ;

/** 
 Add a new @ref QPushButton.  

*/
- (QPushButton*) addButton: (NSString *)text receiver: (QObject *)receiver slot: (NSString *)slot noexpand: (BOOL)noexpand;
- (QPushButton*) addButton: (NSString *)text receiver: (QObject *)receiver slot: (NSString *)slot ;

/** 
 Add a stretch to the buttonbox. 

 Can be used to separate buttons.  That is, if you add the
 buttons OK and Cancel, add a stretch, and then add the button Help,
 the buttons OK and Cancel will be left-aligned (or top-aligned
 for vertical) whereas Help will be right-aligned (or
 bottom-aligned for vertical).

*/
- addStretch: (int)scale;
- addStretch;

/** 
 This function must be called @em once after all buttons have been
 inserted.

 It will start layout control.
    
*/
- layout;

/** 

*/
- (QSize*) bestButtonSize;
- placeButtons;
- (QSize*) buttonSizeHint: (QPushButton*)arg1;
@end

/** Override these methods in subclasses of KButtonBox to customise event handling behaviour */
@protocol KButtonBoxEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
