/***************************************************************************
                            KCommand.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOMMAND_H
#define KCOMMAND_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 The abstract base class for all Commands. Commands are used to
 store information needed for Undo/Redo functionality...
 
 @short 
 The abstract base class for all Commands.
*/
@interface  KCommand : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- (void) dealloc;

/** 
 The main method: executes this command.
 Implement here what this command is about, and remember to
 record any information that will be helpful for @ref unexecute.
     
*/
- execute;

/** 
 Unexecutes (undo) this command.
 Implement here the steps to take for undoing the command.
 If your application uses actions for everything (it should),
 and if you implement unexecute correctly, the application is in the same
 state after unexecute as it was before execute. This means, the next
 call to execute will do the same thing as it did the first time.
     
*/
- unexecute;

/** 

*/
- (NSString *) name;
@end

#endif
