/***************************************************************************
                            KCommandHistory.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOMMANDHISTORY_H
#define KCOMMANDHISTORY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 The command history stores a (user) configurable amount of
 Commands. It keeps track of its size and deletes commands
 if it gets too large. The user can set a maximum undo and
 a maximum redo limit (e.g. max. 50 undo / 30 redo commands).
 The KCommandHistory keeps track of the "borders" and deletes
 commands, if appropriate. It also activates/deactivates the
 undo/redo actions in the menu and changes the text according
 to the name of the command.
 
 @short 
 The command history stores a (user) configurable amount of
 Commands.
*/
@class KActionCollection; 
@class KCommand; 

@interface KCommandHistory : QObject 

/** 
 Creates a command history, to store commands.
 This constructor doesn't create actions, so you need to call
 @ref undo and @ref redo yourself.
     
*/
- init;

/** 
 Creates a command history, to store commands.
 This also creates an undo and a redo action, in the @p actionCollection,
 using the standard names ("edit_undo" and "edit_redo").

*/
- initWithActionCollection: (KActionCollection*)actionCollection withMenus: (BOOL)withMenus;
- initWithActionCollection: (KActionCollection*)actionCollection ;

/** 
 Destructs the command history object.
     
*/
- (void) dealloc;

/** 
 Erases all the undo/redo history.
 Use this when reloading the data, for instance, since this invalidates
 all the commands.
     
*/
- clear;

/** 
 Adds a command to the history. Call this for each @p command you create.
 Unless you set @p execute to false, this will also execute the command.
 This means, most of the application's code will look like
    MyCommand * cmd = new MyCommand(i18n("The name"), parameters);
    m_historyCommand.addCommand( cmd );
     
*/
- addCommand: (KCommand*)command execute: (BOOL)execute;
- addCommand: (KCommand*)command ;

/** 

*/
- (int) undoLimit;

/** 
 Sets the maximum number of items in the undo history.
     
*/
- setUndoLimit: (int)limit;

/** 

*/
- (int) redoLimit;

/** 
 Sets the maximum number of items in the redo history.
     
*/
- setRedoLimit: (int)limit;

/** 
 Enable or disable the undo and redo actions.
 This isn't usually necessary, but this method can be useful if
 you disable all actions (to go to a "readonly" state), and then
 want to come back to a readwrite mode.
     
*/
- updateActions;

/** 
 Undoes the last action.
 Call this if you don't use the builtin KActions.
     
*/
- undo;

/** 
 Redoes the last undone action.
 Call this if you don't use the builtin KActions.
     
*/
- redo;

/** 
 Remembers when you saved the document.
 Call this right after saving the document. As soon as
 the history reaches the current index again (via some
 undo/redo operations) it will emit @ref documentRestored
 If you implemented undo/redo properly the document is
 the same you saved before.
     
*/
- documentSaved;
- slotUndoAboutToShow;
- slotUndoActivated: (int)arg1;
- slotRedoAboutToShow;
- slotRedoActivated: (int)arg1;
@end

/** Override these methods in subclasses of KCommandHistory to customise event handling behaviour */
@protocol KCommandHistoryEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
