/***************************************************************************
                            KDCOPActionProxy.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDCOPACTIONPROXY_H
#define KDCOPACTIONPROXY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/DCOPObjectProxy.h>

/**

 The KDCOPActionProxy class provides an easy way to publish a collection of @ref KAction objects
 through DCOP. For the DCOP client the exported actions behave like full-fledged DCOP objects,
 providing full access to the KAction object functionality in the server.

 This class can generate DCOP object ids for given action objects, which it automatically
 processes, as being a @ref DCOPObjectProxy .

 @short A proxy class publishing a DCOP interface for actions.
 
*/
@class DCOPObject; 
@class KAction; 
@class KActionCollection; 
@class QByteArray; 

@interface KDCOPActionProxy : DCOPObjectProxy 

/** 
 Constructs a dcop action proxy, being able to export the actions of the provided
 @ref KActionCollection through DCOP, using the parent DCOPObject's object id to
 generate unique object ids for the actions.
   
*/
- initWithActionCollection: (KActionCollection*)actionCollection parent: (DCOPObject*)parent;

/** 
 Use this constructor if do not want to provide the exportable actions through a
 @ref KActionCollection . You have to reimplement the virtual @ref  #--actions and
 @ref  #--action methods if you use this constructor.
   
*/
- initWithDCOPObject: (DCOPObject*)parent;

/** 
 Destructor.
   
*/
- (void) dealloc;

/** 
 Returns an action object with the given name. The default implementation queries the action object
 from the @ref KActionCollection, if the first constructor has been used.
   
*/
- (KAction*) action: (NSString *)name;

/** 
 Use this method to retrieve a DCOP object id for an action with the given name.
 This class automatically takes care of processing DCOP object requests for the returned
 object id.

 You can construct a global DCOP object referenence using DCOPRef. For example like
 DCOPRef( -[kapp dcopClient]->appId, -[actionProxy actionObjectId]( actionName ) );

 The action with the given name has to be available through the @ref action method.
   
*/
- (NSString *) actionObjectId: (NSString *)name;

/** 
 Internal reimplementation of @ref -[DCOPObjectProxy process].
   
*/
- (BOOL) process: (NSString *)obj fun: (NSString *)fun data: (QByteArray*)data replyType: (NSString *)replyType replyData: (QByteArray*)replyData;

/** 
 Called by the @ref process method and takes care of processing the object request for an
 action object.
   
*/
- (BOOL) processAction: (NSString *)obj fun: (NSString *)fun data: (QByteArray*)data replyType: (NSString *)replyType replyData: (QByteArray*)replyData action: (KAction*)action;
@end

#endif
