/***************************************************************************
                            KDEDesktopMimeType.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDEDESKTOPMIMETYPE_H
#define KDEDESKTOPMIMETYPE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KMimeType.h>

/**


 @short Mimetype for a .desktop file
 Handles mount/umount icon, and user-defined properties.
*/
@class KDesktopFile;
@class KURL; 
@class QDataStream; 
@class QPixmap;
@class KSimpleConfig;

@interface KDEDesktopMimeType : KMimeType 
- initWithDesktopFile: (KDesktopFile*)config;
- initWithDataStream: (QDataStream *)_str offset: (int)offset;
- (NSString *) icon: (NSString *)_url _is_local: (BOOL)_is_local;
- (NSString *) iconForURL: (KURL*)_url _is_local: (BOOL)_is_local;
- (QPixmap*) pixmap: (KURL*)_url _group: (int)_group _force_size: (int)_force_size _state: (int)_state _path: (NSString *)_path;
- (QPixmap*) pixmap: (KURL*)_url _group: (int)_group ;
- (NSString *) comment: (NSString *)_url _is_local: (BOOL)_is_local;
- (NSString *) commentForURL: (KURL*)_url _is_local: (BOOL)_is_local;

/** 

   
*/
//+ executeService: (NSString *)_path _service: (KDEDesktopMimeType_Service*)_service;

/** 
 Execute @p service on the list of @p urls
   
*/
//+ executeService: (NSArray *)urls service: (KDEDesktopMimeType_Service*)service;

/** 
 Invokes the default action for the desktop entry. If the desktop
 entry is not local, then only false is returned. Otherwise we
 would create a security problem. Only types Link and Mimetype
 could be followed.

*/
+ (long) run: (KURL*)_url _is_local: (BOOL)_is_local;
- (QPixmap*) pixmap: (int)a b: (int)b c: (int)c d: (NSString *)d;
//+ (long) runFSDevice: (KURL*)_url cfg: (KSimpleConfig*)cfg;
//+ (long) runApplication: (KURL*)_url _serviceFile: (NSString *)_serviceFile;
//+ (long) runLink: (KURL*)_url cfg: (KSimpleConfig*)cfg;
//+ (long) runMimeType: (KURL*)_url cfg: (KSimpleConfig*)cfg;
+ (int) ST_MOUNT;
+ (int) ST_UNMOUNT;
+ (int) ST_USER_DEFINED;
@end

#endif
