/***************************************************************************
                            KDirNotify.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDIRNOTIFY_H
#define KDIRNOTIFY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/DCOPObject.h>

/**

 An abstract class that receives notifications of added and removed files
 in any directory, local or remote.
 The information comes from the konqueror/kdesktop instance where the
 operation was done, and can interest KDirListers, bookmark handlers, etc.
 
 @short 
 An abstract class that receives notifications of added and removed files
 in any directory, local or remote.
*/
@class KURL;

@protocol KDirNotifyInterface
//- (k_dcop: /** * Notify that files have been added in @p directory * Note: this is ASYNC so that it can be used with a broadcast */  ASYNC) FilesAdded: (KURL*)directory;

/** 
 Notify that files have been deleted.
 Note: this is ASYNC so that it can be used with a broadcast
   
*/
- FilesRemoved: (NSArray *)fileList;

/** 
 Notify that files have been changed.
 At the moment, this is only used for new icon, but it could be
 used for size etc. as well.
 Note: this is ASYNC so that it can be used with a broadcast
   
*/
- FilesChanged: (NSArray *)fileList;

/** 
 Notify that a file has been renamed.
 Note: this is ASYNC so that it can be used with a broadcast
   
*/
- FileRenamed: (KURL*)src dst: (KURL*)dst;
@end

@interface KDirNotify : DCOPObject <KDirNotifyInterface>
@end

#endif
