/***************************************************************************
                            KGlobalSettings.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KGLOBALSETTINGS_H
#define KGLOBALSETTINGS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Access the KDE global configuration.

 @author David Faure <faure@kde.org>

 @version $Id: KGlobalSettings.h,v 1.3 2002/03/15 02:12:20 rdale Exp $
 
 @short 
 Access the KDE global configuration.
*/
@class QColor; 
@class QFont; 

@interface  KGlobalSettings : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Returns a threshold in pixels for drag & drop operations.
 As long as the mouse movement has not exceeded this number
 of pixels in either X or Y direction no drag operation may
 be started. This prevents spurious drags when the user intended
 to click on something but moved the mouse a bit while doing so.

 For this to work you must save the position of the mouse (oldPos)
 in the @ref -[QWidget mousePressEvent].
 When the position of the mouse (newPos)
 in a  @ref -[QWidget mouseMoveEvent] exceeds this threshold
 you may start a drag
 which should originate from oldPos.

 Example code:
 <pre>
 void -[KColorCells mousePressEvent]( QMouseEvent *e )
 {
    mOldPos = -[e pos];
 }

 void -[KColorCells mouseMoveEvent]( QMouseEvent *e )
 {
    if( !(-[e state] && LeftButton)) return;

    int delay = -[KGlobalSettings dndEventDelay];
    QPoint newPos = -[e pos];
    if(newPos.-x > mOldPos.-x+delay || newPos.-x < mOldPos.-x-delay ||
       newPos.-y > mOldPos.-y+delay || newPos.-y < mOldPos.-y-delay)
    {
       // Drag color object
       int cell = posToCell(mOldPos); // Find color at mOldPos
       if ((cell != -1) && colors[cell].-isValid)
       {
          KColorDrag *d = -[KColorDrag makeDrag]( colors[cell], this);
          -[d dragCopy];
       }
    }
 }
 </pre>

     
*/
+ (int) dndEventDelay;

/** 
 Returns whether KDE runs in single (default) or double click
 mode.

 see @ref http://developer.kde.org/documentation/standards/kde/style/mouse/index.html

*/
+ (BOOL) singleClick;

/** 
 Returns whether tear-off handles are inserted in KPopupMenus.

*/
+ (BOOL) insertTearOffHandle;

/** 

*/
+ (BOOL) changeCursorOverIcon;

/** 

*/
+ (BOOL) visualActivate;
+ (unsigned int) visualActivateSpeed;

/** 
 Returns the KDE setting for the auto-select option

*/
+ (int) autoSelectDelay;

/** 
 Returns the KDE setting for the shortcut key to open
 context menus.

*/
+ (int) contextMenuKey;

/** 
 Returns the KDE setting for context menus.

*/
+ (BOOL) showContextMenusOnPress;

/** 
 Returns the preferred completion mode setting.

*/
+ (int) completionMode;

/** 
 This returns the current mouse settings.
     
*/
//+ (KMouseSettings&) mouseSettings;

/** 
 The path to the desktop directory of the current user.
     
*/
+ (NSString *) desktopPath;

/** 
 The path to the autostart directory of the current user.
     
*/
+ (NSString *) autostartPath;

/** 
 The path to the trash directory of the current user.
     
*/
+ (NSString *) trashPath;

/** 
 The path where documents are stored of the current user.
     
*/
+ (NSString *) documentPath;

/** 
 The default color to use when highlighting toolbar buttons
     
*/
+ (QColor*) toolBarHighlightColor;
+ (QColor*) inactiveTitleColor;
+ (QColor*) inactiveTextColor;
+ (QColor*) activeTitleColor;
+ (QColor*) activeTextColor;
+ (int) contrast;

/** 
 The default colors to use for text and links.
     
*/
+ (QColor*) baseColor;
+ (QColor*) textColor;
+ (QColor*) linkColor;
+ (QColor*) visitedLinkColor;
+ (QColor*) highlightedTextColor;
+ (QColor*) highlightColor;

/** 
 Returns the alternate background color used by @ref KListView with
 @ref KListViewItem. Any other list that uses alternating background
 colors should use this too, to obey to the user's preferences. Returns
 an invalid color if the user doesn't want alternating backgrounds.

*/
+ (QColor*) alternateBackgroundColor;

/** 
 Calculates a color based on @p base to be used as alternating
 color for e.g. listviews.

*/
+ (QColor*) calculateAlternateBackgroundColor: (QColor *)base;
+ (QFont*) generalFont;
+ (QFont*) fixedFont;
+ (QFont*) toolBarFont;
+ (QFont*) menuFont;
+ (QFont*) windowTitleFont;
+ (QFont*) taskbarFont;
+ (int) /***Nocompletionisused.*/CompletionNone;
+ (int) /***Textisautomaticallyfilledinwheneverpossible.*/CompletionAuto;
+ (int) /***Sameasautomaticexceptshortestmatchisusedforcompletion.*/CompletionMan;
+ (int) /***Completetextmuchinthesamewayasatypical*nixshellwould.*/CompletionShell;
+ (int) /***Listsallpossiblematchesinapopuplist-boxtochoosefrom.*/CompletionPopup;
@end

#endif
