/***************************************************************************
                            KIconTheme.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KICONTHEME_H
#define KICONTHEME_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Class to use/access icon themes in KDE. This class is used by the
 iconloader but can be used by others too.
 
 @short 
 Class to use/access icon themes in KDE.
*/
@class KIcon; 

@interface  KIconTheme : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/**  Load an icon theme by name.  
*/
- initWithText: (NSString *)name appName: (NSString *)appName;
- initWithText: (NSString *)name ;
- (void) dealloc;

/**  The stylized name of the icon theme. 
*/
- (NSString *) name;

/**  A description for the icon theme. 
*/
- (NSString *) description;

/**  Return the name of the "example" icon. 
*/
- (NSString *) example;

/**  Return the name of the screenshot. 
*/
- (NSString *) screenshot;

/**  Returns the name of this theme's link overlay. 
*/
- (NSString *) linkOverlay;

/**  Returns the name of this theme's zip overlay. 
*/
- (NSString *) zipOverlay;

/**  Returns the name of this theme's lock overlay. 
*/
- (NSString *) lockOverlay;

/**  Returns the toplevel theme directory. 
*/
- (NSString *) dir;

/**  The themes this icon theme falls back on. 
*/
- (NSArray *) inherits;

/**  The icon theme exists? 
*/
- (BOOL) isValid;

/**  The minimum display depth required for this theme. This can either
 be 8 or 32 
*/
- (int) depth;

/**  The default size of this theme for a certain icon group.

*/
- (int) defaultSize: (int)group;

/**  Query available icons for a size and context. 
*/
- (NSArray *) queryIcons: (int)size context: (int)context;

/**  Query available icons for a context and preferred size. 
*/
- (NSArray *) queryIconsByContext: (int)size context: (int)context;

/**  Lookup an icon in the theme.

*/
- (KIcon*) iconPath: (NSString *)name size: (int)size match: (int)match;

/**  List all icon themes installed on the system, global and local. 
*/
+ (NSArray *) list;

/**  Returns the current icon theme. 
*/
+ (NSString *) current;
+ reconfigure;
@end

#endif
