/***************************************************************************
                            KLed.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KLED_H
#define KLED_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**
 
 Displays a round  or rectangular light emitting diode.

 It is configurable to five colors, the two on/off states and three
 styles (or "looks");

 It may display itself in a performant flat view, a round view with
 light spot or a round view sunken in the screen.

 @author Joerg Habenicht, Richard J. Moore (rich@kde.org) 1998, 1999
 
 @short An LED widget.

*/
@interface KLed : QWidget 

/** 
 Constructs a green, round LED widget which will initially
 be turned on.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructor with the ledcolor, the parent widget, and the name.

 The State will be defaulted On and the Look round.

*/
- initWithColor: (QColor *)col parent: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructor with the ledcolor, ledstate, ledlook,
 the parent widget, and the name.

 Differs from above only in the parameters, which configure all settings.

*/
- initWithColor: (QColor *)col st: (int)st look: (int)look shape: (int)shape parent: (QWidget *)parent name: (NSString *)name;
- initWithColor: (QColor *)col st: (int)st look: (int)look shape: (int)shape ;

/** 
 Destructor

*/
- (void) dealloc;

/** 
 Returns the current state of the widget (on/off).

*/
- (int) state;
- (int) shape;

/** 
 Returns the color of the widget

*/
- (QColor*) color;

/** 
 Returns the look of the widget.

*/
- (int) look;

/** 
 Returns the factor to darken the LED.

*/
- (int) darkFactor;

/** 
 Sets the state of the widget to On or Off.

 The widget will be painted immediately.

*/
- setState: (int)state;

/** 
 Set the shape of the LED to @p s.
   
*/
- setShape: (int)s;

/** 
 Toggle the state of the LED from Off to On and vice versa.

 The widget will be repainted when returning to the main
 event loop.

   
*/
- toggleState;

/** 
 Set the color of the widget.
 The Color is shown with the -[KLed On]state.
 The -[KLed Off]state is shown with QColor.-dark method

 The widget calls the -update method, so it will
 be updated when entering the main event loop.

*/
- setColor: (QColor *)color;

/** 
 Sets the factor to darken the LED in OFF state.
 Same as @ref -[QColor dark].
 "darkfactor should be greater than 100, else the LED gets lighter
 in OFF state.
 Defaults to 300.

*/
- setDarkFactor: (int)darkfactor;

/** 
 Sets the look of the widget.

 The look may be flat, round or sunken.
 The widget calls the -update method, so it will
 be updated when entering the main event loop.

*/
- setLook: (int)look;
- (QSize*) sizeHint;
- (QSize*) minimumSizeHint;

/** 
 Toggles the state of the led from Off to On or vice versa.

 The widget repaints itself immediately.
   
*/
- toggle;

/** 
 Sets the state of the widget to On.

 The widget will be painted immediately.

*/
- on;

/** 
 Sets the state of the widget to Off.

 The widget will be painted immediately.

*/
- off;

/** 
 Paints a circular, flat LED.
   
*/
- paintFlat;

/** 
 Paints a circular, raised LED.
   
*/
- paintRound;

/** 
 Paints a circular, sunken LED.
   
*/
- paintSunken;

/** 
 Paints a rectangular, flat LED.
   
*/
- paintRect;

/** 
 Paints a rectangular LED, either raised or 
 sunken, depending on its argument.
   
*/
- paintRectFrame: (BOOL)raised;
+ (int) Off;
+ (int) On;
+ (int) Rectangular;
+ (int) Circular;
+ (int) Flat;
+ (int) Raised;
+ (int) Sunken;
@end

/** Override these methods in subclasses of KLed to customise event handling behaviour */
@protocol KLedEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;

/** 

   
*/
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
