/***************************************************************************
                            KPopupTitle.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPOPUPTITLE_H
#define KPOPUPTITLE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 Title widget for use in @ref KPopupMenu.

 You usually don't have to create this manually since
 @ref -[KPopupMenu insertTitle]will do it for you, but it is allowed if
 you wish to customize it's look.

 @author Daniel M. Duley <mosfet@kde.org>

 @short KPopupMenu title widget.
 
*/
@class KPixmap; 
@class parse; 

@interface KPopupTitle : QWidget 

/** 
 Constructs a title widget with the user specified gradient, pixmap,
 and colors.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructs a title widget with the specified gradient and colors.
     
*/
- initWithInt: (int)gradient color: (QColor *)color textColor: (QColor *)textColor parent: (QWidget *)parent name: (NSString *)name;
- initWithInt: (int)gradient color: (QColor *)color textColor: (QColor *)textColor ;

/** 
 Constructs a title widget with the specified pixmap and colors.
     
*/
- initWithPixmap: (KPixmap*)background color: (QColor *)color textColor: (QColor *)textColor parent: (QWidget *)parent name: (NSString *)name;
- initWithPixmap: (KPixmap*)background color: (QColor *)color textColor: (QColor *)textColor ;

/** 
 Sets the title string and optional icon for the title widget.

 You will want to call this before inserting into a menu.
     
*/
- setTitle: (NSString *)text icon: (QPixmap *)icon;
- setTitle: (NSString *)text ;

/** 
 Returns the current title.
     
*/
- (NSString *) title;

/** 
 Returns the current icon.
     
*/
- (QPixmap*) icon;
- (QSize*) sizeHint;
@end

/** Override these methods in subclasses of KPopupTitle to customise event handling behaviour */
@protocol KPopupTitleEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) ev;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
