/***************************************************************************
                            KServiceType.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSERVICETYPE_H
#define KSERVICETYPE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KSycocaEntry.h>

/**

 A service type is the generic notion for a mimetype, a type of service
 instead of a type of file.
 For instance, KOfficeFilter is a service type.
 It is associated to services according to the user profile (kuserprofile.h)
 
 @short 
 A service type is the generic notion for a mimetype, a type of service
 instead of a type of file.
*/
@class KDesktopFile; 
@class QDataStream;
@class QVariant; 


@interface KServiceType : KSycocaEntry 

/** 
 Constructor.  You may pass in arguments to create a servicetype with
 specific properties
   
*/
- initWithText: (NSString *)_fullpath _name: (NSString *)_name _icon: (NSString *)_icon _comment: (NSString *)_comment;

/** 
 Construct a service type and take all informations from a config file.

*/
- initWithText: (NSString *)_fullpath;

/** 
 Construct a service type and take all informations from a deskop file.
   
*/
- initWithDesktopFile: (KDesktopFile*)config;

/** 

 The stream must already be positionned at the correct offset
   
*/
- initWithDataStream: (QDataStream *)_str offset: (int)offset;
- (void) dealloc;

/** 

*/
- (NSString *) icon;

/** 

*/
- (NSString *) comment;

/** 

*/
- (NSString *) name;

/** 

*/
- (NSString *) desktopEntryPath;

/** 

*/
- (BOOL) isDerived;

/** 
 If this service type inherits from another service type,
 return the name of the parent. Otherwise -[QString null].
   
*/
- (NSString *) parentServiceType;
- (QVariant*) property: (NSString *)_name;
- (NSArray *) propertyNames;
- (BOOL) isValid;
- (int) propertyDef: (NSString *)_name;
- (NSArray *) propertyDefNames;

/** 
 Save ourselves to the data stream.
   
*/
- save: (QDataStream *)arg1;

/** 
 Load ourselves from the data stream.
   
*/
- load: (QDataStream *)arg1;

/** 

*/
+ (void*) serviceType: (NSString *)_name;

/** 

*/
//+ (KService_List*) offers: (NSString *)_servicetype;

/** 

*/
//+ (List) allServiceTypes;
- init: (KDesktopFile*)config;
@end

#endif
