/***************************************************************************
                            KTar.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KTAR_H
#define KTAR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KArchive.h>

/**


 @author Torben Weis <weis@kde.org>, David Faure <faure@kde.org>
 
 @short A class for reading/writing (optionnally compressed) tar archives.

*/
@interface KTar : KArchive 

/** 
 Creates an instance that operates on the given filename.
 using the compression filter associated to given mimetype.

*/
- initWithText: (NSString *)filename mimetype: (NSString *)mimetype;
- initWithText: (NSString *)filename ;

/** 
 Creates an instance that operates on the given device.
 The device can be compressed (KFilterDev) or not (QFile, etc.).
 WARNING: don't assume that giving a QFile here will decompress the file,
 in case it's compressed!
     
*/
- initWithIODevice: (QIODevice *)dev;

/** 
 If the tar ball is still opened, then it will be
 closed automatically by the destructor.
     
*/
- (void) dealloc;

/** 
 The name of the tar file, as passed to the constructor
 Null if you used the QIODevice constructor.
     
*/
- (NSString *) fileName;

/** 
 Special function for setting the "original file name" in the gzip header,
 when writing a tar.gz file. It appears when using in the "file" command,
 for instance. Should only be called if the underlying device is a KFilterDev!
     
*/
- setOrigFileName: (NSString *)fileName;
- (BOOL) writeDir: (NSString *)name user: (NSString *)user group: (NSString *)group;
- (BOOL) prepareWriting: (NSString *)name user: (NSString *)user group: (NSString *)group size: (unsigned int)size;
- (BOOL) doneWriting: (unsigned int)size;

/** 
 Opens the archive for reading.
 Parses the directory listing of the archive
 and creates the KArchiveDirectory/KArchiveFile entries.

     
*/
- (BOOL) openArchive: (int)mode;
- (BOOL) closeArchive;
@end

#endif
