/***************************************************************************
                            KURL.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KURL_H
#define KURL_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Represents and parses a URL.

 A prototypical URL looks like:
 <pre>
   protocol:/user:password@hostname:port/path/to/file.-[ext reference]
 </pre>

 KURL has some restrictions regarding the path
 encoding. KURL works internally with the decoded path and
 and encoded query. For example,
 <pre>
 http://localhost/cgi-bin/test%20me.pl?cmd=Hello%20you
 </pre>
 would result in a decoded path "/cgi-bin/test me.pl"
 and in the encoded query "?cmd=Hello%20you".
 Since path is internally always encoded you may @em not use
 "%00" in the path, although this is OK for the query.

 @author Torben Weis <weis@kde.org>
 
 @short 
 Represents and parses a URL.
*/
@class QUrl;

@interface  KURL : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Constructs an empty URL.
   
*/
- init;

/** 
 Destructs the KURL object.
   
*/
- (void) dealloc;

/** 
 Usual constructor, to construct from a string.

*/
- initWithText: (NSString *)url encoding_hint: (int)encoding_hint;
- initWithText: (NSString *)url ;

/** 
 Constructor taking a char * @p url, which is an _encoded_ representation
 of the URL, exactly like the usual constructor. This is useful when
 then URL, in its encoded form, is strictly ascii.
   
*/
- initWithText: (NSString *)url encoding_hint: (int)encoding_hint;
- initWithText: (NSString *)url ;

/** 
 Constructor taking a QCString @p url, which is an _encoded_ representation
 of the URL, exactly like the usual constructor. This is useful when
 then URL, in its encoded form, is strictly ascii.
   
*/
- initWithText: (NSString *)url encoding_hint: (int)encoding_hint;
- initWithText: (NSString *)url ;

/** 
 Copy constructor.
   
*/
- copyWithZone: (NSZone *) zone;

/** 
 Converts from a @ref QUrl.
   
*/
- initWithUrl: (QUrl*)u;

/** 
 Constructor allowing relative URLs.

*/
- initWithURL: (KURL*)_baseurl _rel_url: (NSString *)_rel_url encoding_hint: (int)encoding_hint;
- initWithURL: (KURL*)_baseurl _rel_url: (NSString *)_rel_url ;

/** 
 Returns the protocol for the URL (i.e., file, http, etc.).

*/
- (NSString *) protocol;

/** 
 Sets the protocol for the URL (i.e., file, http, etc.)

*/
- setProtocol: (NSString *)_txt;

/** 
 Returns the decoded user name (login, user id, ...) included in the URL.

*/
- (NSString *) user;

/** 
 Sets the user name (login, user id, ...) included in the URL.

 Special characters in the user name will appear encoded in the URL.

*/
- setUser: (NSString *)_txt;

/** 
 Test to see if this URL has a user name included in it.

*/
- (BOOL) hasUser;

/** 
 Returns the decoded password (corresponding to @ref -user) included in the URL.

*/
- (NSString *) pass;

/** 
 Sets the password (corresponding to @ref -user) included in the URL.

 Special characters in the password will appear encoded in the URL.

*/
- setPass: (NSString *)_txt;

/** 
 Test to see if this URL has a password included in it.

*/
- (BOOL) hasPass;

/** 
 Returns the decoded hostname included in the URL.

*/
- (NSString *) host;

/** 
 Sets the hostname included in the URL.

 Special characters in the hostname will appear encoded in the URL.

*/
- setHost: (NSString *)_txt;

/** 
 Test to see if this URL has a hostname included in it.

*/
- (BOOL) hasHost;

/** 
 Returns the port number included in the URL.
 If there is no port number specified in the URL, returns 0.

*/
- (unsigned short) port;

/** 
 Sets the port number included in the URL.

*/
- setPort: (unsigned short)_p;

/** 
 Returns the current decoded path. This does @em not include the query.
   
*/
- (NSString *) path;

/** 

*/
- (NSString *) path: (int)_trailing;

/** 
 path This is considered to be decoded. This means: %3f does not become decoded
      and the ? does not indicate the start of the query part.
      The query is not changed by this function.
   
*/
- setPath: (NSString *)path;

/** 
 Test to see if this URL has a path is included in it.

*/
- (BOOL) hasPath;

/** 
 Resolves "." and ".." components in path.

 Some servers seem not to like the removal of extra '/'
 even though it is against the specification in RFC 2396.
   
*/
- cleanPath: (BOOL)cleanDirSeparator;
- cleanPath;

/** 
 This is useful for HTTP. It looks first for '?' and decodes then.
 The encoded path is the concatenation of the current path and the query.

*/
- setEncodedPathAndQuery: (NSString *)_txt encoding_hint: (int)encoding_hint;
- setEncodedPathAndQuery: (NSString *)_txt ;
- setEncodedPath: (NSString *)_txt encoding_hint: (int)encoding_hint;
- setEncodedPath: (NSString *)_txt ;

/** 

*/
- (NSString *) encodedPathAndQuery: (int)_trailing _no_empty_path: (BOOL)_no_empty_path encoding_hint: (int)encoding_hint;

/** 

 The query should start with a '?'. If it doesn't '?' is prepended.

*/
- setQuery: (NSString *)_txt encoding_hint: (int)encoding_hint;
- setQuery: (NSString *)_txt ;

/** 

*/
- (NSString *) query;

/** 
 The reference is @em never decoded automatically.
   
*/
- (NSString *) ref;

/** 
 Sets the reference part (everything after '#').

*/
- setRef: (NSString *)_txt;

/** 

*/
- (BOOL) hasRef;

/** 

*/
- (NSString *) htmlRef;

/** 

*/
- (NSString *) encodedHtmlRef;

/** 
 Sets the HTML-style reference.

*/
- setHTMLRef: (NSString *)_ref;

/** 

*/
- (BOOL) hasHTMLRef;

/** 

*/
- (BOOL) isValid;

/** 

   
*/
- (BOOL) isMalformed;

/** 

*/
- (BOOL) isLocalFile;

/** 
 Adds encoding information to url.
   
*/
- setFileEncoding: (NSString *)encoding;

/** 
 Returns encoding information from url.

*/
- (NSString *) fileEncoding;

/** 

*/
- (BOOL) hasSubURL;

/** 
 Adds to the current path.
 Assumes that the current path is a directory. @p _txt is appended to the
 current path. The function adds '/' if needed while concatenating.
 This means it does not matter whether the current path has a trailing
 '/' or not. If there is none, it becomes appended. If @p _txt
 has a leading '/' then this one is stripped.

*/
- addPath: (NSString *)_txt;

/** 
 Returns the value of a certain query item.

*/
- (NSString *) queryItem: (NSString *)_item;

/** 
 In comparison to @ref -addPath this function does not assume that the current path
 is a directory. This is only assumed if the current path ends with '/'.

 Any reference is reset.

*/
- setFileName: (NSString *)_txt;

/** 

*/
- (NSString *) fileName: (BOOL)_ignore_trailing_slash_in_path;

/** 

*/
- (NSString *) directory: (BOOL)_strip_trailing_slash_from_result _ignore_trailing_slash_in_path: (BOOL)_ignore_trailing_slash_in_path;

/** 
 Changes the directory by descending into the given directory.
 It is assumed the current URL represents a directory.
 If @p dir starts with a "/" the
 current URL will be "protocol://host/dir" otherwise @p _dir will
 be appended to the path. @p _dir can be ".."
 This function won't strip protocols. That means that when you are in
 file:/dir/dir2/my.-[tgz tar]:/ and you do cd("..") you will
 still be in file:/dir/dir2/my.-[tgz tar]:/

*/
- (BOOL) cd: (NSString *)_dir;

/** 

*/
- (NSString *) url: (int)_trailing encoding_hint: (int)encoding_hint;

/** 

*/
- (NSString *) prettyURL: (int)_trailing;

/** 
 Test to see if the KURL is empty.

*/
- (BOOL) isEmpty;

/** 
 This function is useful to implement the "Up" button in a file manager for example.
 @ref -cd never strips a sub-protocol. That means that if you are in
 file:/home/x.-[tgz gzip]:/ #-tar:/ and hit the up button you expect to see
 file:/home. The algorithm tries to go up on the right-most URL. If that is not
 possible it strips the right most URL. It continues stripping URLs.
   
*/
- (KURL*) upURL;

/** 
 Compares this url with @p u.

*/
- (BOOL) cmp: (KURL*)u ignore_trailing: (BOOL)ignore_trailing;
- (BOOL) cmp: (KURL*)u ;

/** 

*/
- (BOOL) isParentOf: (KURL*)u;

/** 
 Splits nested URLs like file:/home/weis/kde.-[tgz gzip]:/ #-tar:/kdebase
 A URL like http://www.kde.-[org tar]:/kde/README.-[hml ref1] will be split in
 http://www.kde.org and tar:/kde/README.-[html ref1].
 That means in turn that " #-ref1" is an HTML-style reference and not a new sub URL.
 Since HTML-style references mark
 a certain position in a document this reference is appended to every URL.
 The idea behind this is that browsers, for example, only look at the first URL while
 the rest is not of interest to them.

*/
//+ (List) split: (NSString *)_url;

/** 
 A convenience function.
   
*/
//+ (List) split: (KURL*)_url;

/** 
 Reverses @ref -split. Only the first URL may have a reference. This reference
 is considered to be HTML-like and is appended at the end of the resulting
 joined URL.
   
*/
//+ (KURL*) join: (List*)_list;

/** 
 Convenience function.

 Convert unicoded string to local encoding and use %-style
 encoding for all common delimiters / non-ascii characters.

*/
+ (NSString *) encode_string: (NSString *)str encoding_hint: (int)encoding_hint;

/** 
 Convenience function.

 Convert unicoded string to local encoding and use %-style
 encoding for all common delimiters / non-ascii characters
 as well as the slash '/'.

*/
+ (NSString *) encode_string_no_slash: (NSString *)str encoding_hint: (int)encoding_hint;

/** 
 Convenience function.

 Decode %-style encoding and convert from local encoding to unicode.

 Reverse of -encode_string

*/
+ (NSString *) decode_string: (NSString *)str encoding_hint: (int)encoding_hint;

/** 
 Convenience function.

 Returns whether '_url' is likely to be a "relative" URL instead of
 an "absolute" URL.

*/
+ (BOOL) isRelativeURL: (NSString *)_url;
- reset;
- parseURL: (NSString *)_url encoding_hint: (int)encoding_hint;
- parseURL: (NSString *)_url ;
@end

#endif
