/***************************************************************************
                            KURLComboBox.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KURLCOMBOBOX_H
#define KURLCOMBOBOX_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KComboBox.h>

/**

 This combobox shows a number of recent URLs/directories, as well as some
 default directories.
 It will manage the default dirs root-directory, home-directory and
 Desktop-directory, as well as a number of URLs set via @ref -setURLs
 and one additional entry to be set via @ref -setURL.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A combo box showing a number of recent URLs/directories.
*/
@class KURL; 

@interface KURLComboBox : KComboBox 

/** 
 Constructs a KURLComboBox.

*/
- initWithInt: (int)mode parent: (QWidget *)parent name: (NSString *)name;
- initWithInt: (int)mode ;
- initWithInt: (int)mode rw: (BOOL)rw parent: (QWidget *)parent name: (NSString *)name;
- initWithInt: (int)mode rw: (BOOL)rw ;

/** 
 Destructs the combo box.
     
*/
- (void) dealloc;

/** 
 Sets the current url. This combo handles exactly one url additionally
 to the default items and those set via @ref -setURLs. So you can call
 -setURL as often as you want, it will always replace the previous one
 set via -setURL.
 If @p url is already in the combo, the last item will stay there
 and the existing item becomes the current item.
 The current item will always have the open-directory-pixmap as icon.

 Note that you won't receive any signals, e.g. -textChanged,
 -returnPressed or -activated upon calling this method.
     
*/
- setURL: (KURL*)url;

/** 
 Inserts @p urls into the combobox below the "default urls" (see
 @ref addDefaultURL).

 If the list of urls contains more items than maxItems, the first items
 will be stripped.
     
*/
- setURLs: (NSArray *)urls;

/** 
 Inserts @p urls into the combobox below the "default urls" (see
 @ref addDefaultURL).

 If the list of urls contains more items than maxItems, the @p remove
 parameter determines whether the first or last items will be stripped.
     
*/
- setURLs: (NSArray *)urls remove: (int)remove;

/** 

*/
- (NSArray *) urls;

/** 
 Sets how many items should be handled and displayed by the combobox.

*/
- setMaxItems: (int)arg1;

/** 

*/
- (int) maxItems;

/** 
 Adds a url that will always be shown in the combobox, it can't be
 "rotated away". Default urls won't be returned in @ref -urls and don't
 have to be set via @ref -setURLs.
 If you want to specify a special pixmap, use the overloaded method with
 the pixmap parameter.
 Default URLs will be inserted into the combobox by @ref -setDefaults
     
*/
- addDefaultURL: (KURL*)url text: (NSString *)text;
- addDefaultURL: (KURL*)url ;

/** 
 Adds a url that will always be shown in the combobox, it can't be
 "rotated away". Default urls won't be returned in @ref -urls and don't
 have to be set via @ref -setURLs.
 If you don't need to specify a pixmap, use the overloaded method without
 the pixmap parameter.
 Default URLs will be inserted into the combobox by @ref -setDefaults
     
*/
- addDefaultURL: (KURL*)url pixmap: (QPixmap *)pix text: (NSString *)text;
- addDefaultURL: (KURL*)url pixmap: (QPixmap *)pix ;

/** 
 Clears all items and inserts the default urls into the combo. Will be
 called implicitly upon the first call to @ref -setURLs or @ref -setURL

*/
- setDefaults;

/** 
 Removes any occurence of @p url. If @p checkDefaultURLs is false
 default-urls won't be removed.
     
*/
- removeURL: (KURL*)url checkDefaultURLs: (BOOL)checkDefaultURLs;
- removeURL: (KURL*)url ;
- init: (int)mode;
//- insertURLItem: (KURLComboItem*)arg1;

/** 
 Uses -[KMimeType pixmapForURL] to return a proper pixmap for @p url.
 In directory mode, a folder icon is always returned.
     
*/
- (QPixmap*) getPixmap: (KURL*)url;

/** 
 Updates @p item with @p pixmap and sets the url instead of the text
 of the KURLComboItem.
 Also works around a Qt bug.
     
*/
//- updateURLComboItem: (KURLComboItem*)item index: (int)index pixmap: (QPixmap *)pix;
- slotActivated: (int)arg1;
+ (int) Files;
+ (int) Directories;
+ (int) Both;
+ (int) RemoveTop;
+ (int) RemoveBottom;
@end

/** Override these methods in subclasses of KURLComboBox to customise event handling behaviour */
@protocol KURLComboBoxEventHandling
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
