/***************************************************************************
                            KWin.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KWIN_H
#define KWIN_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Convenience access to certain properties and features of the
 window manager.

 This class is not supposed to be instantiated.  It exists mostly as
 a namespace for the static member functions.

 In KDE 2 and KDE 3, communication with the windowmanager is done with the
 NET-protocol, a common window manager specification designed by
 various authors of X11 window managers (including those of the KDE
 project).  The full specification can be found in
 kdebase/kwin/wm-spec/

 To access features of the NET-protocol, use the classes NETRootInfo
 and NETWinInfo.

 The purpose of this class is to to provide easy access to the
 most-commonly used NET-features with a simpler, KDEish interface.

 In addition, it encapsulates KDE functionality not yet provided by
 the NET hints.  Currently that is -invokeContextHelp and
 -setSystemTrayWindowFor only.

 @author Matthias Ettrich (ettrich@kde.org)

 @short Class for interaction with the window manager.

*/
@class QPixmap; 

@interface  KWin : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Sets window @p win to be the active window.

 This is a request to the window manager. It may or may not be
 obeyed.
    
*/
+ setActiveWindow: (unsigned int)win;

/** 
 Invokes interactive context help.
     
*/
+ invokeContextHelp;

/** 
 Makes @p trayWin a system tray window for @p forWin.

 A system tray window serves as an icon replacement. It's
 displayed inside the panel's system tray.
     
*/
+ setSystemTrayWindowFor: (unsigned int)trayWin forWin: (unsigned int)forWin;

/** 
 Returns information about window @p win.
     
*/
//+ (int) info: (unsigned int)win;

/** 
 Returns an icon for window @p win.

 If  @p width and @p height are specified, the best icon for the requested
 size is returned.

 If @p scale is true, the icon is smooth-scaled to have exactly
 the requested size.

     
*/
+ (QPixmap*) icon: (unsigned int)win width: (int)width height: (int)height scale: (BOOL)scale;
+ (QPixmap*) icon: (unsigned int)win ;

/** 
 Sets an @p icon and a  @p miniIcon on window @p win
     
*/
+ setIcons: (unsigned int)win icon: (QPixmap *)icon miniIcon: (QPixmap *)miniIcon;

/** 
 Sets the type of window @p win to @p windowType.

 Possible values are -[NET Normal], -[NET Desktop], -[NET Dock],
 -[NET Tool], -[NET Menu], -[NET Dialog]or -[NET Override](== no
 decoration frame)
     
*/
+ setType: (unsigned int)win windowType: (int)windowType;

/** 
 Sets the state of window @p win to @p state.

 Possible values are or'ed combinations of -[NET Modal],
 -[NET Sticky], -[NET MaxVert], -[NET MaxHoriz], -[NET Shaded],
 -[NET SkipTaskbar], -[NET StaysOnTop], -[NET SkipPager]
*/
+ setState: (unsigned int)win state: (unsigned long)state;

/** 
 Clears the state of window @p win from @p state.

 Possible values are or'ed combinations of -[NET Modal],
 -[NET Sticky], -[NET MaxVert], -[NET MaxHoriz], -[NET Shaded],
 -[NET SkipTaskbar], -[NET StaysOnTop], -[NET SkipPager]
*/
+ clearState: (unsigned int)win state: (unsigned long)state;

/** 
 Sets window @p win to be present on all virtual desktops if @p
 is true. Otherwise the window lives only on one single desktop.
     
*/
+ setOnAllDesktops: (unsigned int)win b: (BOOL)b;

/** 
 Moves window @p win to desktop @p desktop.
     
*/
+ setOnDesktop: (unsigned int)win desktop: (int)desktop;

/** 
 Sets the strut of window @p win to @p left, @p right, @p top, @p bottom.

     
*/
+ setStrut: (unsigned int)win left: (int)left right: (int)right top: (int)top bottom: (int)bottom;

/** 
 Convenience function to access the current desktop.  See NETRootInfo.
     
*/
+ (int) currentDesktop;

/** 
 Convenience function to access the number of desktops. See
 NETRootInfo.
     
*/
+ (int) numberOfDesktops;

/** 
 Convenience function to set the current desktop to @p desktop.
 See NETRootInfo.
     
*/
+ setCurrentDesktop: (int)desktop;

/** 
 Iconifies a window. Compatible to XIconifyWindow but has an
 additional parameter @p animation.

 @ref -deIconifyWindow
     
*/
+ iconifyWindow: (unsigned int)win animation: (BOOL)animation;
+ iconifyWindow: (unsigned int)win ;

/** 
 DeIconifies a window. Compatible to XMapWindow but has an
 additional parameter @p animation.

 @ref -iconifyWindow
     
*/
+ deIconifyWindow: (unsigned int)win animation: (BOOL)animation;
+ deIconifyWindow: (unsigned int)win ;

/** 

 Use @ref -[KStartupInfo appStarted]
*/
+ appStarted;
@end

#endif
