/***************************************************************************
* $Id: ConnectWidget.java,v 1.2 2002/03/10 16:08:03 rdale Exp $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.kde.qt.*;
import java.util.Random;

//
// ConnectWidget - draws connected lines
//
class ConnectWidget  extends QWidget
{
static final int MAXPOINTS = 2000;			// maximum number of points
static final int MAXCOLORS = 40;

private    QPoint[]     points;				// point array
private    QColor[]     colors;				// color array
private    int		count;				// count = number of points
private    boolean	down;				// true if mouse down
private    Random generator = new Random(System.currentTimeMillis());

//
// Constructs a ConnectWidget.
//
public ConnectWidget( )
{
	this(null, null);
}

public ConnectWidget( QWidget parent, String name )
{
    super( parent, name, WStaticContents );
    setBackgroundColor( white() );		// white background
    count = 0;
    down = false;
    points = new QPoint[MAXPOINTS];
    colors = new QColor[MAXCOLORS];
    for ( int i=0; i<MAXCOLORS; i++ )		// init color array
	colors[i] = new QColor( generator.nextInt(255), generator.nextInt(255), generator.nextInt(255) );
}


//
// Handles paint events for the connect widget.
//

void paintEvent( QPaintEvent e  )
{
    QPainter paint = new QPainter( this );
    for ( int i=0; i<count-1; i++ ) {		// connect all points
	for ( int j=i+1; j<count; j++ ) {
	    paint.setPen( colors[generator.nextInt(MAXCOLORS)] ); // set random pen color
	    paint.drawLine( points[i], points[j] ); // draw line
	}
    }
}


//
// Handles mouse press events for the connect widget.
//

void mousePressEvent( QMouseEvent e  )
{
    down = true;
    count = 0;					// start recording points
    erase();					// erase widget contents
}


//
// Handles mouse release events for the connect widget.
//

void mouseReleaseEvent( QMouseEvent e )
{
    down = false;				// done recording points
    update();					// draw the lines
}


//
// Handles mouse move events for the connect widget.
//

void mouseMoveEvent( QMouseEvent e )
{
    if ( down && count < MAXPOINTS ) {
	QPainter paint = new QPainter( this );
	points[count++] = e.pos();		// add point
	paint.drawPoint( e.pos() );		// plot point
    }
}


//
// Create and display a ConnectWidget.
//

public static void main( String[] args )
{
    QApplication a = new QApplication( args );
    ConnectWidget connect = new ConnectWidget();
    connect.setCaption( "Qt Example - Draw lines");
    a.setMainWidget( connect );
    connect.show();
    a.exec();
	return;
}

static {
	qtjava.initialize();
}

}
